/*
 * Decompiled with CFR 0.152.
 */
package smp;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import netscape.javascript.JSObject;
import smp.AppletData;
import smp.FileCache;
import smp.Logger;
import smp.SearchReport;
import smp.SiteSearch;
import smp.Warning;

public class SMPApplet
extends Applet {
    public AppletData appletData = new AppletData();
    public Logger logger;
    public SiteSearch siteSearch;
    public SearchReport searchReport;
    private Button searchButton;
    private Button helpButton;
    private TextField keywords;
    private CheckboxGroup cbg;
    private Checkbox andButton;
    private Checkbox orButton;
    private Panel andOrHelpPanel;
    private int oldProgress = 0;
    private Cursor oldCursor;

    private void setAppletLayout() {
        this.setLayout(new FlowLayout());
        this.add(this.keywords);
        this.add(this.searchButton);
        this.add(this.andOrHelpPanel);
    }

    public void reset() {
        this.oldProgress = 0;
        this.searchButton.setLabel(this.appletData.phraseForSearch);
        this.keywords.repaint();
        ((TextComponent)this.keywords).setText(this.keywords.getText());
        this.setAppletLayout();
        this.validate();
        this.setCursor(this.oldCursor);
    }

    void searchActionPerformed() {
        this.logger.addToLog("SMPApplet", "searchActionPerformed", "Start of Search");
        if (this.searchButton.getLabel().compareTo(this.appletData.phraseForSearch) == 0) {
            this.searchReport.clearReport();
            this.searchButton.setLabel(this.appletData.phraseForStopSearch);
            this.setAppletLayout();
            this.validate();
            this.appletData.keywords = this.keywords.getText();
            this.appletData.orSearch = this.orButton.getState();
            this.oldCursor = this.getCursor();
            this.setCursor(new Cursor(3));
            this.siteSearch = new SiteSearch(this);
            this.siteSearch.start();
            this.validate();
        } else {
            this.appletData.stopSearch = true;
            this.searchButton.setLabel(this.appletData.phraseForSearch);
        }
        this.logger.addToLog("SMPApplet", "searchActionPerformed", "End of Search");
        this.logger.printLog();
    }

    private int checkAppletParameterInteger(String paramName) {
        int appletDataParamValue;
        boolean error = false;
        String param = this.getParameter(paramName);
        try {
            Integer i = new Integer(param);
            appletDataParamValue = i;
        }
        catch (NumberFormatException e) {
            this.sendWarningMessage("Applet parameter \"" + paramName + "\" error.  Its value of \"" + param + "\" is invalid.");
            appletDataParamValue = 10;
        }
        return appletDataParamValue;
    }

    private Color checkAppletParameterColour(String paramName) {
        Color appletDataParamValue;
        boolean error = false;
        String param = this.getParameter(paramName);
        try {
            int red = Integer.decode("0x" + param.substring(0, 2));
            int green = Integer.decode("0x" + param.substring(2, 4));
            int blue = Integer.decode("0x" + param.substring(4, 6));
            appletDataParamValue = new Color(red, green, blue);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.sendWarningMessage("Applet parameter \"" + paramName + "\" error.  Its value of \"" + param + "\" is invalid.");
            appletDataParamValue = new Color(0, 255, 0);
        }
        catch (NumberFormatException e) {
            this.sendWarningMessage("Applet parameter \"" + paramName + "\" error.  Its value of \"" + param + "\" is invalid.");
            appletDataParamValue = new Color(0, 255, 0);
        }
        catch (NullPointerException e) {
            this.sendWarningMessage("Applet parameter \"" + paramName + "\" error.  Its value of \"" + param + "\" is invalid.");
            appletDataParamValue = new Color(0, 255, 0);
        }
        return appletDataParamValue;
    }

    void initForm() {
        this.setBackground(this.appletData.appletBackgroundColour);
        this.searchButton = new Button(this.appletData.phraseForSearch);
        this.searchButton.setFont(new Font(this.appletData.fontFace, 0, this.appletData.fontSize));
        this.helpButton = new Button(this.appletData.phraseForHelp);
        this.helpButton.setFont(new Font(this.appletData.fontFace, 0, this.appletData.fontSize));
        this.keywords = new TextField("", 10);
        this.keywords.setFont(new Font(this.appletData.fontFace, 0, this.appletData.fontSize));
        ((Component)this.keywords).setBackground(this.appletData.keywordBackgroundColour);
        this.cbg = new CheckboxGroup();
        this.andButton = new Checkbox(this.appletData.phraseForAnd, this.cbg, false);
        this.andButton.setFont(new Font(this.appletData.fontFace, 0, this.appletData.fontSize));
        this.orButton = new Checkbox(this.appletData.phraseForOr, this.cbg, true);
        this.orButton.setFont(new Font(this.appletData.fontFace, 0, this.appletData.fontSize));
        this.andOrHelpPanel = new Panel();
        this.andOrHelpPanel.add(this.orButton);
        this.andOrHelpPanel.add(this.andButton);
        this.andOrHelpPanel.add(this.helpButton);
        this.setAppletLayout();
        this.setVisible(true);
        this.searchButton.addActionListener(new ActionListener(){
            {
                SMPApplet.this.getClass();
            }

            public void actionPerformed(ActionEvent e) {
                SMPApplet.this.searchActionPerformed();
            }
        });
        this.keywords.addActionListener(new ActionListener(){
            {
                SMPApplet.this.getClass();
            }

            public void actionPerformed(ActionEvent e) {
                SMPApplet.this.searchActionPerformed();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){
            {
                SMPApplet.this.getClass();
            }

            public void actionPerformed(ActionEvent e) {
                SMPApplet.this.helpActionPerformed();
            }
        });
    }

    public void sendWarningMessage(String WarningText) {
        try {
            JSObject win = JSObject.getWindow((Applet)this);
            ++this.appletData.numberOfWarningMessages;
            this.appletData.warningText.append("<br>\r" + this.appletData.numberOfWarningMessages + ". " + WarningText);
            Warning warning = new Warning(win, this.appletData.warningFrame, this.appletData.warningText.toString(), this.appletData.webMasterEMail, this.appletData.phraseForClose);
        }
        catch (Exception ex) {
            System.out.println("Check the \"mayscript\" parameter is present in the HTML calling the Applet.  There was an error in the calling Javascript.");
        }
    }

    private void usePageParams() {
        int n;
        this.appletData.warningFrame = "Warning";
        this.appletData.logFrame = "Log";
        boolean error = false;
        String param = this.getParameter("SearchReportFrame");
        if (param == null) {
            error = true;
        }
        if (error) {
            this.appletData.searchReportFrame = "Report";
            this.sendWarningMessage("Applet parameter \"SearchReportFrame\" error. Its value of \"" + param + "\" is invalid.");
        } else {
            this.appletData.searchReportFrame = param;
        }
        error = false;
        param = this.getParameter("WebMasterEMail");
        if (param == null) {
            error = true;
        } else {
            n = param.indexOf("@");
            if (n == -1) {
                error = true;
            }
            if ((n = param.indexOf(".", n)) == -1) {
                error = true;
            }
        }
        if (error) {
            this.appletData.webMasterEMail = "Invalid e-mail address";
            this.sendWarningMessage("Applet parameter \"WebMasterEMail\" error.  Its value of \"" + param + "\" is invalid.");
        } else {
            this.appletData.webMasterEMail = param;
        }
        this.appletData.phraseForSearch = this.checkAppletParameterString("PhraseForSearch");
        this.appletData.phraseForSearching = this.checkAppletParameterString("PhraseForSearching");
        this.appletData.phraseForStopSearch = this.checkAppletParameterString("PhraseForStopSearch");
        this.appletData.phraseForClose = this.checkAppletParameterString("PhraseForClose");
        this.appletData.phraseForOr = this.checkAppletParameterString("PhraseForOr");
        this.appletData.phraseForAnd = this.checkAppletParameterString("PhraseForAnd");
        this.appletData.phraseForHelp = this.checkAppletParameterString("PhraseForHelp");
        this.appletData.phraseForInformationAboutTheSearchEngine = this.checkAppletParameterString("PhraseForInformationAboutTheSearchEngine");
        this.appletData.phraseForSearchReport = this.checkAppletParameterString("PhraseForSearchReport");
        this.appletData.phraseForNoHitsFound = this.checkAppletParameterString("PhraseForNoHitsFound");
        this.appletData.phraseForNoDescription = this.checkAppletParameterString("PhraseForNoDescription");
        this.appletData.phraseForNoTitle = this.checkAppletParameterString("PhraseForNoTitle");
        this.appletData.fontFace = this.checkAppletParameterString("FontFace");
        this.appletData.pagesToSearch = this.checkAppletParameterString("PagesToSearch");
        this.appletData.helpText = this.checkAppletParameterString("HelpText");
        String initialFiles = new String(this.appletData.pagesToSearch);
        Vector<String> ifileNames = new Vector<String>();
        if (initialFiles.compareTo("") == 0) {
            ifileNames.addElement(this.getCodeBase().toString());
        } else if (initialFiles.indexOf(";") == 0) {
            ifileNames.addElement(initialFiles.toString());
        } else {
            char nextChar = ' ';
            StringBuffer filename = new StringBuffer(30);
            int i = 0;
            while (i != initialFiles.length()) {
                nextChar = initialFiles.charAt(i);
                if (nextChar == ';') {
                    ifileNames.addElement(filename.toString());
                    filename = new StringBuffer(30);
                } else {
                    filename.append(nextChar);
                }
                ++i;
            }
            if (!filename.toString().equals("")) {
                ifileNames.addElement(filename.toString());
            }
        }
        param = this.getParameter("Spider");
        if (param == null) {
            this.appletData.spider = false;
            this.sendWarningMessage("Applet parameter \"Spider\" error. Its value of \"" + param + "\" is invalid.");
        } else if (param.compareTo("true") == 0) {
            this.appletData.spider = true;
        } else if (param.compareTo("false") == 0) {
            this.appletData.spider = false;
        } else {
            this.appletData.spider = false;
            this.sendWarningMessage("Applet parameter \"Spider\" error. Its value of \"" + param + "\" is invalid.  It should be either \"true\" or \"false\".");
        }
        this.appletData.fontSize = this.checkAppletParameterInteger("FontSize");
        this.appletData.cacheSize = this.checkAppletParameterInteger("CacheSize");
        this.appletData.keywordBackgroundColour = this.checkAppletParameterColour("KeywordBackgroundColour");
        this.appletData.appletBackgroundColour = this.checkAppletParameterColour("AppletBackgroundColour");
        Color colour = this.checkAppletParameterColour("ReportBackgroundColour");
        int r = colour.getRed();
        String rs = r < 16 ? "0" + Integer.toHexString(r) : Integer.toHexString(r);
        int g = colour.getGreen();
        String gs = g < 16 ? "0" + Integer.toHexString(g) : Integer.toHexString(g);
        int b = colour.getBlue();
        String bs = b < 16 ? "0" + Integer.toHexString(b) : Integer.toHexString(b);
        this.appletData.reportBackgroundColour = new String("#" + rs + gs + bs);
        error = false;
        n = this.appletData.version.indexOf(".");
        if (n == -1) {
            error = true;
        }
        if (!this.appletData.version.startsWith("V")) {
            error = true;
        }
        if (error) {
            this.sendWarningMessage("Applet flag \"version\" error. Its value of \"" + this.appletData.version + "\" doesn't have a dot or starts with \"V\" and is invalid.");
        }
        error = false;
        if (this.appletData.softwareBuild.compareTo("debug") != 0 && this.appletData.softwareBuild.compareTo("release") != 0) {
            error = true;
        }
        if (error) {
            this.sendWarningMessage("Applet flag \"softwareBuild\" error. Its value of \"" + this.appletData.softwareBuild + "\" isn't invalid.");
            this.appletData.softwareBuild = "debug";
        }
        error = false;
        if (this.appletData.softwareBuild.compareTo("debug") == 0) {
            this.sendWarningMessage("Applet flag \"softwareBuild\" warning. Its value of \"" + this.appletData.softwareBuild + "\" shows it is a development debug version.");
            this.appletData.version = this.appletData.version + "d";
        }
        error = false;
        if (this.appletData.licence.compareTo("registered") != 0 && this.appletData.licence.compareTo("shareware") != 0) {
            error = true;
        }
        if (error) {
            this.sendWarningMessage("Applet flag \"licence\" error. Its value of \"" + this.appletData.licence + "\" isn't invalid.");
            this.appletData.licence = "shareware";
        }
        error = false;
        param = this.getParameter("ReportBackgroundImage");
        if (param == null) {
            this.appletData.reportBackgroundImage = new String();
        } else {
            try {
                URL urlFile = new URL(this.getDocumentBase(), param);
                BufferedReader inStream = new BufferedReader(new InputStreamReader(urlFile.openStream()));
                this.appletData.reportBackgroundImage = new String(urlFile.toString());
            }
            catch (MalformedURLException e) {
                this.sendWarningMessage("BackgroundImage, malformed URL");
                this.appletData.reportBackgroundImage = new String();
            }
            catch (IOException e) {
                this.sendWarningMessage("BackgroundImage, file read error.");
                this.appletData.reportBackgroundImage = new String();
            }
            catch (SecurityException e) {
                this.sendWarningMessage("BackgroundImage, Jave security error.  The image must be on the same server as the Applet.");
                this.appletData.reportBackgroundImage = new String();
            }
        }
    }

    public void showProgress(int p) {
        if (this.oldProgress > p) {
            this.keywords.repaint();
        }
        this.oldProgress = p;
        Dimension keywordsSize = this.keywords.getSize();
        int width = keywordsSize.width * p / 100;
        int height = keywordsSize.height;
        Graphics g = this.keywords.getGraphics();
        if (g != null) {
            g.setColor(Color.yellow);
            g.fillRect(0, 0, width, height);
        }
        this.validate();
        g.dispose();
    }

    private String deriveHost(String fileName) {
        String host;
        URL target = null;
        try {
            target = new URL(fileName);
            host = target.getHost();
        }
        catch (MalformedURLException ex) {
            host = new String("Local");
        }
        return host;
    }

    public void init() {
        JSObject win;
        this.usePageParams();
        this.appletData.cache = new FileCache(this.appletData.cacheSize);
        this.initForm();
        try {
            win = JSObject.getWindow((Applet)this);
            this.logger = new Logger(win, this.appletData);
        }
        catch (Exception ex) {
            this.sendWarningMessage("Logger did not intialise.");
        }
        try {
            win = JSObject.getWindow((Applet)this);
            this.searchReport = new SearchReport(this, win, this.appletData);
        }
        catch (Exception ex) {
            this.sendWarningMessage("Search report window did not intialise.");
        }
        this.appletData.logAllAppletData(this.logger);
        this.logger.printLog();
    }

    void helpActionPerformed() {
        this.logger.addToLog("SMPApplet", "helpActionPerformed", "");
        this.logger.printLog();
        String helpTextStart = new String("<html>\r  <head>\r    <title>" + this.appletData.phraseForHelp + "</title>\r" + "  </head>\r" + "  <body bgcolor = " + this.appletData.reportBackgroundColour + ">\r" + "    <font face = " + this.appletData.fontFace + ">");
        String helpTextEnd = new String("\r\r    <center>\r    <form>\r      <input type=\"button\" value='" + this.appletData.phraseForClose + "' onclick=document.write('');window.close();>\r" + "    </form>\r" + "    </center>\r" + "  </body>\r" + "</html>\r");
        StringBuffer helpText = new StringBuffer();
        helpText.append(helpTextStart);
        helpText.append(this.appletData.helpText);
        helpText.append(helpTextEnd);
        try {
            JSObject win = JSObject.getWindow((Applet)this);
            win.call("openWin", "help_window", helpText.toString());
        }
        catch (Exception ex) {
            this.sendWarningMessage("Help window did not intialise.");
        }
    }

    private String checkAppletParameterString(String paramName) {
        String appletDataParamValue;
        boolean error = false;
        String param = this.getParameter(paramName);
        if (param == null) {
            error = true;
        }
        if (error) {
            appletDataParamValue = paramName;
            this.sendWarningMessage("Applet parameter \"" + paramName + "\" error.  Its value of \"" + param + "\" is invalid.");
        } else {
            appletDataParamValue = param;
        }
        return appletDataParamValue;
    }
}

