/*
 * Decompiled with CFR 0.152.
 */
package smp;

import java.util.Date;
import java.util.Vector;
import smp.FileCache;
import smp.GetFile;
import smp.SMPApplet;
import smp.SearchFile;

public class TestHarness {
    private SMPApplet parent;

    public TestHarness(SMPApplet par) {
        this.parent = par;
        System.out.println("====== Start Test Harness report ======");
        this.testProgress();
        this.testCache();
        this.testSearchFile();
        this.testGetFile();
        System.out.println("====== End Test Harness report ======");
    }

    public void testProgress() {
        long startTime;
        long currentTime = startTime = new Date().getTime();
        int n = 0;
        while (n < 10000) {
            int p = n * 100 / 10000;
            this.parent.showProgress(p);
            while (currentTime < startTime + (long)n) {
                currentTime = new Date().getTime();
            }
            n += 100;
        }
        System.out.println("Pass : Progress");
    }

    public void testGetFile() {
        GetFile gf = new GetFile();
        gf.getFileContent(this.parent, "testGetFile1.txt");
        gf.getFileContent(this.parent, "testGetFile2.txt");
        gf.getFileContent(this.parent, "testGetFile3.txt");
        gf.getFileContent(this.parent, "testGetFile4.txt");
        gf.getFileContent(this.parent, "testGetFile5.txt");
        gf.getFileContent(this.parent, "testGetFile6.txt");
        gf.getFileContent(this.parent, "testGetFile1.txt");
        gf.getFileContent(this.parent, "testGetFile3.txt");
        System.out.println("GetFile : If the log shows that testGetFile1.txt & testGetFile3.txt were retrived from the cache, then this test has passed.");
    }

    public void testSearchFile() {
        Vector v;
        String s;
        SearchFile sf = new SearchFile(this.parent);
        String fileText = new String("<html><head><meta http-equiv=\"Content-Type\"content=\"text/html; charset=iso-8859-1\"><meta http-equiv=\"revisit-after\" content=\"30 days\"><meta name=\"KEYWORDS\"content=\"web authoring, Internet, links, cataloguer, colour chart, color chart, web building, web site, internet presence, uk, united kingdom\"><meta name=\"description\" content=\"Web Building for small business and keen DIY'ers offering browser friendly advice and low cost software.\"><meta name=\"Copyright\"content=\"Copyright (c) 2000 Rhino Software, rhino@rhinosoftware.co.uk, http://www.rhinosoftware.co.uk\"><meta name=\"robots\" content=\"index\"><meta name=\"GENERATOR\" content=\"Microsoft FrontPage Express 2.0\"><title>Software for Webmasters</title></head><body bgcolor=\"#99FFFF\"><h1 align=\"center\"><font    color=\"#FF6600\" size=\"5\" face=\"Arial, Helvetica\">Software for Webmasters</font></h1>    <p><font size=\"2\" face=\"Arial, Helvetica\">Web Building for    small business and keen DIY'ers offering browser friendly    advice and links to the most useful sites on the net.</font></p>    <p><font size=\"2\" face=\"Arial, Helvetica\">Site content helps    small business, create a web site and an Internet presence on    the world wide web at low cost.</font></p>    <table border=\"0\" width=\"100%\">        <col width=\"90%\">        <tr>            <td valign=\"top\" width=\"50%\"><ul>                <li><a href=\"../issues.htm\"><font size=\"2\"                    face=\"Arial, Helvetica\">Internet Issues</font></a>                </li>                <li><font size=\"2\" face=\"Arial, Helvetica\">What                    every web master needs to be aware of before                    building a site.</font> </li>                <li><a href=\"links.htm\"><font size=\"2\"                    face=\"Arial, Helvetica\">Useful Links</font></a>\n                </li>                <li><font size=\"2\" face=\"Arial, Helvetica\">Valuable                    links to reference sources on the Internet -                    archives, HTML, Java, CGI, layout, etc. etc.</font>                </li>                <li><a href=\"download.htm\"><font size=\"2\"                    face=\"Arial, Helvetica\">Downloads</font></a> </li>                <li><font size=\"2\" face=\"Arial\">Downloads from                    Rhino Software to help you build your own                    site, including Search Me! and Lost Link.</font></li>            </ul>            </td>    </tbody>    </table></body></html>");
        boolean error = false;
        int n = sf.containsKeyword(" ", fileText);
        if (n != 585) {
            error = true;
        }
        if ((n = sf.containsKeyword("Rhino", fileText)) != 5) {
            error = true;
        }
        if ((n = sf.containsKeyword("supercalafragalisticexpiallydoshus", fileText)) != 0) {
            error = true;
        }
        if ((s = sf.getDescription(fileText)).compareTo("Web Building for small business and keen DIY'ers offering browser friendly advice and low cost software.") != 0) {
            error = true;
        }
        if ((s = sf.getTitle(fileText)).compareTo("Software for Webmasters") != 0) {
            error = true;
        }
        if ((v = sf.getVectorOfLinks("", fileText)).size() != 3) {
            error = true;
        }
        if (error) {
            System.out.println("Fail : SearchFile");
        } else {
            System.out.println("Pass : SearchFile");
        }
    }

    public void testCache() {
        boolean error = false;
        FileCache fc = new FileCache(4);
        fc.addFile("C:six.txt", "123456");
        fc.addFile("C:five.txt", "12345");
        fc.addFile("C:ten.txt", "1234567890");
        fc.addFile("C:two.txt", "12");
        fc.addFile("C:six2.txt", "123456");
        fc.addFile("C:eight.txt", "12345678");
        if (fc.getFile("C:five.txt").compareTo("") != 0) {
            error = true;
        }
        if (fc.getFile("C:eight.txt").compareTo("12345678") != 0) {
            error = true;
        }
        if (fc.getFile("C:ten.txt").compareTo("1234567890") != 0) {
            error = true;
        }
        if (fc.getFile("C:two.txt").compareTo("") != 0) {
            error = true;
        }
        if (error) {
            System.out.println("Fail : FileCache");
        } else {
            System.out.println("Pass : FileCache");
        }
    }
}

