/* LIST.C - This file is part of
Resolver for Windows, copyright (C) Fabrizio Gennari, 2000-2003

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <windows.h>
#include <commctrl.h>
#include <winsock2.h>
#include "resource.h"
#include "resolv.h"
#include <stdio.h>

static void ListDomains(HWND hwnd){
	int num,i,result,soa=0,timeout=20000,err,namesize,errors;
	char dns[256],dns_name[256],host[256],message[256],*query,*name,answer[256],fanswer[256],ftype[256],*cpu,*os;
	unsigned char cpulen,oslen;
	unsigned short int qdcount,ancount,nscount,arcount,querylen=0,network_querylen,query_rep_len;
	struct answer *anstype;
	SOCKADDR_IN dns_addr;
	SOCKET sock;
	LV_ITEM linea;
	unsigned char *query_rep, *eom, *src;
	struct query *response;

	num=ListView_GetItemCount(GetDlgItem(GetParent(hwnd),IDC_NS));
	for(i=0;i<num;i++)
		if (ListView_GetItemState(GetDlgItem(GetParent(hwnd),IDC_NS),i,LVIS_SELECTED)==LVIS_SELECTED)
			break;
	linea.iItem=i;
	linea.iSubItem=2;
	linea.mask=LVIF_TEXT;
	linea.pszText=dns;
	linea.cchTextMax=256;
	ListView_GetItem(GetDlgItem(GetParent(hwnd),IDC_NS),&linea);
	dns_addr.sin_port=htons(53);
	dns_addr.sin_family=AF_INET;
	dns_addr.sin_addr.S_un.S_addr=inet_addr(dns);
	memset(dns_addr.sin_zero,0,sizeof(dns_addr.sin_zero));
	linea.pszText=dns_name;
	linea.iSubItem=1;
	ListView_GetItem(GetDlgItem(GetParent(hwnd),IDC_NS),&linea);
	linea.pszText=host;
	linea.iSubItem=0;
	ListView_GetItem(GetDlgItem(GetParent(hwnd),IDC_NS),&linea);
	while(1){
		querylen++;
		query=(char*)malloc(querylen);
		result=res_mkquery(0,host,1,252,0,0,0,query,querylen);
		if (result!=-1) break;
		free(query);
	}
	sprintf(message,"Domain list for %s",host);
	SetWindowText(hwnd,message);
	sock=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	setsockopt(sock,SOL_SOCKET, SO_SNDTIMEO, (char *)&timeout, sizeof(timeout));
	setsockopt(sock,SOL_SOCKET, SO_RCVTIMEO, (char *)&timeout, sizeof(timeout));
	sprintf(message,"Connecting to %u.%u.%u.%u"
		,dns_addr.sin_addr.S_un.S_un_b.s_b1
		,dns_addr.sin_addr.S_un.S_un_b.s_b2
		,dns_addr.sin_addr.S_un.S_un_b.s_b3
		,dns_addr.sin_addr.S_un.S_un_b.s_b4);
	SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),message);
	network_querylen=htons(querylen);
	err=connect(sock,(SOCKADDR*)&dns_addr,16);
	if (err){
		sprintf(message,"Socket error, connection failed");
		SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),message);
		return;
	}
	sprintf(message,"Connected, getting info");
	SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),message);
	if (send(sock,(char*)&network_querylen,2,0) == SOCKET_ERROR){
		SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),"Error sending");
		closesocket(sock);
		return;
	};
	if (send(sock,query,querylen,0) == SOCKET_ERROR){
		SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),"Error sending");
		closesocket(sock);
		return;
	};
	do{
	if (recv(sock,(char*)&query_rep_len,2,0) == SOCKET_ERROR){
		SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),"Error receiving");
		closesocket(sock);
		return;
	};
	query_rep_len=ntohs(query_rep_len);
	query_rep=(char*)malloc(query_rep_len);
	if (recv(sock, (char*)query_rep, query_rep_len, 0) == SOCKET_ERROR){
		SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),"Error receiving");
		closesocket(sock);
		free(query_rep);
		return;
	};
	response = (struct query*)query_rep;
	errors=response->control[1];
	if (process_errors(errors,message,host)){
		SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),message);
		closesocket(sock);
		free(query_rep);
		return;
	}

	qdcount=ntohs(response->qdcount);
	ancount=ntohs(response->ancount);
	nscount=ntohs(response->nscount);
	arcount=ntohs(response->arcount);
	if (ancount==0){
		free(query_rep);
		break;
	}
	eom=query_rep+query_rep_len;
	src=query_rep+sizeof(*response);
	result=ns_skiprr(src,eom,ns_s_qd,qdcount);
	if (result < 0){
		SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),"Error parsing return message");
		closesocket(sock);
		free(query_rep);
		return;
	}
	src+=result;
	for(i=0;i<ancount;i++){
		namesize=256;
		while(1){
			name=(char*)malloc(namesize);
			if (name == NULL){
				SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),"Out of memory");
				closesocket(sock);
				free(query_rep);
				return;
			}
			result=dn_expand(query_rep,eom,src,name,namesize);
			if (result==-2){
				SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),"Server gave back a malformed message");
				closesocket(sock);
				free(query_rep);
				free(name);
				return;
			}
			if (result>=0){
				src+=result;
				break;
			}
			free(name);
			namesize+=256;
		}
		anstype=(struct answer *)src;
		src+=sizeof(*anstype);
		switch(ntohs(anstype->type)){
		case 1:
			strcpy(ftype,"A");
			GetIPAddress(src,eom,fanswer,sizeof(fanswer));
			break;
		case 2:
			strcpy(ftype,"NS");
			dn_expand(query_rep,eom,src,fanswer,sizeof(fanswer));
			break;
		case 5:
			strcpy(ftype,"CNAME");
			dn_expand(query_rep,eom,src,fanswer,sizeof(fanswer));
			break;
		case 6:
		{
			unsigned long refresh,retry,serial,expire;
			char mname[256], rname[256];

			soa++;
			strcpy(ftype,"SOA");
			GetSOA(query_rep,eom,src,
			mname,sizeof(mname),
			rname,sizeof(rname),
			&serial,
			&refresh,
			&retry,
			&expire);
			_snprintf(fanswer,sizeof(fanswer),"primary name server %s, mailbox %s, serial %u, refresh %u, retry %u, expire %u",
			mname,rname,serial,refresh,retry,expire);
			break;
		}
		case 12:
			strcpy(ftype,"PTR");
			dn_expand(query_rep,eom,src,fanswer,sizeof(fanswer));
			break;
		case 13:
		{
			char cpu[256],os[256];

			strcpy(ftype,"HINFO");
			GetCPUOS(src,eom,cpu,sizeof(cpu),os,sizeof(os));
			sprintf(fanswer,"CPU %s, OS %s",cpu,os);
			break;
		}
		case 15:
		{
			unsigned short preference;
			char mxname[256];
			strcpy(ftype,"MX");
			GetMailExchanger(query_rep,eom,src,mxname,sizeof(mxname),&preference);
			sprintf(fanswer,"%s (pref. %u)",mxname,preference);
			break;
		}
		default:
			sprintf(ftype,"%u",anstype);
			sprintf(fanswer,"Unknown type %u",anstype);
		}
		src+=ntohs(anstype->rdlength);
		linea.mask=LVIF_TEXT;
		linea.iItem=i;
		linea.iSubItem=0;
		linea.pszText=name;
		ListView_InsertItem(GetDlgItem(hwnd,IDC_DOMAIN),&linea);
		linea.iSubItem=1;
		linea.pszText=ftype;
		SendDlgItemMessage(hwnd,IDC_DOMAIN,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
		linea.iSubItem=2;
		linea.pszText=fanswer;
		SendDlgItemMessage(hwnd,IDC_DOMAIN,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
		free(name);
	}
	//skip the rest
	UpdateWindow(hwnd);
	free(query_rep);
	}while (soa<2);
	closesocket(sock);
	sprintf(message,"Name server %s (%s) was queried",dns_name,dns);
	SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),message);
}

UINT APIENTRY hook(HWND hdlg, // handle to child dialog window
UINT uiMsg, // message identifier
WPARAM wParam, // message parameter
LPARAM lParam // message parameter
){
	switch(uiMsg){
	case WM_NOTIFY:
		if ((((LPOFNOTIFY)lParam)->hdr.code)==CDN_TYPECHANGE){
			if ((((LPOFNOTIFY)lParam)->lpOFN->nFilterIndex)==1)
				CommDlg_OpenSave_SetDefExt(GetParent(hdlg), "txt");
			else
				CommDlg_OpenSave_SetDefExt(GetParent(hdlg), NULL);
		}
	default:
		;
	}
	return 0;
}

void save_list(HWND hwnd){
	int num_lines,i;
	const char* filter="text files\0*.txt\0All files\0*.*\0\0";
	char filename[256]="", item[256];
	FILE* result;
	LV_ITEM linea;
	OPENFILENAME box;

	box.lStructSize=sizeof(OPENFILENAME);
	box.hwndOwner=hwnd;
	box.lpstrFilter=filter;
	box.lpstrCustomFilter=NULL;
	box.lpstrFile=filename;
	box.nMaxFile=256;
	box.lpstrFileTitle=NULL;
	box.lpstrInitialDir=NULL;
	box.lpstrTitle=NULL;
	box.Flags=OFN_EXPLORER|OFN_HIDEREADONLY|OFN_ENABLEHOOK;
	box.lpfnHook=hook;
	box.lpstrDefExt="txt";
	if (GetSaveFileName(&box)==0) return;
	if ( (result=fopen(box.lpstrFile,"wb")) ==NULL){
		MessageBox(hwnd,box.lpstrFile,"Error in creating this file",MB_OK|MB_ICONERROR);
		return;
	}
	linea.mask=LVIF_TEXT;
	linea.pszText=item;
	linea.cchTextMax=256;
	num_lines=ListView_GetItemCount(GetDlgItem(hwnd,IDC_DOMAIN));
	for(i=0;i<num_lines;i++){
		linea.iItem=i;
		linea.iSubItem=0;
		ListView_GetItem(GetDlgItem(hwnd,IDC_DOMAIN),&linea);
		fprintf(result,"%s\t",item);
		linea.iSubItem=1;
		ListView_GetItem(GetDlgItem(hwnd,IDC_DOMAIN),&linea);
		fprintf(result,"%s\t",item);
		linea.iSubItem=2;
		ListView_GetItem(GetDlgItem(hwnd,IDC_DOMAIN),&linea);
		fprintf(result,"%s\n",item);
	}
	fclose(result);
}

BOOL CALLBACK list_callback(HWND wind, // handle of window
UINT uMsg, // message identifier
WPARAM wParam, // first message parameter
LPARAM lParam // second message parameter
){
	switch (uMsg)
	{
	case WM_INITDIALOG:
		{
			LV_COLUMN colonna;
			char testo[6];
			colonna.mask=LVCF_TEXT|LVCF_WIDTH;
			colonna.pszText=testo;
			colonna.cx=100;
			strcpy(testo,"Entry");
			ListView_InsertColumn(GetDlgItem(wind,IDC_DOMAIN),0,&colonna);
			strcpy(testo,"Value");
			ListView_InsertColumn(GetDlgItem(wind,IDC_DOMAIN),2,&colonna);
			colonna.cx=50;
			strcpy(testo,"Type");
			ListView_InsertColumn(GetDlgItem(wind,IDC_DOMAIN),1,&colonna);
			ListDomains(wind);
			return TRUE;
		}
	case WM_COMMAND:
			if(LOWORD(wParam)==IDOK)
			{
				EndDialog(wind,0);
				return TRUE;
			}
			if(LOWORD(wParam)==IDC_SAVE)
			{
				save_list(wind);
				return TRUE;
			}
			return 0;
	default:
			return 0;
	}
}
