/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

public final class SimplePool {
    private Object[] pool;
    private int max;
    private int minSpare;
    private int maxSpare;
    private int current = -1;
    Object lock;

    public SimplePool(int max) {
        this.max = max;
        this.pool = new Object[max];
        this.lock = new Object();
    }

    public void set(Object o) {
        this.put(o);
    }

    public void put(Object o) {
        int idx = -1;
        Object object = this.lock;
        synchronized (object) {
            if (this.current < this.max) {
                idx = ++this.current;
            }
        }
        if (idx > 0) {
            this.pool[idx] = o;
        }
    }

    public Object get() {
        int idx = -1;
        Object object = this.lock;
        synchronized (object) {
            if (this.current >= 0) {
                idx = this.current--;
            }
        }
        if (idx >= 0) {
            return this.pool[idx];
        }
        return null;
    }

    public int getMax() {
        return this.max;
    }
}

