/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.log;

import org.apache.tomcat.util.log.LogHandler;
import org.apache.tomcat.util.log.LogManager;

public class Log {
    public static final int FATAL = Integer.MIN_VALUE;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 3;
    public static final int DEBUG = 4;
    protected String logname;
    protected String prefix;
    private LogHandler proxy;
    private static LogManager logManager;
    static Class class$org$apache$tomcat$util$log$LogManager;

    protected Log(String channel, String prefix, LogHandler proxy, Object owner) {
        this.logname = channel;
        this.prefix = prefix;
        this.proxy = proxy;
    }

    public static Log getLog(String channel, String prefix) {
        return logManager.getLog(channel, prefix, null);
    }

    public static Log getLog(String channel, Object owner) {
        return logManager.getLog(channel, null, owner);
    }

    public void log(String msg) {
        this.log(msg, null, 3);
    }

    public void log(String msg, Throwable t) {
        this.log(msg, t, 1);
    }

    public void log(String msg, int level) {
        this.log(msg, null, level);
    }

    public void log(String msg, Throwable t, int level) {
        this.log(this.prefix, msg, t, level);
    }

    public void log(String prefix, String msg, Throwable t, int level) {
        this.proxy.log(prefix, msg, t, level);
    }

    public void flush() {
        this.proxy.flush();
    }

    public void close() {
        this.proxy.close();
    }

    public int getLevel() {
        return this.proxy.getLevel();
    }

    public void setLevel(int level) {
        this.proxy.setLevel(level);
    }

    public static LogManager setLogManager(LogManager lm) {
        if (logManager.getClass() == (class$org$apache$tomcat$util$log$LogManager == null ? (class$org$apache$tomcat$util$log$LogManager = Log.class$("org.apache.tomcat.util.log.LogManager")) : class$org$apache$tomcat$util$log$LogManager)) {
            LogManager oldLM = logManager;
            logManager = lm;
            return oldLM;
        }
        return null;
    }

    public String getChannel(LogManager lm) {
        if (lm != logManager) {
            return null;
        }
        return this.logname;
    }

    public void setProxy(LogManager lm, LogHandler l) {
        if (lm != logManager) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Attempt to change proxy ").append(lm).append(" ").append(logManager))));
            return;
        }
        this.proxy = l;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        FATAL = Integer.MIN_VALUE;
        ERROR = 1;
        WARNING = 2;
        INFORMATION = 3;
        DEBUG = 4;
        logManager = new LogManager();
    }
}

