/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;

import stec.iws.Request;
import stec.iws.Response;

import stec.iws.Utils;

public final class CookieTesterServlet extends BaseServlet
{
	public final void service(Request request, Response response) throws ServletException, IOException
	{
		response.setContentType("text/html");

		String charset = response.getCharacterEncoding();

		String key = null;
		String value = null;

		String action = request.getParameter("action");
		if(action == null)
		{
			action = "";
		}
		if(action.equalsIgnoreCase("set cookie"))
		{
			key = request.getParameter("key");
			if(key != null)
			{
				key = key.trim();

				if(key.length() > 0)
				{
					value = request.getParameter("value");
					if(value == null)
					{
						value = "";
					}

					response.addCookie(new Cookie(Utils.encodeURL(key, charset), Utils.encodeURL(value, charset)));
				}
			}
		}
		else if(action.equalsIgnoreCase("remove cookie"))
		{
			key = request.getParameter("key");
			if(key != null)
			{
				key = key.trim();

				if(key.length() > 0)
				{

					Cookie cookie = new Cookie(Utils.encodeURL(key, charset), "");
					cookie.setMaxAge(0);

					response.addCookie(cookie);
				}
			}
		}

		PrintWriter writer = response.getWriter();

		writer.print("<html><head><title>Cookie Tester Servlet</title></head><body><h1>Cookie Tester Servlet</h1><hr>");

		if(action != null)
		{
			if(key != null)
			{
				if(key.length() > 0)
				{
					if(action.equalsIgnoreCase("set cookie"))
					{
						writer.print("Cookie to add or update:<br>");
						writer.print(key + " = [" + value + "]<p>");
					}
					else if(action.equalsIgnoreCase("remove cookie"))
					{
						writer.print("Cookie to remove:<br>");
						writer.print(key + "<p>");
					}
				}
			}
		}

		writer.print("Cookies received from browser:<br>");

		Cookie cookies[] = request.getCookies();

		if(cookies == null)
		{
			writer.print("None");
		}
		else
		{
			int length = cookies.length;

			for(int i = 0; i < length; i++)
			{
				writer.print(Utils.decodeURL(cookies[i].getName(), charset) + " = " + Utils.decodeURL(cookies[i].getValue(), charset) + "<br>");
			}
		}

		writer.print("<br><br><form action=\"./cookietester.html\" method=\"get\">");

		writer.print("Key: ");
		writer.print("<input type=\"text\" name=\"key\" value=\"\">");

		writer.print("<br>Value: ");
		writer.print("<input type=\"text\" name=\"value\" value=\"\">");

		writer.print("<p><input type=\"submit\" name=\"action\" value=\"Set Cookie\">");
		writer.print("<input type=\"submit\" name=\"action\" value=\"Remove Cookie\">");

		writer.print("</form></body></html>");
	}
}
