/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.PrintWriter;

import javax.servlet.ServletException;
import java.io.IOException;

import stec.lang.DString;

import stec.iws.Utils;
import stec.iws.Request;
import stec.iws.Response;

public class LogServlet extends BaseServlet
{
	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		String msg;

		String qs = _request.getQueryString();

		if(qs == null)
		{
			msg = "hello";
		}
		else
		{
			String args = Utils.decodeURL(Utils.getArgs(_request), _response.getCharacterEncoding());
			if(args == null)
			{
				msg = "hello";
			}
			else
			{
				String name = DString.extract(args, " ", 1);
				if(name == null)
				{
					msg = "hello";
				}
				else
				{
					msg = "hello " + name;
				}
			}
		}

		log(msg);

		PrintWriter writer = _response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>Log Servlet</title></head>");
		writer.println("<body>");
		writer.println("<lit>");
		writer.println("[" + msg + "] was sent to the log file");
		writer.println("</lit>");
		writer.println("</body>");
		writer.println("</html>");
	}
}
