/*
    SimpleAIM
    A miniature console AIM client
    http://simpleaim.sourceforge.net
    Copyright (C) 2002
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  */

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.util.Enumeration;
import java.util.StringTokenizer;

/**
 * Handles user input and output messages from client->TOC
 *
 * @author  simpleaim.sourceforge.net.
 */
public class OutHandler extends Thread {

    BufferedReader input;
    private static HelpMessages help;

    public OutHandler() {
        input = new BufferedReader(new InputStreamReader(System.in));
        help = new HelpMessages();
    }

    /**
     * run()
     * 
     */
    public void run() {
        try {
            while (true) {

                // print console prompt
                if (Operations.greeted) System.out.print(Operations.username + " ~ > ");

                // handle client->TOC messages
                StringTokenizer inp = new StringTokenizer(input.readLine());
                String message = "";
                String user;

                if (!inp.hasMoreElements()) {
                    continue;
                }
                else {
                    String command = inp.nextToken().toLowerCase();
                    if (command.equals("send") && inp.countTokens() >= 2) {

                        // process outgoing IMs
                        user = Operations.normalize(inp.nextToken());
                        while (inp.hasMoreElements()) {
                            message = message + " " + inp.nextToken();
                        }
                        message = message.substring(1);
                        Operations.writeFLAP(Operations.DATA, "toc_send_im " + user + " " +
                                             Operations.encodeIM(message));
                    }
                    else if (command.equals("reply") && inp.hasMoreElements()) {

                        // process replies
                        if (Operations.replyToUser != null) {
                            while (inp.hasMoreElements()) {
                                message = message + " " + inp.nextToken();
                            }
                            message = message.substring(1);
                            Operations.writeFLAP(Operations.DATA, "toc_send_im " + Operations.replyToUser
                                                 + " " + Operations.encodeIM(message));
                        }
                    }
                    else if (command.equals("away")) {

                        // comes back from away state
                        if (!inp.hasMoreElements()) {
                            Operations.writeFLAP(Operations.DATA, "toc_set_away");
                            Operations.away = false;
                        }
                        else {

                            // set away message
                            while (inp.hasMoreElements()) {
                                message = message + " " + inp.nextToken();
                            }
                            message = message.substring(1);
                            Operations.writeFLAP(Operations.DATA, "toc_set_away " + Operations.encodeIM(message));
                            Operations.away = true;
                            Operations.awayMessage = message;
                        }
                    }
                    else if (command.equals("warn") && inp.countTokens() == 2) {

                        // warn user
                        while (inp.hasMoreElements()) {
                            message = message + " " + inp.nextToken();
                        }
                        Operations.writeFLAP(Operations.DATA, "toc_evil" + message);
                    }
                    else if (command.equals("buddy_list")) {

                        // show active buddy list
                        Enumeration buddies = Operations.buddyList.elements();
                        System.out.println("\t" + Operations.username + "'s Buddy List:\n");
                        while (buddies.hasMoreElements()) {
                            Buddy bud = (Buddy) buddies.nextElement();
                            System.out.print("\t\t" + bud.name + " ");
                            if (bud.warning > 0)
                                System.out.print("(" + bud.warning + "%)");
                            if (bud.getIdle() > 0)
                                System.out.print("\t\t" + bud.getIdle() + " min");
                            System.out.println();
                        }
                        System.out.println();
                    }
                    else if (command.equals("buddy_list_setup")) {

                        // show buddy list setup
                        System.out.println(Operations.buddyListSetup);
                    }
                    else if (command.equals("set_info") && inp.hasMoreElements()) {

                        // sets user's profile
                        while (inp.hasMoreElements()) {
                            message = message + " " + inp.nextToken();
                        }
                        message = message.substring(1);
                        Operations.writeFLAP(Operations.DATA, "toc_set_info " + Operations.encodeIM(message));
                    }
                    else if (command.equals("get_info") && inp.countTokens() == 1) {

                        // gets a user's profile
                        user = Operations.normalize(inp.nextToken());
                        Operations.writeFLAP(Operations.DATA, "toc_get_info " + user);
                    }
                    else if (command.equals("idle") && inp.countTokens() == 1) {

                        // sets idle time
                        Operations.writeFLAP(Operations.DATA, "toc_set_idle " + inp.nextToken());
                    }
                    else if (command.equals("help")) {

                        // handle help queries
                        System.out.println(help.getHelpMessage(inp));
                    }
                    else if (command.equals("exit")) {

                        System.out.println("\nThank you for using SimpleAIM.");
                        break;
                    }
                    else {

                        // no match; we don't know the command
                        System.out.print("Invalid command\t");

                        // just for debugging
                        if (Operations.DEBUG) System.out.println(command);
                        else System.out.println();
                    }
                } //end else
            } // end while
        }  // end first try catch
        catch (IOException e) {
            if (Operations.DEBUG) e.printStackTrace();
        }

        // Exit from program
        try {
            input.close();  // close input stream
            System.exit(0); // Indicates a normal exit
        }
        catch (IOException e) {
            // show stack only if in debug mode
            if (Operations.DEBUG) e.printStackTrace();
        }
    }
}





