// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__EE0C81ED_53C5_49C1_AEA9_08ED849A24D0__INCLUDED_)
#define AFX_MAINFRM_H__EE0C81ED_53C5_49C1_AEA9_08ED849A24D0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define CFrameWnd CBCGPFrameWnd

#include "FolderListBar.h"

class CWorkspaceObj;

class CMainFrame : public CFrameWnd
{
protected: // create from serialization only
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

// Attributes
public:

// Operations
public:
	void SetWorkSpace (CWorkspaceObj* pWorkSpace);
	void OnCloseFoldersPopup (BOOL bKeep);
	virtual void AdjustDockingLayout (HDWP hdwp = NULL);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void RecalcLayout(BOOL bNotify = TRUE);
	virtual BOOL LoadFrame(UINT nIDResource, DWORD dwDefaultStyle = WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, CWnd* pParentWnd = NULL, CCreateContext* pContext = NULL);
	protected:
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CBCGPMenuBar		m_wndMenuBar;
	CBCGPStatusBar		m_wndStatusBar;

	CBCGPToolBar		m_wndToolBar;
	CBCGPToolBar		m_wndToolBarAdvanced;
	CBCGPToolBar		m_wndToolBarWeb;

	CBCGPOutlookBar	m_wndBarOutlook;
	CBCGPOutlookBarPane	m_wndOutlookPane1;
	CBCGPOutlookBarPane	m_wndOutlookPane2;

	UINT			m_uiHilightedPage;

	CBCGPCaptionBar	m_wndCaption;
	CFolderListBar	m_wndFolderList;

	CSplitterWnd	m_wndSplitter;

	CTreeCtrl		m_wndTree;

	CBCGPToolBarImages	m_UserImages;
	CImageList		m_ImagesSmall;

	CObList			m_lstWorkspaces;	// List of CWorkspaceObj
	CWorkspaceObj*	m_pCurrWorkSpace;

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnViewAdvancedToolbar();
	afx_msg void OnUpdateViewAdvancedToolbar(CCmdUI* pCmdUI);
	afx_msg void OnViewWebToolbar();
	afx_msg void OnUpdateViewWebToolbar(CCmdUI* pCmdUI);
	afx_msg void OnViewOutlookbar();
	afx_msg void OnUpdateViewOutlookbar(CCmdUI* pCmdUI);
	afx_msg void OnViewCaptionbar();
	afx_msg void OnUpdateViewCaptionbar(CCmdUI* pCmdUI);
	afx_msg void OnViewFolderList();
	afx_msg void OnUpdateViewFolderList(CCmdUI* pCmdUI);
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	afx_msg void OnOutlookAddPage();
	afx_msg void OnOutlookAnimation();
	afx_msg void OnOutlookDeletePage();
	afx_msg void OnOutlookRenamePage();
	afx_msg void OnOutlookShowTextLabels();
	afx_msg void OnUpdateOutlookRenamePage(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOutlookDeletePage(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOutlookAnimation(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOutlookShowTextLabels(CCmdUI* pCmdUI);
	afx_msg void OnResetPage();
	afx_msg void OnUpdateResetPage(CCmdUI* pCmdUI);
	afx_msg void OnClose();
	//}}AFX_MSG
	afx_msg void OnViewCustomize();
	afx_msg LRESULT OnToolbarReset(WPARAM,LPARAM);
	afx_msg LRESULT OnToolbarCreateNew(WPARAM,LPARAM);
	void OnToolsViewUserToolbar (UINT id);
	void OnUpdateToolsViewUserToolbar (CCmdUI* pCmdUI);
	afx_msg LRESULT OnToolbarContextMenu(WPARAM,LPARAM);
	afx_msg void OnViewWorkSpace (UINT ud);
	afx_msg void OnViewFoldersPopup();
	DECLARE_MESSAGE_MAP()

	virtual BOOL OnShowPopupMenu (CBCGPPopupMenu* pMenuPopup);

	BOOL CreateOutlookBar ();
	BOOL CreateCaptionBar ();
	void SetBasicCommands ();

	void AddWorkSpace (const CString& strName, const int iIconIndex, const UINT uiCmd,
				   const UINT uiPageId, const UINT uiNewCmdID,
				   CImageList& images);
	int FindFocusedOutlookWnd (CBCGPOutlookWnd** ppOutlookWnd);
	CBCGPOutlookWnd* FindOutlookParent (CWnd* pWnd);
	CBCGPOutlookWnd* m_pCurrOutlookWnd;

	CBCGPOutlookBarPane* m_pCurrOutlookPage;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__EE0C81ED_53C5_49C1_AEA9_08ED849A24D0__INCLUDED_)
