/*
 * Decompiled with CFR 0.152.
 */
package jsetup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.security.Key;
import java.util.ArrayList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import jsetup.FilesToExecute;
import jsetup.FilesToInstall;
import jsetup.ShortcutsToCreate;
import jsetup.SwingWorker;
import jsetup.frmFinished;
import jsetup.frmInstall_jButton2_actionAdapter;

public class frmInstall
extends JFrame {
    private int fileSize = 0;
    private double filesSize = 0.0;
    private double dataWritten = 0.0;
    private ArrayList files = null;
    private ArrayList executes = new ArrayList();
    private ArrayList shortcuts = new ArrayList();
    private ArrayList filesToDelete = new ArrayList();
    ArrayList ar = null;
    private boolean writeUninstaller = false;
    private JFrame jfThis = this;
    SwingWorker worker = new SwingWorker(){

        public Object construct() {
            this.installFiles();
            this.executePrograms();
            this.createShortcuts();
            if (frmInstall.this.writeUninstaller) {
                this.writeUninstallLog();
            }
            frmFinished fF = new frmFinished(frmInstall.this.ar);
            fF.installPath = frmInstall.this.installPath;
            frmInstall.this.jfThis.hide();
            return null;
        }

        public void executePrograms() {
            if (frmInstall.this.executes.size() > 0 && JOptionPane.showConfirmDialog(null, "Setup needs to execute some files in order to complete the installation.\nThese files are not distributed by CompuDav. Therefore, we recommend\n that you only allow the files to be launched if\nthis installer was obtained from a credible source.\n\nWould you like to execute the files?", "Launch Files", 0, 0) == 0) {
                for (int i = 0; i < frmInstall.this.executes.size(); ++i) {
                    try {
                        FilesToExecute fte = (FilesToExecute)frmInstall.this.executes.get(i);
                        File f = new File(fte.fileName);
                        if (!f.exists()) {
                            if (JOptionPane.showConfirmDialog(null, "File to execute does not exist. Continue with setup?", "Non-Existant File", 0, 0) == 0) continue;
                            frmFinished fF = new frmFinished(frmInstall.this.ar);
                            fF.show();
                        }
                        if (!((f = new File(fte.fileToCheck)).exists() && fte.executeOnExists || !f.exists() && fte.executeOnNonExistant) && !fte.executeNeither) continue;
                        if (!fte.wait) {
                            Runtime.getRuntime().exec(fte.fileName + " " + fte.parameters);
                            continue;
                        }
                        Process p = Runtime.getRuntime().exec(fte.fileName);
                        p.waitFor();
                        if (!fte.deleteOnExit) continue;
                        f.deleteOnExit();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void installFiles() {
            frmInstall.this.jProgressBar1.setMaximum(frmInstall.this.fileSize);
            frmInstall.this.jProgressBar1.setMinimum(0);
            for (int i = 0; i < frmInstall.this.fileSize; ++i) {
                try {
                    ZipEntry ze;
                    BufferedOutputStream dest = null;
                    FilesToInstall fi = (FilesToInstall)frmInstall.this.files.get(i);
                    FileInputStream fis = new FileInputStream("data.cjs");
                    ZipInputStream zis = new ZipInputStream(fis);
                    while ((ze = zis.getNextEntry()) != null) {
                        int count;
                        FileOutputStream fos;
                        if (!ze.getName().equals(fi.readFile)) continue;
                        byte[] data = new byte[2048];
                        frmInstall.this.jlInstallFile.setText(fi.fileName);
                        try {
                            fos = new FileOutputStream(fi.installLoc + fi.fileName);
                        }
                        catch (Exception e) {
                            File fi2 = new File(fi.installLoc);
                            fi2.mkdirs();
                            fos = new FileOutputStream(fi.installLoc + fi.fileName);
                        }
                        dest = new BufferedOutputStream(fos, 2048);
                        while ((count = zis.read(data, 0, 2048)) != -1) {
                            dest.write(data, 0, count);
                        }
                        frmInstall.this.jProgressBar1.setValue(i);
                        dest.flush();
                        dest.close();
                        fos.close();
                    }
                    zis.close();
                    continue;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "There has been an error in the installation. Please contact the distributor of this software.", "Setup Error", 0);
                    System.exit(0);
                }
            }
        }

        public void createShortcuts() {
            String home = System.getProperty("user.home");
            if (home == null) {
                home = new File("~" + File.separator).getAbsolutePath();
            }
            for (int i = 0; i < frmInstall.this.shortcuts.size(); ++i) {
                FileWriter fw;
                String shortcutFileName;
                ShortcutsToCreate sc = (ShortcutsToCreate)frmInstall.this.shortcuts.get(i);
                if (System.getProperty("os.name").startsWith("Win")) {
                    try {
                        shortcutFileName = home + File.separator + "Desktop" + File.separator + sc.name + ".URL";
                        fw = new FileWriter(shortcutFileName);
                        fw.write("[InternetShortcut]\n");
                        fw.write("URL=file:///" + sc.path + "\n");
                        fw.write("IconIndex=0\n");
                        fw.write("IconFile=" + sc.icon + "\n");
                        fw.write("WorkingDirectory=" + sc.workingDir);
                        fw.close();
                        frmInstall.this.filesToDelete.add(home + File.separator + "Desktop" + File.separator + sc.name + ".URL");
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (System.getProperty("os.name").startsWith("Mac")) {
                    shortcutFileName = home + File.separator + "Desktop" + File.separator;
                    File f = new File("/bin/ln");
                    System.out.println(f.getPath());
                    String[] arguments = new String[]{f.getPath(), "-s", sc.path, shortcutFileName + sc.name.substring(0, sc.name.length())};
                    System.out.println(shortcutFileName);
                    try {
                        Runtime.getRuntime().exec(arguments);
                        frmInstall.this.filesToDelete.add(shortcutFileName + sc.name.substring(0, sc.name.length()));
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                    continue;
                }
                shortcutFileName = home + File.separator + "Desktop" + File.separator + sc.name + ".desktop";
                try {
                    fw = new FileWriter(shortcutFileName);
                    fw.write("[Desktop Entry]\n");
                    fw.write("Encoding=UTF-8\n");
                    fw.write("Type=Application\n");
                    fw.write("Exec=" + sc.path);
                    fw.write("Name=" + sc.name);
                    fw.write("Icon=" + sc.icon);
                    fw.write("Terminal=false");
                    fw.close();
                    frmInstall.this.filesToDelete.add(home + File.separator + "Desktop" + File.separator + sc.name + ".desktop");
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public void writeUninstallLog() {
            try {
                ArrayList temp = frmInstall.this.ar;
                String applicationName = "The Application";
                for (int xyz = 0; xyz < temp.size(); ++xyz) {
                    String tempString = (String)temp.get(xyz);
                    if (!tempString.startsWith("NAME")) continue;
                    applicationName = tempString.substring(5, tempString.length());
                    break;
                }
                FileWriter fw = new FileWriter(frmInstall.this.installPath + File.separator + "uninstall.jsu");
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(applicationName + "\n");
                for (int xyz = 0; xyz < frmInstall.this.filesToDelete.size(); ++xyz) {
                    if (xyz == frmInstall.this.filesToDelete.size() - 1) {
                        bw.write((String)frmInstall.this.filesToDelete.get(xyz));
                        continue;
                    }
                    bw.write((String)frmInstall.this.filesToDelete.get(xyz) + "\n");
                }
                bw.flush();
                bw.close();
                fw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    JLabel jlTitle = new JLabel();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JLabel jlImage = new JLabel();
    JProgressBar jProgressBar1 = new JProgressBar();
    JLabel jlCurrentlyInstalling = new JLabel();
    JLabel jlInstallFile = new JLabel();
    JLabel jlBillboard = new JLabel();
    public String installPath = "";
    public boolean bFull = false;
    public boolean bTypi = false;
    public boolean bMini = false;
    Cipher globalCipher = null;

    public frmInstall(ArrayList lines) {
        try {
            this.ar = lines;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        char[] key = new char[]{'J', 'S', 'C', 'F', 'G', '-', 'F', 'e', 'b', '-', 'D', 'G', 'L', 'E', 'C', '-', 'X', '9', '0', '0', '2', 'Y'};
        PBEKeySpec pksKey = new PBEKeySpec(key);
        byte[] seed = new byte[]{36, 16, -128, 47, -1, 30, 112, -82};
        PBEParameterSpec pps = new PBEParameterSpec(seed, 3);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey sk = skf.generateSecret(pksKey);
        this.globalCipher = Cipher.getInstance("PBEWithMD5AndDES");
        this.globalCipher.init(2, (Key)sk, pps);
        ((Component)this).setSize(500, 370);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setTitle("CompuDav JSetup");
        this.getContentPane().setLayout(null);
        this.jlTitle.setFont(new Font("Arial", 1, 20));
        this.jlTitle.setText("Installing!");
        this.jlTitle.setBounds(new Rectangle(148, 18, 332, 37));
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.jButton2.setDoubleBuffered(true);
        this.jButton2.addActionListener(new frmInstall_jButton2_actionAdapter(this));
        this.jProgressBar1.setBounds(new Rectangle(146, 262, 331, 23));
        this.jlCurrentlyInstalling.setText("Currently Installing:");
        this.jlCurrentlyInstalling.setBounds(new Rectangle(146, 241, 141, 17));
        this.jlInstallFile.setText("Setup is initializing.");
        this.jlInstallFile.setBounds(new Rectangle(292, 241, 184, 17));
        this.jlBillboard.setText("");
        this.jlBillboard.setBounds(new Rectangle(146, 56, 332, 174));
        this.getContentPane().add(this.jlTitle);
        this.jlImage.setToolTipText("");
        this.jlImage.setText("");
        this.jlImage.setBounds(new Rectangle(11, 2, 120, 335));
        this.jButton2.setBounds(new Rectangle(377, 301, 100, 28));
        this.jButton2.setText("Continue");
        this.getContentPane().add(this.jButton1);
        this.getContentPane().add(this.jButton2);
        this.getContentPane().add(this.jlImage);
        this.getContentPane().add(this.jProgressBar1);
        this.getContentPane().add(this.jlCurrentlyInstalling);
        this.getContentPane().add(this.jlInstallFile);
        this.getContentPane().add(this.jlBillboard);
        this.jButton1.setBounds(new Rectangle(152, 301, 100, 28));
        this.jButton1.setText("Quit");
        Properties p = System.getProperties();
        ImageIcon i = new ImageIcon(Toolkit.getDefaultToolkit().getImage(p.getProperty("user.home") + File.separator + "Sidebar.jpg"));
        this.jlImage.setIcon(i);
        ImageIcon d = new ImageIcon(Toolkit.getDefaultToolkit().getImage(p.getProperty("user.home") + File.separator + "Billboard.jpg"));
        this.jlBillboard.setIcon(d);
        ((Component)this).setVisible(true);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                frmInstall.this.initializeInstall();
            }
        };
        Timer t = new Timer(500, al);
        t.setRepeats(false);
        t.start();
    }

    public void jButton2_actionPerformed(ActionEvent e) {
        new frmFinished(this.ar);
        this.hide();
    }

    public ArrayList initializeInstall() {
        this.files = new ArrayList();
        try {
            for (int i = 0; i < this.ar.size(); ++i) {
                String[] tempPaths;
                String filesPath;
                int[] commaLocations;
                String strTemp = (String)this.ar.get(i);
                if (strTemp.startsWith("CRTE")) {
                    ZipEntry ze;
                    FileInputStream fis = new FileInputStream("data.cjs");
                    ZipInputStream zis = new ZipInputStream(fis);
                    int lastCharSplit = 0;
                    for (int k = 5; k < strTemp.length(); ++k) {
                        if (strTemp.charAt(k) != ',') continue;
                        lastCharSplit = k;
                        break;
                    }
                    String[] strArray = strTemp.split("/", lastCharSplit);
                    String[] temp = strArray[strArray.length - 1].split(",");
                    strArray[strArray.length - 1] = temp[0];
                    strArray[0] = strArray[0].substring(5, strArray[0].length());
                    String strDeleteFilePath = "";
                    for (int iterator = 0; iterator < strArray.length; ++iterator) {
                        strDeleteFilePath = strDeleteFilePath + strArray[iterator] + File.separator;
                    }
                    strDeleteFilePath = strDeleteFilePath.substring(0, strDeleteFilePath.length() - 1);
                    while ((ze = zis.getNextEntry()) != null) {
                        String dbgName = ze.getName();
                        String compareTo = temp[temp.length - 1].substring(1, temp[temp.length - 1].length());
                        String tempPath = "";
                        if (!ze.getName().equals(compareTo)) continue;
                        Properties p = System.getProperties();
                        if (strArray[0].equals("[pathtoInstall]")) {
                            tempPath = this.installPath + p.getProperty("file.separator");
                            if (strArray.length > 2) {
                                for (int j = 1; j < strArray.length - 1; ++j) {
                                    tempPath = tempPath + strArray[j] + p.getProperty("file.separator");
                                }
                            }
                        } else {
                            for (int j = 0; j < strArray.length - 1; ++j) {
                                tempPath = tempPath + strArray[j] + p.getProperty("file.separator");
                            }
                        }
                        if (!(strTemp.substring(lastCharSplit + 2, lastCharSplit + 3).equals("1") == this.bFull && this.bFull || strTemp.substring(lastCharSplit + 5, lastCharSplit + 6).equals("1") == this.bTypi && this.bTypi) && (strTemp.substring(lastCharSplit + 8, lastCharSplit + 9).equals("1") != this.bMini || !this.bMini)) continue;
                        String zipFileInfo = strTemp.substring(lastCharSplit + 11, strTemp.length());
                        String dbgzeName = ze.getName();
                        this.files.add(new FilesToInstall(strArray[strArray.length - 1], ze.getSize(), tempPath, zipFileInfo));
                        this.filesToDelete.add(strDeleteFilePath);
                    }
                    zis.close();
                    fis.close();
                }
                if (strTemp.startsWith("CEXC")) {
                    commaLocations = new int[7];
                    int counter = 0;
                    for (int k = 4; k < strTemp.length(); ++k) {
                        if (strTemp.charAt(k) != ',') continue;
                        commaLocations[counter] = k;
                        ++counter;
                    }
                    Properties p = System.getProperties();
                    filesPath = strTemp.substring(5, commaLocations[0]);
                    tempPaths = filesPath.split("/");
                    filesPath = "";
                    if (tempPaths[0].equals("[pathtoInstall]")) {
                        tempPaths[0] = this.installPath;
                    }
                    for (int y = 0; y < tempPaths.length; ++y) {
                        filesPath = y < tempPaths.length - 1 ? filesPath + tempPaths[y] + p.getProperty("file.separator") : filesPath + tempPaths[y];
                    }
                    String params = strTemp.substring(commaLocations[0] + 1, commaLocations[1]);
                    String temporary = strTemp.substring(commaLocations[1] + 1, commaLocations[2]).trim();
                    boolean wait = temporary.equals("1");
                    temporary = strTemp.substring(commaLocations[2] + 1, commaLocations[3]).trim();
                    boolean doIfExists = temporary.equals("1");
                    temporary = strTemp.substring(commaLocations[3] + 1, commaLocations[4]).trim();
                    boolean doIfNotExists = temporary.equals("1");
                    temporary = strTemp.substring(commaLocations[4] + 1, commaLocations[5]).trim();
                    boolean doIfNeither = temporary.equals("1");
                    temporary = strTemp.substring(commaLocations[5] + 1, commaLocations[6]).trim();
                    boolean delOnExit = temporary.equals("1");
                    String fileInQuestion = temporary = strTemp.substring(commaLocations[6] + 1, strTemp.length()).trim();
                    tempPaths = fileInQuestion.split("/");
                    fileInQuestion = "";
                    if (tempPaths[0].equals("[pathtoInstall]")) {
                        tempPaths[0] = this.installPath;
                    }
                    for (int y = 0; y < tempPaths.length; ++y) {
                        fileInQuestion = y < tempPaths.length - 1 ? fileInQuestion + tempPaths[y] + p.getProperty("file.separator") : fileInQuestion + tempPaths[y];
                    }
                    this.executes.add(new FilesToExecute(filesPath, params, wait, doIfExists, doIfNotExists, doIfNeither, delOnExit, fileInQuestion));
                }
                if (strTemp.startsWith("CSCT")) {
                    String[] sctIconArray;
                    commaLocations = new int[2];
                    int counter = 0;
                    for (int k = 4; k < strTemp.length(); ++k) {
                        if (strTemp.charAt(k) != ',') continue;
                        commaLocations[counter] = k;
                        ++counter;
                    }
                    Properties p = System.getProperties();
                    filesPath = strTemp.substring(5, commaLocations[0]);
                    tempPaths = filesPath.split("/");
                    filesPath = "";
                    if (tempPaths[0].equals("[pathtoInstall]")) {
                        tempPaths[0] = this.installPath;
                    }
                    for (int y = 0; y < tempPaths.length; ++y) {
                        filesPath = y < tempPaths.length - 1 ? filesPath + tempPaths[y] + p.getProperty("file.separator") : filesPath + tempPaths[y];
                    }
                    String shortcutName = strTemp.substring(commaLocations[0] + 1, commaLocations[1]);
                    String shortcutIcon = strTemp.substring(commaLocations[1] + 1, strTemp.length());
                    if (shortcutName.startsWith(" ")) {
                        shortcutName = shortcutName.substring(1, shortcutName.length());
                    }
                    if (shortcutIcon.startsWith(" ")) {
                        shortcutIcon = shortcutIcon.substring(1, shortcutIcon.length());
                    }
                    if ((sctIconArray = shortcutIcon.split("/"))[0].equals("[pathtoInstall]")) {
                        sctIconArray[0] = this.installPath;
                    }
                    shortcutIcon = "";
                    for (int y = 0; y < sctIconArray.length; ++y) {
                        shortcutIcon = y < sctIconArray.length - 1 ? shortcutIcon + sctIconArray[y] + p.getProperty("file.separator") : shortcutIcon + sctIconArray[y];
                    }
                    int lastChar = 0;
                    for (int y = 0; y < filesPath.length(); ++y) {
                        if (filesPath.charAt(y) != File.separatorChar) continue;
                        lastChar = y;
                    }
                    String workingDir = filesPath.substring(0, lastChar + 1);
                    ShortcutsToCreate stc = new ShortcutsToCreate(filesPath, shortcutName, shortcutIcon);
                    stc.workingDir = workingDir;
                    this.shortcuts.add(stc);
                }
                if (!strTemp.startsWith("UNIN")) continue;
                this.writeUninstaller = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.installFiles(this.files);
        return this.files;
    }

    public void installFiles(ArrayList files) {
        for (int jkl = 0; jkl < files.size(); ++jkl) {
            FilesToInstall fi = (FilesToInstall)files.get(jkl);
            this.filesSize += (double)fi.fileSize;
        }
        this.fileSize = files.size();
        this.worker.start();
    }
}

