#include <CNova.h>

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{
	CNova *Engine=new CNova();
	Engine->Setup(hInstance,"Example1",NO_ICON);
	
	CSurface *sprite=Engine->Graphic->Create_Surface("arrow.bmp",BITMAP_FILE);
	//creating a movie
	CMovie *movie=Engine->Create_Movie(L"C:\\DXSDK\\samples\\multimedia\\media\\butterfly.mpg");

	RECT source_rect,dest_rect;
	int x=120, y=320;
	source_rect.left=0;
	source_rect.top=0;
	source_rect.right=sprite->Width;
	source_rect.bottom=sprite->Height;

	RECT line;
	line.left=200;
	line.top=260;
	line.right=460;
	line.bottom=261;

	while(true)
	{
		//lets see how much the mouse moved
		x+=Engine->Get_XAxis();
		y+=Engine->Get_YAxis();

		dest_rect.left=x;
		dest_rect.top=y;
		dest_rect.right=sprite->Width+x;
		dest_rect.bottom=sprite->Height+y;

		if(Engine->Loop()==D_ERROR)
			if(!Engine->Graphic->Restored)
				break;
		
		if(Engine->Graphic->Blit(sprite,dest_rect,source_rect)==D_ERROR)
		{ 
			Engine->Graphic->Destroy_Surface(sprite);
			sprite=Engine->Graphic->Create_Surface("arrow.bmp",BITMAP_FILE);
		}
		 
		
		if(Engine->Key_Down(DIK_ESCAPE))
			break;
		
		if(Engine->Key_Down(DIK_F1))
		{
			Engine->Graphic->Destroy_Surface(sprite);
			Engine->Graphic->Set_Mode(1024,768,16);
			sprite=Engine->Graphic->Create_Surface("arrow.bmp",BITMAP_FILE);
		}

		//if you press P, the movie will play
		if(Engine->Key_Down(DIK_P))
		{
			movie->Play();
		}
		//lets mess with the mouse buttons
		if(Engine->Key_Down(RIGHT_MOUSE))
			break;
	}
	Engine->Destroy_Movie(movie);
	Engine->Graphic->Destroy_Surface(sprite);
	MSG temp=Engine->Get_Message();
	delete Engine;
	return temp.wParam;
}