#include <CWav.h>

//creates the wav, path, and performance
int CWav::Create(WCHAR *file,IDirectMusicLoader8 *Loader,IDirectMusicPerformance8 *Perf2,int channel)
{
	this->Destroy();
	this->Perf=Perf2;
	if(FAILED(Loader->LoadObjectFromFile(CLSID_DirectMusicSegment,IID_IDirectMusicSegment8,file,(LPVOID*) &Segment)))
		return D_ERROR;
	if(FAILED(Perf->CreateStandardAudioPath(DMUS_APATH_DYNAMIC_3D,(DWORD)channel,TRUE,&Path)))
		return D_ERROR;
	if(FAILED(Segment->Download(Path)))
		return D_ERROR;
	this->Set_Volume(100);
	IDirectSound3DListener *Listen=NULL;
    if(FAILED(Path->GetObjectInPath(0,DMUS_PATH_PRIMARY_BUFFER,0,GUID_NULL,0,IID_IDirectSound3DListener,(LPVOID*) &Listen)))
		return D_ERROR;
	if(FAILED(Listen->SetRolloffFactor(0.25f,DS3D_IMMEDIATE)))
        return D_ERROR;
    Listen->Release();
	Listen=NULL;
	return D_FINE;
}

//0 to 100
int CWav::Set_Volume(int volume)
{
	if(volume>100)
		volume=100;
	if(volume<0)
		volume=0;
	long total;
	this->volume=volume;
	if(volume!=0)
		total=(volume*20)-2000;
	if(volume==0)
		total=-9600;
	if(FAILED(Path->SetVolume(total,0)))
		return D_ERROR;
	return D_FINE;
}

//returns true if playing, false if not playing
bool CWav::Is_Playing()
{
	if(Perf->IsPlaying(Segment,NULL)==S_OK)
		return TRUE;
	return FALSE;
}

//sets the new position of the sound
int CWav::Set_Position(float x,float y,float z)
{
	IDirectSound3DBuffer8 *Buffer3D;
	if(FAILED(Path->GetObjectInPath(DMUS_PCHANNEL_ALL,DMUS_PATH_BUFFER,0,GUID_NULL,0,IID_IDirectSound3DBuffer,(LPVOID*)&Buffer3D)))
		return D_ERROR;
	if(FAILED(Buffer3D->SetPosition(x,y,z,DS3D_IMMEDIATE)))
		return D_ERROR;
	Buffer3D->Release();
	Buffer3D=NULL;
	return D_FINE;
}

//set cone angles, inside angle and outside angle
int CWav::Set_Cone(DWORD inside,DWORD outside)
{
	IDirectSound3DBuffer8 *Buffer3D;
	if(FAILED(Path->GetObjectInPath(DMUS_PCHANNEL_ALL,DMUS_PATH_BUFFER,0,GUID_NULL,0,IID_IDirectSound3DBuffer,(LPVOID*)&Buffer3D)))
		return D_ERROR;
	if(FAILED(Buffer3D->SetConeAngles(inside,outside,DS3D_IMMEDIATE)))
		return D_ERROR;
	Buffer3D->Release();
	Buffer3D=NULL;
	return D_FINE;
}

//set cone orientation
int CWav::Cone_Orientation(float x,float y,float z)
{
	IDirectSound3DBuffer8 *Buffer3D;
	if(FAILED(Path->GetObjectInPath(DMUS_PCHANNEL_ALL,DMUS_PATH_BUFFER,0,GUID_NULL,0,IID_IDirectSound3DBuffer,(LPVOID*)&Buffer3D)))
		return D_ERROR;
	if(FAILED(Buffer3D->SetConeOrientation(x,y,z,DS3D_IMMEDIATE)))
		return D_ERROR;
	Buffer3D->Release();
	Buffer3D=NULL;
	return D_FINE;
}

//set volume outside of cone (0 to 100)
int CWav::Outside_Cone_Volume(int volume)
{
	if(volume>100)
		volume=100;
	if(volume<0)
		volume=0;
	long volume2=(volume*20)-2000;
	IDirectSound3DBuffer8 *Buffer3D;
	if(FAILED(Path->GetObjectInPath(DMUS_PCHANNEL_ALL,DMUS_PATH_BUFFER,0,GUID_NULL,0,IID_IDirectSound3DBuffer,(LPVOID*)&Buffer3D)))
		return D_ERROR;
	if(FAILED(Buffer3D->SetConeOutsideVolume(volume2,DS3D_IMMEDIATE)))
		return D_ERROR;
	Buffer3D->Release();
	Buffer3D=NULL;
	return D_FINE;
}

//set the velocity vector
int CWav::Set_Velocity(float x,float y,float z)
{
	IDirectSound3DBuffer8 *Buffer3D;
	if(FAILED(Path->GetObjectInPath(DMUS_PCHANNEL_ALL,DMUS_PATH_BUFFER,0,GUID_NULL,0,IID_IDirectSound3DBuffer,(LPVOID*)&Buffer3D)))
		return D_ERROR;
	if(FAILED(Buffer3D->SetVelocity(x,y,z,DS3D_IMMEDIATE)))
		return D_ERROR;
	Buffer3D->Release();
	Buffer3D=NULL;
	return D_FINE;
}

//set the doppler factor (1 is normal, max of 10, min of 0)
int CWav::Set_Doppler_Factor(float factor)
{
	if(factor<0)
		factor=0;
	if(factor>10)
		factor=10;
	IDirectSound3DListener8 *Listen;
	if(FAILED(Path->GetObjectInPath(0,DMUS_PATH_PRIMARY_BUFFER,0,GUID_NULL,0,IID_IDirectSound3DListener,(LPVOID*) &Listen)))
		return D_ERROR;
	if(FAILED(Listen->SetDopplerFactor(factor,DS3D_IMMEDIATE)))
		return D_ERROR;
	Listen->Release();
	Listen=NULL;
	return D_FINE;
}

//plays a sound
int CWav::Play()
{
	if(this->volume==0)
		return D_FINE;
	if(FAILED(Perf->PlaySegmentEx(Segment,NULL,NULL,DMUS_SEGF_SECONDARY,0,NULL,NULL,Path)))
		return D_ERROR;
	return D_FINE;
}

int CWav::Stop()
{
	if(this->Is_Playing())
	{
		if(FAILED(Perf->Stop(Segment,NULL,0,0)))
			return D_ERROR;
	}
	return D_FINE;
}

//destroys the class
int CWav::Destroy()
{
	if(Segment!=NULL)
	{
		Segment->Unload(Path);
		Segment->Release();
		Segment=NULL;
	}
	if(Path!=NULL)
	{
		Path->Activate(FALSE);
		Path->Release();
		Path=NULL;
	}
	return D_FINE;
}

CWav::CWav()
{
	Segment=NULL;
	Perf=NULL;
	Path=NULL;
}

CWav::~CWav()
{
	this->Destroy();
}