#include <CWindow.h>

HDC main_hdc;
int ico;
bool quiting;
int g_Active;

LRESULT CALLBACK WindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	PAINTSTRUCT	ps;
	HDC			hdc;
	hdc=main_hdc;
	switch(msg)
	{
		case WM_CREATE:
		{
			return 0;
		} break;
		case WM_PAINT:
		{
			hdc=BeginPaint(hwnd,&ps);
			EndPaint(hwnd,&ps);
			return 0;
		} break;
		case WM_DESTROY:
		{
			quiting=FALSE;
			PostQuitMessage(0);
			return 0;
		} break;
		case WM_ACTIVATE:
		{
			if(LOWORD(wparam)==WA_INACTIVE)
			{
				if(ico==1)
					ShowCursor(TRUE);
				g_Active=NOT_ACTIVE;
			}
			else
			{
				if(ico==1)
					ShowCursor(FALSE);
				g_Active=ACTIVE;
			}
		}break;
	}
	return (DefWindowProc(hwnd,msg,wparam,lparam));
}

HINSTANCE CWindow::Get_HINSTANCE()
{
	return hinst_main;
}

HWND CWindow::Get_HWND()
{
	return main_win;
}

CWindow::CWindow(){
	g_Active=ACTIVE;
	ico=0;
	main_hdc=NULL;
	width=GetSystemMetrics(SM_CXSCREEN);
	height=GetSystemMetrics(SM_CYSCREEN);
	cursor_state=1;
	quiting=FALSE;
}

CWindow::~CWindow()
{
	if(ico==1)
	{
		ShowCursor(TRUE);
		ico=2;
	}
}

void CWindow::Close_Message()
{
	SendMessage(main_win,WM_CLOSE,0,0);
}

int CWindow::Create_Window(HINSTANCE hinstance, char title[], int icon, int cursor)
{
	WNDCLASSEX	winclass;	//class
	HWND		hwnd;		//window handle
	
	winclass.cbSize=sizeof(WNDCLASSEX);
	winclass.style=CS_HREDRAW | CS_VREDRAW| CS_DBLCLKS| CS_OWNDC;
	winclass.lpfnWndProc=WindowProc;
	winclass.cbClsExtra=0;
	winclass.cbWndExtra=0;
	winclass.hInstance=hinstance;
	if(icon!=NO_ICON)
		winclass.hIcon=LoadIcon(hinstance,MAKEINTRESOURCE(icon));
	else
		winclass.hIcon=LoadIcon(hinstance,IDI_APPLICATION);
	if(cursor==NO_CURSOR)
	{
		ico=1;
		ShowCursor(FALSE);
		winclass.hCursor=LoadCursor(NULL,IDC_ARROW);
	}
	else
		winclass.hCursor=LoadCursor(NULL,MAKEINTRESOURCE(cursor));
	winclass.hbrBackground=(HBRUSH)GetStockObject(BLACK_BRUSH);
	winclass.lpszMenuName=NULL;
	winclass.lpszClassName=WINDOW_CLASS_NAME;
	if(icon!=NO_ICON)
		winclass.hIconSm=LoadIcon(hinstance,MAKEINTRESOURCE(icon));
	else
		winclass.hIconSm=LoadIcon(hinstance,IDI_APPLICATION);

	if(!RegisterClassEx(&winclass))
		return D_ERROR;

	if(!(hwnd=CreateWindowEx(NULL,WINDOW_CLASS_NAME,title,WS_VISIBLE|WS_POPUP,0,0,width,height,NULL,NULL,hinstance,NULL)))
		return D_ERROR;

	main_win=hwnd;
	HDC	hdc=GetDC(hwnd);
	main_hdc=hdc;
	hinst_main=hinstance;
	return(D_FINE);
}

int CWindow::Check_Message()
{
	g_Active=NO_CHANGE;
	do
	{
		while(PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			if(msg.message==WM_QUIT)
			{
				return -1;
			}
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		if(g_Active==NO_CHANGE)
			break;
		if(g_Active==NOT_ACTIVE)
			ShowWindow(this->main_win,SW_MINIMIZE);
	}while(g_Active!=ACTIVE);
	return D_FINE;
}
