#ifndef __wav__
#define __wav__

#include <globals.h>
#ifdef DEBUG_NOVA
#pragma comment(lib,"CWavD.lib")
#endif
#ifndef DEBUG_NOVA
#pragma comment(lib,"CWav.lib")
#endif

class CWav
{
private:
	IDirectMusicSegment8 *Segment;
	IDirectMusicPerformance8 *Perf;
	IDirectMusicAudioPath8 *Path;

	int volume;
public:
	CWav();
	~CWav();
	int Create(WCHAR *file,IDirectMusicLoader8 *Loader,IDirectMusicPerformance8 *Perf2,int channel);
	int Play();
	int Destroy();
	int Set_Volume(int volume);
	int Set_Position(float x,float y,float z);
	int Set_Cone(DWORD inside,DWORD outside);
	int Cone_Orientation(float x,float y,float z);
	int Outside_Cone_Volume(int volume);
	int Set_Velocity(float x,float y,float z);
	int Set_Doppler_Factor(float factor);
	bool Is_Playing();
	int Stop();
};

#endif