/*
 * Decompiled with CFR 0.152.
 */
package org.aris.hldb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import org.aris.hldb.CS;
import org.aris.hldb.Common;
import org.aris.hldb.NamedParam;
import org.aris.hldb.pools.ConnectionProviderI;
import org.aris.hldb.servers.DBServerI;

public class Sql {
    private ConnectionProviderI hlcon;
    private CS hl_cs;
    private DBServerI sqlSPParser;

    public Sql(CS hlcs, Class sqlSPParser) throws InstantiationException, IllegalAccessException {
        this.hl_cs = hlcs;
        this.hlcon = this.hl_cs.gethlCon();
        this.sqlSPParser = (DBServerI)sqlSPParser.newInstance();
        this.sqlSPParser.spCreator(this.hlcon);
    }

    public void Add(String filename, int maxInPool) throws FileNotFoundException, IOException, Exception {
        this.Add(filename, 1003, 1007, maxInPool);
    }

    public void AddSql(String key, String sql, int resultSetType, int resultSetConcurency, int maxInPool) throws FileNotFoundException, IOException, Exception {
        StringBuffer buf = new StringBuffer("[");
        buf.append(key).append("]\n").append(sql);
        StringReader rdr = new StringReader(buf.toString());
        this.Add(rdr, resultSetType, resultSetConcurency, maxInPool);
    }

    public void AddSql(String key, String sql, int maxInPool) throws FileNotFoundException, IOException, Exception {
        this.AddSql(key, sql, 1003, 1007, maxInPool);
    }

    public void Add(String filename, int resultSetType, int resultSetConcurency, int maxInPool) throws FileNotFoundException, IOException, Exception {
        FileReader rdr = new FileReader(filename);
        this.Add(rdr, resultSetType, resultSetConcurency, maxInPool);
    }

    public void Add(Reader rdr, int resultSetType, int resultSetConcurency, int maxInPool) throws FileNotFoundException, IOException, Exception {
        String line;
        BufferedReader f = new BufferedReader(rdr);
        Stack<NamedParam> sqlparams = new Stack<NamedParam>();
        int linen = 1;
        while ((line = f.readLine()) != null) {
            if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                String key;
                if (line.charAt(0) != '[') {
                    throw new Exception("hlSql: '[' expected at line " + String.valueOf(linen) + ". Found [" + line + "] instead.");
                }
                StringBuffer call = new StringBuffer();
                int paramcount = 0;
                int idx = line.indexOf(93);
                int eq = line.indexOf(61);
                if (eq > -1) {
                    key = line.substring(1, eq);
                    call.append(line.substring(eq + 1, idx));
                } else {
                    int k1;
                    key = line.substring(1, idx);
                    String sql = Common.gline(f);
                    ++linen;
                    if (sql.compareTo("{") == 0) {
                        sql = "";
                        while ((line = Common.gline(f)).compareTo("}") != 0) {
                            sql = String.valueOf(sql) + line + "\n";
                            ++linen;
                        }
                    }
                    int l = sql.length();
                    int i = 0;
                    while (i < l) {
                        if (sql.charAt(i) == '?') {
                            ++paramcount;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < paramcount) {
                        line = Common.gline(f);
                        ++linen;
                        NamedParam np = new NamedParam();
                        np.name = null;
                        np.type = line;
                        sqlparams.push(np);
                        ++i;
                    }
                    while ((k1 = sql.indexOf(124)) > -1) {
                        int k2 = sql.indexOf(124, k1 + 1);
                        String s = sql.substring(k1 + 1, k2);
                        String[] nt = s.split(",");
                        NamedParam np = new NamedParam();
                        np.name = nt[0];
                        np.type = nt[1];
                        if (!sqlparams.contains(np)) {
                            sqlparams.push(np);
                            ++paramcount;
                        }
                        sql = String.valueOf(sql.substring(0, k1)) + "@" + np.name + sql.substring(k2 + 1);
                    }
                    this.sqlSPParser.CreateStoredProcedure(key, sql, sqlparams, paramcount);
                    call.append("{call ");
                    call.append(Common.SP_Prefix).append(key).append("(");
                    int i2 = 1;
                    while (i2 < paramcount) {
                        call.append("?,");
                        ++i2;
                    }
                    sqlparams.clear();
                    if (paramcount == 0) {
                        call.append(")}");
                    } else {
                        call.append("?)}");
                    }
                }
                String cll = call.toString();
                if (Common.debug) {
                    System.out.println("hlSQL: SQL key: [" + key + "]");
                    System.out.println("hlSQL: Parameters: " + String.valueOf(paramcount));
                    System.out.println("hlSQL: Call=" + cll);
                }
                this.hl_cs.addSqlCall(key, cll, resultSetType, resultSetConcurency, maxInPool);
            }
            ++linen;
        }
        f.close();
    }
}

