<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "<xsl:text><![CDATA[ ]]></xsl:text>">
	<!ENTITY nl "<xsl:text><![CDATA[
]]></xsl:text>">
	<!ENTITY copylogo "&#169;">
	<!ENTITY cnl "&lt;P&gt;">
]>
<!--
	This template is used as the base for making custom class templates for databases.
	
	Author : Konstantine Kougios
	Version: 0.9Beta
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="yes" encoding="UTF-8" omit-xml-declaration="yes"/>

<xsl:template match="ROOT">
<!--
	==================================================================================================================
	Start of the template
	==================================================================================================================
-->
 <!--
	==================================================================================================================
	Package declaration and static imports
	==================================================================================================================
-->
 
package <xsl:value-of select="CLASSINFO/@package"/>;

import org.aris.hldb.CS;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Iterator;
<xsl:if test="//template/willBeExtended!='true'">
import org.jdom.Element;
</xsl:if>

<!--
	==================================================================================================================
	Imports defined in the user's configuration.xml
	==================================================================================================================
-->
<xsl:value-of select="template/imports"/>

<!--
	==================================================================================================================
	Start of the class
	==================================================================================================================
-->
/**
 * TABLE: <xsl:value-of select="CLASSINFO/@tableName"/>&cnl;
 * 
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.&cnl;
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.&cnl;
 *
 * This class was generated with the OODBFramework &copylogo; 2004 Konstantine Kougios.&cnl;
 */
<xsl:value-of select="template/modifiers"/> class <xsl:value-of select="CLASSNAME"/>
<xsl:if test="template/extends!=''">
	extends <xsl:value-of select="template/extends"/>
</xsl:if>
	 implements Cloneable
{
<!--
	==================================================================================================================
	Start of the variable declarations
	==================================================================================================================
-->
	// dirty bit
	protected boolean isDirty=false;
	// Connection
	protected CS cs;
	// ============================================================================
	// =       Variable declaration, according to table columns.                  =
	// ============================================================================
<xsl:for-each select="COLUMN">
	protected <xsl:value-of select="@javaType"/>&nbsp;<xsl:value-of select="@name"/>;
	<xsl:if test="@javaType='java.io.InputStream'">
		// length of this binary stream
		protected int&nbsp;<xsl:value-of select="@name"/>Len;
	</xsl:if>
	<xsl:if test="@primaryKey!=''">
		protected <xsl:value-of select="@javaType"/>&nbsp;old_<xsl:value-of select="@name"/>; // Old value of the key is kept too
	</xsl:if>
</xsl:for-each>
	
<!--
	==================================================================================================================
	Constructors
	==================================================================================================================
-->
	// ============================================================================
	// =                  Constructors                                            =
	// ============================================================================
	
	/**
	 * default constructor, protected. 
	 */
	protected <xsl:value-of select="CLASSNAME"/>()
	{
	}
	
	/**
	 * use this to create a new row by calling the setters and then insert().
	 */
	public <xsl:value-of select="CLASSNAME"/>(CS cs)
	{
		this.cs=cs;
	}
<xsl:choose>
<xsl:when test="count(PRIMARYKEYS)>0">	
	/**
	 * Get from primary key(s), queries the database
	 */
	public <xsl:value-of select="CLASSNAME"/>(CS cs,<xsl:value-of select="PRIMARYKEYS/@commaSepJavaType"/>) throws SQLException
	{
		this.cs=cs;
		CallableStatement cc=null;
		ResultSet rs=null;
		try
		{
			cc=cs.allocCS("SELECT_<xsl:value-of select="//CLASSNAME"/>");
		<xsl:for-each select="PRIMARYKEYS/KEY">
			cc.set<xsl:value-of select="COLUMN/@resultSetGetSet"/>(<xsl:value-of select="position()"/>,<xsl:value-of select="@column"/>);
		</xsl:for-each>
			rs=cc.executeQuery();
			rs.next();
			setFromRs(rs);
		} finally
		{
			if (rs!=null) rs.close();
			cs.freeCS(cc);
		}
	<xsl:if test="template/debug>0">
		// template/debug was set to >0 during conversion
	</xsl:if>
	}
</xsl:when>
<xsl:otherwise>
</xsl:otherwise>
</xsl:choose>
	/**
	 * Constructor by ResultSet (which must contain all columns = SELECT *)
	 * @param cs  A cache of callable statements
	 * @param rs  the ResultSet
	 */
	public <xsl:value-of select="CLASSNAME"/>(CS cs,java.sql.ResultSet rs) throws java.sql.SQLException
	{
		this.cs=cs;
		setFromRs(rs);
	}
<!--
	==================================================================================================================
	Utility functions
	==================================================================================================================
-->
	/**
	 * This is usefull for reusing of this class. Also, the constructors use this
	 */
	public void setFromRs(ResultSet rs) throws SQLException
	{
		<xsl:for-each select="COLUMN[@javaType!='java.io.InputStream']">
				<xsl:value-of select="@name"/>=
				<xsl:if test="@primaryKey!=''">
					old_<xsl:value-of select="@name"/>=
				</xsl:if>
				<xsl:if test="@allocateVar=1">new <xsl:value-of select="@javaType"/>(</xsl:if>
				rs.get<xsl:value-of select="@resultSetGetSet"/>("<xsl:value-of select="@name"/>")
				<xsl:if test="@allocateVar=1">);
				if (rs.wasNull()) <xsl:value-of select="@name"/>=null;
				</xsl:if>;
		</xsl:for-each>
	}
	
<!--
	==================================================================================================================
	Setters and getters
	==================================================================================================================
-->
	// ============================================================================
	// =                  Setters and getters                                     =
	// ============================================================================
<xsl:for-each select="COLUMN">

	/**
	 * Getter for <xsl:value-of select="@name"/>.
	 * <xsl:value-of select="@remarks"/>
	 */
<xsl:choose>
	<xsl:when test="@javaType='java.io.InputStream'">protected</xsl:when>
	<xsl:otherwise>public</xsl:otherwise>
</xsl:choose>
	&nbsp;<xsl:value-of select="@javaType"/> get<xsl:value-of select="@name"/>()
	{
		return <xsl:value-of select="@name"/>;
	}
	
	/**
	 * Setter for <xsl:value-of select="@name"/>.
	 * <xsl:value-of select="@remarks"/>
	 */
<xsl:choose>
	<xsl:when test="@identity=0">public</xsl:when>
	<xsl:otherwise>protected</xsl:otherwise>
</xsl:choose>
<xsl:choose>
<xsl:when test="@javaType='java.io.InputStream'">
	void set<xsl:value-of select="@name"/>(<xsl:value-of select="@javaType"/> stream,int length)
	{
		this.<xsl:value-of select="@name"/>=stream;
		this.<xsl:value-of select="@name"/>Len=length;
		isDirty=true;
	}
</xsl:when>
<xsl:otherwise>
	void set<xsl:value-of select="@name"/>(<xsl:value-of select="@javaType"/> value)
	{
		this.<xsl:value-of select="@name"/>=value;
		isDirty=true;
	}	
</xsl:otherwise>
</xsl:choose>
<!--
	==================================================================================================================
	Getters for multiple results
	==================================================================================================================
-->
<xsl:if test="@dbType!='text' and @dbType!='ntext' and @javaType!='java.io.InputStream'">
	/**
	 * Gets a ResultSet (by CallableStatement.getResultSet()) of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
	 */
	public CallableStatement getResultSetWithSameValueOf<xsl:value-of select="@name"/>(int maxResults) throws SQLException
	{
		return getResultSetWith<xsl:value-of select="@name"/>ValueOf(cs,get<xsl:value-of select="@name"/>(),maxResults);
	}
	
	/**
	 * Gets a ResultSet (by CallableStatement.getResultSet()) of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
	 */
	public static CallableStatement getResultSetWith<xsl:value-of select="@name"/>ValueOf(CS cs,<xsl:value-of select="@javaType"/> value,int maxResults) throws SQLException
	{
		CallableStatement cc=cs.allocCS("SELECT_<xsl:value-of select="//CLASSNAME"/>_<xsl:value-of select="@name"/>");
		cc.setMaxRows(maxResults);
		
		try
		{
		<xsl:if test="@nullable=1">
			if (value==null) 
				cc.setNull(1,<xsl:value-of select="@java.sql.Types"/>);
			else
		</xsl:if>
				cc.set<xsl:value-of select="@resultSetGetSet"/>(1,value<xsl:value-of select="@convertorToPrimitive"/>);
			//ResultSet rs=
			cc.executeQuery();
		} catch (SQLException e)
		{
			cs.freeCS(cc);
			throw e;
		} finally {
			cc.setMaxRows(Integer.MAX_VALUE);
		}
		<xsl:if test="template/debug>0">
			// template/debug was set to >0 during conversion
		</xsl:if>
		return cc;
	}

	/**
	 * Gets a LinkedList of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the same <xsl:value-of select="@name"/> as this instance.
	 */
	public LinkedList getLinkedListWithSameValueOf<xsl:value-of select="@name"/>(int maxResults) throws SQLException
	{
		return getLinkedListWith<xsl:value-of select="@name"/>ValueOf(cs,get<xsl:value-of select="@name"/>(),maxResults);
	}
	
	/**
	 * Gets a LinkedList of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the "value".
	 */
	public static LinkedList getLinkedListWith<xsl:value-of select="@name"/>ValueOf(CS cs, <xsl:value-of select="@javaType"/> value,int maxResults) throws SQLException
	{
		CallableStatement cc=getResultSetWith<xsl:value-of select="@name"/>ValueOf(cs,value,maxResults);
		LinkedList ll=new LinkedList();
		try
		{
			ResultSet rs=cc.getResultSet();
			while (rs.next())
			{
				ll.addLast(new <xsl:value-of select="//CLASSNAME"/>(cs,rs));
			}
		} finally
		{
			cs.freeCS(cc);
		}
		return ll;
	}

	/**
	 * Gets an Iterator of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the same <xsl:value-of select="@name"/> as this instance.
	 */
	public Iterator getIteratorWithSameValueOf<xsl:value-of select="@name"/>(int maxResults) throws SQLException
	{
		return getIteratorWith<xsl:value-of select="@name"/>ValueOf(cs,get<xsl:value-of select="@name"/>(),maxResults);
	}
	
	/**
	 * Gets an Iterator of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the "value".
	 */
	public static Iterator getIteratorWith<xsl:value-of select="@name"/>ValueOf(CS cs, <xsl:value-of select="@javaType"/> value,int maxResults) throws SQLException
	{
		return getLinkedListWith<xsl:value-of select="@name"/>ValueOf(cs,value,maxResults).iterator();
	}
</xsl:if>
</xsl:for-each>

	/**
	 * Free a callable statement that was returned by any of the class's members
	 */
	public void freeCS(CallableStatement callableStatement)
	{
		cs.freeCS(callableStatement);
	}
<!--
	==================================================================================================================
	Delete method, based on primary keys.
	==================================================================================================================
-->
	// ============================================================================
	// =                  Delete and Update methods                               =
	// ============================================================================
<xsl:if test="count(PRIMARYKEYS)>0">	
	/**
	 * Delete the current object from database
	 */
	public int delete() throws SQLException
	{
		return <xsl:value-of select="//CLASSNAME"/>.delete(cs,<xsl:value-of select="PRIMARYKEYS/@commaSep"/>);
	}
	
	/**
	 * Delete an row from database
	 */
	public static int delete(CS cs,<xsl:value-of select="PRIMARYKEYS/@commaSepJavaType"/>) throws SQLException
	{
		CallableStatement cc=null;
		int res=0;
		try
		{
			cc=cs.allocCS("DELETE_<xsl:value-of select="//CLASSNAME"/>");
		<xsl:for-each select="PRIMARYKEYS/KEY">
			cc.set<xsl:value-of select="COLUMN/@resultSetGetSet"/>(<xsl:value-of select="position()"/>,<xsl:value-of select="@column"/>);
		</xsl:for-each>
			res=cc.executeUpdate();
		} finally
		{
			cs.freeCS(cc);
		}

		<xsl:if test="template/debug>0">
			// template/debug was set to >0 during conversion
		</xsl:if>
		return res;
	}

<!--
	==================================================================================================================
	Update methods, based on primary keys.
	==================================================================================================================
-->
	<!-- Update exists only if table contains more than 1 non-identity field -->
<xsl:variable name="countPKID0" select="count(COLUMN[@primaryKey='' and @identity=0 and @dbType!='timestamp'])"/>
<xsl:if test="$countPKID0>0">
	/**
	 * Update the current object to the database (primary keys/autoincrements are not updated)
	 */
	public int update() throws SQLException
	{
		if (isDirty)
		{
			CallableStatement cc=null;
			int res=0;
			try
			{
				cc=cs.allocCS("UPDATE_<xsl:value-of select="//CLASSNAME"/>");
			<xsl:for-each select="COLUMN[@primaryKey='' and @identity=0 and @dbType!='timestamp']">
				<xsl:if test="@allocateVar=1">
					if (<xsl:value-of select="@name"/>==null)
						cc.setNull(<xsl:value-of select="position()"/>,<xsl:value-of select="@java.sql.Types"/>);
						else
				</xsl:if>
				cc.set<xsl:value-of select="@resultSetGetSet"/>(<xsl:value-of select="position()"/>,get<xsl:value-of select="@name"/>()<xsl:value-of select="@convertorToPrimitive"/><xsl:if test="@resultSetGetSet='BinaryStream'">,0</xsl:if>);
			</xsl:for-each>
			<xsl:for-each select="PRIMARYKEYS/KEY">
				cc.set<xsl:value-of select="COLUMN/@resultSetGetSet"/>(<xsl:value-of select="position()+$countPKID0"/>,get<xsl:value-of select="COLUMN/@name"/>()<xsl:value-of select="COLUMN/@convertorToPrimitive"/>);
			</xsl:for-each>
				res=cc.executeUpdate();
				isDirty=false;
			} finally
			{
				cs.freeCS(cc);
			}
			
			<xsl:if test="template/debug>0">
				// template/debug was set to >0 during conversion
			</xsl:if>
			return res;
		}
		return -1;
	}
</xsl:if>

	private void updateOldKeys()
	{
		// update the old_x old key values
		<xsl:for-each select="PRIMARYKEYS/KEY">
			old_<xsl:value-of select="@column"/>=<xsl:value-of select="@column"/>;
		</xsl:for-each>
	}
	
<xsl:variable name="countID0" select="count(COLUMN[@identity=0 and @dbType!='timestamp'])"/>
<xsl:if test="$countID0>$countPKID0">
	/**
	 * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
	 */
	public int updateAll() throws SQLException
	{
		if (isDirty)
		{
			CallableStatement cc=null;
			int res=0;
			try
			{
				cc=cs.allocCS("UPDATEALL_<xsl:value-of select="//CLASSNAME"/>");
			<xsl:for-each select="COLUMN[@identity=0 and @dbType!='timestamp']">
				<xsl:if test="@allocateVar=1">
					if (<xsl:value-of select="@name"/>==null)
						cc.setNull(<xsl:value-of select="position()"/>,<xsl:value-of select="@java.sql.Types"/>);
						else
				</xsl:if>
				cc.set<xsl:value-of select="@resultSetGetSet"/>(<xsl:value-of select="position()"/>,get<xsl:value-of select="@name"/>()<xsl:value-of select="@convertorToPrimitive"/><xsl:if test="@resultSetGetSet='BinaryStream'">,0</xsl:if>);
			</xsl:for-each>
			<xsl:for-each select="PRIMARYKEYS/KEY">
				cc.set<xsl:value-of select="COLUMN/@resultSetGetSet"/>(<xsl:value-of select="position()+$countID0"/>,old_<xsl:value-of select="@column"/><xsl:value-of select="COLUMN/@convertorToPrimitive"/>);
			</xsl:for-each>
				res=cc.executeUpdate();
				isDirty=false;
			} finally
			{
				cs.freeCS(cc);
			}
			
			<xsl:if test="template/debug>0">
				// template/debug was set to >0 during conversion
			</xsl:if>
			updateOldKeys();
			return res;
		}
		return -1;
	}
</xsl:if>
</xsl:if>

<!--
	==================================================================================================================
	Insert methods
	==================================================================================================================
-->
	/**
	 * Inserts this new object to a new row (all columns are inserted, except the identities)
	 * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
	 * as set by the insert into () sql.
	 * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
	 * Thus, some synchronization maybe necessary for this call to complete atomically.
	 */
	public synchronized void insert() throws SQLException
	{
		CallableStatement cc=null;
		<xsl:if test="count(COLUMN[@identity='1'])>0">	
		ResultSet rs=null;
		</xsl:if>
		try
		{
			cc=cs.allocCS("INSERT_<xsl:value-of select="//CLASSNAME"/>");
		<xsl:for-each select="COLUMN[@identity=0 and @dbType!='timestamp']">
				<xsl:if test="@allocateVar=1">
					if (<xsl:value-of select="@name"/>==null)
						cc.setNull(<xsl:value-of select="position()"/>,<xsl:value-of select="@java.sql.Types"/>);
						else
				</xsl:if>
			cc.set<xsl:value-of select="@resultSetGetSet"/>(<xsl:value-of select="position()"/>,get<xsl:value-of select="@name"/>()<xsl:value-of select="@convertorToPrimitive"/><xsl:if test="@resultSetGetSet='BinaryStream'">,<xsl:value-of select="@name"/>Len</xsl:if>);
		</xsl:for-each>
		<xsl:choose>
			<xsl:when test="count(COLUMN[@identity='1'])>0">	
				rs=cc.executeQuery();
				rs.next();
			</xsl:when>
			<xsl:otherwise>
				cc.executeUpdate();
			</xsl:otherwise>
		</xsl:choose>
		<xsl:for-each select="COLUMN[@identity='1']">
			set<xsl:value-of select="@name"/>(rs.get<xsl:value-of select="@resultSetGetSet"/>(<xsl:value-of select="position()"/>));
		</xsl:for-each>
		<xsl:if test="count(PRIMARYKEYS)>0">	
			updateOldKeys();
		</xsl:if>
				isDirty=false;
		} finally
		{
		<xsl:if test="count(COLUMN[@identity='1'])>0">	
			if (rs!=null) rs.close();
		</xsl:if>
			cs.freeCS(cc);
		}
		<xsl:if test="template/debug>0">
			// template/debug was set to >0 during conversion
		</xsl:if>
	}

<!--
	==================================================================================================================
	Getters/Setters for the cross referenced classes.
	==================================================================================================================
-->
<xsl:if test="//template/willBeExtended!='true'">
	<!-- produce these, only if the class won't be subclassed -->
<xsl:for-each select="CROSSREFERENCES/RELATIONSHIP">
	<xsl:variable name="refclass"><xsl:value-of select="@references"/><xsl:value-of select="//template/ext"/></xsl:variable>
	/**
	 * Sets this row of <xsl:value-of select="//CLASSINFO/@tableName"/> to reference the ref row of <xsl:value-of select="@references"/>
	 */
	public void set<xsl:value-of select="@helpStr"/>Ref(<xsl:value-of select="$refclass"/> ref)
	{
	<xsl:for-each select="CROSSREFERENCE">
		<xsl:choose>
			<xsl:when test="@fkNullable=0">
				set<xsl:value-of select="@fkcolumn"/>(ref.get<xsl:value-of select="@pkcolumn"/>());
			</xsl:when>
			<xsl:otherwise>
				set<xsl:value-of select="@fkcolumn"/>(new <xsl:value-of select="@fkcolumnJavaType"/>(ref.get<xsl:value-of select="@pkcolumn"/>()));
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>		
	}

	/**
	 * Gets this row of <xsl:value-of select="//CLASSINFO/@tableName"/> from referenced row of <xsl:value-of select="@references"/>
	 */
	public <xsl:value-of select="$refclass"/> get<xsl:value-of select="@helpStr"/>Ref() throws SQLException
	{
		return get<xsl:value-of select="@helpStr"/>Ref(cs);
	}
	
	/**
	 * Gets this row of <xsl:value-of select="//CLASSINFO/@tableName"/> from referenced row of <xsl:value-of select="@references"/>
	 */
	public <xsl:value-of select="$refclass"/> get<xsl:value-of select="@helpStr"/>Ref(CS cs) throws SQLException
	{
		<xsl:if test="count(CROSSREFERENCE[@fkNullable!=0])">
			if (
				<xsl:for-each select="CROSSREFERENCE[@fkNullable!=0]">
					<xsl:if test="position()>1">||</xsl:if>
					get<xsl:value-of select="@fkcolumn"/>()==null
				</xsl:for-each>
				) return null;
		</xsl:if>	
			
		return new <xsl:value-of select="$refclass"/>(cs
	<xsl:for-each select="CROSSREFERENCE">
		<xsl:choose>
			<xsl:when test="@fkNullable=0">
				,get<xsl:value-of select="@fkcolumn"/>()
			</xsl:when>
			<xsl:otherwise>
				,get<xsl:value-of select="@fkcolumn"/>()<xsl:value-of select="@fkcolumnJavaTypePrimitiveConverter"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>);	
	}
</xsl:for-each>
</xsl:if>

<!--
	==================================================================================================================
	Debugging helpers.
	==================================================================================================================
-->
	public void dump(String prefix)
	{
	<xsl:for-each select="COLUMN[@javaType!='java.io.InputStream']">
		System.out.println(prefix+"<xsl:value-of select="@name"/>:"+get<xsl:value-of select="@name"/>());
	</xsl:for-each>
	}
	
	public void dump()
	{
		dump("");
	}
<!--
	==================================================================================================================
	XML utilities
	==================================================================================================================
-->
<xsl:if test="//template/willBeExtended!='true'">

<xsl:variable name="crossrefCnt" select="count(CROSSREFERENCES/RELATIONSHIP)"/>
	/**
	 * returns the XML form of this object and depth childs
	 */
	public Element toXML(int depth)<xsl:if test="$crossrefCnt>0"> throws SQLException</xsl:if>
	{
		Element root=new Element("<xsl:value-of select="CLASSNAME"/>");
		<xsl:for-each select="COLUMN[@javaType!='java.io.InputStream']">
			<xsl:choose>
				<xsl:when test="@toXmlMode=0">
					root.setAttribute("<xsl:value-of select="@name"/>",
					<xsl:if test="@javaType!='String'">String.valueOf(</xsl:if>
					get<xsl:value-of select="@name"/>()
					<xsl:if test="@javaType!='String'">)</xsl:if>
					);
				</xsl:when>
				<xsl:when test="@toXmlMode=1">
					root.addContent(new Element("<xsl:value-of select="@name"/>").setText(
					<xsl:if test="@javaType!='String'">String.valueOf(</xsl:if>
						get<xsl:value-of select="@name"/>()
					<xsl:if test="@javaType!='String'">)</xsl:if>
						));
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		
		<xsl:if test="$crossrefCnt>0">
		if (depth>0)
		{
		<xsl:for-each select="CROSSREFERENCES/RELATIONSHIP">
			<xsl:variable name="refclass"><xsl:value-of select="@references"/><xsl:value-of select="//template/ext"/></xsl:variable>
			<xsl:value-of select="$refclass"/>&nbsp;temp<xsl:value-of select="position()"/>=get<xsl:value-of select="@helpStr"/>Ref(cs);
			if (temp<xsl:value-of select="position()"/>!=null) root.addContent(temp<xsl:value-of select="position()"/>.toXML(depth-1));
 		</xsl:for-each>
		}
		</xsl:if>
		return root;
	}
	/**
	 * returns the XML form of this object only
	 */
	public Element toXML()<xsl:if test="$crossrefCnt>0"> throws SQLException</xsl:if>
	{
		return toXML(0);
	}
</xsl:if>
<!--
	==================================================================================================================
	Special Query Code
	==================================================================================================================
-->
<xsl:for-each select="//commonParams/specialQueryCode/table[@name=//CLASSINFO/@tableName]">
	/**
	 * Gets a ResultSet (CallableStatement.getResultSet()) of <xsl:value-of select="//CLASSNAME"/>'s
	 */
	public static CallableStatement get<xsl:value-of select="@functionName"/>ResultSet(CS cs, 
	<xsl:for-each select="whereParam">
		<xsl:if test="position()>1">,</xsl:if><xsl:value-of select="@javaType"/> p<xsl:value-of select="position()"/>
	</xsl:for-each>
		) throws SQLException
	{
		CallableStatement cc=cs.allocCS("SQC_<xsl:value-of select="//CLASSNAME"/>_<xsl:value-of select="@functionName"/>");
		try
		{
		<xsl:for-each select="whereParam">
			cc.set<xsl:value-of select="@javaType"/>(<xsl:value-of select="position()"/>,p<xsl:value-of select="position()"/>);
		</xsl:for-each>
			//ResultSet rs=
			cc.executeQuery();
		} catch (SQLException e)
		{
			cs.freeCS(cc);
			throw e;
		}
		<xsl:if test="//template/debug>0">
			// template/debug was set to >0 during conversion
		</xsl:if>
		return cc;
	}
</xsl:for-each>

<!--
	==================================================================================================================
	Overrides:
	==================================================================================================================
-->
	public String toString()
	{
		StringBuffer sb=new StringBuffer();
<xsl:for-each select="COLUMN">
		<xsl:if test="position()>1">sb.append(",");</xsl:if>
		sb.append(<xsl:value-of select="@name"/>);
</xsl:for-each>
		return sb.toString();
	}

<!--
	==================================================================================================================
	Clonable:
	==================================================================================================================
-->
	public Object clone() throws CloneNotSupportedException
	{
		return super.clone();
	}
	
<!--
	==================================================================================================================
	END OF CLASS
	==================================================================================================================
-->
}
<!--
	==================================================================================================================
	End of the template
	==================================================================================================================
-->

</xsl:template>


</xsl:stylesheet>