<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "<xsl:text><![CDATA[ ]]></xsl:text>">
	<!ENTITY nl "<xsl:text><![CDATA[
]]></xsl:text>">
	<!ENTITY copylogo "&#169;">
	<!ENTITY cnl "&lt;P&gt;">
]>
<!--
	This template is creating classes that extend the hldbBase template class,
	and cache in memory database records.
	
	Author : Konstantine Kougios
	Version: 0.9Beta
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="yes" encoding="UTF-8" omit-xml-declaration="yes"/>

<xsl:template match="ROOT">
<!--
	==================================================================================================================
	Start of the template
	==================================================================================================================
-->

<!--
	==================================================================================================================
	Package declaration and static imports
	==================================================================================================================
-->
<!-- 
	Nothing should be made if the table doesn't contain primary keys. Memory caching is based on these to store records.
 -->
<xsl:if test="count(PRIMARYKEYS)>0">	

package <xsl:value-of select="CLASSINFO/@package"/>;

import org.aris.hldb.CS;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aris.cache.universalcache.UniversalCache;
import org.jdom.Element;
import java.util.Iterator;
import java.util.LinkedList;
import java.sql.CallableStatement;

// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

<!--
	==================================================================================================================
	Imports defined in the user's configuration.xml
	==================================================================================================================
-->
<xsl:value-of select="template/imports"/>

<!--
	==================================================================================================================
	Start of the class
	==================================================================================================================
-->
/**
 * TABLE: <xsl:value-of select="CLASSINFO/@tableName"/> &cnl;
 * 
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.&cnl;
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.&cnl;
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.&cnl;
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.&cnl;
 *
 * This class was generated with the OODBFramework &copylogo; 2004 Konstantine Kougios.&cnl;
 */
<xsl:value-of select="template/modifiers"/> class <xsl:value-of select="CLASSNAME"/>&nbsp;extends <xsl:value-of select="template/extends"/>
	 implements Cloneable
{

<!--
	==================================================================================================================
	Start of the variable declarations
	==================================================================================================================
-->
	
<!--
	==================================================================================================================
	Constructors
	==================================================================================================================
-->
	// ============================================================================
	// =                  Constructors                                            =
	// ============================================================================
	
	/**
	 * Use this constructor to create a new row by calling the setters and then insert().
	 *
	 * Use static member instance() instead of a constructor to get an object if you know the
	 * primary key values.&cnl;
	 *
	 */
	public <xsl:value-of select="CLASSNAME"/>(CS cs)
	{
		super(cs);
	}
<xsl:choose>
<xsl:when test="count(PRIMARYKEYS)>0">	
	/**
	 * Get from primary key(s), also stores the row in the cache. This doesn't lookup
	 * the cache, and is used internally. Use instance() to get the object.
	 * 
	 * @param cs The hldb CS
	 */
	protected <xsl:value-of select="CLASSNAME"/>(CS cs,<xsl:value-of select="PRIMARYKEYS/@commaSepJavaType"/>) throws SQLException
	{
		super(cs, <xsl:value-of select="PRIMARYKEYS/@commaSep"/>);
		storeInCache();
	<xsl:if test="template/debug>0">
		// template/debug was set to >0 during conversion
	</xsl:if>
	}
</xsl:when>
<xsl:otherwise>
</xsl:otherwise>
</xsl:choose>
	/**
	 * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
	 * fetched, and the object is created from this row. A clone of the object is cached too.
	 * All modifications done to the object are not reflected to the cache, until an
	 * update() or insert() is called.&cnl;
	 *
	 * Use static member instance() instead of a constructor to get an object if you know the
	 * primary key values.&cnl;
	 *
	 * @param cs  A cache of callable statements
	 * @param rs  the ResultSet
	 */
	public <xsl:value-of select="CLASSNAME"/>(CS cs,ResultSet rs) throws java.sql.SQLException
	{
		super(cs,rs);
	}
<!--
	==================================================================================================================
	Utility functions
	==================================================================================================================
-->
	/**
	 * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
	 * creates the object from the resultset. Also caches the object.&cnl;
	 *
	 * Use static member instance() instead of this, to get an object if you know the
	 * primary key values.&cnl;
	 *
	 */
	public void setFromRs(ResultSet rs) throws SQLException
	{
		super.setFromRs(rs);
		storeInCache();
	}
	
<!--
	==================================================================================================================
	Setters and getters
	==================================================================================================================
-->
<xsl:for-each select="CROSSREFERENCES/RELATIONSHIP">
	<xsl:variable name="refclass"><xsl:value-of select="@references"/><xsl:value-of select="//template/ext"/></xsl:variable>

	/**
	 * Sets this row of <xsl:value-of select="//CLASSINFO/@tableName"/> to reference the ref row of <xsl:value-of select="@references"/>
	 */
	public void set<xsl:value-of select="@helpStr"/>Ref(<xsl:value-of select="$refclass"/> ref)
	{
	<xsl:for-each select="CROSSREFERENCE">
		<xsl:choose>
			<xsl:when test="@fkNullable=0">
				set<xsl:value-of select="@fkcolumn"/>(ref.get<xsl:value-of select="@pkcolumn"/>());
			</xsl:when>
			<xsl:otherwise>
				set<xsl:value-of select="@fkcolumn"/>(new <xsl:value-of select="@fkcolumnJavaType"/>(ref.get<xsl:value-of select="@pkcolumn"/>()));
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>		
	}

	/**
	 * Gets this row of <xsl:value-of select="//CLASSINFO/@tableName"/> from referenced row of <xsl:value-of select="@references"/>
	 */
	public <xsl:value-of select="$refclass"/> get<xsl:value-of select="@helpStr"/>Ref() throws SQLException, CloneNotSupportedException
	{
		return get<xsl:value-of select="@helpStr"/>Ref(cs);
	}

	/**
	 * Gets this row of <xsl:value-of select="//CLASSINFO/@tableName"/> from referenced row of <xsl:value-of select="@references"/>
	 */
	public <xsl:value-of select="$refclass"/> get<xsl:value-of select="@helpStr"/>Ref(CS cs) throws SQLException, CloneNotSupportedException
	{
		<xsl:if test="count(CROSSREFERENCE[@fkNullable!=0])">
			if (
				<xsl:for-each select="CROSSREFERENCE[@fkNullable!=0]">
					<xsl:if test="position()>1">||</xsl:if>
					get<xsl:value-of select="@fkcolumn"/>()==null
				</xsl:for-each>
				) return null;
		</xsl:if>	
			
		return <xsl:value-of select="$refclass"/>.instance(cs
	<xsl:for-each select="CROSSREFERENCE">
		<xsl:choose>
			<xsl:when test="@fkNullable=0">
				,get<xsl:value-of select="@fkcolumn"/>()
			</xsl:when>
			<xsl:otherwise>
				,get<xsl:value-of select="@fkcolumn"/>()<xsl:value-of select="@fkcolumnJavaTypePrimitiveConverter"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>);	
	}
</xsl:for-each>

<!--
	==================================================================================================================
	Getters for multiple results
	==================================================================================================================
-->
<xsl:for-each select="COLUMN">
	<xsl:if test="@dbType!='text' and @dbType!='ntext' and @javaType!='java.io.InputStream'">

	/**
	 * Gets a LinkedList of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the same <xsl:value-of select="@name"/> as this instance.
	 */
	public LinkedList getLinkedListWithSameValueOf<xsl:value-of select="@name"/>(int maxResults) throws SQLException
	{
		return getLinkedListWith<xsl:value-of select="@name"/>ValueOf(cs,get<xsl:value-of select="@name"/>(),maxResults);
	}
	
	/**
	 * Gets a LinkedList of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the "value".
	 */
	public static LinkedList getLinkedListWith<xsl:value-of select="@name"/>ValueOf(CS cs, <xsl:value-of select="@javaType"/> value,int maxResults) throws SQLException
	{
		CallableStatement cc=getResultSetWith<xsl:value-of select="@name"/>ValueOf(cs,value,maxResults);
		LinkedList ll=new LinkedList();
		try
		{
			ResultSet rs=cc.getResultSet();
			while (rs.next())
			{
				ll.addLast(new <xsl:value-of select="//CLASSNAME"/>(cs,rs));
			}
		} finally
		{
			cs.freeCS(cc);
		}
		return ll;
	}

	/**
	 * Gets an Iterator of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the same <xsl:value-of select="@name"/> as this instance.
	 */
	public Iterator getIteratorWithSameValueOf<xsl:value-of select="@name"/>(int maxResults) throws SQLException
	{
		return getIteratorWith<xsl:value-of select="@name"/>ValueOf(cs,get<xsl:value-of select="@name"/>(),maxResults);
	}
	
	/**
	 * Gets an Iterator of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the "value".
	 */
	public static Iterator getIteratorWith<xsl:value-of select="@name"/>ValueOf(CS cs, <xsl:value-of select="@javaType"/> value,int maxResults) throws SQLException
	{
		return getLinkedListWith<xsl:value-of select="@name"/>ValueOf(cs,value,maxResults).iterator();
	}
</xsl:if>
</xsl:for-each>

<!--
	==================================================================================================================
	Delete method, based on primary keys.
	==================================================================================================================
-->
	// ============================================================================
	// =                  Delete and Update methods                               =
	// ============================================================================
<xsl:if test="count(PRIMARYKEYS)>0">	
	/**
	 * Delete the current object from database
	 */
	public int delete() throws SQLException
	{
		return <xsl:value-of select="//CLASSNAME"/>.delete(cs,<xsl:value-of select="PRIMARYKEYS/@commaSep"/>);
	}
	
	/**
	 * Delete an row from database
	 */
	public static int delete(CS cs,<xsl:value-of select="PRIMARYKEYS/@commaSepJavaType"/>) throws SQLException
	{
		Cache.getCache().removeSynchronized(new Object[]
			{
				<xsl:value-of select="//CLASSNAME"/>.class, 
				<xsl:for-each select="PRIMARYKEYS/KEY">
					<xsl:if test="position()>1">,</xsl:if>
					<xsl:choose>
						<xsl:when test="COLUMN/@asObject=''">
							<xsl:value-of select="@column"/>
						</xsl:when>
						<xsl:otherwise>
							new <xsl:value-of select="COLUMN/@asObject"/>(<xsl:value-of select="@column"/>)
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			});
		return <xsl:value-of select="template/extends"/>.delete(cs, <xsl:value-of select="PRIMARYKEYS/@commaSep"/>);
	}

<!--
	==================================================================================================================
	Update methods, based on primary keys.
	==================================================================================================================
-->
	<!-- Update exists only if table contains more than 1 non-identity field -->
<xsl:variable name="countPKID0" select="count(COLUMN[@primaryKey='' and @identity=0 and @dbType!='timestamp'])"/>
<xsl:if test="$countPKID0>0">
	/**
	 * Update the current object to the database (primary keys/autoincrements are not updated)
	 */
	public int update() throws SQLException
	{
		if (isDirty)
		{
			int res = super.update();
			storeInCache();
			return res;
		}
		return -1;
	}
</xsl:if>

<xsl:variable name="countID0" select="count(COLUMN[@identity=0 and @dbType!='timestamp'])"/>
<xsl:if test="$countID0>$countPKID0">
	/**
	 * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
	 */
	public int updateAll() throws SQLException
	{
		if (isDirty)
		{
			Cache.getCache().removeSynchronized(new Object[]
			{
				<xsl:value-of select="//CLASSNAME"/>.class, 
				<xsl:for-each select="PRIMARYKEYS/KEY">
					<xsl:if test="position()>1">,</xsl:if>
					<xsl:choose>
						<xsl:when test="COLUMN/@asObject=''">
							old_<xsl:value-of select="@column"/>
						</xsl:when>
						<xsl:otherwise>
							new <xsl:value-of select="COLUMN/@asObject"/>(old_<xsl:value-of select="@column"/>)
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			});
			int res = super.updateAll();
			storeInCache();
			return res;
		}
		return -1;
	}
</xsl:if>
</xsl:if>

<!--
	==================================================================================================================
	Insert methods
	==================================================================================================================
-->
	/**
	 * Inserts this new object to a new row (all columns are inserted, except the identities)
	 * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
	 * as set by the insert into () sql.
	 * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
	 * Thus, some synchronization maybe necessary for this call to complete atomically.
	 */
	public synchronized void insert() throws SQLException
	{
		super.insert();
		storeInCache();

		<xsl:if test="template/debug>0">
			// template/debug was set to >0 during conversion
		</xsl:if>
	}
<!--
	==================================================================================================================
	caching Utility functions.
	==================================================================================================================
-->
	private final Object[] keysObj()
	{
		return new Object[]
			{
				<xsl:value-of select="//CLASSNAME"/>.class, 
				<xsl:for-each select="PRIMARYKEYS/KEY">
					<xsl:if test="position()>1">,</xsl:if>
					<xsl:choose>
						<xsl:when test="COLUMN/@asObject=''">
							<xsl:value-of select="@column"/>
						</xsl:when>
						<xsl:otherwise>
							new <xsl:value-of select="COLUMN/@asObject"/>(<xsl:value-of select="@column"/>)
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			};
	}

	private void storeInCache()
	{
		try
		{
			Cache.getCache().putSynchronized(keysObj(), this.clone());
		} catch (CloneNotSupportedException e)
		{
			// This should not occur.
			e.printStackTrace();
		}
	}
	
	/**
	 * Flush all cached <xsl:value-of select="//CLASSNAME"/> items.
	 */
	public static void flushCache()
	{
		Cache.getCache().flushSynchronized(new Object[]{<xsl:value-of select="//CLASSNAME"/>.class});
	}

	/**
	 * Flush a cached <xsl:value-of select="//CLASSNAME"/> item.
	 */
	public static void flushCache(<xsl:value-of select="PRIMARYKEYS/@commaSepJavaType"/>)
	{
		Cache.getCache().removeSynchronized(new Object[]{
		<xsl:value-of select="//CLASSNAME"/>.class,
			<xsl:for-each select="PRIMARYKEYS/KEY">
				<xsl:if test="position()>1">,</xsl:if>
				<xsl:choose>
					<xsl:when test="COLUMN/@asObject=''">
						<xsl:value-of select="@column"/>
					</xsl:when>
					<xsl:otherwise>
						new <xsl:value-of select="COLUMN/@asObject"/>(<xsl:value-of select="@column"/>)
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		});
	}
	
	private static <xsl:value-of select="//CLASSNAME"/> cacheLookup(<xsl:value-of select="PRIMARYKEYS/@commaSepJavaType"/>)  throws CloneNotSupportedException
	{
		// try to find the record in the cache
		UniversalCache c = Cache.getCache();
		synchronized(<xsl:value-of select="//CLASSNAME"/>.class)
		{
			<xsl:value-of select="//CLASSNAME"/> t = (<xsl:value-of select="//CLASSNAME"/>) c.get(new Object[]{
				<xsl:value-of select="//CLASSNAME"/>.class, 
				<xsl:for-each select="PRIMARYKEYS/KEY">
					<xsl:if test="position()>1">,</xsl:if>
					<xsl:choose>
						<xsl:when test="COLUMN/@asObject=''">
							<xsl:value-of select="@column"/>
						</xsl:when>
						<xsl:otherwise>
							new <xsl:value-of select="COLUMN/@asObject"/>(<xsl:value-of select="@column"/>)
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			});
			if (t != null) return (<xsl:value-of select="//CLASSNAME"/>) t.clone();
		}
		return null;
	}

	/**
	 * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
	 * is the function that should be used, when the primary keys are known.&cnl;
	 * 
	 * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
	 */
	public static <xsl:value-of select="//CLASSNAME"/> instance(CS cs, <xsl:value-of select="PRIMARYKEYS/@commaSepJavaType"/>) throws SQLException, CloneNotSupportedException
	{
		<xsl:value-of select="//CLASSNAME"/> t=cacheLookup(<xsl:value-of select="PRIMARYKEYS/@commaSep"/>);
		if (t != null) return t;
		// not in cache, search the database
		t = new <xsl:value-of select="//CLASSNAME"/>(cs, <xsl:value-of select="PRIMARYKEYS/@commaSep"/>);
		return t;
	}
<!--
	==================================================================================================================
	Getters/Setters for the cross referenced classes.
	==================================================================================================================
-->

<!--
	==================================================================================================================
	Debugging helpers.
	==================================================================================================================
-->

<!--
	==================================================================================================================
	XML utilities
	==================================================================================================================
-->
<xsl:variable name="crossrefCnt" select="count(CROSSREFERENCES/RELATIONSHIP)"/>
	/**
	 * returns the XML form of this object and depth childs
	 */
	public Element toXML(int depth)<xsl:if test="$crossrefCnt>0"> throws SQLException, CloneNotSupportedException</xsl:if>
	{
		Element root=new Element("<xsl:value-of select="CLASSNAME"/>");
		<xsl:for-each select="COLUMN[@javaType!='java.io.InputStream']">
			<xsl:choose>
				<xsl:when test="@toXmlMode=0">
					root.setAttribute("<xsl:value-of select="@name"/>",
					<xsl:if test="@javaType!='String'">String.valueOf(</xsl:if>
					get<xsl:value-of select="@name"/>()
					<xsl:if test="@javaType!='String'">)</xsl:if>
					);
				</xsl:when>
				<xsl:when test="@toXmlMode=1">
					root.addContent(new Element("<xsl:value-of select="@name"/>").setText(
					<xsl:if test="@javaType!='String'">String.valueOf(</xsl:if>
						get<xsl:value-of select="@name"/>()
					<xsl:if test="@javaType!='String'">)</xsl:if>
						));
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		
		<xsl:if test="$crossrefCnt>0">
		if (depth>0)
		{
		<xsl:for-each select="CROSSREFERENCES/RELATIONSHIP">
			<xsl:variable name="refclass"><xsl:value-of select="@references"/><xsl:value-of select="//template/ext"/></xsl:variable>
			<xsl:value-of select="$refclass"/>&nbsp;temp<xsl:value-of select="position()"/>=get<xsl:value-of select="@helpStr"/>Ref(cs);
			if (temp<xsl:value-of select="position()"/>!=null) root.addContent(temp<xsl:value-of select="position()"/>.toXML(depth-1));
 		</xsl:for-each>
		}
		</xsl:if>
		return root;
	}
	/**
	 * returns the XML form of this object only
	 */
	public Element toXML()<xsl:if test="$crossrefCnt>0"> throws SQLException, CloneNotSupportedException</xsl:if>
	{
		return toXML(0);
	}
	
<!--
	==================================================================================================================
	Special Query Code
	==================================================================================================================
-->

<!--
	==================================================================================================================
	Clonable:
	==================================================================================================================
-->
	public Object clone() throws CloneNotSupportedException
	{
		return super.clone();
	}

<!--
	==================================================================================================================
	END OF CLASS
	==================================================================================================================
-->

}
<!--
	==================================================================================================================
	End of the template
	==================================================================================================================
-->
</xsl:if>

</xsl:template>


</xsl:stylesheet>