package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Categories<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class CategoriesBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected int CategoryID;
    protected int old_CategoryID; // Old value of the key is kept too
    protected String CategoryName;
    protected String Description;
    protected java.io.InputStream Picture;

    // length of this binary stream
    protected int PictureLen;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected CategoriesBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public CategoriesBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Get from primary key(s), queries the database
     */
    public CategoriesBase(CS cs, int CategoryID) throws SQLException {
        this.cs = cs;

        CallableStatement cc = null;
        ResultSet rs = null;

        try {
            cc = cs.allocCS("SELECT_CategoriesBase");

            cc.setInt(1, CategoryID);

            rs = cc.executeQuery();
            rs.next();
            setFromRs(rs);
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public CategoriesBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        CategoryID = old_CategoryID = rs.getInt("CategoryID");
        CategoryName = rs.getString("CategoryName");
        Description = rs.getString("Description");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for CategoryID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getCategoryID() {
        return CategoryID;
    }

    /**
     * Setter for CategoryID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    protected void setCategoryID(int value) {
        this.CategoryID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of CategoriesBase's by querying table field CategoryID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCategoryID(
        int maxResults) throws SQLException {
        return getResultSetWithCategoryIDValueOf(cs, getCategoryID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of CategoriesBase's by querying table field CategoryID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCategoryIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_CategoriesBase_CategoryID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of CategoriesBase's by querying table field CategoryID
     * for equality with the same CategoryID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCategoryID(int maxResults)
        throws SQLException {
        return getLinkedListWithCategoryIDValueOf(cs, getCategoryID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of CategoriesBase's by querying table field CategoryID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCategoryIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCategoryIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new CategoriesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of CategoriesBase's by querying table field CategoryID
     * for equality with the same CategoryID as this instance.
     */
    public Iterator getIteratorWithSameValueOfCategoryID(int maxResults)
        throws SQLException {
        return getIteratorWithCategoryIDValueOf(cs, getCategoryID(), maxResults);
    }

    /**
     * Gets an Iterator of CategoriesBase's by querying table field CategoryID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCategoryIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithCategoryIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for CategoryName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCategoryName() {
        return CategoryName;
    }

    /**
     * Setter for CategoryName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCategoryName(String value) {
        this.CategoryName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of CategoriesBase's by querying table field CategoryName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCategoryName(
        int maxResults) throws SQLException {
        return getResultSetWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of CategoriesBase's by querying table field CategoryName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_CategoriesBase_CategoryName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of CategoriesBase's by querying table field CategoryName
     * for equality with the same CategoryName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCategoryName(int maxResults)
        throws SQLException {
        return getLinkedListWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of CategoriesBase's by querying table field CategoryName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCategoryNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new CategoriesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of CategoriesBase's by querying table field CategoryName
     * for equality with the same CategoryName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCategoryName(int maxResults)
        throws SQLException {
        return getIteratorWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets an Iterator of CategoriesBase's by querying table field CategoryName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCategoryNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Description.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getDescription() {
        return Description;
    }

    /**
     * Setter for Description.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setDescription(String value) {
        this.Description = value;
        isDirty = true;
    }

    /**
     * Getter for Picture.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    protected java.io.InputStream getPicture() {
        return Picture;
    }

    /**
     * Setter for Picture.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setPicture(java.io.InputStream stream, int length) {
        this.Picture = stream;
        this.PictureLen = length;
        isDirty = true;
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return CategoriesBase.delete(cs, CategoryID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int CategoryID) throws SQLException {
        CallableStatement cc = null;
        int res = 0;

        try {
            cc = cs.allocCS("DELETE_CategoriesBase");

            cc.setInt(1, CategoryID);

            res = cc.executeUpdate();
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
        return res;
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATE_CategoriesBase");

                cc.setString(1, getCategoryName());

                cc.setString(2, getDescription());

                cc.setBinaryStream(3, getPicture(), 0);

                cc.setInt(4, getCategoryID());

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            return res;
        }

        return -1;
    }

    private void updateOldKeys() {
        // update the old_x old key values
        old_CategoryID = CategoryID;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        ResultSet rs = null;

        try {
            cc = cs.allocCS("INSERT_CategoriesBase");

            cc.setString(1, getCategoryName());

            cc.setString(2, getDescription());

            cc.setBinaryStream(3, getPicture(), PictureLen);

            rs = cc.executeQuery();
            rs.next();

            setCategoryID(rs.getInt(1));

            updateOldKeys();

            isDirty = false;
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "CategoryID:" + getCategoryID());

        System.out.println(prefix + "CategoryName:" + getCategoryName());

        System.out.println(prefix + "Description:" + getDescription());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(CategoryID);
        sb.append(",");
        sb.append(CategoryName);
        sb.append(",");
        sb.append(Description);
        sb.append(",");
        sb.append(Picture);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
