package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Orders Qry<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class Orders_QryBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected int OrderID;
    protected String CustomerID;
    protected Integer EmployeeID;
    protected java.sql.Date OrderDate;
    protected java.sql.Date RequiredDate;
    protected java.sql.Date ShippedDate;
    protected Integer ShipVia;
    protected Double Freight;
    protected String ShipName;
    protected String ShipAddress;
    protected String ShipCity;
    protected String ShipRegion;
    protected String ShipPostalCode;
    protected String ShipCountry;
    protected String CompanyName;
    protected String Address;
    protected String City;
    protected String Region;
    protected String PostalCode;
    protected String Country;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected Orders_QryBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public Orders_QryBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Orders_QryBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        OrderID = rs.getInt("OrderID");
        CustomerID = rs.getString("CustomerID");
        EmployeeID = new Integer(rs.getInt("EmployeeID"));

        if (rs.wasNull()) {
            EmployeeID = null;
        }

        ;
        OrderDate = rs.getDate("OrderDate");
        RequiredDate = rs.getDate("RequiredDate");
        ShippedDate = rs.getDate("ShippedDate");
        ShipVia = new Integer(rs.getInt("ShipVia"));

        if (rs.wasNull()) {
            ShipVia = null;
        }

        ;
        Freight = new Double(rs.getDouble("Freight"));

        if (rs.wasNull()) {
            Freight = null;
        }

        ;
        ShipName = rs.getString("ShipName");
        ShipAddress = rs.getString("ShipAddress");
        ShipCity = rs.getString("ShipCity");
        ShipRegion = rs.getString("ShipRegion");
        ShipPostalCode = rs.getString("ShipPostalCode");
        ShipCountry = rs.getString("ShipCountry");
        CompanyName = rs.getString("CompanyName");
        Address = rs.getString("Address");
        City = rs.getString("City");
        Region = rs.getString("Region");
        PostalCode = rs.getString("PostalCode");
        Country = rs.getString("Country");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for OrderID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getOrderID() {
        return OrderID;
    }

    /**
     * Setter for OrderID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setOrderID(int value) {
        this.OrderID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field OrderID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getResultSetWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field OrderID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithOrderIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_OrderID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field OrderID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithOrderIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public Iterator getIteratorWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getIteratorWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field OrderID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for CustomerID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCustomerID() {
        return CustomerID;
    }

    /**
     * Setter for CustomerID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCustomerID(String value) {
        this.CustomerID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field CustomerID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCustomerID(
        int maxResults) throws SQLException {
        return getResultSetWithCustomerIDValueOf(cs, getCustomerID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field CustomerID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCustomerIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_CustomerID");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field CustomerID
     * for equality with the same CustomerID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCustomerID(int maxResults)
        throws SQLException {
        return getLinkedListWithCustomerIDValueOf(cs, getCustomerID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field CustomerID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCustomerIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCustomerIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field CustomerID
     * for equality with the same CustomerID as this instance.
     */
    public Iterator getIteratorWithSameValueOfCustomerID(int maxResults)
        throws SQLException {
        return getIteratorWithCustomerIDValueOf(cs, getCustomerID(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field CustomerID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCustomerIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCustomerIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for EmployeeID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Integer getEmployeeID() {
        return EmployeeID;
    }

    /**
     * Setter for EmployeeID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setEmployeeID(Integer value) {
        this.EmployeeID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field EmployeeID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfEmployeeID(
        int maxResults) throws SQLException {
        return getResultSetWithEmployeeIDValueOf(cs, getEmployeeID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field EmployeeID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithEmployeeIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_EmployeeID");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.INTEGER);
            } else {
                cc.setInt(1, value.intValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field EmployeeID
     * for equality with the same EmployeeID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfEmployeeID(int maxResults)
        throws SQLException {
        return getLinkedListWithEmployeeIDValueOf(cs, getEmployeeID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field EmployeeID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithEmployeeIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithEmployeeIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field EmployeeID
     * for equality with the same EmployeeID as this instance.
     */
    public Iterator getIteratorWithSameValueOfEmployeeID(int maxResults)
        throws SQLException {
        return getIteratorWithEmployeeIDValueOf(cs, getEmployeeID(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field EmployeeID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithEmployeeIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        return getLinkedListWithEmployeeIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for OrderDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public java.sql.Date getOrderDate() {
        return OrderDate;
    }

    /**
     * Setter for OrderDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setOrderDate(java.sql.Date value) {
        this.OrderDate = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field OrderDate
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfOrderDate(
        int maxResults) throws SQLException {
        return getResultSetWithOrderDateValueOf(cs, getOrderDate(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field OrderDate
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithOrderDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_OrderDate");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.DATE);
            } else {
                cc.setDate(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field OrderDate
     * for equality with the same OrderDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfOrderDate(int maxResults)
        throws SQLException {
        return getLinkedListWithOrderDateValueOf(cs, getOrderDate(), maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field OrderDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithOrderDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithOrderDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field OrderDate
     * for equality with the same OrderDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfOrderDate(int maxResults)
        throws SQLException {
        return getIteratorWithOrderDateValueOf(cs, getOrderDate(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field OrderDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithOrderDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithOrderDateValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for RequiredDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public java.sql.Date getRequiredDate() {
        return RequiredDate;
    }

    /**
     * Setter for RequiredDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setRequiredDate(java.sql.Date value) {
        this.RequiredDate = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field RequiredDate
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfRequiredDate(
        int maxResults) throws SQLException {
        return getResultSetWithRequiredDateValueOf(cs, getRequiredDate(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field RequiredDate
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithRequiredDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_RequiredDate");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.DATE);
            } else {
                cc.setDate(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field RequiredDate
     * for equality with the same RequiredDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRequiredDate(int maxResults)
        throws SQLException {
        return getLinkedListWithRequiredDateValueOf(cs, getRequiredDate(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field RequiredDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRequiredDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRequiredDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field RequiredDate
     * for equality with the same RequiredDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfRequiredDate(int maxResults)
        throws SQLException {
        return getIteratorWithRequiredDateValueOf(cs, getRequiredDate(),
            maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field RequiredDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRequiredDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithRequiredDateValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ShippedDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public java.sql.Date getShippedDate() {
        return ShippedDate;
    }

    /**
     * Setter for ShippedDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setShippedDate(java.sql.Date value) {
        this.ShippedDate = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShippedDate
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfShippedDate(
        int maxResults) throws SQLException {
        return getResultSetWithShippedDateValueOf(cs, getShippedDate(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShippedDate
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithShippedDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_ShippedDate");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.DATE);
            } else {
                cc.setDate(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShippedDate
     * for equality with the same ShippedDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShippedDate(int maxResults)
        throws SQLException {
        return getLinkedListWithShippedDateValueOf(cs, getShippedDate(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShippedDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShippedDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShippedDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShippedDate
     * for equality with the same ShippedDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfShippedDate(int maxResults)
        throws SQLException {
        return getIteratorWithShippedDateValueOf(cs, getShippedDate(),
            maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShippedDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShippedDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithShippedDateValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ShipVia.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Integer getShipVia() {
        return ShipVia;
    }

    /**
     * Setter for ShipVia.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setShipVia(Integer value) {
        this.ShipVia = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipVia
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfShipVia(int maxResults)
        throws SQLException {
        return getResultSetWithShipViaValueOf(cs, getShipVia(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipVia
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithShipViaValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_ShipVia");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.INTEGER);
            } else {
                cc.setInt(1, value.intValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipVia
     * for equality with the same ShipVia as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipVia(int maxResults)
        throws SQLException {
        return getLinkedListWithShipViaValueOf(cs, getShipVia(), maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipVia
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipViaValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipViaValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipVia
     * for equality with the same ShipVia as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipVia(int maxResults)
        throws SQLException {
        return getIteratorWithShipViaValueOf(cs, getShipVia(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipVia
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipViaValueOf(CS cs, Integer value,
        int maxResults) throws SQLException {
        return getLinkedListWithShipViaValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for Freight.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Double getFreight() {
        return Freight;
    }

    /**
     * Setter for Freight.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setFreight(Double value) {
        this.Freight = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field Freight
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfFreight(int maxResults)
        throws SQLException {
        return getResultSetWithFreightValueOf(cs, getFreight(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field Freight
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithFreightValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_Freight");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(1, value.doubleValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field Freight
     * for equality with the same Freight as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfFreight(int maxResults)
        throws SQLException {
        return getLinkedListWithFreightValueOf(cs, getFreight(), maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field Freight
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithFreightValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithFreightValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field Freight
     * for equality with the same Freight as this instance.
     */
    public Iterator getIteratorWithSameValueOfFreight(int maxResults)
        throws SQLException {
        return getIteratorWithFreightValueOf(cs, getFreight(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field Freight
     * for equality with the "value".
     */
    public static Iterator getIteratorWithFreightValueOf(CS cs, Double value,
        int maxResults) throws SQLException {
        return getLinkedListWithFreightValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for ShipName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getShipName() {
        return ShipName;
    }

    /**
     * Setter for ShipName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setShipName(String value) {
        this.ShipName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfShipName(int maxResults)
        throws SQLException {
        return getResultSetWithShipNameValueOf(cs, getShipName(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithShipNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_ShipName");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipName
     * for equality with the same ShipName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipName(int maxResults)
        throws SQLException {
        return getLinkedListWithShipNameValueOf(cs, getShipName(), maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipName
     * for equality with the same ShipName as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipName(int maxResults)
        throws SQLException {
        return getIteratorWithShipNameValueOf(cs, getShipName(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipNameValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithShipNameValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for ShipAddress.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getShipAddress() {
        return ShipAddress;
    }

    /**
     * Setter for ShipAddress.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setShipAddress(String value) {
        this.ShipAddress = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipAddress
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfShipAddress(
        int maxResults) throws SQLException {
        return getResultSetWithShipAddressValueOf(cs, getShipAddress(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipAddress
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithShipAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_ShipAddress");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipAddress
     * for equality with the same ShipAddress as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipAddress(int maxResults)
        throws SQLException {
        return getLinkedListWithShipAddressValueOf(cs, getShipAddress(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipAddress
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipAddressValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipAddress
     * for equality with the same ShipAddress as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipAddress(int maxResults)
        throws SQLException {
        return getIteratorWithShipAddressValueOf(cs, getShipAddress(),
            maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipAddress
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithShipAddressValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ShipCity.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getShipCity() {
        return ShipCity;
    }

    /**
     * Setter for ShipCity.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setShipCity(String value) {
        this.ShipCity = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipCity
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfShipCity(int maxResults)
        throws SQLException {
        return getResultSetWithShipCityValueOf(cs, getShipCity(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipCity
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithShipCityValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_ShipCity");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipCity
     * for equality with the same ShipCity as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipCity(int maxResults)
        throws SQLException {
        return getLinkedListWithShipCityValueOf(cs, getShipCity(), maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipCity
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipCityValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipCityValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipCity
     * for equality with the same ShipCity as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipCity(int maxResults)
        throws SQLException {
        return getIteratorWithShipCityValueOf(cs, getShipCity(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipCity
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithShipCityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for ShipRegion.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getShipRegion() {
        return ShipRegion;
    }

    /**
     * Setter for ShipRegion.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setShipRegion(String value) {
        this.ShipRegion = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipRegion
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfShipRegion(
        int maxResults) throws SQLException {
        return getResultSetWithShipRegionValueOf(cs, getShipRegion(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipRegion
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithShipRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_ShipRegion");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipRegion
     * for equality with the same ShipRegion as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipRegion(int maxResults)
        throws SQLException {
        return getLinkedListWithShipRegionValueOf(cs, getShipRegion(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipRegion
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipRegionValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipRegion
     * for equality with the same ShipRegion as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipRegion(int maxResults)
        throws SQLException {
        return getIteratorWithShipRegionValueOf(cs, getShipRegion(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipRegion
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithShipRegionValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ShipPostalCode.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getShipPostalCode() {
        return ShipPostalCode;
    }

    /**
     * Setter for ShipPostalCode.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setShipPostalCode(String value) {
        this.ShipPostalCode = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipPostalCode
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfShipPostalCode(
        int maxResults) throws SQLException {
        return getResultSetWithShipPostalCodeValueOf(cs, getShipPostalCode(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipPostalCode
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithShipPostalCodeValueOf(
        CS cs, String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Orders_QryBase_ShipPostalCode");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipPostalCode
     * for equality with the same ShipPostalCode as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipPostalCode(int maxResults)
        throws SQLException {
        return getLinkedListWithShipPostalCodeValueOf(cs, getShipPostalCode(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipPostalCode
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipPostalCodeValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipPostalCode
     * for equality with the same ShipPostalCode as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipPostalCode(int maxResults)
        throws SQLException {
        return getIteratorWithShipPostalCodeValueOf(cs, getShipPostalCode(),
            maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipPostalCode
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithShipPostalCodeValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ShipCountry.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getShipCountry() {
        return ShipCountry;
    }

    /**
     * Setter for ShipCountry.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setShipCountry(String value) {
        this.ShipCountry = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipCountry
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfShipCountry(
        int maxResults) throws SQLException {
        return getResultSetWithShipCountryValueOf(cs, getShipCountry(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field ShipCountry
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithShipCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_ShipCountry");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipCountry
     * for equality with the same ShipCountry as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipCountry(int maxResults)
        throws SQLException {
        return getLinkedListWithShipCountryValueOf(cs, getShipCountry(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field ShipCountry
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipCountryValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipCountry
     * for equality with the same ShipCountry as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipCountry(int maxResults)
        throws SQLException {
        return getIteratorWithShipCountryValueOf(cs, getShipCountry(),
            maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field ShipCountry
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithShipCountryValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCompanyName() {
        return CompanyName;
    }

    /**
     * Setter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCompanyName(String value) {
        this.CompanyName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCompanyName(
        int maxResults) throws SQLException {
        return getResultSetWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_CompanyName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCompanyNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getIteratorWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Address.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getAddress() {
        return Address;
    }

    /**
     * Setter for Address.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setAddress(String value) {
        this.Address = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field Address
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getResultSetWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field Address
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_Address");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field Address
     * for equality with the same Address as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getLinkedListWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field Address
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithAddressValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field Address
     * for equality with the same Address as this instance.
     */
    public Iterator getIteratorWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getIteratorWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field Address
     * for equality with the "value".
     */
    public static Iterator getIteratorWithAddressValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithAddressValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for City.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCity() {
        return City;
    }

    /**
     * Setter for City.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCity(String value) {
        this.City = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field City
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getResultSetWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field City
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCityValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_City");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field City
     * for equality with the same City as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getLinkedListWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field City
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCityValueOf(cs, value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field City
     * for equality with the same City as this instance.
     */
    public Iterator getIteratorWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getIteratorWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field City
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for Region.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getRegion() {
        return Region;
    }

    /**
     * Setter for Region.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setRegion(String value) {
        this.Region = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field Region
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getResultSetWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field Region
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_Region");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field Region
     * for equality with the same Region as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getLinkedListWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field Region
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field Region
     * for equality with the same Region as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getIteratorWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field Region
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithRegionValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for PostalCode.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getPostalCode() {
        return PostalCode;
    }

    /**
     * Setter for PostalCode.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setPostalCode(String value) {
        this.PostalCode = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field PostalCode
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfPostalCode(
        int maxResults) throws SQLException {
        return getResultSetWithPostalCodeValueOf(cs, getPostalCode(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field PostalCode
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_PostalCode");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field PostalCode
     * for equality with the same PostalCode as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfPostalCode(int maxResults)
        throws SQLException {
        return getLinkedListWithPostalCodeValueOf(cs, getPostalCode(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field PostalCode
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithPostalCodeValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field PostalCode
     * for equality with the same PostalCode as this instance.
     */
    public Iterator getIteratorWithSameValueOfPostalCode(int maxResults)
        throws SQLException {
        return getIteratorWithPostalCodeValueOf(cs, getPostalCode(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field PostalCode
     * for equality with the "value".
     */
    public static Iterator getIteratorWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithPostalCodeValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Country.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCountry() {
        return Country;
    }

    /**
     * Setter for Country.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCountry(String value) {
        this.Country = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field Country
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getResultSetWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Orders_QryBase's by querying table field Country
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Orders_QryBase_Country");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getLinkedListWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets a LinkedList of Orders_QryBase's by querying table field Country
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCountryValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Orders_QryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public Iterator getIteratorWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getIteratorWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets an Iterator of Orders_QryBase's by querying table field Country
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCountryValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCountryValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_Orders_QryBase");

            cc.setInt(1, getOrderID());

            cc.setString(2, getCustomerID());

            if (EmployeeID == null) {
                cc.setNull(3, java.sql.Types.INTEGER);
            } else {
                cc.setInt(3, getEmployeeID().intValue());
            }

            cc.setDate(4, getOrderDate());

            cc.setDate(5, getRequiredDate());

            cc.setDate(6, getShippedDate());

            if (ShipVia == null) {
                cc.setNull(7, java.sql.Types.INTEGER);
            } else {
                cc.setInt(7, getShipVia().intValue());
            }

            if (Freight == null) {
                cc.setNull(8, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(8, getFreight().doubleValue());
            }

            cc.setString(9, getShipName());

            cc.setString(10, getShipAddress());

            cc.setString(11, getShipCity());

            cc.setString(12, getShipRegion());

            cc.setString(13, getShipPostalCode());

            cc.setString(14, getShipCountry());

            cc.setString(15, getCompanyName());

            cc.setString(16, getAddress());

            cc.setString(17, getCity());

            cc.setString(18, getRegion());

            cc.setString(19, getPostalCode());

            cc.setString(20, getCountry());

            cc.executeUpdate();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "OrderID:" + getOrderID());

        System.out.println(prefix + "CustomerID:" + getCustomerID());

        System.out.println(prefix + "EmployeeID:" + getEmployeeID());

        System.out.println(prefix + "OrderDate:" + getOrderDate());

        System.out.println(prefix + "RequiredDate:" + getRequiredDate());

        System.out.println(prefix + "ShippedDate:" + getShippedDate());

        System.out.println(prefix + "ShipVia:" + getShipVia());

        System.out.println(prefix + "Freight:" + getFreight());

        System.out.println(prefix + "ShipName:" + getShipName());

        System.out.println(prefix + "ShipAddress:" + getShipAddress());

        System.out.println(prefix + "ShipCity:" + getShipCity());

        System.out.println(prefix + "ShipRegion:" + getShipRegion());

        System.out.println(prefix + "ShipPostalCode:" + getShipPostalCode());

        System.out.println(prefix + "ShipCountry:" + getShipCountry());

        System.out.println(prefix + "CompanyName:" + getCompanyName());

        System.out.println(prefix + "Address:" + getAddress());

        System.out.println(prefix + "City:" + getCity());

        System.out.println(prefix + "Region:" + getRegion());

        System.out.println(prefix + "PostalCode:" + getPostalCode());

        System.out.println(prefix + "Country:" + getCountry());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(OrderID);
        sb.append(",");
        sb.append(CustomerID);
        sb.append(",");
        sb.append(EmployeeID);
        sb.append(",");
        sb.append(OrderDate);
        sb.append(",");
        sb.append(RequiredDate);
        sb.append(",");
        sb.append(ShippedDate);
        sb.append(",");
        sb.append(ShipVia);
        sb.append(",");
        sb.append(Freight);
        sb.append(",");
        sb.append(ShipName);
        sb.append(",");
        sb.append(ShipAddress);
        sb.append(",");
        sb.append(ShipCity);
        sb.append(",");
        sb.append(ShipRegion);
        sb.append(",");
        sb.append(ShipPostalCode);
        sb.append(",");
        sb.append(ShipCountry);
        sb.append(",");
        sb.append(CompanyName);
        sb.append(",");
        sb.append(Address);
        sb.append(",");
        sb.append(City);
        sb.append(",");
        sb.append(Region);
        sb.append(",");
        sb.append(PostalCode);
        sb.append(",");
        sb.append(Country);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
