package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Products<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class ProductsBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected int ProductID;
    protected int old_ProductID; // Old value of the key is kept too
    protected String ProductName;
    protected Integer SupplierID;
    protected Integer CategoryID;
    protected String QuantityPerUnit;
    protected Double UnitPrice;
    protected Short UnitsInStock;
    protected Short UnitsOnOrder;
    protected Short ReorderLevel;
    protected boolean Discontinued;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected ProductsBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public ProductsBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Get from primary key(s), queries the database
     */
    public ProductsBase(CS cs, int ProductID) throws SQLException {
        this.cs = cs;

        CallableStatement cc = null;
        ResultSet rs = null;

        try {
            cc = cs.allocCS("SELECT_ProductsBase");

            cc.setInt(1, ProductID);

            rs = cc.executeQuery();
            rs.next();
            setFromRs(rs);
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public ProductsBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        ProductID = old_ProductID = rs.getInt("ProductID");
        ProductName = rs.getString("ProductName");
        SupplierID = new Integer(rs.getInt("SupplierID"));

        if (rs.wasNull()) {
            SupplierID = null;
        }

        ;
        CategoryID = new Integer(rs.getInt("CategoryID"));

        if (rs.wasNull()) {
            CategoryID = null;
        }

        ;
        QuantityPerUnit = rs.getString("QuantityPerUnit");
        UnitPrice = new Double(rs.getDouble("UnitPrice"));

        if (rs.wasNull()) {
            UnitPrice = null;
        }

        ;
        UnitsInStock = new Short(rs.getShort("UnitsInStock"));

        if (rs.wasNull()) {
            UnitsInStock = null;
        }

        ;
        UnitsOnOrder = new Short(rs.getShort("UnitsOnOrder"));

        if (rs.wasNull()) {
            UnitsOnOrder = null;
        }

        ;
        ReorderLevel = new Short(rs.getShort("ReorderLevel"));

        if (rs.wasNull()) {
            ReorderLevel = null;
        }

        ;
        Discontinued = rs.getBoolean("Discontinued");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for ProductID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getProductID() {
        return ProductID;
    }

    /**
     * Setter for ProductID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    protected void setProductID(int value) {
        this.ProductID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field ProductID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfProductID(
        int maxResults) throws SQLException {
        return getResultSetWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field ProductID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithProductIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ProductsBase_ProductID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field ProductID
     * for equality with the same ProductID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductID(int maxResults)
        throws SQLException {
        return getLinkedListWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field ProductID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field ProductID
     * for equality with the same ProductID as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductID(int maxResults)
        throws SQLException {
        return getIteratorWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field ProductID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithProductIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ProductName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getProductName() {
        return ProductName;
    }

    /**
     * Setter for ProductName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setProductName(String value) {
        this.ProductName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field ProductName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfProductName(
        int maxResults) throws SQLException {
        return getResultSetWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field ProductName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ProductsBase_ProductName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field ProductName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getIteratorWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field ProductName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for SupplierID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Integer getSupplierID() {
        return SupplierID;
    }

    /**
     * Setter for SupplierID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setSupplierID(Integer value) {
        this.SupplierID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field SupplierID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfSupplierID(
        int maxResults) throws SQLException {
        return getResultSetWithSupplierIDValueOf(cs, getSupplierID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field SupplierID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithSupplierIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ProductsBase_SupplierID");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.INTEGER);
            } else {
                cc.setInt(1, value.intValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field SupplierID
     * for equality with the same SupplierID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfSupplierID(int maxResults)
        throws SQLException {
        return getLinkedListWithSupplierIDValueOf(cs, getSupplierID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field SupplierID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithSupplierIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithSupplierIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field SupplierID
     * for equality with the same SupplierID as this instance.
     */
    public Iterator getIteratorWithSameValueOfSupplierID(int maxResults)
        throws SQLException {
        return getIteratorWithSupplierIDValueOf(cs, getSupplierID(), maxResults);
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field SupplierID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithSupplierIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        return getLinkedListWithSupplierIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for CategoryID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Integer getCategoryID() {
        return CategoryID;
    }

    /**
     * Setter for CategoryID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCategoryID(Integer value) {
        this.CategoryID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field CategoryID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCategoryID(
        int maxResults) throws SQLException {
        return getResultSetWithCategoryIDValueOf(cs, getCategoryID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field CategoryID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCategoryIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ProductsBase_CategoryID");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.INTEGER);
            } else {
                cc.setInt(1, value.intValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field CategoryID
     * for equality with the same CategoryID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCategoryID(int maxResults)
        throws SQLException {
        return getLinkedListWithCategoryIDValueOf(cs, getCategoryID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field CategoryID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCategoryIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCategoryIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field CategoryID
     * for equality with the same CategoryID as this instance.
     */
    public Iterator getIteratorWithSameValueOfCategoryID(int maxResults)
        throws SQLException {
        return getIteratorWithCategoryIDValueOf(cs, getCategoryID(), maxResults);
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field CategoryID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCategoryIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        return getLinkedListWithCategoryIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for QuantityPerUnit.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getQuantityPerUnit() {
        return QuantityPerUnit;
    }

    /**
     * Setter for QuantityPerUnit.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setQuantityPerUnit(String value) {
        this.QuantityPerUnit = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field QuantityPerUnit
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfQuantityPerUnit(
        int maxResults) throws SQLException {
        return getResultSetWithQuantityPerUnitValueOf(cs, getQuantityPerUnit(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field QuantityPerUnit
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithQuantityPerUnitValueOf(
        CS cs, String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ProductsBase_QuantityPerUnit");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field QuantityPerUnit
     * for equality with the same QuantityPerUnit as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfQuantityPerUnit(
        int maxResults) throws SQLException {
        return getLinkedListWithQuantityPerUnitValueOf(cs,
            getQuantityPerUnit(), maxResults);
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field QuantityPerUnit
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithQuantityPerUnitValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithQuantityPerUnitValueOf(cs,
                value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field QuantityPerUnit
     * for equality with the same QuantityPerUnit as this instance.
     */
    public Iterator getIteratorWithSameValueOfQuantityPerUnit(int maxResults)
        throws SQLException {
        return getIteratorWithQuantityPerUnitValueOf(cs, getQuantityPerUnit(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field QuantityPerUnit
     * for equality with the "value".
     */
    public static Iterator getIteratorWithQuantityPerUnitValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithQuantityPerUnitValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for UnitPrice.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Double getUnitPrice() {
        return UnitPrice;
    }

    /**
     * Setter for UnitPrice.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setUnitPrice(Double value) {
        this.UnitPrice = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field UnitPrice
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfUnitPrice(
        int maxResults) throws SQLException {
        return getResultSetWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field UnitPrice
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithUnitPriceValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ProductsBase_UnitPrice");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(1, value.doubleValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field UnitPrice
     * for equality with the same UnitPrice as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfUnitPrice(int maxResults)
        throws SQLException {
        return getLinkedListWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field UnitPrice
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithUnitPriceValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithUnitPriceValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field UnitPrice
     * for equality with the same UnitPrice as this instance.
     */
    public Iterator getIteratorWithSameValueOfUnitPrice(int maxResults)
        throws SQLException {
        return getIteratorWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field UnitPrice
     * for equality with the "value".
     */
    public static Iterator getIteratorWithUnitPriceValueOf(CS cs, Double value,
        int maxResults) throws SQLException {
        return getLinkedListWithUnitPriceValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for UnitsInStock.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Short getUnitsInStock() {
        return UnitsInStock;
    }

    /**
     * Setter for UnitsInStock.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setUnitsInStock(Short value) {
        this.UnitsInStock = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field UnitsInStock
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfUnitsInStock(
        int maxResults) throws SQLException {
        return getResultSetWithUnitsInStockValueOf(cs, getUnitsInStock(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field UnitsInStock
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithUnitsInStockValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ProductsBase_UnitsInStock");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.SMALLINT);
            } else {
                cc.setShort(1, value.shortValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field UnitsInStock
     * for equality with the same UnitsInStock as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfUnitsInStock(int maxResults)
        throws SQLException {
        return getLinkedListWithUnitsInStockValueOf(cs, getUnitsInStock(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field UnitsInStock
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithUnitsInStockValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithUnitsInStockValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field UnitsInStock
     * for equality with the same UnitsInStock as this instance.
     */
    public Iterator getIteratorWithSameValueOfUnitsInStock(int maxResults)
        throws SQLException {
        return getIteratorWithUnitsInStockValueOf(cs, getUnitsInStock(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field UnitsInStock
     * for equality with the "value".
     */
    public static Iterator getIteratorWithUnitsInStockValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        return getLinkedListWithUnitsInStockValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for UnitsOnOrder.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Short getUnitsOnOrder() {
        return UnitsOnOrder;
    }

    /**
     * Setter for UnitsOnOrder.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setUnitsOnOrder(Short value) {
        this.UnitsOnOrder = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field UnitsOnOrder
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfUnitsOnOrder(
        int maxResults) throws SQLException {
        return getResultSetWithUnitsOnOrderValueOf(cs, getUnitsOnOrder(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field UnitsOnOrder
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithUnitsOnOrderValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ProductsBase_UnitsOnOrder");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.SMALLINT);
            } else {
                cc.setShort(1, value.shortValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field UnitsOnOrder
     * for equality with the same UnitsOnOrder as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfUnitsOnOrder(int maxResults)
        throws SQLException {
        return getLinkedListWithUnitsOnOrderValueOf(cs, getUnitsOnOrder(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field UnitsOnOrder
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithUnitsOnOrderValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithUnitsOnOrderValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field UnitsOnOrder
     * for equality with the same UnitsOnOrder as this instance.
     */
    public Iterator getIteratorWithSameValueOfUnitsOnOrder(int maxResults)
        throws SQLException {
        return getIteratorWithUnitsOnOrderValueOf(cs, getUnitsOnOrder(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field UnitsOnOrder
     * for equality with the "value".
     */
    public static Iterator getIteratorWithUnitsOnOrderValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        return getLinkedListWithUnitsOnOrderValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ReorderLevel.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Short getReorderLevel() {
        return ReorderLevel;
    }

    /**
     * Setter for ReorderLevel.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setReorderLevel(Short value) {
        this.ReorderLevel = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field ReorderLevel
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfReorderLevel(
        int maxResults) throws SQLException {
        return getResultSetWithReorderLevelValueOf(cs, getReorderLevel(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field ReorderLevel
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithReorderLevelValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ProductsBase_ReorderLevel");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.SMALLINT);
            } else {
                cc.setShort(1, value.shortValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field ReorderLevel
     * for equality with the same ReorderLevel as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfReorderLevel(int maxResults)
        throws SQLException {
        return getLinkedListWithReorderLevelValueOf(cs, getReorderLevel(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field ReorderLevel
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithReorderLevelValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithReorderLevelValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field ReorderLevel
     * for equality with the same ReorderLevel as this instance.
     */
    public Iterator getIteratorWithSameValueOfReorderLevel(int maxResults)
        throws SQLException {
        return getIteratorWithReorderLevelValueOf(cs, getReorderLevel(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field ReorderLevel
     * for equality with the "value".
     */
    public static Iterator getIteratorWithReorderLevelValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        return getLinkedListWithReorderLevelValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Discontinued.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public boolean getDiscontinued() {
        return Discontinued;
    }

    /**
     * Setter for Discontinued.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setDiscontinued(boolean value) {
        this.Discontinued = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field Discontinued
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfDiscontinued(
        int maxResults) throws SQLException {
        return getResultSetWithDiscontinuedValueOf(cs, getDiscontinued(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ProductsBase's by querying table field Discontinued
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithDiscontinuedValueOf(CS cs,
        boolean value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ProductsBase_Discontinued");
        cc.setMaxRows(maxResults);

        try {
            cc.setBoolean(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field Discontinued
     * for equality with the same Discontinued as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfDiscontinued(int maxResults)
        throws SQLException {
        return getLinkedListWithDiscontinuedValueOf(cs, getDiscontinued(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsBase's by querying table field Discontinued
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithDiscontinuedValueOf(CS cs,
        boolean value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithDiscontinuedValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field Discontinued
     * for equality with the same Discontinued as this instance.
     */
    public Iterator getIteratorWithSameValueOfDiscontinued(int maxResults)
        throws SQLException {
        return getIteratorWithDiscontinuedValueOf(cs, getDiscontinued(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsBase's by querying table field Discontinued
     * for equality with the "value".
     */
    public static Iterator getIteratorWithDiscontinuedValueOf(CS cs,
        boolean value, int maxResults) throws SQLException {
        return getLinkedListWithDiscontinuedValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return ProductsBase.delete(cs, ProductID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int ProductID) throws SQLException {
        CallableStatement cc = null;
        int res = 0;

        try {
            cc = cs.allocCS("DELETE_ProductsBase");

            cc.setInt(1, ProductID);

            res = cc.executeUpdate();
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
        return res;
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATE_ProductsBase");

                cc.setString(1, getProductName());

                if (SupplierID == null) {
                    cc.setNull(2, java.sql.Types.INTEGER);
                } else {
                    cc.setInt(2, getSupplierID().intValue());
                }

                if (CategoryID == null) {
                    cc.setNull(3, java.sql.Types.INTEGER);
                } else {
                    cc.setInt(3, getCategoryID().intValue());
                }

                cc.setString(4, getQuantityPerUnit());

                if (UnitPrice == null) {
                    cc.setNull(5, java.sql.Types.NUMERIC);
                } else {
                    cc.setDouble(5, getUnitPrice().doubleValue());
                }

                if (UnitsInStock == null) {
                    cc.setNull(6, java.sql.Types.SMALLINT);
                } else {
                    cc.setShort(6, getUnitsInStock().shortValue());
                }

                if (UnitsOnOrder == null) {
                    cc.setNull(7, java.sql.Types.SMALLINT);
                } else {
                    cc.setShort(7, getUnitsOnOrder().shortValue());
                }

                if (ReorderLevel == null) {
                    cc.setNull(8, java.sql.Types.SMALLINT);
                } else {
                    cc.setShort(8, getReorderLevel().shortValue());
                }

                cc.setBoolean(9, getDiscontinued());

                cc.setInt(10, getProductID());

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            return res;
        }

        return -1;
    }

    private void updateOldKeys() {
        // update the old_x old key values
        old_ProductID = ProductID;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        ResultSet rs = null;

        try {
            cc = cs.allocCS("INSERT_ProductsBase");

            cc.setString(1, getProductName());

            if (SupplierID == null) {
                cc.setNull(2, java.sql.Types.INTEGER);
            } else {
                cc.setInt(2, getSupplierID().intValue());
            }

            if (CategoryID == null) {
                cc.setNull(3, java.sql.Types.INTEGER);
            } else {
                cc.setInt(3, getCategoryID().intValue());
            }

            cc.setString(4, getQuantityPerUnit());

            if (UnitPrice == null) {
                cc.setNull(5, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(5, getUnitPrice().doubleValue());
            }

            if (UnitsInStock == null) {
                cc.setNull(6, java.sql.Types.SMALLINT);
            } else {
                cc.setShort(6, getUnitsInStock().shortValue());
            }

            if (UnitsOnOrder == null) {
                cc.setNull(7, java.sql.Types.SMALLINT);
            } else {
                cc.setShort(7, getUnitsOnOrder().shortValue());
            }

            if (ReorderLevel == null) {
                cc.setNull(8, java.sql.Types.SMALLINT);
            } else {
                cc.setShort(8, getReorderLevel().shortValue());
            }

            cc.setBoolean(9, getDiscontinued());

            rs = cc.executeQuery();
            rs.next();

            setProductID(rs.getInt(1));

            updateOldKeys();

            isDirty = false;
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "ProductID:" + getProductID());

        System.out.println(prefix + "ProductName:" + getProductName());

        System.out.println(prefix + "SupplierID:" + getSupplierID());

        System.out.println(prefix + "CategoryID:" + getCategoryID());

        System.out.println(prefix + "QuantityPerUnit:" + getQuantityPerUnit());

        System.out.println(prefix + "UnitPrice:" + getUnitPrice());

        System.out.println(prefix + "UnitsInStock:" + getUnitsInStock());

        System.out.println(prefix + "UnitsOnOrder:" + getUnitsOnOrder());

        System.out.println(prefix + "ReorderLevel:" + getReorderLevel());

        System.out.println(prefix + "Discontinued:" + getDiscontinued());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(ProductID);
        sb.append(",");
        sb.append(ProductName);
        sb.append(",");
        sb.append(SupplierID);
        sb.append(",");
        sb.append(CategoryID);
        sb.append(",");
        sb.append(QuantityPerUnit);
        sb.append(",");
        sb.append(UnitPrice);
        sb.append(",");
        sb.append(UnitsInStock);
        sb.append(",");
        sb.append(UnitsOnOrder);
        sb.append(",");
        sb.append(ReorderLevel);
        sb.append(",");
        sb.append(Discontinued);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
