/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.PieChart;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Enumeration;

public class LineChart
extends Chart {
    public static final int SAMPLE_HIGHLIGHT_CIRCLE = 0;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_OPAQUE = 1;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_FILLED = 2;
    public static final int SAMPLE_HIGHLIGHT_SQUARE = 3;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_OPAQUE = 4;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_FILLED = 5;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND = 6;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_OPAQUE = 7;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_FILLED = 8;
    public static final int VALUE_LABELS_OUTSIDE_POINT = 1;
    public static final int VALUE_LABELS_AT_POINT = 0;
    private int valueLabelStyle;
    private int sampleLabelStyle;
    private int seriesLabelStyle;
    private boolean seriesLabelsOn;
    private boolean autoLabelSpacingOn;
    private int[] lineWidth;
    private boolean stackedOn;
    private boolean[][] sampleHighlightOn;
    private boolean[] sampleHighlightOn_all;
    private int[] sampleHighlightStyle;
    private int[] sampleHighlightSize;
    private boolean[] seriesLinesOn;
    private boolean[] connectedLinesOn;
    private String[] highlightImages;
    private int[][][] samplePoints;
    private int lastSelectedLine;

    public void setSampleHighlightStyle(int n, int n2) {
        int n3 = 0;
        while (n3 < this.sampleHighlightStyle.length) {
            this.setSampleHighlightStyle(n3, n, n2);
            ++n3;
        }
    }

    public void setSeriesLabelStyle(int n) {
        if (this.seriesLabelStyle != n) {
            this.seriesLabelStyle = n;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public void setSampleHighlightStyle(int n, int n2, int n3) {
        this.sampleHighlightSize[n] = Math.max(0, n3);
        this.sampleHighlightStyle[n] = n2;
        this.needRender = true;
        this.autoRepaint();
    }

    public int getSampleHighlightStyle(int n) {
        try {
            return this.sampleHighlightStyle[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public boolean isSampleLabelsOn() {
        return this.sampleLabelsOn;
    }

    public void setAutoLabelSpacingOn(boolean bl) {
        if (this.autoLabelSpacingOn != bl) {
            this.autoLabelSpacingOn = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public void setStackedOn(boolean bl) {
        if (this.stackedOn != bl) {
            this.stackedOn = bl;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public void setConnectedLinesOn(int n, boolean bl) {
        if (n >= 0 && n < this.connectedLinesOn.length) {
            this.connectedLinesOn[n] = bl;
        } else if (n == -1) {
            int n2 = 0;
            while (n2 < this.connectedLinesOn.length) {
                this.connectedLinesOn[n2] = bl;
                ++n2;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    boolean isAnyFloatingLabelsOn() {
        return this.isValueLabelsOn() && this.valueLabelStyle == 3 || this.sampleLabelsOn && (this.sampleLabelStyle == 3 || this.sampleLabelStyle == 4) || this.seriesLabelsOn;
    }

    public String[] getLegendLabels() {
        if (this.legendLabels != null) {
            return this.legendLabels;
        }
        return this.getSeriesLabels();
    }

    private void paintBelowSampleLabels(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        String[] stringArray = this.getSampleLabels();
        Font font = this.getFont("sampleLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        fontMetrics.getAscent();
        int n = this.getLabelAngle("sampleLabelAngle");
        int n2 = Math.max(this.visibleSamples[0] - 1, 0);
        int n3 = Math.min(n2 + this.visibleSamples[1] + 1, this.getSampleCount());
        double d = 0.0;
        int n4 = n2;
        while (n4 < n3) {
            String string = null;
            if (stringArray != null) {
                string = stringArray[n4];
            }
            Dimension dimension = this.getLabelSize(string, fontMetrics);
            Dimension dimension2 = this.getAngledLabelSize(dimension, n);
            if (this.sampleLabelsOn && (this.sampleLabelStyle == 2 || this.sampleLabelStyle == 4)) {
                int n5 = rectangle.y + rectangle.height;
                int n6 = rectangle.x;
                int n7 = rectangle.x + rectangle.width;
                if (this.is3DModeOn()) {
                    n5 -= this.depth3dPoint.y;
                    n7 -= this.depth3dPoint.x;
                    n6 -= this.depth3dPoint.x;
                }
                if (this.sampleScrollerOn) {
                    n5 += 10;
                }
                int n8 = this.samplePoints[0][n4][0];
                if (string != null && string.length() > 0 && n8 >= n6 && n8 <= n7 + 1) {
                    int n9 = n5 + 8;
                    if (n % 180 == 0) {
                        n9 += fontMetrics.getMaxAscent() - 4;
                    }
                    int n10 = 0;
                    n10 = n % 180 == 0 ? n8 - dimension2.width / 2 : (n % 360 > 90 && n % 360 < 180 || n % 360 > 270 ? n8 - dimension2.width + fontMetrics.getAscent() / 2 : n8 - fontMetrics.getAscent() / 2);
                    graphics.setFont(font);
                    Color color = this.getForeground();
                    Color color2 = this.getSampleLabelColor(n4);
                    if (color2 == null) {
                        color2 = color;
                    }
                    graphics.setColor(color);
                    if (this.autoLabelSpacingOn) {
                        if (string != null && string.trim().length() > 0 && ((double)n10 > d || n4 == 0)) {
                            graphics.drawLine(Math.round(n8), n5, Math.round(n8), n5 + 3);
                            graphics.setColor(color2);
                            this.paintLabel(graphics, string, n10, n9, dimension, 0, n);
                            d = n10 + dimension2.width;
                        }
                    } else if (string != null && string.trim().length() > 0) {
                        graphics.drawLine(Math.round(n8), n5, Math.round(n8), n5 + 3);
                        graphics.setColor(color2);
                        this.paintLabel(graphics, string, n10, n9, dimension, 0, n);
                    }
                }
            }
            ++n4;
        }
    }

    public void setSampleLabelStyle(int n) {
        if (this.sampleLabelStyle != n) {
            this.sampleLabelStyle = n;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getSampleLabelStyle() {
        return this.sampleLabelStyle;
    }

    public void setSeriesLineOn(boolean bl) {
        int n = 0;
        while (n < this.seriesLinesOn.length) {
            this.seriesLinesOn[n] = bl;
            ++n;
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSeriesLineOn(int n, boolean bl) {
        if (this.seriesLinesOn[n] != bl) {
            this.seriesLinesOn[n] = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    private void paintSampleHighlight(Graphics graphics, int n, int n2, int n3, Color color) {
        Shape shape = graphics.getClip();
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        String string = this.getLegendImage(n);
        Dimension dimension = this.getImageSize(string);
        if (string != null && dimension.width > 0 && dimension.height > 0) {
            Image image = (Image)this.images.get(string);
            if (image != null) {
                graphics.drawImage(image, n2 - dimension.width / 2, n3 - dimension.height / 2, this);
            }
        } else {
            int n4 = 6;
            if (n >= 0 && n < this.sampleHighlightSize.length) {
                n4 = this.sampleHighlightSize[n];
            }
            int n5 = 0;
            if (n >= 0 && n < this.sampleHighlightStyle.length) {
                n5 = this.sampleHighlightStyle[n];
            }
            Color color2 = this.getChartBackground();
            graphics.setColor(color);
            switch (n5) {
                case 0: {
                    graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 2: {
                    graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    break;
                }
                case 1: {
                    graphics.setColor(color2);
                    graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    graphics.setColor(color);
                    graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 3: {
                    graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 5: {
                    graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    break;
                }
                case 4: {
                    graphics.setColor(color2);
                    graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    graphics.setColor(color);
                    graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    int[] nArray = new int[4];
                    nArray[0] = nArray[2] = n2;
                    nArray[1] = n2 + n4 / 2;
                    nArray[3] = n2 - n4 / 2;
                    int[] nArray2 = new int[4];
                    nArray2[0] = n3 - n4 / 2;
                    nArray2[2] = n3 + n4 / 2;
                    nArray2[1] = nArray2[3] = n3;
                    if (n5 == 7) {
                        graphics.setColor(color2);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    } else if (n5 == 8) {
                        graphics.setColor(color);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    }
                    graphics.setColor(color);
                    graphics.drawPolygon(nArray, nArray2, 4);
                    break;
                }
            }
        }
        graphics.setClip(shape);
    }

    double getHighestValue(int n) {
        if (this.stackedOn) {
            return Math.max(super.getHighestValue(n), this.getMaxValue(-2));
        }
        return super.getHighestValue(n);
    }

    public double getMaxValue(int n) {
        if (n >= -1 || !this.stackedOn) {
            return super.getMaxValue(n);
        }
        double d = 0.0;
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        int n4 = 0;
        while (n4 < n2) {
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < n3) {
                ChartSample chartSample = this.getSample(n5, n4);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && chartSample.value > 0.0) {
                    d2 += chartSample.value.doubleValue();
                }
                ++n5;
            }
            d = Math.max(d, d2);
            ++n4;
        }
        return d;
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
        if (!this.needChartCalculation) {
            return;
        }
        int n = this.getSampleCount();
        int n2 = this.getSeriesCount();
        this.calculateZeroLines(rectangle);
        boolean bl = this.is3DModeOn();
        if (bl) {
            if (this.depth3d > -1) {
                this.depth3dPoint.x = this.depth3d;
                this.depth3dPoint.y = -this.depth3d;
            } else {
                int n3 = Math.max(n, 20);
                if (n2 > 1 && !this.stackedOn) {
                    n3 /= n2;
                    n3 = Math.max(n3, 4);
                }
                double d = (double)rectangle.width / (double)n3;
                this.depth3dPoint.x = (int)Math.round(d * 1.25);
                this.depth3dPoint.y = (int)Math.round(-d / 1.25);
            }
        }
        if (this.samplePoints == null || this.samplePoints.length != n2 || this.samplePoints[0] == null || this.samplePoints[0].length != n) {
            this.samplePoints = new int[n2][n][2];
        }
        double d = rectangle2.x;
        double d2 = rectangle2.width;
        double d3 = this.depth3dPoint.x;
        if (n > 2) {
            d2 = (double)rectangle2.width / (double)(n - 1);
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            n5 = d >= 0.0 ? (int)(d + 0.5) : (int)(d - 0.5);
            int n6 = 0;
            while (n6 < n2) {
                int n7;
                this.samplePoints[n6][n4][0] = n5;
                if (bl && !this.stackedOn) {
                    d3 = (double)this.depth3dPoint.x / (double)n2 * (double)n6;
                    int[] nArray = this.samplePoints[n6][n4];
                    nArray[0] = (int)((double)nArray[0] + d3);
                }
                double d4 = 0.0;
                if (n6 >= 0 && this.stackedOn) {
                    n7 = 0;
                    while (n7 <= n6) {
                        d4 += this.getSampleValue(n7, n4);
                        ++n7;
                    }
                } else if (n6 >= 0) {
                    d4 = this.getSampleValue(n6, n4);
                }
                n7 = this.getSeriesRange(n6);
                double d5 = 0.0;
                try {
                    d5 = (d4 - this.currentLowerRange[n7]) / (this.currentUpperRange[n7] - this.currentLowerRange[n7]);
                }
                catch (ArithmeticException arithmeticException) {
                    d5 = Double.NaN;
                }
                double d6 = (double)(rectangle.y + rectangle.height) - d5 * (double)rectangle.height;
                this.samplePoints[n6][n4][1] = d6 >= 0.0 ? (int)(d6 + 0.5) : (int)(d6 - 0.5);
                if (bl && this.stackedOn) {
                    int[] nArray = this.samplePoints[n6][n4];
                    nArray[1] = nArray[1] - this.depth3dPoint.y;
                } else if (bl) {
                    int[] nArray = this.samplePoints[n6][n4];
                    nArray[1] = nArray[1] - this.depth3dPoint.y;
                    double d7 = (double)this.depth3dPoint.y / (double)this.getSeriesCount() * (double)n6;
                    int[] nArray2 = this.samplePoints[n6][n4];
                    nArray2[1] = nArray2[1] + (int)Math.round(d7);
                }
                ++n6;
            }
            d += d2;
            ++n4;
        }
        this.needChartCalculation = false;
    }

    void paintFloatingLabels(Graphics graphics, Rectangle rectangle) {
        super.paintFloatingLabels(graphics, rectangle);
        boolean bl = this.isValueLabelsOn(-1) && this.valueLabelStyle == 3;
        bl |= this.sampleLabelsOn && (this.sampleLabelStyle == 3 || this.sampleLabelStyle == 4);
        if (bl |= this.seriesLabelsOn && this.seriesLabelStyle == 3) {
            Font font = this.getFont("floatingLabelFont");
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.mouseOverSampleIndex >= 0 && this.mouseOverSeriesIndex >= 0) {
                ChartSample chartSample = this.getSample(this.mouseOverSeriesIndex, this.mouseOverSampleIndex);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                    String string = this.constructLabel(this.mouseOverSeriesIndex, this.mouseOverSampleIndex, this.seriesLabelsOn, 3);
                    this.paintFloatingLabel(graphics, rectangle, this.mouseOverSeriesIndex, this.mouseOverSampleIndex, string, font, fontMetrics);
                }
            } else if (this.mouseOverSeriesIndex >= 0 && this.isFloatingOnLegendOn()) {
                int n = this.getSampleCount();
                int n2 = 0;
                while (n2 < n) {
                    ChartSample chartSample = this.getSample(this.mouseOverSeriesIndex, n2);
                    if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                        String string = this.constructLabel(this.mouseOverSeriesIndex, n2, false, 3);
                        this.paintFloatingLabel(graphics, rectangle, this.mouseOverSeriesIndex, n2, string, font, fontMetrics);
                    }
                    ++n2;
                }
            }
        }
    }

    public boolean isSeriesLineOn(int n) {
        return this.seriesLinesOn[n];
    }

    public void setSampleLabelsOn(boolean bl) {
        this.sampleLabelsOn = bl;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isSeriesLabelsOn() {
        return this.seriesLabelsOn;
    }

    private String constructLabel(int n, int n2, boolean bl, int n3) {
        String string;
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount()) {
            return "";
        }
        String string2 = "";
        boolean bl2 = n3 == 5 && this.seriesLabelStyle == 1;
        bl2 |= n3 == 3 && this.seriesLabelStyle == 3;
        boolean bl3 = n3 == 5 && this.sampleLabelStyle == 1;
        bl3 |= n3 == 3 && (this.sampleLabelStyle == 3 || this.sampleLabelStyle == 4);
        boolean bl4 = n3 == 5 && this.valueLabelStyle == 1;
        bl4 |= n3 == 3 && this.valueLabelStyle == 3;
        if (bl && bl2 && (string = this.getSeriesLabel(n)) != null) {
            string2 = string2 + string;
            if (!string.endsWith("\n") && this.sampleLabelsOn && bl3 && this.getSampleLabel(n2) != null) {
                string2 = n3 == 3 ? string2 + " : " : string2 + ":";
            }
        }
        if (this.sampleLabelsOn && bl3 && this.getSampleLabel(n2) != null) {
            string2 = string2 + this.getSampleLabel(n2);
        }
        if (this.isValueLabelsOn(n) && bl4) {
            String string3;
            string = this.getLabel("valueLabelPrefix_" + n);
            if (string == null) {
                string = this.getLabel("valueLabelPrefix");
            }
            if ((string3 = this.getLabel("valueLabelPostfix_" + n)) == null) {
                string3 = this.getLabel("valueLabelPostfix");
            }
            if (string2.length() > 0) {
                String string4 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string4 = string != null ? string + string4 : string4;
                String string5 = string4 = string3 != null ? string4 + string3 : string4;
                string2 = string2.endsWith("\n") ? string2 + string4 : (n3 == 3 ? string2 + " : " + string4 : string2 + ":" + string4);
            } else {
                string2 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string2 = string != null ? string + string2 : string2;
                string2 = string3 != null ? string2 + string3 : string2;
            }
        }
        return string2;
    }

    public void setLineWidth(int n) {
        this.setLineWidth(-1, n);
    }

    public void setLineWidth(int n, int n2) {
        if (n >= 0 && n < this.lineWidth.length) {
            this.lineWidth[n] = n2;
        } else if (n < 0) {
            int n3 = 0;
            while (n3 < this.lineWidth.length) {
                this.lineWidth[n3] = n2;
                ++n3;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public int getLineWidth() {
        return this.getLineWidth(0);
    }

    public int getLineWidth(int n) {
        if (n >= 0 && n < this.lineWidth.length) {
            return this.lineWidth[n];
        }
        return this.lineWidth[0];
    }

    private void paintStaticLabels(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        int n = this.getSampleCount();
        int n2 = this.getSeriesCount();
        boolean bl = this.is3DModeOn();
        double d = rectangle2.width;
        if (n > 2) {
            d = (double)rectangle2.width / (double)(n - 1);
        }
        Font font = this.getFont("valueLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n3 = this.getLabelAngle("valueLabelAngle");
        Font font2 = this.getFont("sampleLabelFont");
        FontMetrics fontMetrics2 = this.getFontMetrics(font2);
        int n4 = this.getLabelAngle("sampleLabelAngle");
        int n5 = 0;
        while (n5 < n2) {
            String string;
            String string2;
            if (this.stackedOn) {
                if (n5 != 0) break;
                n5 = n2 - 1;
            }
            if ((string2 = this.getLabel("valueLabelPrefix_" + n5)) == null) {
                string2 = this.getLabel("valueLabelPrefix");
            }
            if ((string = this.getLabel("valueLabelPostfix_" + n5)) == null) {
                string = this.getLabel("valueLabelPostfix");
            }
            int n6 = this.getSampleDecimalCount(n5);
            ChartSample[] chartSampleArray = this.getSamples(n5);
            int n7 = Math.max(this.visibleSamples[0] - 1, 0);
            int n8 = Math.min(n7 + this.visibleSamples[1] + 1, n);
            int n9 = n7;
            while (n9 < n8) {
                block39: {
                    double d2;
                    block41: {
                        block40: {
                            if (!this.stackedOn && (chartSampleArray[n9] == null || chartSampleArray[n9].value == null || chartSampleArray[n9].value.isNaN())) break block39;
                            d2 = 0.0;
                            if (!this.stackedOn) break block40;
                            boolean bl2 = false;
                            int n10 = 0;
                            while (n10 < n2) {
                                ChartSample chartSample = this.getSample(n10, n9);
                                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                                    d2 += chartSample.value.doubleValue();
                                    bl2 = true;
                                }
                                ++n10;
                            }
                            if (bl2) break block41;
                            break block39;
                        }
                        ChartSample chartSample = this.getSample(n5, n9);
                        if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) break block39;
                        d2 = chartSampleArray[n9].getFloatValue();
                    }
                    double d3 = d2;
                    if (n9 >= 1 && chartSampleArray[n9 - 1] != null) {
                        d3 = chartSampleArray[n9 - 1].getFloatValue();
                    }
                    double d4 = d2;
                    if (n9 < chartSampleArray.length - 1 && chartSampleArray[n9 + 1] != null) {
                        d4 = chartSampleArray[n9 + 1].getFloatValue();
                    }
                    double d5 = (d2 - d3) / d;
                    double d6 = (d4 - d2) / d;
                    Dimension dimension = new Dimension();
                    int n11 = this.samplePoints[n5][n9][0];
                    int n12 = this.samplePoints[n5][n9][1] - 1;
                    if (this.valueLabelStyle == 0 && this.isValueLabelsOn(n5)) {
                        String string3 = this.formatNumber(d2, n6);
                        string3 = string2 != null ? string2 + string3 : string3;
                        string3 = string != null ? string3 + string : string3;
                        Dimension dimension2 = this.getLabelSize(string3, fontMetrics);
                        dimension = this.getAngledLabelSize(dimension2, n3);
                        int n13 = Math.round(n11 - dimension.width / 2) + 1;
                        int n14 = n12;
                        n14 = n3 % 180 == 0 ? (n14 += fontMetrics.getAscent() / 2) : n12 - dimension.height / 2;
                        if (bl) {
                            if (d5 >= d6) {
                                n14 += this.depth3dPoint.y;
                            } else {
                                n13 -= this.depth3dPoint.x;
                            }
                        }
                        graphics.setColor(this.getChartForeground());
                        if (this.isLabelInside(n11, n12, n14 + dimension.height, rectangle)) {
                            graphics.setFont(font);
                            this.paintLabel(graphics, string3, n13, n14, dimension2, 0, n3);
                        }
                    }
                    if (this.valueLabelStyle == 1 && this.isValueLabelsOn(n5) || this.sampleLabelStyle == 1 && this.sampleLabelsOn || this.seriesLabelStyle == 1 && this.seriesLabelsOn) {
                        int n15 = 0;
                        int n16 = fontMetrics2.getAscent();
                        Color color = null;
                        if (this.sampleLabelStyle == 1 && this.sampleLabelsOn) {
                            graphics.setFont(font2);
                            color = this.getSampleLabelColor(n9);
                            n15 = n4;
                            n16 = fontMetrics2.getAscent();
                        } else if (this.valueLabelStyle == 1 && this.isValueLabelsOn(n5)) {
                            graphics.setFont(font);
                            n15 = n3;
                            n16 = fontMetrics.getAscent();
                        } else if (this.seriesLabelStyle == 1 && this.seriesLabelsOn) {
                            graphics.setFont(font2);
                            color = this.getSeriesLabelColor(n5);
                        }
                        if (color == null) {
                            color = this.getChartForeground();
                        }
                        String string4 = this.constructLabel(n5, n9, this.seriesLabelsOn, 5);
                        Dimension dimension3 = this.getLabelSize(string4, graphics.getFontMetrics());
                        Dimension dimension4 = this.getAngledLabelSize(dimension3, n15);
                        int n17 = Math.round(n11 - dimension4.width / 2) + 1;
                        if (bl && d5 < d6) {
                            n17 -= this.depth3dPoint.x;
                        }
                        n17 = bl ? Math.max(rectangle.x - this.depth3dPoint.x + 2, n17) : Math.max(rectangle.x + 2, n17);
                        n17 = Math.min(n17, rectangle.x + rectangle.width - dimension4.width - 1);
                        if (n15 % 360 > 90 && n15 % 360 < 180 || n15 % 360 > 270) {
                            n17 = n11 - graphics.getFontMetrics().getAscent() / 2;
                        }
                        int n18 = n12;
                        if (bl && d5 >= d6) {
                            n18 += this.depth3dPoint.y;
                        }
                        if (n15 % 180 != 0) {
                            n18 -= dimension4.height + 1;
                        }
                        int n19 = n18;
                        n19 = n15 % 180 == 0 ? (n19 += n16) : (n19 += dimension4.height + 6);
                        int n20 = n18;
                        if (n15 % 180 == 0) {
                            n20 -= dimension4.height - graphics.getFontMetrics().getAscent() - 1;
                        }
                        boolean bl3 = false;
                        int n21 = 0;
                        try {
                            bl3 = this.sampleHighlightOn[n5][n9];
                            n21 = this.sampleHighlightSize[n5];
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            System.out.println("Internal error with value labels");
                            indexOutOfBoundsException.printStackTrace();
                        }
                        if (bl3 || this.valueLabelStyle == 0 && this.isValueLabelsOn(n5)) {
                            if (n21 >= dimension.height) {
                                n19 += n21 / 2;
                                n20 -= n21 / 2;
                            } else {
                                n19 += dimension.height / 2 - 3;
                                n20 -= dimension.height / 2 - 1;
                            }
                        }
                        if ((n18 = d5 < d6 ? n19 : n20) == n19) {
                            if (n15 % 360 > 90 && n15 % 360 < 180 || n15 % 360 > 270) {
                                n17 = n11 - dimension4.width + graphics.getFontMetrics().getAscent() / 2;
                            }
                        } else if (bl && !this.stackedOn) {
                            double d7 = (double)this.depth3dPoint.x / (double)n2;
                            n17 = (int)((double)n17 + d7);
                        }
                        if (bl || this.isLabelInside(n11, n12, n18 + dimension4.height, rectangle)) {
                            graphics.setColor(color);
                            this.paintLabel(graphics, string4, n17, n18, dimension3, 0, n15);
                        }
                    }
                }
                ++n9;
            }
            ++n5;
        }
    }

    public int getValueLabelStyle() {
        return this.valueLabelStyle;
    }

    public void setValueLabelStyle(int n) {
        if (this.valueLabelStyle != n) {
            this.valueLabelStyle = n;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isSampleHighlightOn(int n, int n2) {
        try {
            return this.sampleHighlightOn_all[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series or index: " + n + ", " + n2);
        }
    }

    public ChartSample checkSelection(Point point) {
        int n;
        if (point == null) {
            return null;
        }
        ChartSample chartSample = null;
        this.getSeriesCount();
        if (this.isLegendOn() && this.legendBounds != null) {
            n = 0;
            while (n < this.legendBounds.length) {
                if (this.legendBounds[n] != null && this.legendBounds[n].contains(point)) {
                    chartSample = new ChartSample(-1);
                    chartSample.setSeries(n);
                    break;
                }
                ++n;
            }
        }
        if (chartSample == null && this.samplePoints != null) {
            n = 3;
            int n2 = 0;
            while (n2 < this.samplePoints.length) {
                int n3 = 0;
                while (n3 < this.samplePoints[n2].length) {
                    Point point2 = new Point(this.samplePoints[n2][n3][0], this.samplePoints[n2][n3][1]);
                    if (this.is3DModeOn()) {
                        point2.x -= this.depth3dPoint.x;
                        if (!this.stackedOn) {
                            double d = (double)this.depth3dPoint.x / (double)this.getSeriesCount();
                            int n4 = (int)Math.round(d * (double)n2);
                            point2.x += n4;
                        }
                    }
                    boolean bl = point.x >= point2.x - n && point.x <= point2.x + n;
                    if (bl &= point.y >= point2.y - n && point.y <= point2.y + n) {
                        return this.getSample(n2, n3);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return chartSample;
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.paintLines(graphics, rectangle, rectangle2);
    }

    public void reset() {
        super.reset();
        this.valueLabelStyle = 1;
        this.sampleLabelStyle = 2;
        this.seriesLabelStyle = 3;
        this.autoLabelSpacingOn = false;
        this.multiSeriesOn = true;
    }

    public void setSampleColors(Color[] colorArray) {
        super.setSampleColors(colorArray);
        if (colorArray == null) {
            this.setSampleColor(2, new Color(132, 255, 198));
        }
        this.autoRepaint();
    }

    public LineChart() {
        this(1, 5, 100.0);
    }

    public LineChart(int n, int n2, double d) {
        this(n, n2, d, 0.0);
    }

    public LineChart(int n, int n2, double d, double d2) {
        super(n2);
        this.chartType = "line";
        this.multiSeriesOn = true;
        this.sampleHighlightOn = new boolean[n][n2];
        this.sampleHighlightOn_all = new boolean[n];
        this.sampleHighlightStyle = new int[n];
        this.sampleHighlightSize = new int[n];
        this.seriesLinesOn = new boolean[n];
        this.lineWidth = new int[n];
        int n3 = 0;
        while (n3 < this.sampleHighlightSize.length) {
            this.sampleHighlightSize[n3] = 6;
            this.seriesLinesOn[n3] = true;
            this.lineWidth[n3] = 2;
            ++n3;
        }
        this.connectedLinesOn = new boolean[n];
        this.setAutomaticRepaintOn(false);
        this.setSeriesCount(n);
        this.setRange(0, d);
        this.setLowerRange(0, d2);
        this.setSampleColors(null);
        this.setAutomaticRepaintOn(true);
        this.lastSelectedLine = -1;
    }

    private void paintLine(Graphics graphics, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        int n2;
        int n3;
        ChartSample[] chartSampleArray;
        int n4 = this.getSeriesCount();
        if (n < 0 || n >= n4) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        if (bl) {
            this.lastSelectedLine = n;
        }
        if ((chartSampleArray = this.getSamples(n)) == null || chartSampleArray.length == 0) {
            return;
        }
        Color color2 = this.stackedOn || bl ? color.darker() : color;
        boolean bl2 = this.is3DModeOn();
        Graphics graphics2 = graphics;
        if (bl2) {
            graphics2.setClip(rectangle.x - this.depth3dPoint.x + 1, rectangle.y + 1, rectangle.width + this.depth3dPoint.x - 1, rectangle.height - this.depth3dPoint.y - 1);
        } else {
            graphics2.setClip(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height + 1);
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n5 = 0;
        int n6 = this.samplePoints[n][0][0];
        int n7 = this.samplePoints[n][0][1];
        int n8 = 0;
        while (n8 < chartSampleArray.length - 1) {
            boolean bl3 = chartSampleArray[n8] != null && chartSampleArray[n8].value != null && !chartSampleArray[n8].value.isNaN();
            n3 = chartSampleArray[n8 + 1] == null || chartSampleArray[n8 + 1].value == null || chartSampleArray[n8 + 1].value.isNaN() ? 0 : 1;
            n2 = !bl3 || n3 == 0 ? 0 : 1;
            if ((n2 |= n3 == 0 || !this.connectedLinesOn[n] ? 0 : 1) != 0 && n8 < this.samplePoints[n].length - 1) {
                n2 = this.samplePoints[n][n8][0] == n6 ? 0 : 1;
                n2 |= this.samplePoints[n][n8 + 1][1] == n7 ? 0 : 1;
            }
            if (bl3) {
                n6 = this.samplePoints[n][n8][0];
                n7 = this.samplePoints[n][n8][1];
                n5 = 1;
            }
            if ((n2 &= n5) != 0) {
                int n9;
                if (this.connectedLinesOn[n]) {
                    nArray[0] = n6;
                    nArray2[0] = n7;
                } else {
                    nArray[0] = this.samplePoints[n][n8][0];
                    nArray2[0] = this.samplePoints[n][n8][1];
                }
                nArray[1] = this.samplePoints[n][n8 + 1][0];
                nArray2[1] = this.samplePoints[n][n8 + 1][1];
                if (bl2) {
                    nArray[0] = nArray[0] - this.depth3dPoint.x;
                    nArray[1] = nArray[1] - this.depth3dPoint.x;
                    nArray[2] = nArray[2] - this.depth3dPoint.x;
                    nArray[3] = nArray[3] - this.depth3dPoint.x;
                    if (!this.stackedOn) {
                        double d = (double)this.depth3dPoint.x / (double)n4;
                        n9 = (int)Math.round(d * (double)n);
                        nArray[0] = nArray[0] + n9;
                        nArray[1] = nArray[1] + n9;
                        nArray[2] = nArray[2] + n9;
                        nArray[3] = nArray[3] + n9;
                    }
                }
                if (this.stackedOn) {
                    nArray[2] = nArray[1];
                    nArray2[2] = n > 0 ? this.samplePoints[n - 1][n8 + 1][1] : rectangle.y + rectangle.height;
                    if (bl2) {
                        nArray2[2] = nArray2[2] - this.depth3dPoint.y;
                    }
                    nArray[3] = nArray[0];
                    nArray2[3] = n > 0 ? this.samplePoints[n - 1][n8][1] : rectangle.y + rectangle.height;
                    if (bl2) {
                        nArray2[3] = nArray2[3] - this.depth3dPoint.y;
                    }
                }
                boolean bl4 = false;
                int n10 = rectangle.x - (bl2 ? this.depth3dPoint.x * 2 : 0);
                n9 = rectangle.x + rectangle.width;
                bl4 |= nArray[0] >= n10 && nArray[0] <= n9;
                bl4 |= nArray[1] >= n10 && nArray[1] <= n9;
                if (bl4 |= nArray[0] <= n10 && nArray[1] >= n9) {
                    int n11;
                    nArray[0] = Math.max(nArray[0], -10000);
                    nArray[1] = Math.max(nArray[1], -10000);
                    nArray[0] = Math.min(nArray[0], 11000);
                    nArray[1] = Math.min(nArray[1], 11000);
                    nArray2[0] = Math.max(nArray2[0], -10000);
                    nArray2[1] = Math.max(nArray2[1], -10000);
                    nArray2[0] = Math.min(nArray2[0], 11000);
                    nArray2[1] = Math.min(nArray2[1], 11000);
                    if (this.seriesLinesOn[n]) {
                        if (bl2 && this.stackedOn) {
                            boolean bl5;
                            boolean bl6 = n == n4 - 1;
                            boolean bl7 = bl5 = n8 == chartSampleArray.length - 2;
                            if (n8 < chartSampleArray.length - 2) {
                                bl5 |= chartSampleArray[n8 + 2] == null || chartSampleArray[n8 + 2].value == null || chartSampleArray[n8 + 2].value.isNaN();
                                bl5 &= !this.connectedLinesOn[n];
                            }
                            this.paint3DLine(graphics2, nArray[0], nArray2[0], nArray[1], nArray2[1], nArray2[2], color2, bl6, bl5);
                        } else if (bl2) {
                            this.paint3DLine(graphics2, nArray[0], nArray2[0], nArray[1], nArray2[1], nArray2[2], color2, true, false);
                        }
                    }
                    if (this.stackedOn && this.seriesLinesOn[n]) {
                        graphics2.setColor(bl ? color.darker() : color);
                        graphics2.fillPolygon(nArray, nArray2, 4);
                        graphics2.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                    }
                    graphics2.setColor(color);
                    if (bl2 && this.stackedOn) {
                        graphics2.setColor(color.darker().darker());
                    } else if (bl2 || this.stackedOn) {
                        graphics2.setColor(color.darker());
                    }
                    if (this.seriesLinesOn[n] || bl) {
                        graphics2.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                        if (!bl2 && !this.stackedOn && this.lineWidth[n] > 1 && (this.seriesLinesOn[n] || bl)) {
                            double d = 0.0;
                            if (nArray[1] - nArray[0] != 0) {
                                d = Math.abs((double)(nArray2[1] - nArray2[0]) / (double)(nArray[1] - nArray[0]));
                            }
                            n11 = 1;
                            int n12 = 2;
                            while (n12 <= this.lineWidth[n]) {
                                int n13 = n12 / 2 * n11;
                                if (d <= 1.0) {
                                    graphics2.drawLine(nArray[0], nArray2[0] + n13, nArray[1], nArray2[1] + n13);
                                } else {
                                    graphics2.drawLine(nArray[0] - n13, nArray2[0], nArray[1] - n13, nArray2[1]);
                                }
                                n11 = -n11;
                                ++n12;
                            }
                        }
                    }
                    if (bl && this.seriesLinesOn[n] && !bl2 && !this.stackedOn) {
                        double d = 0.0;
                        if (nArray[1] - nArray[0] != 0) {
                            d = Math.abs((double)(nArray2[1] - nArray2[0]) / (double)(nArray[1] - nArray[0]));
                        }
                        n11 = this.lineWidth[n] / 2 + 1;
                        graphics2.setColor(color.darker().darker());
                        if (d <= 1.0) {
                            graphics2.drawLine(nArray[0], nArray2[0] + n11, nArray[1], nArray2[1] + n11);
                        } else {
                            graphics2.drawLine(nArray[0] - n11, nArray2[0], nArray[1] - n11, nArray2[1]);
                        }
                    }
                }
            }
            ++n8;
        }
        if (!bl2) {
            n8 = 0;
            while (n8 < chartSampleArray.length) {
                ChartSample chartSample = chartSampleArray[n8];
                if (this.sampleHighlightOn[n][n8] && chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                    n3 = this.samplePoints[n][n8][0];
                    n2 = this.samplePoints[n][n8][1];
                    if (n2 >= rectangle.y && n2 <= rectangle.y + rectangle.height && n3 >= rectangle.x && n3 <= rectangle.x + rectangle.width + 1) {
                        this.paintSampleHighlight(graphics, n, Math.round(n3), n2, color);
                    }
                }
                ++n8;
            }
        }
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private boolean isLabelInside(double d, double d2, double d3, Rectangle rectangle) {
        boolean bl = true;
        if (this.is3DModeOn()) {
            if (d2 <= d3) {
                bl = d2 >= (double)(rectangle.y - 2) && d2 <= (double)(rectangle.y + rectangle.height + 2 - this.depth3dPoint.y) && d >= (double)(rectangle.x - 2 - this.depth3dPoint.x) && d <= (double)(rectangle.x + rectangle.width + 2);
            } else {
                double d4 = (double)this.depth3dPoint.x / (double)this.getSeriesCount();
                double d5 = (double)this.depth3dPoint.y / (double)this.getSeriesCount();
                bl = d2 >= (double)rectangle.y - d5 - 2.0 && d2 <= (double)(rectangle.y + rectangle.height - this.depth3dPoint.y) - d5 && d >= (double)(rectangle.x - this.depth3dPoint.x) - d4 - 2.0 && d <= (double)(rectangle.x + rectangle.width) - d4 + 2.0;
            }
        } else {
            bl = d2 >= (double)(rectangle.y - 2) && d2 <= (double)(rectangle.y + rectangle.height + 2) && d >= (double)(rectangle.x - 4) && d <= (double)(rectangle.x + rectangle.width + 2);
        }
        return bl;
    }

    public boolean isAutoLabelSpacingOn() {
        return this.autoLabelSpacingOn;
    }

    public boolean isStackedOn() {
        return this.stackedOn;
    }

    public boolean isConnectedLinesOn(int n) {
        if (n >= 0 && n < this.connectedLinesOn.length) {
            return this.connectedLinesOn[n];
        }
        if (n == -1) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.connectedLinesOn.length) {
                if (this.connectedLinesOn[n2]) {
                    bl = true;
                }
                ++n2;
            }
            return bl;
        }
        return false;
    }

    public void setLegendImage(int n, String string) {
        if (n >= 0 && n < 1000) {
            super.setLegendImage(n, string);
            if (this.highlightImages == null) {
                this.highlightImages = new String[n + 1];
            }
            if (n >= this.highlightImages.length) {
                String[] stringArray = new String[n + 1];
                System.arraycopy(this.highlightImages, 0, stringArray, 0, this.highlightImages.length);
                this.highlightImages = stringArray;
            }
            this.highlightImages[n] = string;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public void render(Graphics graphics) {
        this.render(graphics, !this.isServletModeOn());
    }

    void render(Graphics graphics, boolean bl) {
        Rectangle rectangle;
        Rectangle rectangle2;
        Chart chart;
        Dimension dimension = this.getSize();
        Rectangle rectangle3 = this.getGraphBounds();
        Rectangle rectangle4 = this.getDataBounds(rectangle3);
        this.calculateChartData(rectangle3, rectangle4);
        int n = 0;
        while (n < this.overlayCharts.size()) {
            chart = (Chart)this.overlayCharts.elementAt(n);
            if (chart != null) {
                rectangle2 = new Rectangle(rectangle3);
                rectangle = new Rectangle(rectangle4);
                if (this.is3DModeOn()) {
                    rectangle2.x -= this.depth3dPoint.x;
                    rectangle2.y -= this.depth3dPoint.y;
                    rectangle.x -= this.depth3dPoint.x;
                    rectangle.y -= this.depth3dPoint.y;
                }
                chart.calculateChartData(rectangle2, rectangle);
            }
            ++n;
        }
        if (bl && this.offscreen == null) {
            this.offscreen = this.createImage(Math.max(1, dimension.width), Math.max(1, dimension.height));
            this.needRender = true;
        }
        if (!bl || this.needRender || this.offscreen == null) {
            if (!this.externalGraphicsOn && !bl) {
                this.og = graphics;
            } else if (bl || this.externalGraphicsOn) {
                if (!this.externalGraphicsOn && this.offscreen != null) {
                    this.og = this.offscreen.getGraphics();
                }
                this.og.setColor(this.getBackground());
                this.og.fillRect(0, 0, dimension.width, dimension.height);
            }
            this.paintGrid(this.og, rectangle3);
            this.paintBelowSampleLabels(this.og, rectangle3, rectangle4);
            this.paintTitle(this.og, dimension);
            if (this.isLegendOn()) {
                this.paintLegend(this.og, rectangle3, this.getLegendLabels());
            }
            this.renderData(this.og, rectangle3, rectangle4);
            n = 0;
            while (n < this.overlayCharts.size()) {
                chart = (Chart)this.overlayCharts.elementAt(n);
                if (chart != null && this.isOverlayChartOn(n)) {
                    rectangle2 = new Rectangle(rectangle3);
                    rectangle = new Rectangle(rectangle4);
                    rectangle2.x -= this.depth3dPoint.x;
                    rectangle2.y -= this.depth3dPoint.y;
                    rectangle.x -= this.depth3dPoint.x;
                    rectangle.y -= this.depth3dPoint.y;
                    if (chart instanceof LineChart || chart instanceof PieChart) {
                        chart.renderData(this.og, rectangle2, rectangle);
                    } else {
                        chart.renderData(this.og, rectangle3, rectangle4);
                    }
                }
                ++n;
            }
            if (this.is3DModeOn()) {
                n = this.rangeOn.length - 1;
                while (n >= 0) {
                    this.paint3DZeroDivider(this.og, rectangle3, n);
                    --n;
                }
            }
            if (!this.externalGraphicsOn && this.og != graphics) {
                this.og.dispose();
            }
            this.needRender = false;
        }
        if ((bl || this.externalGraphicsOn) && this.offscreen != null) {
            graphics.drawImage(this.offscreen, 0, 0, this);
        }
        this.paintFloatingLabels(graphics, rectangle3);
    }

    private void paintLines(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        int n = this.getSeriesCount();
        if (n > 0) {
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3 = this.getSeriesRange(n2);
                if (this.currentUpperRange[n3] != this.currentLowerRange[n3]) {
                    this.paintLine(graphics, n2, rectangle, rectangle2, this.getSampleColor(n2), this.isSelected(n2, -1));
                }
                --n2;
            }
            if (!this.is3DModeOn() && this.lastSelectedLine >= 0) {
                n2 = this.lastSelectedLine;
                this.paintLine(graphics, n2, rectangle, rectangle2, this.getSampleColor(n2), this.isSelected(n2, -1));
            }
            if (this.isValueLabelsOn(-1) || this.sampleLabelsOn || this.seriesLabelsOn) {
                this.paintStaticLabels(graphics, rectangle, rectangle2);
            }
        }
    }

    public int getValuePosition(double d) {
        return this.getValuePosition(0, d, this.getGraphBounds());
    }

    public void setSeriesLabelsOn(boolean bl) {
        if (this.seriesLabelsOn != bl) {
            this.seriesLabelsOn = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public void setSampleHighlightOn(boolean bl) {
        int n = 0;
        while (n < this.sampleHighlightOn.length) {
            this.sampleHighlightOn_all[n] = bl;
            int n2 = 0;
            while (n2 < this.sampleHighlightOn[n].length) {
                this.sampleHighlightOn[n][n2] = bl;
                ++n2;
            }
            ++n;
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, boolean bl) {
        try {
            this.sampleHighlightOn_all[n] = bl;
            int n2 = 0;
            while (n2 < this.sampleHighlightOn[n].length) {
                this.sampleHighlightOn[n][n2] = bl;
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, int n2, boolean bl) {
        try {
            this.sampleHighlightOn[n][n2] = bl;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series or index: " + n + ", " + n2);
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public int getSampleHighlightSize(int n) {
        try {
            return this.sampleHighlightSize[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    protected void checkDataIntegrity() {
        int n;
        super.checkDataIntegrity();
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        int n4 = this.sampleHighlightOn != null ? this.sampleHighlightOn.length : 1;
        int n5 = n = n4 > 0 && this.sampleHighlightOn != null ? this.sampleHighlightOn[0].length : 0;
        if (n2 != n4 || n3 != n) {
            boolean[][] blArray = new boolean[n2][n3];
            boolean[] blArray2 = new boolean[n2];
            int n6 = 0;
            while (n6 < n2) {
                if (n6 < n4 && this.sampleHighlightOn_all != null) {
                    blArray2[n6] = this.sampleHighlightOn_all[n6];
                    int n7 = 0;
                    while (n7 < n3) {
                        blArray[n6][n7] = n7 < n ? this.sampleHighlightOn[n6][n7] : this.sampleHighlightOn_all[n6];
                        ++n7;
                    }
                }
                ++n6;
            }
            this.sampleHighlightOn = blArray;
            this.sampleHighlightOn_all = blArray2;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            boolean[] blArray3 = new boolean[n2];
            boolean[] blArray4 = new boolean[n2];
            int[] nArray3 = new int[n2];
            int n8 = 0;
            while (n8 < n2) {
                if (n8 < n4 && this.sampleHighlightStyle != null && this.sampleHighlightSize != null && this.seriesLinesOn != null && this.connectedLinesOn != null && this.lineWidth != null) {
                    nArray[n8] = this.sampleHighlightStyle[n8];
                    nArray2[n8] = this.sampleHighlightSize[n8];
                    blArray3[n8] = this.seriesLinesOn[n8];
                    blArray4[n8] = this.connectedLinesOn[n8];
                    nArray3[n8] = this.lineWidth[n8];
                } else {
                    nArray2[n8] = 6;
                    blArray3[n8] = true;
                    nArray3[n8] = 2;
                }
                ++n8;
            }
            this.sampleHighlightStyle = nArray;
            this.sampleHighlightSize = nArray2;
            this.seriesLinesOn = blArray3;
            this.connectedLinesOn = blArray4;
            this.lineWidth = nArray3;
        }
        if (this.lastSelectedLine >= n2) {
            this.lastSelectedLine = -1;
        }
    }

    public Rectangle getGraphBounds() {
        Insets insets;
        String string;
        Object object;
        Object object2;
        if (!this.needGraphBounds && this.currentBounds != null) {
            return this.currentBounds;
        }
        Rectangle rectangle = super.getGraphBounds(this.getLegendLabels());
        Dimension dimension = this.getSize();
        int n = rectangle.x;
        int n2 = dimension.width - rectangle.width - rectangle.x;
        int n3 = rectangle.y;
        int n4 = dimension.height - rectangle.height - rectangle.y;
        int n5 = 0;
        while (n5 < this.rangeAdjusterOn.length) {
            if (this.rangeAdjusterOn[n5]) {
                if (this.rangeAdjusterPosition[n5] == 0) {
                    n += 6;
                } else {
                    n2 += 6;
                }
            }
            ++n5;
        }
        if (this.sampleLabelsOn && this.getSampleCount() > 0 && (this.sampleLabelStyle == 2 || this.sampleLabelStyle == 4)) {
            Dimension dimension2;
            Font font = this.getFont("sampleLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n6 = 0;
            int n7 = this.getLabelAngle("sampleLabelAngle");
            object2 = this.getSampleLabels();
            int n8 = 0;
            while (n8 < ((String[])object2).length) {
                Dimension dimension3 = this.getLabelSize(object2[n8], fontMetrics);
                dimension2 = this.getAngledLabelSize(dimension3, n7);
                n6 = Math.max(dimension2.height, n6);
                ++n8;
            }
            n4 += n6 + 6;
            if (n7 % 180 == 0) {
                n4 -= fontMetrics.getMaxDescent();
            }
            String string2 = this.getSampleLabel(this.getSampleCount() - 1);
            int n9 = 0;
            if (string2 != null) {
                dimension2 = this.getLabelSize(string2, fontMetrics);
                object = this.getAngledLabelSize(dimension2, n7);
                n9 = ((Dimension)object).width / 2 - 5;
            }
            int n10 = 0;
            if (this.isLegendOn() && this.getLegendPosition() == 1) {
                n10 = this.legend.width;
            }
            if (n9 > n10) {
                n2 += n9 - n10;
            }
        }
        boolean bl = false;
        int n11 = 0;
        while (n11 < this.rangeOn.length) {
            bl = this.rangeOn[n11] ? true : bl;
            ++n11;
        }
        if (bl || this.targetsLabel.size() > 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont("rangeLabelFont"));
            String string3 = this.getLabel("rangeLabelPrefix");
            String string4 = this.getLabel("rangeLabelPostfix");
            int n12 = 0;
            int n13 = 0;
            Enumeration enumeration = this.targetsLabel.keys();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                object = this.getTargetLabel(string5);
                if (object == null || ((String)object).length() <= 0) continue;
                if (this.rangePosition[0] == 0) {
                    n12 = Math.max(n12, fontMetrics.stringWidth((String)object));
                    continue;
                }
                n13 = Math.max(n13, fontMetrics.stringWidth((String)object));
            }
            if (this.rangeLabelsOn[0] && this.rangeOn[0]) {
                int n14 = this.getRangeDecimalCount(0);
                String string6 = this.formatNumber(this.upperRange[0], n14);
                object = this.formatNumber(this.lowerRange[0], n14);
                string6 = string3 != null ? string3 + string6 : string6;
                object = string3 != null ? string3 + (String)object : object;
                string6 = string4 != null ? string6 + string4 : string6;
                Object object3 = object = string4 != null ? (String)object + string4 : object;
                if (this.rangePosition[0] == 0) {
                    n12 = Math.max(n12, fontMetrics.stringWidth(string6));
                    n12 = Math.max(n12, fontMetrics.stringWidth((String)object));
                } else {
                    n13 = Math.max(n13, fontMetrics.stringWidth(string6));
                    n13 = Math.max(n13, fontMetrics.stringWidth((String)object));
                }
            }
            if (this.rangeLabelsOn[1] && this.rangeOn[1]) {
                int n15 = this.getRangeDecimalCount(1);
                String string7 = this.formatNumber(this.upperRange[1], n15);
                object = this.formatNumber(this.lowerRange[1], n15);
                if (this.rangePosition[1] == 0) {
                    n12 = Math.max(n12, fontMetrics.stringWidth(string7));
                    n12 = Math.max(n12, fontMetrics.stringWidth((String)object));
                } else {
                    n13 = Math.max(n13, fontMetrics.stringWidth(string7));
                    n13 = Math.max(n13, fontMetrics.stringWidth((String)object));
                }
            }
            n += n12 + 2;
            n2 += n13 > 0 ? n13 + 2 : 0;
        }
        if ((string = this.getLabel("sampleAxisLabel")) != null) {
            Font font = this.getFont("sampleAxisLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n16 = this.getLabelAngle("sampleAxisLabelAngle");
            Dimension dimension4 = this.getLabelSize(string, fontMetrics);
            Dimension dimension5 = this.getAngledLabelSize(dimension4, n16);
            n4 += dimension5.height + 3;
            if (n16 % 180 == 0) {
                n4 -= fontMetrics.getDescent();
            }
        }
        int n17 = 0;
        do {
            String string8;
            String string9 = string8 = n17 == 0 ? this.getLabel("rangeAxisLabel") : this.getLabel("rangeAxisLabel_2");
            if (string8 == null) continue;
            object2 = this.getFont("rangeAxisLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics((Font)object2);
            int n18 = n17 == 0 ? this.getLabelAngle("rangeAxisLabelAngle") : this.getLabelAngle("rangeAxisLabelAngle_2");
            Dimension dimension6 = this.getLabelSize(string8, fontMetrics);
            object = this.getAngledLabelSize(dimension6, n18);
            if (this.rangePosition[n17] == 0) {
                n += ((Dimension)object).width + 20;
                continue;
            }
            n2 += ((Dimension)object).width + 20;
        } while (++n17 < 2);
        if (this.is3DModeOn()) {
            if (this.depth3d > -1) {
                n += this.depth3dPoint.x;
                n4 -= this.depth3dPoint.y;
            } else {
                n17 = Math.max(20, this.getSampleCount());
                int n19 = this.getSeriesCount();
                if (n19 > 1 && !this.stackedOn) {
                    n17 /= n19;
                    n17 = Math.max(n17, 4);
                }
                int n20 = (int)((float)rectangle.width * 1.25f / ((float)n17 + 1.25f));
                rectangle.width = dimension.width - (n += n20) - n2;
                double d = rectangle.width / n17;
                n4 += (int)Math.round(d / 1.25);
            }
        }
        if ((insets = this.getGraphInsets()) != null) {
            n3 = insets.top == -1 ? n3 : insets.top;
            n = insets.left == -1 ? n : insets.left;
            n4 = insets.bottom == -1 ? n4 : insets.bottom;
            n2 = insets.right == -1 ? n2 : insets.right;
        }
        rectangle.x = n;
        rectangle.width = dimension.width - n - n2 - 1;
        rectangle.y = n3;
        rectangle.height = dimension.height - n3 - n4 - 1;
        this.needGraphBounds = false;
        this.currentBounds = rectangle;
        return rectangle;
    }

    private void paint3DLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl, boolean bl2) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n6 = this.stackedOn ? 1 : Math.max(1, this.getSeriesCount());
        int n7 = (int)Math.round((double)this.depth3dPoint.x / (double)n6);
        int n8 = (int)Math.round((double)this.depth3dPoint.y / (double)n6);
        nArray[0] = n;
        nArray2[0] = n2;
        nArray[1] = n + n7;
        nArray2[1] = n2 + n8;
        nArray[2] = nArray[1] + (n3 - n);
        nArray2[2] = n4 + n8;
        nArray[3] = n3;
        nArray2[3] = n4;
        Color color2 = color.darker();
        if (bl) {
            double d = 0.0;
            if (nArray[1] - nArray[0] != 0) {
                d = (double)(n2 - n4) / (double)(n3 - n);
            }
            if (d > 0.69) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color);
            }
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(color2);
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
            graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
        }
        if (bl2) {
            nArray[0] = nArray[3];
            nArray2[0] = nArray2[3];
            nArray[1] = nArray[2];
            nArray2[1] = nArray2[2];
            nArray[2] = nArray[2];
            nArray2[2] = n5 + n8;
            nArray[3] = nArray[0];
            nArray2[3] = n5;
            graphics.setColor(color);
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(color2);
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
            graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
            graphics.drawLine(nArray[3], nArray2[3], nArray[0], nArray2[0]);
        }
    }

    private void paint3DZeroDivider(Graphics graphics, Rectangle rectangle, int n) {
        if (this.rangeOn[n = Math.min(this.rangeOn.length - 1, Math.max(0, n))]) {
            int n2 = Math.max(this.zeroLine[n], rectangle.y);
            n2 = Math.min(n2, rectangle.y + rectangle.height);
            int n3 = rectangle.x - this.depth3dPoint.x;
            int n4 = n2 - this.depth3dPoint.y;
            graphics.setColor(n == 0 ? this.getChartForeground() : this.getRangeColor(n));
            graphics.drawLine(n3, n4, n3 + rectangle.width, n4);
            graphics.drawLine(n3 + rectangle.width, n4, rectangle.x + rectangle.width, n2);
        }
    }

    private void paintFloatingLabel(Graphics graphics, Rectangle rectangle, int n, int n2, String string, Font font, FontMetrics fontMetrics) {
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount() || fontMetrics == null) {
            return;
        }
        int n3 = 0;
        if (this.is3DModeOn()) {
            if (this.stackedOn) {
                n3 = -this.depth3d;
            } else {
                double d = (double)this.depth3dPoint.x / (double)this.getSeriesCount();
                n3 = (int)Math.round(d * (double)n) - this.depth3dPoint.x;
            }
        }
        int n4 = this.samplePoints[n][n2][0];
        int n5 = this.samplePoints[n][n2][1];
        if (n4 < rectangle.x || n4 > rectangle.x + rectangle.width - n3) {
            return;
        }
        if (n5 < rectangle.y || n5 > (this.is3DModeOn() ? rectangle.y + rectangle.height - this.depth3dPoint.y : rectangle.y + rectangle.height)) {
            return;
        }
        Dimension dimension = this.getLabelSize(string, fontMetrics);
        int n6 = n4 - dimension.width / 2 + n3;
        int n7 = n5 - dimension.height + fontMetrics.getAscent() - 3;
        Dimension dimension2 = this.getSize();
        n6 = Math.max(n6, 3);
        n6 = Math.min(n6, dimension2.width - dimension.width - 3);
        n7 = Math.max(n7, fontMetrics.getAscent());
        n7 = Math.min(n7, dimension2.height - dimension.height + fontMetrics.getAscent() - 1);
        int n8 = fontMetrics.getHeight();
        int n9 = fontMetrics.getDescent();
        graphics.setColor(new Color(255, 255, 231));
        graphics.fillRect(n6 - 2, n7 - n8 + n9 * 2 - 2, dimension.width + 5, dimension.height);
        graphics.setColor(this.getChartForeground());
        graphics.setColor(this.getSampleColor(n).darker());
        graphics.drawRect(n6 - 3, n7 - n8 + n9 * 2 - 3, dimension.width + 5, dimension.height + 1);
        graphics.setColor(Color.black);
        this.paintLabel(graphics, string, n6, n7, dimension, 0, 0);
    }

    public int getSeriesLabelStyle() {
        return this.seriesLabelStyle;
    }
}

