/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChartApplet;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartApplet;
import com.objectplanet.chart.LineChartApplet;
import com.objectplanet.chart.PieChartApplet;
import com.objectplanet.chart.jpeg.JpegEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ChartServlet
extends GenericServlet {
    protected Hashtable chartApplets;

    public void init(ServletConfig servletConfig) {
        try {
            super.init(servletConfig);
        }
        catch (ServletException servletException) {
            // empty catch block
        }
        this.chartApplets = new Hashtable();
        this.chartApplets.put("bar", new BarChartApplet());
        this.chartApplets.put("com.objectplanet.chart.BarChartApplet".toLowerCase(), this.chartApplets.get("bar"));
        this.chartApplets.put("line", new LineChartApplet());
        this.chartApplets.put("com.objectplanet.chart.LineChartApplet".toLowerCase(), this.chartApplets.get("line"));
        this.chartApplets.put("pie", new PieChartApplet());
        this.chartApplets.put("com.objectplanet.chart.PieChartApplet".toLowerCase(), this.chartApplets.get("pie"));
    }

    public synchronized void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = servletRequest.getParameter("data");
        string = this.a(string, servletRequest.getParameter("dataParamSeparator"), servletRequest.getParameter("dataEqualsSign"));
        String string2 = null;
        if (string != null && string.trim().length() > 0) {
            try {
                this.a(string, hashtable);
            }
            catch (MalformedURLException malformedURLException) {
                string2 = "INVALID URL:\n" + string;
                string2 = string2 + "\n" + malformedURLException.toString();
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                string2 = "ERROR:\nCould not read data from\n" + string;
                string2 = string2 + "\n" + iOException.toString();
            }
            catch (SecurityException securityException) {
                System.out.println(securityException.getMessage());
                string2 = "SECURITY ERROR:\nCould not read data from\n" + string;
                string2 = string2 + "\n" + securityException.toString();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                string2 = exception.toString();
            }
        }
        if (servletRequest.getParameter("chart") != null) {
            hashtable.put("chart", servletRequest.getParameter("chart").trim());
        }
        ChartApplet chartApplet = this.a((String)hashtable.get("chart"));
        chartApplet.theChart.setSize(300, 200);
        chartApplet.reset();
        Enumeration enumeration = servletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            object = servletRequest.getParameter(string3);
            if (object == null) continue;
            hashtable.put(string3.toLowerCase(), (String)object);
        }
        hashtable.remove("data");
        hashtable.remove("chart");
        hashtable.remove("dataparamseparator");
        boolean bl = false;
        if (hashtable.containsKey("antialias")) {
            bl = ((String)hashtable.get("antialias")).trim().equalsIgnoreCase("true");
            hashtable.remove("antialias");
        }
        chartApplet.setParameters(hashtable);
        object = chartApplet.theChart.getSize();
        Image image = this.a(chartApplet.theChart, ((Dimension)object).width, ((Dimension)object).height, bl);
        if (string2 != null) {
            Graphics graphics = image.getGraphics();
            graphics.setColor(chartApplet.getForeground());
            graphics.setFont(chartApplet.getFont());
            this.a(graphics, string2, 5, graphics.getFontMetrics().getHeight());
        }
        this.encodeChartImage(image, (OutputStream)servletResponse.getOutputStream(), servletResponse);
        image.flush();
    }

    protected void encodeChartImage(Image image, OutputStream outputStream, ServletResponse servletResponse) throws IOException {
        if (image != null && outputStream != null) {
            if (servletResponse != null) {
                servletResponse.setContentType("image/jpeg");
            }
            JpegEncoder jpegEncoder = new JpegEncoder(image, 75, outputStream);
            jpegEncoder.Compress();
            outputStream.flush();
        }
    }

    private ChartApplet a(String string) {
        ChartApplet chartApplet = (ChartApplet)this.chartApplets.get("bar");
        if (string != null && this.chartApplets.get(string.trim().toLowerCase()) != null) {
            chartApplet = (ChartApplet)this.chartApplets.get(string.trim().toLowerCase());
        } else if (string != null) {
            try {
                string = string.trim();
                Class<?> clazz = Class.forName(string);
                if (clazz != null) {
                    Object obj = clazz.newInstance();
                    if (obj instanceof ChartApplet) {
                        chartApplet = (ChartApplet)obj;
                    } else {
                        System.out.println("ERROR: " + string + " is not a subclass of com.objectplanet.chart.ChartApplet");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("chart class found: " + string);
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Could not instantiate " + string);
                System.out.println(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Could not instantiate " + string);
                System.out.println(illegalAccessException.getMessage());
            }
            catch (Throwable throwable) {
                System.out.println("Could not create chart applet, we keep running anyway");
                System.out.println(throwable.getMessage());
            }
        }
        return chartApplet;
    }

    private Image a(Chart chart, int n, int n2, boolean bl) {
        n = Math.max(1, n);
        n2 = Math.max(1, n2);
        Image image = null;
        if (chart != null) {
            chart.setSize(n, n2);
            image = chart.createImage(n, n2);
            if (image != null) {
                if (bl) {
                    Graphics2D graphics2D = (Graphics2D)image.getGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    chart.setExternalGraphics(graphics2D, image);
                    if (graphics2D != null) {
                        chart.paint(graphics2D);
                    }
                } else {
                    Graphics graphics = image.getGraphics();
                    if (graphics != null) {
                        chart.paint(graphics);
                    }
                }
            }
        }
        return image;
    }

    private String a(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() != 1) {
            string2 = "\u00a4";
        }
        if (string3 == null || string3.length() != 1) {
            string3 = "*";
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] == string2.charAt(0)) {
                stringBuffer.append('&');
            } else if (cArray[n2] == string3.charAt(0)) {
                stringBuffer.append('=');
            } else {
                stringBuffer.append(cArray[n2]);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void a(String string, Hashtable hashtable) throws Exception {
        if (string == null || string.trim().length() == 0 || hashtable == null) {
            return;
        }
        URL uRL = new URL(string);
        if (uRL != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf("=");
                if (n <= 0) continue;
                String string3 = string2.substring(0, n).trim().toLowerCase();
                String string4 = string2.substring(n + 1).trim();
                hashtable.put(string3, string4);
            }
            bufferedReader.close();
        }
    }

    private void a(Graphics graphics, String string, int n, int n2) {
        if (string != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (string2 != null && string2.length() > 0) {
                    Color color = graphics.getColor();
                    graphics.setColor(Color.white);
                    graphics.fillRect(n, n2 - (fontMetrics.getMaxAscent() - 1), fontMetrics.stringWidth(string2), fontMetrics.getMaxAscent() + 1);
                    graphics.setColor(color);
                    graphics.drawString(string2, n, n2);
                }
                n2 += fontMetrics.getMaxAscent() + 1;
            }
        }
    }
}

