/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/


#ifndef PRODUCT_CATEGORY
#define PRODUCT_CATEGORY "CrossSprings"
#endif

#ifndef PRODUCT_NAME
#define PRODUCT_NAME	 "CoreModule"
#endif

#ifndef PRODUCT_EDITION
#define PRODUCT_EDITION	 "Professional"
#endif

#ifndef PRODUCT_VERSION_MAJOR
#define PRODUCT_VERSION_MAJOR	0
#endif

#ifndef PRODUCT_VERSION_MINOR
#define PRODUCT_VERSION_MINOR	1
#endif

#ifndef PRODUCT_BUILD
#define PRODUCT_BUILD	 1
#endif

#define XSP_MKSTR(N) #N

#define PRODUCT_VERSION_FULL	XSP_MKSTR(PRODUCT_VERSION_MAJOR) "." XSP_MKSTR(PRODUCT_VERSION_MINOR)

#ifndef PRODUCT_NAME_FULL
#define PRODUCT_NAME_FULL PRODUCT_CATEGORY "-" PRODUCT_NAME " v" PRODUCT_VERSION_FULL " (" PRODUCT_EDITION " edition, build " XSP_MKSTR(PRODUCT_BUILD) ")"
#endif


namespace XSP
{

   class VersionInfo
   {
   protected:
   		String productCategory;
   		String productName;
   		String editionName;
   		String fullVersion;
   		String fullName;
   		uint32 majorVersion;
   		uint32 minorVersion;
   		uint32 buildNumber;

   	public:
   		const String& ProductCategory() const   // Win32 (NT) OS
   		{return productCategory; }
   		
   		const String& ProductName() const	  	// XP
   		{ return productName; }
   		
   		const String& EditionName() const	  	// Workstation
   		{ return editionName; }
   		
   		const String& FullVersion() const	  	// 5.1
   		{ return fullVersion; }
   		
   		uint32		  MajorVersion() const		// 5
   		{ return majorVersion; }
   		
   		uint32		  MinorVersion() const		// 1
   		{ return minorVersion; }
   		
   		uint32		  BuildNmber() const		// 1906
   		{ return buildNumber; }
   		
   		const String& FullName() const			// WinXP-Workstation (NT_5.1 build_1906)
   		{ return fullName; }
   };
      
   class RuntimeVersion : public VersionInfo
   {
   public:
   		RuntimeVersion();
   };

} // namespace XSP
