/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

namespace XSP
{

#if TARGET_API_MAC_OS8

RuntimeVersion::RuntimeVersion()
{
    productCategory = String::From_c_str("MAC");
	long value;
	if (::Gestalt(gestaltSystemVersion, &value) == noErr)
	{
		majorVersion = static_cast<uint32>(value>>8);
		majorVersion = (majorVersion>>4)*10 + (majorVersion&0x0F);
		minorVersion = static_cast<uint32>((value>>4) & 0x0F);
		buildNumber  = static_cast<uint32>(value & 0x0F);

	    fullVersion	 = String::From_uint32(majorVersion) 
	    			 + String::From_c_str(".")
	    			 + String::From_uint32(minorVersion);
		
		switch (majorVersion)
		{
		case 10:
		    switch (minorVersion)
		    {
		    case 2:	 productName = String::From_c_str("OSX-Jaguar"); break;
		    default: productName = String::From_c_str("OSX"); break;
		    }
		    break;
		default:
		    productName = String::From_c_str("OS");
		    break;
		}
	}
	if (::Gestalt(gestaltSysArchitecture, &value) == noErr)
	{
		switch(value)
		{
		case gestalt68k:
			editionName = String::From_c_str("68K");
			break;
		case gestaltPowerPC:
			editionName = String::From_c_str("PowerPC");
			break;
		};
	}
	if (::Gestalt(gestaltROMVersion, &value) == noErr)
	{
	    editionName.append(String::From_c_str("-ROMv"));
	    editionName.append(String::From_sint32(value,16U));
	}
/*
    gestaltSystemUpdateVersion
    gestaltCarbonVersion
    gestaltIntel
    gestaltNativeCPUtype
    gestaltNativeCPUfamily
    gestaltROMVersion // on OS9 and lower (no Carbon)
*/
	String sspace = String::From_c_str(" ");
	fullName = productCategory + String::From_c_str(" ") 
			 + productName 
			 + String::From_c_str(" version ") + fullVersion 
			 + String::From_c_str(" (") + editionName 
			 + String::From_c_str(" edition, build ")
			 + String::From_uint32( buildNumber )
			 + String::From_c_str(")");
}

#endif


} // namespace XSP
