/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

namespace XSP
{

#if TARGET_API_Win32 || TARGET_API_Win32_Console


struct _OSVERSIONINFOEX_full 
{
    DWORD dwOSVersionInfoSize;
    DWORD dwMajorVersion;
    DWORD dwMinorVersion;
    DWORD dwBuildNumber;
    DWORD dwPlatformId;
    CHAR   szCSDVersion[ 128 ];     // Maintenance string for PSS usage
    WORD   wServicePackMajor;
    WORD   wServicePackMinor;
    WORD   wSuiteMask;
    BYTE  wProductType;
    BYTE  wReserved;
};

RuntimeVersion::RuntimeVersion()
{
	_OSVERSIONINFOEX_full ver;
	std::char_traits<char>::assign((char*)&ver, sizeof(ver), 0);
	bool exinfo = true;
	ver.dwOSVersionInfoSize = sizeof(ver);
	if (0 == ::GetVersionEx((OSVERSIONINFO*)&ver))
	{
		exinfo = false;
		ver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		if (0 == ::GetVersionEx((OSVERSIONINFO*)&ver))
		{
			Exception(XSPMSG(7, "Cannot retrieve OS version from the operating system"))
				.Raise();
		}
	}

	majorVersion = ver.dwMajorVersion;
	minorVersion = ver.dwMinorVersion;
    buildNumber  = ver.dwBuildNumber;
    fullVersion	 = String::From_uint32(majorVersion) 
    			 + String::From_c_str(".")
    			 + String::From_uint32(minorVersion);
    
    switch (ver.dwPlatformId)
    {
	case VER_PLATFORM_WIN32_NT:
		productCategory = String::From_c_str("Microsoft Windows NT");
		switch (majorVersion *100 + minorVersion)
		{
			case 500:   productName = String::From_c_str("Win2000"); break;
			case 501:   productName = String::From_c_str("WinXP"); break;
			case 502:   productName = String::From_c_str("WinServer2003"); break;
			default:	productName = String::From_c_str("Win32-NT"); break;
		};
		if (exinfo)
		{
	        if ( ver.wProductType == 1 ) //VER_NT_WORKSTATION )
	        {
	           if( majorVersion == 4 )
	           		editionName = String::From_c_str("Workstation");
	           #ifndef VER_SUITE_PERSONAL
	           #define VER_SUITE_PERSONAL 0x0200
	           #endif
	           else if( ver.wSuiteMask & VER_SUITE_PERSONAL )
	           		editionName = String::From_c_str("Home");
	           else
	           		editionName = String::From_c_str("Professional");
	        }
	        else if ( ver.wProductType == 3) //VER_NT_SERVER )
	        {
				if( ver.wSuiteMask & 0x80) //VER_SUITE_DATACENTER )
					editionName = String::From_c_str("Datacenter Server");
				else if( ver.wSuiteMask & 0x02) //VER_SUITE_ENTERPRISE )
				{
					if( majorVersion == 5 && minorVersion == 0 )
	           			editionName = String::From_c_str("Advanced Server");
					else
						editionName = String::From_c_str("Enterprise Server");
				}
	           #ifndef VER_SUITE_BLADE
	           #define VER_SUITE_BLADE 0x0400
	           #endif
				else if ( ver.wSuiteMask == VER_SUITE_BLADE )
					editionName = String::From_c_str("Web Server");
				else
					editionName = String::From_c_str("Standard Server");
			}
		}
		else  // no extended version info, must get stuff from registry
		{
	        HKEY hKey;
	        char szProductType[256];
	        DWORD dwBufLen=sizeof(szProductType);
	        LONG lRet = ::RegOpenKeyEx( HKEY_LOCAL_MACHINE,
	           					"SYSTEM\\CurrentControlSet\\Control\\ProductOptions",
	           					0, KEY_QUERY_VALUE, &hKey );
	        if( lRet == ERROR_SUCCESS )
			{
		        lRet = ::RegQueryValueEx( hKey, "ProductType", NULL, NULL,
		           						 (LPBYTE) szProductType, &dwBufLen);
		        ::RegCloseKey( hKey );
		        if( (lRet == ERROR_SUCCESS) && (dwBufLen <= sizeof(szProductType)) )
		        	switch (szProductType[0])
		        	{
		        		case 'w': case 'W': editionName = String::From_c_str("Workstation"); break;
		        		case 'l': case 'L': editionName = String::From_c_str("Server"); break;
		        		case 's': case 'S': editionName = String::From_c_str("Advanced Server"); break;
					}
			}
		}
		break;
    case VER_PLATFORM_WIN32_WINDOWS:
		productCategory = String::From_c_str("Microsoft Windows Win32");
		switch (majorVersion *100 + minorVersion)
		{
			case 400:   
		         if ( ver.szCSDVersion[1] == 'C' || ver.szCSDVersion[1] == 'B' )
					productName = String::From_c_str("Win95 OSR2"); 
				 else
					productName = String::From_c_str("Win95"); 
				 break;
			case 410:
		         if ( ver.szCSDVersion[1] == 'A' )
					productName = String::From_c_str("Win98 SE"); 
				 else
					productName = String::From_c_str("Win98"); 
				 break;
			case 490:   productName = String::From_c_str("WinME"); break;
			default:	productName = String::From_c_str("Win9x"); break;
		};
    	break;
    case VER_PLATFORM_WIN32s:
		productCategory = String::From_c_str("Microsoft Windows");
		productName = String::From_c_str("Win32s");
    	break;
    };
	editionName.append( String::From_c_str(ver.szCSDVersion) );
	
	String sspace = String::From_c_str(" ");
	fullName = productCategory + String::From_c_str(" ") 
			 + productName 
			 + String::From_c_str(" version ") + fullVersion 
			 + String::From_c_str(" (") + editionName 
			 + String::From_c_str(" edition, build ")
			 + String::From_uint32( buildNumber )
			 + String::From_c_str(")");
}

#endif


} // namespace XSP
