
CFLAGS=-O2 -Wno-deprecated
LFLAGS=

all:  XSP_Core.lib

clean:
	rm *.o *.lib

INCDIR=-I ../Includes -I ../../../Libs/regexpp2/include

HEADER=-include ../../Targets/Includes/TargetAPI_Win32.h

ALL_HEADER= ../../Targets/Includes/stl.h \
	../../Targets/Includes/TargetAPI_Win32.h \
	../../Targets/Includes/TargetAPI_Win32_Debug.h \
	../Includes/XSP_Core.h \
	../Includes/XSP_CoreModule.h \
	../Includes/XSP_ErrorManagement.h \
	../Includes/XSP_EventLoop.h \
	../Includes/XSP_MemoryMgr.h \
	../Includes/XSP_Ref.h \
	../Includes/XSP_StringMessage.h \
	../Includes/XSP_TimeMgr.h \
	../Includes/XSP_UnitTest.h \
	../Includes/XSP_Version.h

ALL_OBJ= CoreModule.o \
	ErrorManagement.o \
	ErrorsToConsole.o \
	EventLoop.o \
	MainEntryPoint.o \
	MemoryMgr.o \
	Ref.o \
	RunTestChain.o \
	StringMessage.o \
	StringRegExp.o \
	TimeMgr.o \
	TimeMgr_Carbon.o \
	TimeMgr_Darwin.o \
	TimeMgr_Linux.o \
	TimeMgr_Win32.o \
	UnitTest.o \
	Version.o \
	Version_Darwin.o \
	Version_Linux.o \
	Version_MacCarbon.o \
	Version_MacOS8.o \
	Version_Win32.o 

CoreModule.o: ../Sources/CoreModule.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

ErrorManagement.o: ../Sources/ErrorManagement.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

ErrorsToConsole.o: ../Sources/ErrorsToConsole.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

EventLoop.o: ../Sources/EventLoop.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

MainEntryPoint.o: ../Sources/MainEntryPoint.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

MemoryMgr.o: ../Sources/MemoryMgr.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

Ref.o: ../Sources/Ref.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

RunTestChain.o: ../Sources/RunTestChain.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

StringMessage.o: ../Sources/StringMessage.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

StringRegExp.o: ../Sources/StringRegExp.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

TimeMgr.o: ../Sources/TimeMgr.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

TimeMgr_Carbon.o: ../Sources/TimeMgr_Carbon.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

TimeMgr_Darwin.o: ../Sources/TimeMgr_Darwin.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

TimeMgr_Linux.o: ../Sources/TimeMgr_Linux.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

TimeMgr_Win32.o: ../Sources/TimeMgr_Win32.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

UnitTest.o: ../Sources/UnitTest.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

Version.o: ../Sources/Version.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

Version_Darwin.o: ../Sources/Version_Darwin.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

Version_Linux.o: ../Sources/Version_Linux.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

Version_MacCarbon.o: ../Sources/Version_MacCarbon.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

Version_MacOS8.o: ../Sources/Version_MacOS8.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

Version_Win32.o: ../Sources/Version_Win32.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

XSP_Core.lib: $(ALL_OBJ)
	ar rc $@ $(ALL_OBJ)
	ranlib $@
