#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"
#include "XSP_Codecs.h"
using namespace XSP;

class MySimpleApp_BAK : public Event_Abstract
{
	static const sint16 kAlertID = 128;
public:
	MySimpleApp_BAK();
	void Run();	
};

MySimpleApp_BAK::MySimpleApp_BAK()
{
	#if TARGET_API_MAC_OS8
		InitGraf(&qd.thePort);
		InitFonts();
		InitWindows();
		InitMenus();
		TEInit();
		InitDialogs(nil);	
		InitCursor();
	#elif TARGET_API_MAC_Carbon  
		InitCursor();			  
	#elif TARGET_API_MAC_Mach0
		InitCursor();
	#elif TARGET_API_Darwin
		// nothing to do
	#elif TARGET_API_Win32 || TARGET_API_Win32_Console
		// nothing to do
	#endif
}

void MySimpleApp_BAK::Run()
{
	#if TARGET_API_MAC_OS8
		NoteAlert(kAlertID, NULL);
	#elif TARGET_API_MAC_Carbon  
		NoteAlert(kAlertID, NULL);
	#elif TARGET_API_MAC_Mach0
		NoteAlert(kAlertID, NULL);
	#elif TARGET_API_Darwin
		// no message box
	#elif TARGET_API_Win32 || TARGET_API_Win32_Console
	{
		MessageBox(NULL, "Message", "Title", MB_OK);
	}
	#endif
}


#if 0
#pragma mark -
#endif

namespace XSP
{
	void MainEntryPoint()
	{
	    CoreModule _coreModule; // initialize the core module
	    _coreModule.mainLoop = new EventLoop();
	    _coreModule.mainLoop->SetErrorSink(new ErrorsToConsole());

	    FileModule _fileModule; // initialize the file module
		
		GUI_Module _gui;
		_gui.codecFactory = new SmartCodecFactory();

		#if DEBUG
		{
			bool& result = UnitTest::TestResult();
			result = true;
			try
			{ 	// add your test functions here
				String::RunUnitTest();
				#ifdef BOOST_RE_REGEX_HPP
					RegExp::RunUnitTest();
				#endif
				LocalTime::RunUnitTest();
				FileName::RunUnitTest();
				WinMgr::RunUnitTest();
			}
			catch(const Exception& err)
			{
				UnitTest::Failed(" exception caught while running the test chain");
			}
			catch(...)
			{
				UnitTest::Failed(" unknown exception caught while running the test chain");
			}
			// we only run the application if the test 
			// chain completes successfully
			if (!result)
				return;
		}		
		#endif

		printf("%s \n", CoreModule::_instance->runtimeVersion.FullName().c_str());
		
		refc<Event_Abstract> myApp(new MySimpleApp());
		_coreModule.mainLoop->PostEvent(myApp);
		// make sure a quit is at the end of the queue
		//_coreModule.mainLoop->PostEvent(_coreModule.mainLoop->CreateQuitEvent());
		_coreModule.mainLoop->Run();
	}
} // namespace XSP

















/*

#if __MACH__
	#include <Carbon/Carbon.h>
#else
	#include <Carbon.h>
#endif

const CFStringRef kMainNibFileName = CFSTR("SimpleHello");

const CFStringRef kMenuBarNibName  = CFSTR("MenuBar");
const CFStringRef kMenuBarClassicNibName = CFSTR("MenuBarClassic");
const CFStringRef kSimpleHelloNibName = CFSTR("MainWindow");

class SimpleHello
{
public:
	SimpleHello();
	~SimpleHello();
	void Run();
	
private:
	bool Initialize();
	bool InstallMenus();
	void DisplaySimpleHelloWindow();
	
	bool mIsSetupGood;
	CFBundleRef mBundle;
	IBNibRef mNibs;
};

SimpleHello::SimpleHello()
{
	mIsSetupGood = Initialize();
	
	if (mIsSetupGood)
		mIsSetupGood = InstallMenus();
}

SimpleHello::~SimpleHello()
{
	if (mNibs != NULL)
		DisposeNibReference(mNibs);
	
	if (mBundle != NULL)
		CFRelease(mBundle);
}

bool SimpleHello::Initialize()
{
	OSErr theErr;
	bool isInitialized;
	
	isInitialized = false;
	mBundle = NULL;
	mNibs = NULL;
	
	mBundle = CFBundleGetMainBundle();
	
	if (mBundle != NULL)
	{
		theErr = CreateNibReferenceWithCFBundle(mBundle, kMainNibFileName, &mNibs);
		
		if ((theErr == noErr) && (mNibs != NULL))
			isInitialized = true;
	}
	
	InitCursor();
	
	return isInitialized;
}

bool SimpleHello::InstallMenus()
{
	OSErr theErr;
	bool isMenuInstalled;
	long theResponse;
	
	isMenuInstalled = false;
	
	theErr = Gestalt(gestaltMenuMgrAttr, &theResponse);
	
	if (theErr == noErr)
	{
		if (theResponse & gestaltMenuMgrAquaLayoutMask)
			theErr = SetMenuBarFromNib(mNibs, kMenuBarNibName);
		else
			theErr = SetMenuBarFromNib(mNibs, kMenuBarClassicNibName);
		
		if (theErr == noErr)
			isMenuInstalled = true;
	}
	
	return isMenuInstalled;
}

void SimpleHello::DisplaySimpleHelloWindow()
{
	OSErr theErr;
	WindowRef theWindow;
	
	theErr = CreateWindowFromNib(mNibs, kSimpleHelloNibName, &theWindow);
	
	if ((theErr == noErr) && (theWindow != NULL))
		ShowWindow(theWindow);
}

void SimpleHello::Run()
{
	if (mIsSetupGood)
	{
		DisplaySimpleHelloWindow();
		
		RunApplicationEventLoop();
	}
}

int main(void)
{
	SimpleHello theApplication;
	
	theApplication.Run();
	
	return 0;
}

*/





