/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr14-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"

namespace XSP
{
#ifdef DEBUG
void FileName::RunUnitTest()
{
	UnitTest::Log("FileName");

	String sfn(String::From_c_str("c:\\temp\\test.tmp"));
	FileName fn(FileName::FromPathNameWin32(sfn));
	String tfn(fn.GetFullPathNameWin32());
	if (sfn != tfn)
		UnitTest::Failed("w32 '%s' != '%s'", sfn.c_str(), tfn.c_str());

	sfn = String::From_c_str("c:temp\\test.tmp");
	fn  = FileName::FromPathNameWin32(sfn);
	tfn = fn.GetFullPathNameWin32();
	if (sfn != tfn)
		UnitTest::Failed("w32 '%s' != '%s'", sfn.c_str(), tfn.c_str());

	sfn = String::From_c_str("\\temp\\test.tmp");
	fn  = FileName::FromPathNameWin32(sfn);
	tfn = fn.GetFullPathNameWin32();
	if (sfn != tfn)
		UnitTest::Failed("w32 '%s' != '%s'", sfn.c_str(), tfn.c_str());

	sfn = String::From_c_str("temp\\test.tmp");
	fn  = FileName::FromPathNameWin32(sfn);
	tfn = fn.GetFullPathNameWin32();
	if (sfn != tfn)
		UnitTest::Failed("w32 '%s' != '%s'", sfn.c_str(), tfn.c_str());

	sfn = String::From_c_str("test.tmp");
	fn  = FileName::FromPathNameWin32(sfn);
	tfn = fn.GetFullPathNameWin32();
	if (sfn != tfn)
		UnitTest::Failed("w32 '%s' != '%s'", sfn.c_str(), tfn.c_str());

	sfn = String::From_c_str("c:\\");
	fn  = FileName::FromPathNameWin32(sfn);
	tfn = fn.GetFullPathNameWin32();
	if (sfn != tfn)
		UnitTest::Failed("w32 '%s' != '%s'", sfn.c_str(), tfn.c_str());

	sfn = String::From_c_str("\\");
	fn  = FileName::FromPathNameWin32(sfn);
	tfn = fn.GetFullPathNameWin32();
	if (sfn != tfn)
		UnitTest::Failed("w32 '%s' != '%s'", sfn.c_str(), tfn.c_str());

	sfn = String::From_c_str("c:");
	fn  = FileName::FromPathNameWin32(sfn);
	tfn = fn.GetFullPathNameWin32();
	if (sfn != tfn)
		UnitTest::Failed("w32 '%s' != '%s'", sfn.c_str(), tfn.c_str());

	sfn = String::From_c_str("/tmp/test.tmp");
	fn  = FileName::FromPathNameLinux(sfn);
	tfn = fn.GetFullPathNameLinux();
	if (sfn != tfn)
		UnitTest::Failed("linux '%s' != '%s'", sfn.c_str(), tfn.c_str());

	sfn = String::From_c_str("volume:temp:test.tmp");
	fn  = FileName::FromPathNameMac(sfn);
	tfn = fn.GetFullPathNameMac();
	if (sfn != tfn)
		UnitTest::Failed("mac '%s' != '%s'", sfn.c_str(), tfn.c_str());
			
	const SpecialFileNames& sfnm = FileModule::_instance->specialFileNames;
    
	UnitTest::Log("SystemDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::SystemDir) 
		? sfnm[SpecialFileNames::SystemDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("MachineRoot = '%s'"
		, sfnm.HasFileName(SpecialFileNames::MachineRoot) 
		? sfnm[SpecialFileNames::MachineRoot].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("UserHomeDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::UserHomeDir) 
		? sfnm[SpecialFileNames::UserHomeDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("TempDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::TempDir) 
		? sfnm[SpecialFileNames::TempDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("ProcessWorkingDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::ProcessWorkingDir) 
		? sfnm[SpecialFileNames::ProcessWorkingDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("AppName = '%s'"
		, sfnm.HasFileName(SpecialFileNames::AppName) 
		? sfnm[SpecialFileNames::AppName].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("AppDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::AppDir) 
		? sfnm[SpecialFileNames::AppDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("UserPreferencesDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::UserPreferencesDir) 
		? sfnm[SpecialFileNames::UserPreferencesDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("UserDesktopDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::UserDesktopDir) 
		? sfnm[SpecialFileNames::UserDesktopDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("MachinePreferencesDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::MachinePreferencesDir) 
		? sfnm[SpecialFileNames::MachinePreferencesDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("RecycleBinDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::RecycleBinDir) 
		? sfnm[SpecialFileNames::RecycleBinDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("StartupDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::StartupDir) 
		? sfnm[SpecialFileNames::StartupDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("ShutdownDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::ShutdownDir) 
		? sfnm[SpecialFileNames::ShutdownDir].GetFullPathNameOS().c_str() 
		: "");
	UnitTest::Log("MenuDir = '%s'"
		, sfnm.HasFileName(SpecialFileNames::MenuDir) 
		? sfnm[SpecialFileNames::MenuDir].GetFullPathNameOS().c_str() 
		: "");
		
    { // dir listing
	    fn  = FileModule::_instance->specialFileNames[SpecialFileNames::MachineRoot];
	    FileList flist(fn);
	    FileList::size_type z = flist.size();
	    if (z == 0)
			UnitTest::Failed("root dir '%s' contains 0 files", fn.GetFullPathNameOS().c_str());
	    
		UnitTest::Log("dir '%s' contains %d items (showing max 3)",
						fn.GetFullPathNameOS().c_str(),
						z );
		if (z > 3)
			z = 3;
		for(FileList::iterator b=flist.begin(); z>0; --z,++b)
		{
			const FileProperties& fp = *b;
			UnitTest::Log("\t>'%s' size=%s modified='%s'", 
							fp.GetFileName().GetName().c_str(),
							fp[FileProperties::Size].c_str(),
							fp[FileProperties::ModifyTime].c_str());
		}	
	}
	
	{  // exist create delete
	    fn = FileModule::_instance->specialFileNames[SpecialFileNames::TempDir];
	    fn = FileName::From(fn, String::From_c_str("__test__.txt"));
	    if (fn.Exists())
			UnitTest::Log("file '%s' already exists", fn.GetFullPathNameOS().c_str());
		fn.Delete();
	    if (fn.Exists())
			UnitTest::Failed("dir delete '%s'", fn.GetFullPathNameOS().c_str());
		fn.CreateDir(true);
	    if (!fn.Exists())
			UnitTest::Failed("dir creation '%s'", fn.GetFullPathNameOS().c_str());
	    if (!fn.IsDir())
			UnitTest::Failed("IsDir '%s'", fn.GetFullPathNameOS().c_str());
		{
			FileProperties fp(fn);
			UnitTest::Log("Created dir=>'%s' size=%s modified='%s'", 
						fp.GetFileName().GetName().c_str(),
						fp[FileProperties::Size].c_str(),
						fp[FileProperties::ModifyTime].c_str());
	    }
		fn.Delete();
	    if (fn.Exists())
			UnitTest::Failed("dir delete '%s'", fn.GetFullPathNameOS().c_str());
		{
			OpenedFile of(fn, OpenedFile::ReadWriteExclusive);
			if (of.GetSize() != 0)
				UnitTest::Failed("file created with size %ld!=0 '%s'"
								, of.GetSize(), fn.GetFullPathNameOS().c_str());
			char wrbuf[] = "some data";
			const uint32 wrz = sizeof(wrbuf)-1;
			if (wrz != of.Write(0, wrbuf, wrz))
				UnitTest::Failed("cannot write full %d bytes '%s'"
								, wrz, fn.GetFullPathNameOS().c_str());
			if (of.GetSize() != wrz)
				UnitTest::Failed("file size %ld!=%d '%s'"
								, of.GetSize()
								, wrz
								, fn.GetFullPathNameOS().c_str());
			char rrbuf[sizeof(wrbuf)];
			const uint32 rrz = (sizeof(rrbuf)-1) /2;
			if (rrz != of.Read(rrz, &rrbuf, rrz))
				UnitTest::Failed("cannot read full %d bytes from '%s'"
								, rrz, fn.GetFullPathNameOS().c_str());
			if (!std::equal(rrbuf, rrbuf+rrz, wrbuf+rrz))
				UnitTest::Failed("read not same as write '%s'"
								, fn.GetFullPathNameOS().c_str());
		}
	    if (!fn.Exists())
			UnitTest::Failed("file create '%s'", fn.GetFullPathNameOS().c_str());
	    if (fn.IsDir())
			UnitTest::Failed("IsDir, should be a file '%s'", fn.GetFullPathNameOS().c_str());
		{
			FileProperties fp(fn);
			UnitTest::Log("Created file=>'%s' size=%s modified='%s'", 
						fp.GetFileName().GetName().c_str(),
						fp[FileProperties::Size].c_str(),
						fp[FileProperties::ModifyTime].c_str());
	    }
		fn.Delete();
	    if (fn.Exists())
			UnitTest::Failed("file delete '%s'", fn.GetFullPathNameOS().c_str());
	}
		
}
#endif

} // namespace XSP
