/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

#if 0
#pragma mark FontName
#endif

class FontName
{
public:
	String faceName;
	uint32 fontSize;
	bool boldFont;
	bool italicFont;
	bool underlineFont;
	uint8 charset; // default charset (1)
public:
	FontName();
	FontName(const FontName& t);
	~FontName();
	
	String ToString() const { return faceName; }
	const String& GetCharset(); // the string format of the charset
	
	typedef std::map<uint32, String> Charsets;
	static Charsets _charsets;
	
	typedef std::vector<FontName> Container;
	// enumerate all fonts in the system into the container
	static void EnumerateAllInto(Container& c);
}; // class FontName

#if 0
#pragma mark TextFont
#endif

// size, shape, width BUT NO color
class TextFont
{
public:
	class _Data;
	refc<_Data> data;
public:
	TextFont();	 // default system font
	TextFont(const FontName& fontName);
	~TextFont();
	TextFont(const TextFont& i);
	TextFont& operator = (const TextFont& i);

    bool operator == (const TextFont& f) const;
    bool operator != (const TextFont& f) const;
    
    const String& GetFaceName() const;
//    const String& GetCharset() const;
    sint32 GetAscent() const;
    sint32 GetDescent() const;
    sint32 GetLeading() const;
    sint32 GetMaxCharWidth() const;
    sint32 GetHeight() const;
    bool   IsItalic() const;
    bool   IsUnderline() const;
    bool   IsBold() const;
}; // class TextFont

#if 0
#pragma mark TextFont::_Data
#endif

#if TARGET_API_Win32 || TARGET_API_Win32_Console
	class TextFont::_Data
	{
	private:
		uint32 refcount;
	public:
	    HFONT handle;
	    String faceName;
	    TEXTMETRIC metric;
	public:
		_Data();
		~_Data();
		void addref() { ++refcount; }
		void release() { if (--refcount == 0) delete this; }
	}; // class ImageBuffer::Data
#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
	class TextFont::_Data
	{
	private:
		uint32 refcount;
	public:
	    String faceName;
		SInt16 fontID;
		SInt16 fontSize;
		Style  fontStyle;
		FontInfo metric;
	public:
		_Data();
		~_Data();
		void addref() { ++refcount; }
		void release() { if (--refcount == 0) delete this; }
	}; // class TextFont::_Data
#elif TARGET_API_Darwin || TARGET_API_Linux
	class TextFont::_Data
	{
	private:
		uint32 refcount;
	public:
		_Data();
		~_Data();
		void addref() { ++refcount; }
		void release() { if (--refcount == 0) delete this; }
	}; // class TextFont::_Data
#endif


} // namespace XSP
