unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, SWFStreams;

type
  TForm1 = class(TForm)
    L1: TLabel;
    EXMin: TEdit;
    LXMin: TLabel;
    Label1: TLabel;
    EXMax: TEdit;
    LXMax: TLabel;
    Label3: TLabel;
    EYMin: TEdit;
    LYMin: TLabel;
    Label5: TLabel;
    EYMax: TEdit;
    LYMax: TLabel;
    LFile: TLabel;
    Bevel1: TBevel;
    Button1: TButton;
    BModif: TButton;
    CBBackup: TCheckBox;
    Label2: TLabel;
    EFPS: TEdit;
    LInfo: TLabel;
    CBCompress: TCheckBox;
    Bevel2: TBevel;
    procedure Button1Click(Sender: TObject);
    procedure EXMinChange(Sender: TObject);
    procedure EXMaxChange(Sender: TObject);
    procedure EYMinChange(Sender: TObject);
    procedure EYMaxChange(Sender: TObject);
    procedure BModifClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
     SWF: TSWFStreamReader;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
 var OD:tOpenDialog;
     S:single;
     BS:byte;
     R:tRect;
     WAddr:LongWord;
     il,ip:byte;
     stt: string;
     sr: TSearchRec;
begin
 OD:=tOpenDialog.Create(self);
 OD.Filter:='SWF|*.swf';
 if OD.Execute then
  begin
   LFile.Caption:= OD.FileName;
   Try
       if SWF<>nil then SWF.Free;
       SWF:= TSWFStreamReader.Create(OD.FileName);

       if SWF.Compressed then
         begin
          FindFirst(OD.FileName, faAnyFile, sr);
          stt := ' ('+ IntToStr(sr.Size)+')';
          FindClose(SR);
         end else stt := '';

       LInfo.Caption:=Format('Ver: %d   Size: %d%s bytes   Frames count: %d',[SWF.Version, SWF.SWFHeader.FileSize, stt, SWF.FramesCount]);

       With SWF.MovieRect do
        begin
         EXMin.Text:= IntToStr(Left);
         EXMax.Text:= IntToStr(Right);
         EYMin.Text:= IntToStr(Top);
         EYMax.Text:= IntToStr(Bottom);
        end;
       EFPS.Text:=FloatToStr(SWF.FPS);
       CBCompress.Checked := SWF.Compressed;
       BModif.Enabled:=true;
   except
    ShowMessage('Error opening!');
   end;

  end;
 OD.Free;
end;

procedure TForm1.EXMinChange(Sender: TObject);
 var V:integer;
begin
 Try
   V:=StrToInt(EXMin.Text);
 finally
   LXMin.Caption:= Format('(%d px)',[V div 20]);
 end;
end;

procedure TForm1.EXMaxChange(Sender: TObject);
 var V:integer;
begin
 Try
   V:=StrToInt(EXMax.Text);
 finally
   LXMax.Caption:= Format('(%d px)',[V div 20]);
 end;
end;

procedure TForm1.EYMinChange(Sender: TObject);
 var V:integer;
begin
 Try
   V:=StrToInt(EYMin.Text);
 finally
   LYMin.Caption:= Format('(%d px)',[V div 20]);
 end;
end;

procedure TForm1.EYMaxChange(Sender: TObject);
 var V:integer;
begin
 Try
   V:=StrToInt(EYMax.Text);
 finally
   LYMax.Caption:= Format('(%d px)',[V div 20]);
 end;
end;

procedure TForm1.BModifClick(Sender: TObject);
 var
    W:Word;
    S:single;
    R: TRect;
    ch:char;
    stt: string;
begin

 try
   W:= StrToInt(EFPS.Text);
   S:=W;
 except
   try
    S:= StrToFloat(EFPS.Text);
   except
    S:=0;
   end;
 end;

 if S=0 then
  begin
   ShowMessage('FPS is not valid!');
   exit;
  end;

 try
  R:=Rect(StrToInt(EXMin.Text),
          StrToInt(EYMin.Text),
          StrToInt(EXMax.Text),
          StrToInt(EYMax.Text));
 except
  ShowMessage('Movie rect is not valid!');
  exit;
 end;


 SWF.MovieRect := R;
 SWF.FPS := S;
 SWF.Compressed := CBCompress.Checked;

  if CBBackup.Checked then
    begin
      stt := ChangeFileExt(lFile.Caption, '.bak');
      if FileExists(stt) then DeleteFile(stt);
      Copyfile(PChar(lFile.Caption), PChar(stt), true);
    end;
 SWF.SaveToFile(lFile.Caption);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  if SWF<>nil then SWF.Free;
end;

end.
