//*******************************************************//
//                                                       //
//                      DelphiFlash.com                  //
//              Copyright (c) 2004 FeatherySoft, Inc.    //
//                    info@delphiflash.com               //
//                                                       //
//*******************************************************//

//  Description: Main demo
//  Last update: 17 sep 2004

unit UDemo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, ExtCtrls, ComCtrls,
  StdCtrls, Buttons, Menus,
  ShockwaveFlashObjects_TLB, ShockwaveEx, FlashObjects, SWFObjects,
  SWFTools, FLV;

type
  TmDemo = class(TForm)
    P1: TPanel;
    Splitter: TSplitter;
    Pages: TPageControl;
    P2: TPanel;
    eName: TEdit;
    bBrowse: TSpeedButton;
    P3: TPanel;
    P4: TPanel;
    CBCompr: TCheckBox;
    Bevel1: TBevel;
    bPlay: TSpeedButton;
    bPause: TSpeedButton;
    TrackBar: TTrackBar;
    bReweind: TSpeedButton;
    TabSound: TTabSheet;
    SndName: TEdit;
    bSndBrowse: TSpeedButton;
    Label1: TLabel;
    sndVariant: TRadioGroup;
    lFrames: TLabel;
    TimerSWF: TTimer;
    SndEvParam: TGroupBox;
    Label2: TLabel;
    sndLoop: TEdit;
    cbSyncNoMultiple: TCheckBox;
    TabShape: TTabSheet;
    rvShape: TRadioGroup;
    FillShape: TRadioGroup;
    GroupBox1: TGroupBox;
    cbLine: TCheckBox;
    UseA: TCheckBox;
    ImgName: TEdit;
    Label3: TLabel;
    BrowsImg: TSpeedButton;
    TabButton: TTabSheet;
    Label4: TLabel;
    EOpenUtr: TEdit;
    TabText: TTabSheet;
    StaticText: TEdit;
    BFont: TButton;
    FontDialog: TFontDialog;
    EditText: TEdit;
    MemoHTML: TMemo;
    HTMLBrowse: TSpeedButton;
    RBText1: TRadioButton;
    RBText2: TRadioButton;
    RBText3: TRadioButton;
    LGetText: TLabel;
    TabTransform: TTabSheet;
    FlashPlayer: TShockwaveFlashEx;
    Trans2: TCheckBox;
    Trans1: TCheckBox;
    Trans3: TCheckBox;
    Trans4: TCheckBox;
    TabSprite: TTabSheet;
    Sprite1: TCheckBox;
    Sprite2: TCheckBox;
    TabSheet1: TTabSheet;
    Label5: TLabel;
    StreamBox: TGroupBox;
    CBDuration: TCheckBox;
    Label6: TLabel;
    SDuratiom: TEdit;
    cbProtect: TCheckBox;
    EPassw: TEdit;
    FntEmbed: TCheckBox;
    TabSheet2: TTabSheet;
    RBMorphFill: TRadioGroup;
    CBLineM: TCheckBox;
    TabVIdeo: TTabSheet;
    z: TGroupBox;
    VCBoxPlace: TCheckBox;
    VCBoxWriteFrame: TCheckBox;
    VSTStartframe: TStaticText;
    VSTY: TStaticText;
    VEStartFrame: TEdit;
    VEX: TEdit;
    VEY: TEdit;
    VLabelX: TLabel;
    VFileEdit: TEdit;
    VFileButton: TSpeedButton;
    Label7: TLabel;
    VSoundEnableChecker: TCheckBox;
    CBPreloader: TCheckBox;
    bMake: TBitBtn;
    procedure bBrowseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure bMakeClick(Sender: TObject);
    procedure P4Resize(Sender: TObject);
    procedure P2Resize(Sender: TObject);
    procedure P3Resize(Sender: TObject);
    procedure TimerSWFTimer(Sender: TObject);
    procedure bSndBrowseClick(Sender: TObject);
    procedure TrackBarChange(Sender: TObject);
    procedure bPauseClick(Sender: TObject);
    procedure bPlayClick(Sender: TObject);
    procedure bReweindClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BrowsImgClick(Sender: TObject);
    procedure BFontClick(Sender: TObject);
    procedure HTMLBrowseClick(Sender: TObject);
    procedure CBDurationClick(Sender: TObject);
    procedure CBLineMClick(Sender: TObject);
    procedure RBMorphFillClick(Sender: TObject);
    procedure VFileButtonClick(Sender: TObject);
    procedure cbProtectClick(Sender: TObject);
  private
    { Private declarations }
    FLV: TFLVData;
    procedure CustomPlace (be:TBitsEngine; P: TWriteFrameInfo; Tr: TFlashPlaceObject);
    procedure CustomWrite (be:TBitsEngine; P: TWriteFrameInfo);
    procedure CustomWriteFrame(sender: TSWFObject; BE: TBitsEngine);
  public
    { Public declarations }
    prgChange : boolean;
    GetEditValueState: byte; // 0 - no get  1 - prepare   2 - geting
    MP3Duration : single;
    TmpName: string;
   end;

var
  mDemo: TmDemo;

implementation

{$R *.dfm}

Uses SWFConst, SoundReader, ImageReader, ExtDlgs, JPEG,
     FontReader;

const
  pShape = 0;
  pSound = 1;
  pButton = 2;
  pText = 3;
  pTransform = 4;
  pSprite = 5;
  PScript = 6;
  pMorph = 7;
  pVideo = 8;

procedure TmDemo.CustomPlace (be:TBitsEngine; P: TWriteFrameInfo; Tr: TFlashPlaceObject);
begin
  Tr.ColorTransform.addA := - P.Frame;
  Tr.SetPosition(TR.TranslateX + P.Frame, TR.TranslateY + P.Frame*2);
end;

procedure TmDemo.CustomWriteFrame(sender: TSWFObject; BE: TBitsEngine);
begin
  With FLV.Frame[TSWFVideoFrame(sender).FrameNum] do
   begin
    if FLV.Header.CodecInfo = 3
      then be.WriteByte((byte(FLV.Header.KeyFrame) shl 4)+FLV.Header.CodecInfo);
      FLV.Data.Position := Start;
      BE.BitsStream.CopyFrom(FLV.Data, Len);
   end;
end;

procedure TmDemo.CustomWrite(be:TBitsEngine; P: TWriteFrameInfo);
var
  l, i: Cardinal;
  VFrame: TSWFVIdeoFrame;
  PlaceMatrix: TSWFMatrix;
  VDefStream: TSWFDefineVideoStream;
  PlaceStream: TSWFPlaceObject2;
begin
    PlaceStream:= TSWFPlaceObject2.Create;
    if P.Frame = 0 then
    begin
      VDefStream := TSWFDefineVideoStream.Create;
      VDefStream.CharacterID:=P.ID;
      VDefStream.CodecID:=FLV.Header.CodecInfo;
      VDefStream.NumFrames:=FLV.Header.FrameCount;
      VDefStream.Width:=FLV.Header.XDim;
      VDefStream.Height:=FLV.Header.YDim;
      VDefStream.WriteToStream(BE);
      VDefStream.Free;

      PlaceStream.Depth := P.Depth;
      PlaceStream.CharacterId := P.ID;
    end else
    begin
      PlaceStream.PlaceFlagMove:=True;
      PlaceStream.Depth := P.Depth;
           i:=FLV.Header.YDim*P.Frame;
           if i > 40*FLV.Header.YDim then i:=40*FLV.Header.YDim;
           l:= P.Frame; if l > 90 then l:= 90;

           PlaceMatrix := PlaceStream.Matrix;
           PlaceMatrix.SetTranslate(20, i);
           PlaceMatrix.SetRotate(l);
      PlaceStream.Ratio:= P.Frame;
    end;
    VFrame := TSWFVIdeoFrame.Create;
    VFrame.StreamID := P.ID;
    VFrame.FrameNum := P.Frame mod FLV.Header.FrameCount;
    VFrame.OnDataWrite := CustomWriteFrame;
    VFrame.WriteToStream(be);
    VFrame.Free;

    PlaceStream.ColorTransform.addA := - 100;
    PlaceStream.WriteToStream(be);
    PlaceStream.Free;
end;

procedure TmDemo.FormCreate(Sender: TObject);
 var ACH: array [0..255] of char;
begin
  TmpName := ExtractFilePath(ParamStr(0));
  eName.Text := TmpName + 'demo.swf';
  prgChange := false;
  bReweind.Down := FlashPlayer.Loop;
  sndName.Text := TmpName + 'stream.mp3';
  imgName.Text := TmpName + 'img.jpg';
  GetWindowsDirectory(ACH, SizeOf(ACH));
  TmpName := string(ACH) + '\Temp\temp.swf';
  CreateEmptySWF(TmpName, WithoutA(cswfWhite));
  Pages.TabIndex := 0;
  MP3Duration := 21.92;
  SDuratiom.Text := Format('%2.2f', [MP3Duration]);
end;

procedure TmDemo.FormDestroy(Sender: TObject);
begin
  DeleteFile(TmpName);
end;

procedure TmDemo.bBrowseClick(Sender: TObject);
begin
  With TSaveDialog.Create(self) do
    begin
      Options := Options + [ofOverwritePrompt];
      Filter := 'SWF|*.swf';
      DefaultExt := 'swf';
      FileName := eName.Text;
      if Execute then eName.Text := FileName;
      Free;
    end;
end;

procedure TmDemo.bMakeClick(Sender: TObject);
  var Movie: TFlashMovie;
    I: Integer;
      il, il2: integer;
      Shapes: array [1..12] of TFlashShape;
      C: recRGBA;
      AP: array [0..6] of TPoint;
      AC: array [1..4] of recRGBA;
      Img: TFlashImage;
      But: TFlashButton;
      Txt: TFlashText;
      Sprite: TFlashSprite;
      Fnt: TFlashFont;
      FCh: TFlashChar;
      balpha: byte;
      TransX, TransY: integer;
      BDC, OFH: THandle;
      Morph: TFlashMorphShape;
      Video: TFlashVideo;
      PV, PV2: TFlashPlaceVideo;
      _label1: TSWFOffsetMarker;
begin
  Randomize;

  bPlay.Enabled := true;
  bPause.Enabled := true;
  bReweind.Enabled := true;

  GetEditValueState := 0;
  LGetText.Caption := '';

  Movie := TFlashMovie.Create(0, 0, 400 * twips, 400 * twips, 12);
  Movie.SystemCoord := scPix;
  Movie.Version := 6;
  Movie.Compressed := CBCompr.Checked;
  Movie.Protect := cbProtect.Checked;
  if cbProtect.Checked then
     Movie.Password := EPassw.Text;

  if CBPreloader.Checked then
    begin
      AC[1] := cswfGray70;
      AC[2] := cswfGray20;
      AC[3] := cswfGray60;
      AC[4] := cswfBlack;
      Movie.AddRectangle(0, 0, 200, 10).SetLinearGradient(AC, 270);
      Movie.AddFont(self.Font, true).Bold := true;
      with Movie.AddDynamicText('pr', '0%', cswfRed, Movie.Fonts[0], Rect(100, 100, 300, 120)) do
       begin
         AutoSize := false;
         NoSelect := true;
         Align := taCenter;
       end;
      Sprite := Movie.AddSprite;
      Sprite.PlaceObject(Movie.Shapes[0], 1);

      Sprite := Movie.AddSprite;
      with Sprite.PlaceObject(Movie.Shapes[0], 1) do
        begin
          ColorTransform.AddA := -180;
          SetTranslate(100, 115);
        end;

      Sprite.PlaceObject(Movie.Texts[0], 2).Name := 'prText';

      with Sprite.PlaceObject(Movie.Sprites[0], 10) do
       begin
        SetTranslate(100, 115);
        Name := 'pBar';
       end;

      Sprite.ShowFrame;

      with Movie.PlaceObject(Sprite, 1) do
      begin
       with OnEnterFrame do
        begin
          ConstantPool(['loaded', '_root', 'getBytesLoaded', 'getBytesTotal',
                            'pBar', '_xscale', 'pr', '%', 'gotoAndPlay']);
          Push([0, 100, 0, 1], [vtConstant8, vtInteger, vtInteger, vtConstant8]);
          GetVariable;
          PushConstant(2);
          CallMethod;
          Push([0, 1], [vtInteger, vtConstant8]);
          GetVariable;
          PushConstant(3);
          CallMethod;
          Divide;
          Multiply;
          ToInteger;
          SetVariable;
          PushConstant(4);
          GetVariable;
          PushConstant([5, 0]);
          GetVariable;
          SetMember;
          PushConstant([6, 0]);
          GetVariable;
          PushConstant(7);
          Add2;
          SetVariable;
          PushConstant(0);
          GetVariable;
          Push(100);
          Equals2;
          _Not;
          _label1 := _If.BranchOffsetMarker;
          Push([2, 1, 1], [vtInteger, vtInteger, vtConstant8]);
          GetVariable;
          PushConstant(8);
          CallMethod;
          Pop;
          SetMarker(_label1);
        end;

      end;

      Movie.FrameActions.Stop;
      Movie.ShowFrame;
      Movie.RemoveObject(1);
    end;

  case Pages.ActivePageIndex of
   pShape: for il:=1 to 12 do
            begin
              Case rvShape.ItemIndex of
                0: Shapes[il] := Movie.AddRectangle(0, 0, Random(200),Random(200));
                1: Shapes[il] := Movie.AddStar(Random(100), Random(100), Random(150) - 50, Random(200), Random(100));
                2: Shapes[il] := Movie.AddEllipse(0, 0, Random(200),Random(200));
                3: Shapes[il] := Movie.AddCircle(Random(100), Random(100), Random(200));
                4: begin
                     AP[0] := Point(0, 0);
                     AP[6] := AP[0];
                     For il2:=1 to 5 do
                       AP[il2] := Point(Random(200), Random(200));
                     Shapes[il] := Movie.AddPolygon(AP);
                   end;
                5: Shapes[il] := Movie.AddRing(Random(100), Random(100), Random(100) + 20, Random(50)+20);
                6: Shapes[il] := Movie.AddPie(Random(100), Random(100), Random(100) + 20, Random(100) + 20, Random(360), Random(360));
                7: Shapes[il] := Movie.AddArc(Random(100), Random(100), Random(100) + 20, Random(100) + 20,
                                      Random(360), Random(360));
                8: Shapes[il] := Movie.AddDiamond(0, 0, Random(200),Random(200));
              end;

              C.R := Random(255);
              C.G := Random(255);
              C.B := Random(255);
              if UseA.Checked then C.A := Random(255) else C.A := $ff;

              Case FillShape.ItemIndex of
                0: Shapes[il].SetSolidColor(C);
                1: begin
                    case il of
                      1..3: Shapes[il].SetLinearGradient(C, cswfWhite, (il - 1) * 45);
                      4..5: begin
                           AC[1] := C;
                           AC[2] := cswfWhite;
                           AC[3] := C;
                           AC[4] := cswfBlack;
                           Shapes[il].SetLinearGradient(AC, 0);
                         end;
                      6..7: Shapes[il].SetRadialGradient(C, cswfWhite, 50, 50);
                      8: Shapes[il].SetRadialGradient(cswfWhite, C, 35, 35);
                      9..11: Shapes[il].SetRadialGradient(C, cswfWhite, (il - 9) * 30, (il - 9) * 20);
                      12: begin
                           AC[1] := C;
                           if UseA.Checked then AC[1].A := 0;
                           AC[2] := cswfWhite;
                           AC[3] := C;
                           AC[4] := cswfBlack;
                           Shapes[il].SetRadialGradient(AC, 50, 50);
                          end;
                    end;
                   end;
                2: begin
                    case il of
                     1:begin
                         Img := Movie.AddImage(ImgName.Text);
                         if UseA.Checked and img.AsJPEG then
                           begin
                            Img.MakeAlphaLayer;
                            Img.AlphaData.Position := 0;
                            for il2 := 0 to Img.AlphaData.Size - 1 do
                             begin
                              if (il2 mod Img.Width) = 0 then balpha := 255;
                              balpha := balpha - 1;
                              img.AlphaData.Write(balpha, 1);
                             end;
                           end;
                         Shapes[il].SetImageFill(Img, fmFit);
                       end;
                     2, 4, 8:
                       Shapes[il].SetImageFill(Img, fmClip);
                     3, 6, 7:
                        With Shapes[il].SetImageFill(Img, fmTile) do
                          Matrix.SetScale(2, 2);
                     else Shapes[il].SetImageFill(Img, fmFit);
                    end;
                   end;
              end;

              if cbLine.Checked then
                begin
                  C.R := Random(255);
                  C.G := Random(255);
                  C.B := Random(255);
                  Shapes[il].SetLineStyle(Random(10), C);
                end;

              Movie.PlaceObject(Shapes[il], il).SetTranslate(Random(200), Random(200));
              Movie.ShowFrame(2);
              if il > 6 then Movie.RemoveObject(il-6);
              Case il of
                4, 8, 12: Movie.ShowFrame(10);
              end;

            end;
   pSound: begin
             Movie.BackgroundColor.RGB := SWFRGB(clSkyBlue);
             if fileExists(SndName.Text) then
               begin
                 Case sndVariant.ItemIndex of
                   1: begin // as event
                        With Movie.StartSound(Movie.AddSound(SndName.Text).CharacterID) do
                          begin
                            HasLoops := true;
                            try
                              LoopCount := StrToInt(sndLoop.Text);
                            except
                              LoopCount := 1;
                            end;
                            SyncNoMultiple := cbSyncNoMultiple.Checked;
                          end;
                        Movie.ShowFrame;
                      end;
                   0: begin // as stream
                        Movie.BackgroundSound.LoadSound(SndName.Text);
                        Movie.BackgroundSound.AutoLoop := false;
                        if CBPreloader.Checked then
                          Movie.BackgroundSound.StartFrame := 1; 
                        if not CBDuration.Checked then
                          try
                            MP3Duration := StrToFloat(SDuratiom.Text);
                          except
                            MP3Duration := Movie.BackgroundSound.Duration;
                          end;
                        Movie.ShowFrame(round(MP3Duration * 12));
                      end;
                 end;
               end;
           end;
   pButton:begin

             Shapes[1] := Movie.AddCircle(0, 0, 40);
             Shapes[1].SetRadialGradient(cswfWhite, cswfBlue, 35, 35);

             Shapes[2] := Movie.AddCircle(0, 0, 40);
             Shapes[2].SetRadialGradient(cswfWhite, cswfNavy, 40, 40);

             But := Movie.AddButton;

             But.SndRollOver.SoundId := Movie.AddSound('event.wav').CharacterID;
             But.AddRecord(Shapes[1], [bsUp, bsHitTest]);
             with But.AddRecord(Shapes[1], [bsOver]) do
               Matrix.SetScale(1.1, 1.1);

             with But.AddRecord(Shapes[2], [bsDown]) do
               Matrix.SetScale(1.1, 1.1);
//             But.Actions.AddGetUrl(EOpenUtr.Text, '_blank');
             But.OnReleaseActions.GetUrl(EOpenUtr.Text, '_blank');

             Movie.PlaceObject(But, 1).SetTranslate(100, 100);
             Movie.ShowFrame;
           end;
   pText:begin

           if FntEmbed.Checked then
             begin
               Fnt := Movie.AddFont(BFont.Font, false);
               Fnt.Layout := true;
             end else
               Fnt := Movie.AddFont(BFont.Font);

           if RBText1.Checked then
             begin
               Shapes[1] := Movie.AddRectangle(50, 120, 200, 220);
               Shapes[1].SetLineStyle(1, cswfGray30);

               Movie.PlaceObject(Shapes[1], 1);

               Txt := Movie.AddText(StaticText.Text, cswfBlue, Fnt, Point(200, 120), taRight);
               Txt.NoSelect := true;
               Movie.PlaceObject(Txt, 2);

           //    Shapes[1] := Movie.AddRectangle(0, 0, 150, 50);
           //    Shapes[1].SetSolidColor(cswfYellow);
           //    Movie.PlaceObject(Shapes[1], 1);
             end;

           if RBText2.Checked then
             begin
               Fnt.AddChars(AllChars);
               Txt := Movie.AddDynamicText('EditText', EditText.Text, cswfBlue,
                                    Fnt, Rect(10, 100, 390, 150));
               Txt.Border := true;
               Txt.Align := taCenter;
               Movie.PlaceObject(Txt, 2);

               Txt := Movie.AddDynamicText('EditText2', EditText.Text, cswfBlue,
                                    Fnt, Rect(10, 160, 390, 400));
               Txt.Border := true;
               Txt.WordWrap := true;
               Txt.Multiline := true;
               Txt.Align := taCenter;
               Movie.PlaceObject(Txt, 3);

               GetEditValueState := 1;
             end;

           if RBText3.Checked then
             begin
               Fnt.Bold := false;
               Fnt.Italic := false;
               Fnt.AddChars(AllEnglishChars);

               Txt := Movie.AddDynamicText('', string(MemoHTML.Lines.GetText), cswfGray50,
                         Fnt, Rect(0, 0, 400, 400));
               TXT.HTML := true;
               Txt.ReadOnly := true;
               Movie.PlaceObject(Txt, 3);
               if FntEmbed.Checked then
                 begin
                   Fnt := Movie.AddFont(BFont.Font, false);
                   Fnt.Bold := true;
                   Fnt.Italic := false;
                   Fnt.FontUsing := [fuDynamicText];
                   Fnt.AddChars('bold');
                   Fnt.Layout := true;

                   Fnt := Movie.AddFont(BFont.Font, false);
                   Fnt.Bold := false;
                   Fnt.Italic := true;
                   Fnt.FontUsing := [fuDynamicText];
                   Fnt.AddChars('italc'); // two "i"
                   Fnt.Layout := true;
                 end;
             end;
           Movie.ShowFrame;
         end;
   pTransform:
     begin
       Shapes[1] := Movie.AddCircle(0, 0, 50);
       Shapes[1].SetRadialGradient(cswfWhite, SWFRGBA(clNavy), 35, 35);

       if not (Trans1.Checked or Trans2.Checked or Trans3.Checked or Trans4.Checked) then Trans1.Checked := true;

       For il := 0 to 40 do
        begin
         With Movie.PlaceObject(Shapes[1], 1) do
           begin
             if Trans1.Checked then
               SetScale(1+il / 10, 1+il / 20);
             TransX := 200;
             TransY := 200;
             if Trans2.Checked then
               begin
                 TransX := TransX + il*2;
                 TransY := TransY - il*2;
               end;
             SetTranslate(TransX, TransY);

             if Trans3.Checked then
               SetSkew(il /10, 0);

             if Trans4.Checked then
               InitColorTransform(true, Round(il / 40 * 255), 0, -Round(il / 40 * 255), 0,
                                  false, 0, 0, 0, 0,
                                  true);

             if il>0 then RemoveDepth := true
               else Movie.ShowFrame(5);
           end;

           Movie.ShowFrame;
        end;

     end;
   pSprite:
     begin
       Shapes[1] := Movie.AddRectangle(0, -45, 100, 45);
       C.R := Random(255);
       C.G := Random(255);
       C.B := Random(255);
       C.A := 200;
       AC[1] := C;
       AC[2] := cswfWhite;
       AC[3] := C;
       AC[4] := cswfBlack;
       Shapes[1].SetLinearGradient(AC, 0);

       Sprite := Movie.AddSprite;
       Sprite.PlaceObject(Shapes[1], 1);
       Sprite.ShowFrame;
       For il := 1 to 10 do
        begin
         With Sprite.PlaceObject(Shapes[1], 1) do
          begin
            if il > 5 then  SetScale(1, 1 + (10 - il)/ 10)
              else SetScale(1, 1 + il/ 10);
            RemoveDepth := true
          end;
         Sprite.ShowFrame;
        end;

       if Sprite2.Checked then
         Movie.PlaceObject(Sprite, 2).SetTranslate(150, 200);

       if not Sprite1.Checked then
          Movie.PlaceObject(Sprite, 1).SetTranslate(150, 100)
        else
        For il := 1 to 30 do
         with Movie.PlaceObject(Sprite, 1) do
         begin
           SetRotate(360 * il / 30);
           SetTranslate(50 + il*6, 100);
           if il > 1 then RemoveDepth := true;
           Movie.ShowFrame;
         end;

     end;
   PScript:
     begin
       Txt := Movie.AddDynamicText('EditText', '0', cswfRed,
                            Movie.AddFont(BFont.Font), Rect(30, 10, 100, 50));
       Txt.ReadOnly := false;
       Txt.NoSelect := false;
       Movie.PlaceObject(Txt, 1);

       Shapes[1] := Movie.AddCircle(0, 0, 20);
       Shapes[1].SetRadialGradient(cswfWhite, cswfGray60, 35, 35);

       But := Movie.AddButton;
       But.AddRecord(Shapes[1], [bsUp, bsOver, bsHitTest]);
       With But.AddRecord(Shapes[1], [bsDown]).ColorTransform do
         begin
           addR := 200;
           addG := 10;
           addB := 10;
         end;

       With But.OnReleaseActions do
         begin
          Push('EditText');
          GetVariable('EditText');
          ToInteger;
          Push(1);
          Operation('+');
          SetVariable;
         end;

       with Movie.PlaceObject(But, 2) do
         begin
          SetTranslate(200, 200);
          Name := 'but';
         end;

       Movie.ShowFrame;

       With Movie.FrameActions do
         begin

          Push([1,'but', fpPosX, 'but', fpPosX]);
          GetProperty;
          Random(7, 15);
          Operation('+');
          SetProperty;

          Push(['but', fpPosY, 'but', fpPosY]);
          GetProperty;
          Random(7, 15);
          Operation('+');
          SetProperty;

          GotoFrame2(true);
         end;
       Movie.ShowFrame;
     end;
   pMorph:
     begin
       Morph := Movie.AddMorphShape;   // 1
       Morph.SetStartBound(0, 0, 50, 50);
       Morph.SetEndBound(-70, -70, 70, 70);
       if CBLineM.Checked then
         Morph.SetLineStyle(1, 12, cswfBlue, cswfYellow);
       case RBMorphFill.ItemIndex of
         1: Morph.SetSolidColor(cswfGray10, cswfRed);
         2: Morph.SetLinearGradient(cswfRed, cswfWhite, cswfRed, cswfBlack, 0, 90);
         3: Morph.SetRadialGradient(cswfRed, cswfWhite, cswfRed, cswfBlack, 50, 50, 35, 35);
       end;

       With Morph.StartEdges do
         begin
          MoveDelta(-50, 0);
          MakeEllipse(50, 50);
          MakeMirror(true, false);
         end;

       With Morph.EndEdges do
         begin
           MakeStar(0, 0, 60, 30, 8, true);
           MakeMirror(true, false);
         end;

       for il := 0 to 20 do
         begin
           With Movie.PlaceObject(Morph, 1) do
            begin
              Ratio := Round(il / 20 * $FFFF);
              if il > 0 then RemoveDepth := true
                else SetTranslate(100, 100);
            end;
           Movie.ShowFrame;
         end;
       Movie.ShowFrame(2);
       Movie.RemoveObject(1);

       Morph := Movie.AddMorphShape;   // 2
       Morph.SetStartBound(-70, -70, 70, 70);
       Morph.SetEndBound(-3, -3, 103, 63);

       if CBLineM.Checked then
         Morph.SetLineStyle(12, 6, cswfYellow, cswfBlack);
       case RBMorphFill.ItemIndex of
         1: Morph.SetSolidColor(cswfRed, cswfGreen);
         2: Morph.SetLinearGradient(cswfRed, cswfBlack, cswfBlue, cswfBlack, 90, 180);
         3: Morph.SetRadialGradient(cswfRed, cswfBlack, cswfBlack, cswfBlue, 35, 35, 50, 70);
       end;

       With Morph.StartEdges do
         begin
           MakeStar(0, 0, 60, 30, 8, true);
           MakeMirror(true, false);
         end;
       With Morph.EndEdges do
         begin
           MoveDelta(-100, 0);
           LineDelta(20, 0);
           LineDelta(0, 30);
           LineDelta(50, 0);
           LineDelta(0, -30);
           LineDelta(30, 0);
           LineDelta(0, 60);
           LineDelta(-100, 0);
           LineDelta(0, -60);
           MakeMirror(true, false);
         end;

       for il := 0 to 20 do
         begin
           With Movie.PlaceObject(Morph, 1) do
            begin
              Ratio := Round(il / 20 * $FFFF);
              if il > 0 then RemoveDepth := true
                else SetTranslate(100, 100);
            end;
           Movie.ShowFrame;
         end;
      Movie.ShowFrame(2);
      Movie.RemoveObject(1);

      Morph := Movie.AddMorphShape;   // 3
      Morph.SetStartBound(-3, -3, 103, 63);
      Morph.SetEndBound(0, 0, 50, 50);

      if CBLineM.Checked then
         Morph.SetLineStyle(6, 1, cswfBlack, cswfBlue);
      case RBMorphFill.ItemIndex of
         1: Morph.SetSolidColor(cswfGreen, cswfGray10);
         2: Morph.SetLinearGradient(cswfBlue, cswfBlack, cswfRed, cswfWhite, 180, 0);
         3: Morph.SetRadialGradient(cswfBlack, cswfBlue, cswfRed, cswfWhite, 50, 70, 50, 50);
      end;

      With Morph.StartEdges do
        begin
           MoveDelta(-100, 0);
           LineDelta(20, 0);
           LineDelta(0, 30);
           LineDelta(50, 0);
           LineDelta(0, -30);
           LineDelta(30, 0);
           LineDelta(0, 60);
           LineDelta(-100, 0);
           LineDelta(0, -60);
           MakeMirror(true, false);
        end;

       With Morph.EndEdges do
         begin
          MoveDelta(-50, 0);
          MakeEllipse(50, 50);
          MakeMirror(true, false);
         end;

      for il := 0 to 20 do
       begin
         With Movie.PlaceObject(Morph, 1) do
          begin
            Ratio := Round(il / 20 * $FFFF);
            if il > 0 then RemoveDepth := true
              else SetTranslate(100, 100);
          end;
         Movie.ShowFrame;
       end;
     Movie.ShowFrame(2);

    end;
  pVideo:
        begin
          Movie.BackgroundColor.RGB := SWFRGB(clBlack);
          if fileExists(VFIleEdit.Text) then
          begin
            Video := Movie.AddVideo(VFIleEdit.Text);
            FLV := Video.FLV;
            Movie.FPS:=WordToSingle(FLV.FPS);
            PV := Movie.PlaceVideo(Video, 2);
            PV.EnableSound:=VSoundEnableChecker.Checked;
            PV.StartFrame := StrToInt(VEStartFrame.Text);
            if (PV.StartFrame = 0) and CBPreloader.Checked then PV.StartFrame := 1;
            PV.AutoReplay := false;
            try
              AP[0].X := StrToInt(VEX.Text);
            except
              AP[0].X := 0;
            end;
            try
              AP[0].Y := StrToInt(VEY.Text);
            except
              AP[0].Y := 0;
            end;
            PV.SetTranslate(AP[0].X, AP[0].Y);
            if VCBoxPlace.Checked then
            begin
               PV2 := Movie.PlaceVideo(Video, 1);
               PV2.SetTranslate(AP[0].X, AP[0].Y);
               PV2.onPlaceFrame := CustomPlace;
            end;
            if VCBoxWriteFrame.Checked then
            begin
               PV2:=Movie.PlaceVideo(Video, 3);
               PV2.onWriteFrame := CustomWrite;
            end;
          end;
          Movie.ShowFrame(FLV.FrameCount + 10);
          //ShowMessage(IntToStr(FLV.FrameCount));
         end;
  end;

  Movie.MakeStream;
  Movie.SaveToFile(eName.Text);
  Movie.Free;

  FlashPlayer.Movie := TmpName; // for empty last movie
  FlashPlayer.Movie := eName.Text;

  TrackBar.Max := FlashPlayer.TotalFrames - 1;
  lFrames.AutoSize := true;
  lFrames.Caption := IntToStr(FlashPlayer.TotalFrames)+'/'+IntToStr(FlashPlayer.TotalFrames) + ' frm';
  lFrames.AutoSize := false;
  FlashPlayer.Play;
  P4Resize(nil);
  TimerSWF.Enabled := true;
  if GetEditValueState = 1 then GetEditValueState := 2;

end;

procedure TmDemo.P4Resize(Sender: TObject);
begin
//  if sender
  bReweind.Left := P4.Width - bReweind.Width - 2;
  lFrames.Left :=  bReweind.Left - 4 - lFrames.Width;
  TrackBar.Width := lFrames.Left - 1 - TrackBar.Left;
end;

procedure TmDemo.P2Resize(Sender: TObject);
begin
  bBrowse.Left :=  P1.Width - bBrowse.Width - 2;
  eName.Width := bBrowse.Left - 4 - eName.Left;
end;

procedure TmDemo.P3Resize(Sender: TObject);
begin
  FlashPlayer.CreateWnd;
end;

procedure TmDemo.TimerSWFTimer(Sender: TObject);
begin
  prgChange := true;
  try
    lFrames.Caption := IntToStr(FlashPlayer.CurrentFrame)+'/'+IntToStr(FlashPlayer.TotalFrames) + ' frm';
    TrackBar.Position := FlashPlayer.CurrentFrame;
    if GetEditValueState = 2 then
     begin
      LGetText.Caption := FlashPlayer.GetVariable('EditText');
     end;
  finally
    prgChange := false;
  end;  
end;

procedure TmDemo.bSndBrowseClick(Sender: TObject);
begin
  With TOpenDialog.Create(self) do
    begin
      Filter := 'Music & sound (*.wav, *.mp3)|*.wav;*.mp3';
      FileName := SndName.Text;
      if Execute then
        begin
          if isSupportSoundFormat(FileName)
            then
              begin
                SndName.Text := FileName;
                With TFlashSound.Create(FileName) do
                 begin
                   MP3Duration := Duration;
                   SDuratiom.Text := Format('%2.2f', [Duration]);
                   Free;
                 end;
              end
            else MessageBox(handle,'Sorry, this sound format is not supported.', PChar(Caption), MB_Ok	+ MB_ICONError);

        end;
      Free;
    end;
end;

procedure TmDemo.TrackBarChange(Sender: TObject);
 var pl: boolean;
begin
 if prgChange then Exit;
 pl := FlashPlayer.Playing;
 FlashPlayer.GotoFrame(TrackBar.Position);
 if pl then FlashPlayer.Play;
end;

procedure TmDemo.bPauseClick(Sender: TObject);
begin
  FlashPlayer.Stop;
end;

procedure TmDemo.bPlayClick(Sender: TObject);
begin
  if FlashPlayer.Movie <> '' then
    FlashPlayer.Play;
end;

procedure TmDemo.bReweindClick(Sender: TObject);
begin
  FlashPlayer.Loop := bReweind.Down;
end;

procedure TmDemo.BrowsImgClick(Sender: TObject);
begin
  With TOpenPictureDialog.Create(self) do
    begin
      Filter := 'Picture (*.bmp, *.jpg)|*.bmp;*.jpg';
      FileName := imgName.Text;
      if Execute then
        begin
          if isSupportImageFormat(FileName)
            then imgName.Text := FileName
            else MessageBox(handle,'Sorry, this image format is not supported.', PChar(Caption), MB_Ok	+ MB_ICONError);

        end;
      Free;
    end;
end;

procedure TmDemo.BFontClick(Sender: TObject);
begin
  with TFontDialog.Create(self) do
   begin
     Options := [fdTrueTypeOnly];
     Font.Assign(BFont.Font);
     if Execute then
       begin
         BFont.Font.Assign(Font);
         BFont.Caption := Font.Name;
       end;
     free;
   end;
end;

procedure TmDemo.HTMLBrowseClick(Sender: TObject);
begin
  With TOpenDialog.Create(self) do
    begin
      Filter := 'HTML (*.htm, *.html)|*.htm;*.html';
      if Execute then
        MemoHTML.Lines.LoadFromFile(FileName);
      Free;
    end;
end;

procedure TmDemo.CBDurationClick(Sender: TObject);
begin
  if CBDuration.Checked then SDuratiom.Text := Format('%2.2f', [MP3Duration]);
  SDuratiom.Enabled := not CBDuration.Checked;
end;

procedure TmDemo.CBLineMClick(Sender: TObject);
begin
 if (not CBLineM.Checked) and (RBMorphFill.ItemIndex = 0) then
    RBMorphFill.ItemIndex := 1;
end;

procedure TmDemo.RBMorphFillClick(Sender: TObject);
begin
  if (RBMorphFill.ItemIndex = 0) and (not CBLineM.Checked) then
    CBLineM.Checked := true;
end;

procedure TmDemo.VFileButtonClick(Sender: TObject);
begin
  With TOpenDialog.Create(self) do
    begin
      Filter := 'Stream video (*.flv)|*.flv';
      FileName := VFIleEdit.Text;
      if Execute then VFIleEdit.Text := FileName;
      Free;
    end;

end;

procedure TmDemo.cbProtectClick(Sender: TObject);
begin
  EPassw.Enabled := cbProtect.Checked;
end;

end.



