//*******************************************************//
//                                                       //
//                      DelphiFlash.com                  //
//              Copyright (c) 2004 FeatherySoft, Inc.    //
//                    info@delphiflash.com               //
//                                                       //
//*******************************************************//

//  Description:  Parsing SWF file. Main form
//  Last date update:  29 jun 2004
unit MAIN;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls, StdActns,
  ActnList, ToolWin, ImgList, XPMan, ExtDlgs;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    OpenDialog: TOpenDialog;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    StatusBar: TStatusBar;
    WindowTileItem2: TMenuItem;
    ImageList1: TImageList;
    XPManifest1: TXPManifest;
    Test: TMenuItem;
    Tools1: TMenuItem;
    Deleteselected1: TMenuItem;
    CopyAS1: TMenuItem;
    mSaveSound: TMenuItem;
    mSaveSelTags: TMenuItem;
    mSaveTagsAsByte: TMenuItem;
    mSaveTagsAsText: TMenuItem;
    mSaveImage: TMenuItem;
    SPD: TSavePictureDialog;
    SD: TSaveDialog;
    N2: TMenuItem;
    PareseActions: TMenuItem;
    procedure FileOpen1Execute(Sender: TObject);
    procedure HelpAbout1Execute(Sender: TObject);
    procedure FileExit1Execute(Sender: TObject);
    procedure FileSave1Execute(Sender: TObject);
    procedure FileSaveAsItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure Deleteselected1Click(Sender: TObject);
    procedure Tools1Click(Sender: TObject);
    procedure CopyAS1Click(Sender: TObject);
    procedure mSaveSoundClick(Sender: TObject);
    procedure mSaveTagsAsTextClick(Sender: TObject);
    procedure mSaveImageClick(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure WindowTileItem2Click(Sender: TObject);
  private
    { Private declarations }
    procedure CreateMDIChild(const Name: string);
  public
    Procedure SaveSWF(FileName: string);

  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

uses UWinParse, about, FlashObjects, SWFConst, SWFTools;

procedure TMainForm.CreateMDIChild(const Name: string);
var
  Child: TMDIChild;
begin
  { create a new MDI child window }
  Child := TMDIChild.Create(Application);
  Child.Caption := Name;
  Child.ParseAction := PareseActions.Checked;
  if FileExists(Name) then Child.LoadSWF(Name);
end;

procedure TMainForm.FileOpen1Execute(Sender: TObject);
begin
  if OpenDialog.Execute then
    CreateMDIChild(OpenDialog.FileName);
end;

procedure TMainForm.HelpAbout1Execute(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainForm.FileExit1Execute(Sender: TObject);
begin
  Close;
end;

Procedure TMainForm.SaveSWF(FileName: string);
begin
  With TMDIChild(ActiveMDIChild) do
   begin
    {if isModif then} SWF.MakeStream;
    isModif := false;
    SWF.SaveToFile(FileName);
   end;
end;

procedure TMainForm.FileSave1Execute(Sender: TObject);
begin
 With TMDIChild(ActiveMDIChild) do
  SaveSWF(SwfName);
end;

procedure TMainForm.FileSaveAsItemClick(Sender: TObject);
begin
  if SD.Execute then SaveSWF(SD.FileName);
end;

procedure TMainForm.FileCloseItemClick(Sender: TObject);
begin
  ActiveMDIChild.Close;
end;

procedure TMainForm.File1Click(Sender: TObject);
begin
 FileCloseItem.Enabled := not (ActiveMDIChild = nil);
 FileSaveItem.Enabled := FileCloseItem.Enabled and TMDIChild(ActiveMDIChild).isModif;
 FileSaveAsItem.Enabled := FileCloseItem.Enabled;
end;

procedure TMainForm.Deleteselected1Click(Sender: TObject);
begin
 TMDIChild(ActiveMDIChild).bDelClick;
end;

procedure TMainForm.Tools1Click(Sender: TObject);
begin
 Deleteselected1.Enabled :=  not (ActiveMDIChild = nil);
 CopyAS1.Enabled := Deleteselected1.Enabled;
 mSaveSelTags.Enabled := Deleteselected1.Enabled;
 mSaveImage.Enabled := Deleteselected1.Enabled;
end;

procedure TMainForm.CopyAS1Click(Sender: TObject);
begin
 TMDIChild(ActiveMDIChild).bActionSaveClick;
end;

procedure TMainForm.mSaveSoundClick(Sender: TObject);
begin
 // SaveSound;
end;

procedure TMainForm.mSaveTagsAsTextClick(Sender: TObject);
begin
 With TSaveDialog.Create(self) do
  begin
    if Execute then
      TMDIChild(ActiveMDIChild).SaveSelTag(FileName, boolean(TMenuItem(Sender).Tag));
   Free;
  end;
end;

procedure TMainForm.mSaveImageClick(Sender: TObject);
begin
  if SPD.Execute then
    TMDIChild(ActiveMDIChild).SaveImage(SPD.FileName);
end;

procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  TileMode := tbHorizontal;
  Tile;
end;

procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.WindowTileItem2Click(Sender: TObject);
begin
  TileMode := tbVertical;
  Tile;
end;

end.
