// mainfrm.cpp : implementation of the CMainFrame class
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1998 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.


#include "stdafx.h"
#include "drawcli.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_MDITABS_TOP, OnMditabsTop)
	ON_UPDATE_COMMAND_UI(ID_MDITABS_TOP, OnUpdateMditabsTop)
	ON_COMMAND(ID_MDITABS_BOTTOM, OnMditabsBottom)
	ON_UPDATE_COMMAND_UI(ID_MDITABS_BOTTOM, OnUpdateMditabsBottom)
	ON_COMMAND(ID_MDITABS_LEFT, OnMditabsLeft)
	ON_UPDATE_COMMAND_UI(ID_MDITABS_LEFT, OnUpdateMditabsLeft)
	ON_COMMAND(ID_MDITABS_RIGHT, OnMditabsRight)
	ON_UPDATE_COMMAND_UI(ID_MDITABS_RIGHT, OnUpdateMditabsRight)
	ON_COMMAND(ID_MDITABS_SHOW_CLOSE, OnMditabsShowClose)
	ON_UPDATE_COMMAND_UI(ID_MDITABS_SHOW_CLOSE, OnUpdateMditabsShowClose)
	ON_COMMAND(ID_MDITABS_SHOW_CTX_HELP, OnMditabsShowCtxHelp)
	ON_UPDATE_COMMAND_UI(ID_MDITABS_SHOW_CTX_HELP, OnUpdateMditabsShowCtxHelp)
	ON_COMMAND(ID_UISTYLE_2000, OnUistyle2000)
	ON_UPDATE_COMMAND_UI(ID_UISTYLE_2000, OnUpdateUistyle2000)
	ON_COMMAND(ID_UISTYLE_XP, OnUistyleXp)
	ON_UPDATE_COMMAND_UI(ID_UISTYLE_XP, OnUpdateUistyleXp)
	//}}AFX_MSG_MAP

	ON_COMMAND_EX(ID_VIEW_MENUBAR, OnBarCheck )
	ON_UPDATE_COMMAND_UI(ID_VIEW_MENUBAR, OnUpdateControlBarMenu)

	ON_COMMAND_EX(ID_VIEW_TOOLBAR2, OnBarCheck )
	ON_UPDATE_COMMAND_UI(ID_VIEW_TOOLBAR2, OnUpdateControlBarMenu)

	ON_REGISTERED_MESSAGE(
		CExtPopupMenuWnd::g_nMsgPrepareMenu,
		OnExtMenuPrepare
		)
	ON_REGISTERED_MESSAGE(
		CExtPopupMenuWnd::g_nMsgPopupDrawItem,
		OnDrawPopupMenuItem
		)

	// color popup menu
	ON_REGISTERED_MESSAGE(
		CExtPopupColorMenuWnd::g_nMsgNotifyColorChangedFinally,
		OnColorChangedFinally
		)
	ON_REGISTERED_MESSAGE(
		CExtPopupColorMenuWnd::g_nMsgNotifyCustColor,
		OnColorSelectCustom
		)
	
END_MESSAGE_MAP()

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here

	// window placement persistence
	::memset( &m_dataFrameWP, 0, sizeof(WINDOWPLACEMENT) );
	m_dataFrameWP.length = sizeof(WINDOWPLACEMENT);
	m_dataFrameWP.showCmd = SW_HIDE;
}

CMainFrame::~CMainFrame()
{
}

static UINT g_statBasicCommands[] =
{
	ID_APP_ABOUT,
	ID_APP_EXIT,
	ID_FILE_NEW,
	ID_FILE_OPEN,
	ID_FILE_SAVE,
	ID_FILE_PRINT,
	ID_FILE_PRINT_PREVIEW,
	ID_EDIT_CUT,
	ID_EDIT_COPY,
	ID_EDIT_PASTE,
	ID_EDIT_SELECT_ALL,
	ID_OLE_INSERT_NEW,
	ID_OLE_EDIT_LINKS,
	ID_DRAW_SELECT,
	ID_DRAW_LINE,
	ID_DRAW_RECT,
	ID_DRAW_ROUNDRECT,
	ID_DRAW_ELLIPSE,
	ID_DRAW_POLYGON,
	ID_OBJECT_LINECOLOR,
	ID_OBJECT_FILLCOLOR,
	ID_VIEW_MENUBAR,
	ID_VIEW_TOOLBAR,
	ID_VIEW_TOOLBAR2,
	ID_VIEW_STATUS_BAR,
	ID_MDITABS_TOP,
	ID_MDITABS_BOTTOM,
	ID_MDITABS_LEFT,
	ID_MDITABS_RIGHT,
	ID_MDITABS_SHOW_CLOSE,
	ID_MDITABS_SHOW_CTX_HELP,
	ID_UISTYLE_2000,
	ID_UISTYLE_XP,
	ID_EDIT_COPY,
	ID_EDIT_CUT,
	ID_EDIT_PASTE,
	ID_WINDOW_NEW,
	ID_WINDOW_CASCADE,
	ID_WINDOW_TILE_HORZ,
	ID_WINDOW_ARRANGE,
	ID_LINE_WIDTH_OTHER,
	ID_LINE_WIDTH_0,
	ID_LINE_WIDTH_1,
	ID_LINE_WIDTH_2,
	ID_LINE_WIDTH_3,
	ID_LINE_WIDTH_4,
	ID_LINE_WIDTH_5,
	ID_LINE_WIDTH_6,
	ID_LINE_WIDTH_7,
	ID_LINE_WIDTH_8,
	ID_LINE_WIDTH_9,
	ID_LINE_WIDTH_10,
	0, // end of list
};

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
CWinApp * pApp = ::AfxGetApp();
	ASSERT( pApp != NULL );
	ASSERT( pApp->m_pszRegistryKey != NULL );
	ASSERT( pApp->m_pszRegistryKey[0] != _T('\0') );
	ASSERT( pApp->m_pszProfileName != NULL );
	ASSERT( pApp->m_pszProfileName[0] != _T('\0') );

	ASSERT( pApp->m_pszProfileName != NULL );
	g_CmdManager->ProfileSetup(
		pApp->m_pszProfileName,
		GetSafeHwnd()
		);
	VERIFY(
		g_CmdManager->UpdateFromMenu(
			pApp->m_pszProfileName,
			IDR_MAINFRAME
			)
		);
	VERIFY(
		g_CmdManager->UpdateFromMenu(
			pApp->m_pszProfileName,
			IDR_DRAWCLTYPE
			)
		);

	m_wndMenuBar.SetMdiWindowPopupName( _T("Window") );
	if(	!m_wndMenuBar.Create(
			NULL,
			this,
			ID_VIEW_MENUBAR
			)
		)
    {
        TRACE0("Failed to create menubar\n");
        return -1;      // failed to create
    }

	if( !m_wndToolBarStandard.Create(
			NULL,
			this,
			AFX_IDW_TOOLBAR
			)
		||
		!m_wndToolBarStandard.LoadToolBar(IDR_MAINFRAME)
		)
	{
		TRACE0("Failed to create standard toolbar\n");
		return -1;      // fail to create
	}

CSize _sizeBtn = m_wndToolBarStandard._GetDefButtonSize();

CExtCmdManager::cmd_t * p_cmd =
		g_CmdManager->CmdGetPtr(
			g_CmdManager->ProfileNameFromWnd( GetSafeHwnd() ),
			ID_DOC_LINE_WIDTH
			);
	ASSERT( p_cmd != NULL );
	p_cmd->m_sMenuText = _T("Line &Width");

INT nBtnIdx = m_wndToolBarStandard.CommandToIndex(ID_DOC_LINE_WIDTH);
	ASSERT( nBtnIdx >= 0 );
	VERIFY(
		m_btnLineWidth.Create(
			_T(""), // _T("Outline"),
			WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,
			CRect( 0, 0, _sizeBtn.cx+12, _sizeBtn.cy ), // CRect( 0, 0, 80, _sizeBtn.cy+2 ),
			&m_wndToolBarStandard,
			ID_DOC_LINE_WIDTH
			)
		);
CMenu _line_menu;
	VERIFY( _line_menu.LoadMenu(IDR_MENU_LW) );
	VERIFY(
		m_btnLineWidth.m_menu.Attach( _line_menu.Detach() )
		);
CExtCmdManager::icon_t _icon(
		g_CmdManager->CmdGetHICON(
			g_CmdManager->ProfileNameFromWnd( GetSafeHwnd() ),
			ID_DOC_LINE_WIDTH
			),
		true
		);
	m_btnLineWidth.m_dwMenuOpt |= TPMX_OWNERDRAW_FIXED;
	m_btnLineWidth.SetIcon( _icon.Detach() );
	m_wndToolBarStandard.SetButtonCtrl( nBtnIdx, &m_btnLineWidth );
	m_wndToolBarStandard.SetButtonCtrlVisibleVertically( nBtnIdx, true );

	nBtnIdx = m_wndToolBarStandard.CommandToIndex(ID_OBJECT_FILLCOLOR);
	VERIFY(
		m_btnColorFill.Create(
			_T(""), // _T("Fill color"),
			WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,
			CRect( 0, 0, _sizeBtn.cx+12, _sizeBtn.cy ), // CRect( 0, 0, 100, _sizeBtn.cy+2 ),
			&m_wndToolBarStandard,
			ID_OBJECT_FILLCOLOR
			)
		);
	VERIFY( m_btnColorFill.m_sBtnTextColorDefault.LoadString(IDS_STRING_NO_COLOR_FILL) );
	ASSERT( !m_btnColorFill.m_sBtnTextColorDefault.IsEmpty() );
	m_btnColorFill.m_lParamCookie = ID_OBJECT_FILLCOLOR;
	m_wndToolBarStandard.SetButtonCtrl( nBtnIdx, &m_btnColorFill );
	m_wndToolBarStandard.SetButtonCtrlVisibleVertically( nBtnIdx, true );
	
	nBtnIdx = m_wndToolBarStandard.CommandToIndex(ID_OBJECT_LINECOLOR);
	VERIFY(
		m_btnColorOutline.Create(
			_T(""), // _T("Line color"),
			WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,
			CRect( 0, 0, _sizeBtn.cx+12, _sizeBtn.cy ), // CRect( 0, 0, 100, _sizeBtn.cy+2 ),
			&m_wndToolBarStandard,
			ID_OBJECT_LINECOLOR
			)
		);
	VERIFY( m_btnColorOutline.m_sBtnTextColorDefault.LoadString(IDS_STRING_NO_COLOR_OUTLINE) );
	ASSERT( !m_btnColorOutline.m_sBtnTextColorDefault.IsEmpty() );
	m_btnColorOutline.m_lParamCookie = ID_OBJECT_LINECOLOR;
	m_wndToolBarStandard.SetButtonCtrl( nBtnIdx, &m_btnColorOutline );
	m_wndToolBarStandard.SetButtonCtrlVisibleVertically( nBtnIdx, true );

	if( !m_wndToolBarCustom.Create(
			NULL,
			this,
			ID_VIEW_TOOLBAR2
			)
		|| !m_wndToolBarCustom.InitContentExpandButton()
		)
	{
		TRACE0("Failed to create custom toolbar\n");
		return -1;      // fail to create
	}
static struct
{
	UINT m_nCmdID;
	LPCTSTR m_sToolbarText;
}
custom_toolbar_cmds[] =
{
	{ ID_OBJECT_MOVETOFRONT,	_T("Move to front") },
	{ ID_OBJECT_MOVETOBACK,		_T("Move to back") },
	{ ID_SEPARATOR,				NULL },
	{ ID_OBJECT_MOVEFORWARD,	NULL },
	{ ID_OBJECT_MOVEBACK,		NULL },
};
HINSTANCE hInstResource =
		AfxFindResourceHandle(
			MAKEINTRESOURCE( IDR_DRAWCLTYPE ),
			RT_GROUP_ICON
			);
	ASSERT( hInstResource != NULL );
	for(	INT nCustBarIdx = 0;
			nCustBarIdx < sizeof(custom_toolbar_cmds)/sizeof(custom_toolbar_cmds[0]);
			nCustBarIdx++
			)
	{ // add buttons to custom toolbar
		UINT nCmdID = custom_toolbar_cmds[nCustBarIdx].m_nCmdID;
		if( nCmdID != ID_SEPARATOR )
		{
			LPCTSTR sToolBarBtnText =
				custom_toolbar_cmds[nCustBarIdx].m_sToolbarText;
			if( sToolBarBtnText != NULL )
			{
				CExtCmdManager::cmd_t * p_cmd =
					g_CmdManager->CmdGetPtr(
						g_CmdManager->ProfileNameFromWnd(GetSafeHwnd()),
						nCmdID
						);
				ASSERT( p_cmd != NULL );
				p_cmd->m_sToolbarText = sToolBarBtnText;
			} // if( sToolBarBtnText != NULL )
			HICON hIcon =
				(HICON)::LoadImage(
					hInstResource,
					MAKEINTRESOURCE( nCmdID ),
					IMAGE_ICON,
					16,
					16,
					0
					);
			if( hIcon != NULL )
			{
				VERIFY(
					g_CmdManager->CmdSetIcon(
						g_CmdManager->ProfileNameFromWnd(GetSafeHwnd()),
						nCmdID,
						hIcon,
						false
						)
					);
			} // if( hIcon != NULL )
		} // if( nCmdID != ID_SEPARATOR )
		m_wndToolBarCustom.InsertButton( -1, nCmdID, FALSE );
	} // add buttons to custom toolbar

	if(	!m_wndStatusBar.Create(
			this,
			WS_CHILD|WS_VISIBLE|CBRS_BOTTOM|CBRS_HIDE_INPLACE
			)
		||	!m_wndStatusBar.SetIndicators(
				indicators,
				sizeof(indicators) / sizeof(UINT)
				)
			)
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

    m_wndMenuBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolBarStandard.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolBarCustom.EnableDocking(CBRS_ALIGN_ANY);

	if( !CExtControlBar::FrameEnableDocking(this) )
	{
		ASSERT( FALSE );
		return -1;
	}
	
	DockControlBar( &m_wndMenuBar );
	DockControlBar( &m_wndToolBarStandard );
	DockControlBar( &m_wndToolBarCustom );

	VERIFY(
		g_CmdManager->SetBasicCommands(
			pApp->m_pszProfileName,
			g_statBasicCommands
			)
		);

	CExtControlBar::ProfileBarStateLoad(
		this,
		pApp->m_pszRegistryKey,
		pApp->m_pszProfileName,
		pApp->m_pszProfileName,
		&m_dataFrameWP
		);
	g_CmdManager->SerializeState(
		pApp->m_pszProfileName,
		pApp->m_pszRegistryKey,
		pApp->m_pszProfileName,
		false
		);

#if (!defined __EXT_MFC_NO_TABMDI_CTRL)
	if( !m_wndMdiTabs.Create( this ) )
	{
		ASSERT( FALSE );
		return -1;
	}
#endif // (!defined __EXT_MFC_NO_TABMDI_CTRL)

	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg) 
{
	if( m_wndMenuBar.TranslateMainFrameMessage(pMsg) )
		return TRUE;

	return CMDIFrameWnd::PreTranslateMessage(pMsg);
}

BOOL CMainFrame::DestroyWindow() 
{
CWinApp * pApp = ::AfxGetApp();
	ASSERT( pApp != NULL );
	ASSERT( pApp->m_pszRegistryKey != NULL );
	ASSERT( pApp->m_pszRegistryKey[0] != _T('\0') );
	ASSERT( pApp->m_pszProfileName != NULL );
	ASSERT( pApp->m_pszProfileName[0] != _T('\0') );

	VERIFY(
		CExtControlBar::ProfileBarStateSave(
			this,
			pApp->m_pszRegistryKey,
			pApp->m_pszProfileName,
			pApp->m_pszProfileName
			)
		);
	VERIFY(
		g_CmdManager->SerializeState(
			pApp->m_pszProfileName,
			pApp->m_pszRegistryKey,
			pApp->m_pszProfileName,
			true
			)
		);
	g_CmdManager->ProfileWndRemove( GetSafeHwnd() );
	
	return CMDIFrameWnd::DestroyWindow();
}

void CMainFrame::ActivateFrame(int nCmdShow) 
{
	// window placement persistence
	if( m_dataFrameWP.showCmd != SW_HIDE )
	{
		SetWindowPlacement( &m_dataFrameWP );
		CFrameWnd::ActivateFrame( m_dataFrameWP.showCmd );
		m_dataFrameWP.showCmd = SW_HIDE;
		return;
	}
	
	CMDIFrameWnd::ActivateFrame(nCmdShow);
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	cs.lpszClass = ::AfxRegisterWndClass(CS_DBLCLKS);
	ASSERT( cs.lpszClass != NULL );

	cs.style =
		WS_OVERLAPPED|WS_CAPTION|WS_THICKFRAME|WS_SYSMENU
		|WS_MINIMIZEBOX| WS_MAXIMIZEBOX
		|FWS_ADDTOTITLE
		;

	cs.dwExStyle &= ~ (WS_EX_CLIENTEDGE | WS_EX_STATICEDGE);

	return TRUE;
}

LRESULT CMainFrame::OnExtMenuPrepare(WPARAM wParam, LPARAM lParam)
{
CFrameWnd * pFrame = GetActiveFrame();
CView * pView = NULL;
	if( pFrame != this && pFrame != NULL )
	{
		ASSERT_VALID( pFrame );
		pView = pFrame->GetActiveView();
	}
	if( pView == NULL )
	{
		return FALSE;
	}
	ASSERT_VALID( pView );
	return
		pView->SendMessage(
			CExtPopupMenuWnd::g_nMsgPrepareMenu,
			wParam,
			lParam
			);
}

LRESULT CMainFrame::OnDrawPopupMenuItem(WPARAM wParam, LPARAM lParam)
{
CFrameWnd * pFrame = GetActiveFrame();
CView * pView = NULL;
	if( pFrame != this && pFrame != NULL )
	{
		ASSERT_VALID( pFrame );
		pView = pFrame->GetActiveView();
	}
	if( pView == NULL )
	{
		return FALSE;
	}
	ASSERT_VALID( pView );
	return
		pView->SendMessage(
			CExtPopupMenuWnd::g_nMsgPopupDrawItem,
			wParam,
			lParam
			);
}

LRESULT CMainFrame::OnColorChangedFinally(WPARAM wParam, LPARAM lParam)
{
CFrameWnd * pFrame = GetActiveFrame();
CView * pView = NULL;
	if( pFrame != this && pFrame != NULL )
	{
		ASSERT_VALID( pFrame );
		pView = pFrame->GetActiveView();
	}
	if( pView == NULL )
	{
		return FALSE;
	}
	ASSERT_VALID( pView );
	return
		pView->SendMessage(
			CExtPopupColorMenuWnd::g_nMsgNotifyColorChangedFinally,
			wParam,
			lParam
			);
}

LRESULT CMainFrame::OnColorSelectCustom(WPARAM wParam, LPARAM lParam)
{
CFrameWnd * pFrame = GetActiveFrame();
CView * pView = NULL;
	if( pFrame != this && pFrame != NULL )
	{
		ASSERT_VALID( pFrame );
		pView = pFrame->GetActiveView();
	}
	if( pView == NULL )
	{
		return FALSE;
	}
	ASSERT_VALID( pView );
	return
		pView->SendMessage(
			CExtPopupColorMenuWnd::g_nMsgNotifyCustColor,
			wParam,
			lParam
			);
}

void CMainFrame::CColorBtnOutline::OnGenerateColorBtnIcon(
	HICON * p_hIcon,
	bool * p_bDestroyIcon
	)
{
CClientDC dc( this );
	ASSERT( p_hIcon != NULL );
	ASSERT( p_bDestroyIcon != NULL );
	*p_hIcon = NULL;
	*p_bDestroyIcon = false;

ICONINFO iiNewIcon;
	iiNewIcon.fIcon = true;	// set that it is an icon
	// create DC's
HDC hIconDC = ::CreateCompatibleDC( dc.GetSafeHdc() );
HDC hMaskDC = ::CreateCompatibleDC( dc.GetSafeHdc() );
	ASSERT(
		hIconDC != NULL && hMaskDC != NULL
		);
	// load bitmaps
	iiNewIcon.hbmColor = ::CreateCompatibleBitmap(
		dc.GetSafeHdc(),
		16,
		16
		);
	ASSERT( iiNewIcon.hbmColor != NULL );
	iiNewIcon.hbmMask = ::CreateCompatibleBitmap(
		hMaskDC,
		16,
		16
		);
	ASSERT( iiNewIcon.hbmMask != NULL );
HGDIOBJ hOldIconDC =
		::SelectObject(
			hIconDC,
			iiNewIcon.hbmColor
			);
	ASSERT( hOldIconDC != NULL );
HGDIOBJ hOldMaskDC =
		::SelectObject(
			hMaskDC,
			iiNewIcon.hbmMask
			);
	ASSERT( hOldMaskDC != NULL );

CBrush brColorItem( m_clrSelected );
CRect rcColorItem(0,0,16,16);
	::FillRect(
		hMaskDC,
		&rcColorItem,
		(HBRUSH)::GetStockObject(WHITE_BRUSH)
		);
	rcColorItem.DeflateRect( 1, 2 );
	::FillRect(
		hMaskDC,
		&rcColorItem,
		(HBRUSH)::GetStockObject(BLACK_BRUSH)
		);
	::FillRect(
		hIconDC,
		&rcColorItem,
		(HBRUSH)brColorItem.GetSafeHandle()
		);
	rcColorItem.DeflateRect( 2, 2 );
	::FillRect(
		hMaskDC,
		&rcColorItem,
		(HBRUSH)::GetStockObject(WHITE_BRUSH)
		);
	::FillRect(
		hIconDC,
		&rcColorItem,
		(HBRUSH)::GetStockObject(BLACK_BRUSH)
		);

	::SelectObject(hIconDC,hOldIconDC);
	::SelectObject(hMaskDC,hOldMaskDC);
	*p_hIcon = CreateIconIndirect(&iiNewIcon);
	ASSERT( *p_hIcon != NULL );
	// cleanup
	DeleteObject(iiNewIcon.hbmColor);
	DeleteObject(iiNewIcon.hbmMask);
	DeleteDC(hMaskDC);
	DeleteDC(hIconDC);

	if( *p_hIcon != NULL )
	{
		CExtCmdManager::icon_t * pIcon =
			g_CmdManager->CmdGetIconPtr(
				g_CmdManager->ProfileNameFromWnd( GetSafeHwnd() ),
				GetDlgCtrlID()
				);
		if( pIcon != NULL )
			*pIcon = *p_hIcon;
	} // if( hIcon != NULL )
}

CMainFrame::CColorBtnFill::CColorBtnFill()
{
LOGFONT lf;
	::memset( &lf, 0 , sizeof(LOGFONT) );
	g_PaintManager->m_FontBold.GetLogFont( &lf );
	_tcscpy( lf.lfFaceName, _T("Times New Roman") );
	lf.lfHeight = ::MulDiv( lf.lfHeight, 3, 2 );
	lf.lfWeight = 900;
	VERIFY(
		m_FontForLetter.CreateFontIndirect( &lf )
		);
	ASSERT( m_FontForLetter.GetSafeHandle() != NULL );
}

void CMainFrame::CColorBtnFill::OnGenerateColorBtnIcon(
	HICON * p_hIcon,
	bool * p_bDestroyIcon
	)
{
CClientDC dc( this );
	ASSERT( p_hIcon != NULL );
	ASSERT( p_bDestroyIcon != NULL );
	*p_hIcon = NULL;
	*p_bDestroyIcon = false;

ICONINFO iiNewIcon;
	iiNewIcon.fIcon = true;	// set that it is an icon
	// create DC's
HDC hIconDC = ::CreateCompatibleDC( dc.GetSafeHdc() );
HDC hMaskDC = ::CreateCompatibleDC( dc.GetSafeHdc() );
	ASSERT(
		hIconDC != NULL && hMaskDC != NULL
		);
	// load bitmaps
	iiNewIcon.hbmColor = ::CreateCompatibleBitmap(
		dc.GetSafeHdc(),
		16,
		16
		);
	ASSERT( iiNewIcon.hbmColor != NULL );
	iiNewIcon.hbmMask = ::CreateCompatibleBitmap(
		hMaskDC,
		16,
		16
		);
	ASSERT( iiNewIcon.hbmMask != NULL );
HGDIOBJ hOldIconDC =
		::SelectObject(
			hIconDC,
			iiNewIcon.hbmColor
			);
	ASSERT( hOldIconDC != NULL );
HGDIOBJ hOldMaskDC =
		::SelectObject(
			hMaskDC,
			iiNewIcon.hbmMask
			);
	ASSERT( hOldMaskDC != NULL );

CRect rcColorItem(0,0,16,16);
	::FillRect(
		hMaskDC,
		&rcColorItem,
		(HBRUSH)::GetStockObject(WHITE_BRUSH)
		);

	ASSERT( m_FontForLetter.GetSafeHandle() != NULL );

HGDIOBJ hOldFontIconDC = ::SelectObject( hIconDC, m_FontForLetter.GetSafeHandle() );
HGDIOBJ hOldFontMaskDC = ::SelectObject( hMaskDC, m_FontForLetter.GetSafeHandle() );

CRect rcText( rcColorItem );
	rcText.bottom -= 4;
CString sText( _T("A") );

	::SetTextColor( hIconDC, RGB(0,0,0) );
	::SetBkMode( hIconDC, TRANSPARENT );
	::DrawText(
		hIconDC,
		LPCTSTR( sText ),
		sText.GetLength(),
		&rcText,
		DT_SINGLELINE|DT_CENTER|DT_VCENTER
		);
	
	::SetTextColor( hMaskDC, RGB(0,0,0) );
	::SetBkMode( hMaskDC, TRANSPARENT );
	::DrawText(
		hMaskDC,
		LPCTSTR( sText ),
		sText.GetLength(),
		&rcText,
		DT_SINGLELINE|DT_CENTER|DT_VCENTER
		);

	::SelectObject( hIconDC, hOldFontIconDC );
	::SelectObject( hMaskDC, hOldFontMaskDC );

CRect rcColorBar( rcText );
	rcColorBar.OffsetRect( 0, rcColorBar.Height() + 1 );
	rcColorBar.bottom = rcColorBar.top + 3;
	rcColorBar.DeflateRect( 2, 0 );

CBrush brColor( m_clrSelected );
	::FillRect(
		hIconDC,
		&rcColorBar,
		(HBRUSH)brColor.GetSafeHandle()
		);
	::FillRect(
		hMaskDC,
		&rcColorBar,
		(HBRUSH)::GetStockObject(BLACK_BRUSH)
		);

	::SelectObject(hIconDC,hOldIconDC);
	::SelectObject(hMaskDC,hOldMaskDC);
	*p_hIcon = CreateIconIndirect(&iiNewIcon);
	ASSERT( *p_hIcon != NULL );
	// cleanup
	DeleteObject(iiNewIcon.hbmColor);
	DeleteObject(iiNewIcon.hbmMask);
	DeleteDC(hMaskDC);
	DeleteDC(hIconDC);

	if( *p_hIcon != NULL )
	{
		CExtCmdManager::icon_t * pIcon =
			g_CmdManager->CmdGetIconPtr(
				g_CmdManager->ProfileNameFromWnd( GetSafeHwnd() ),
				GetDlgCtrlID()
				);
		if( pIcon != NULL )
			*pIcon = *p_hIcon;
	} // if( hIcon != NULL )
}

void CMainFrame::OnMditabsTop() 
{
#if (!defined __EXT_MFC_NO_TABMDI_CTRL)
	m_wndMdiTabs.OrientationSet( __ETWS_ORIENT_TOP );
	RecalcLayout();
#endif // (!defined __EXT_MFC_NO_TABMDI_CTRL)
}
void CMainFrame::OnUpdateMditabsTop(CCmdUI* pCmdUI) 
{
#if (defined __EXT_MFC_NO_TABMDI_CTRL)
	pCmdUI->Enable( FALSE );
#else
	pCmdUI->SetRadio(
		(m_wndMdiTabs.OrientationGet() == __ETWS_ORIENT_TOP) ? TRUE : FALSE
		);
	pCmdUI->Enable( m_wndMdiTabs.IsWindowVisible() );
#endif // else from (defined __EXT_MFC_NO_TABMDI_CTRL)
}

void CMainFrame::OnMditabsBottom() 
{
#if (!defined __EXT_MFC_NO_TABMDI_CTRL)
	m_wndMdiTabs.OrientationSet( __ETWS_ORIENT_BOTTOM );
	RecalcLayout();
#endif // (!defined __EXT_MFC_NO_TABMDI_CTRL)
}
void CMainFrame::OnUpdateMditabsBottom(CCmdUI* pCmdUI) 
{
#if (defined __EXT_MFC_NO_TABMDI_CTRL)
	pCmdUI->Enable( FALSE );
#else
	pCmdUI->SetRadio(
		(m_wndMdiTabs.OrientationGet() == __ETWS_ORIENT_BOTTOM) ? TRUE : FALSE
		);
	pCmdUI->Enable( m_wndMdiTabs.IsWindowVisible() );
#endif // else from (defined __EXT_MFC_NO_TABMDI_CTRL)
}

void CMainFrame::OnMditabsLeft() 
{
#if (!defined __EXT_MFC_NO_TABMDI_CTRL)
	m_wndMdiTabs.OrientationSet( __ETWS_ORIENT_LEFT );
	RecalcLayout();
#endif // (!defined __EXT_MFC_NO_TABMDI_CTRL)
}
void CMainFrame::OnUpdateMditabsLeft(CCmdUI* pCmdUI) 
{
#if (defined __EXT_MFC_NO_TABMDI_CTRL)
	pCmdUI->Enable( FALSE );
#else
	pCmdUI->SetRadio(
		(m_wndMdiTabs.OrientationGet() == __ETWS_ORIENT_LEFT) ? TRUE : FALSE
		);
	pCmdUI->Enable( m_wndMdiTabs.IsWindowVisible() );
#endif // else from (defined __EXT_MFC_NO_TABMDI_CTRL)
}

void CMainFrame::OnMditabsRight() 
{
#if (!defined __EXT_MFC_NO_TABMDI_CTRL)
	m_wndMdiTabs.OrientationSet( __ETWS_ORIENT_RIGHT );
	RecalcLayout();
#endif // (!defined __EXT_MFC_NO_TABMDI_CTRL)
}
void CMainFrame::OnUpdateMditabsRight(CCmdUI* pCmdUI) 
{
#if (defined __EXT_MFC_NO_TABMDI_CTRL)
	pCmdUI->Enable( FALSE );
#else
	pCmdUI->SetRadio(
		(m_wndMdiTabs.OrientationGet() == __ETWS_ORIENT_RIGHT) ? TRUE : FALSE
		);
	pCmdUI->Enable( m_wndMdiTabs.IsWindowVisible() );
#endif // else from (defined __EXT_MFC_NO_TABMDI_CTRL)
}

void CMainFrame::OnMditabsShowClose() 
{
#if (!defined __EXT_MFC_NO_TABMDI_CTRL)
	if( m_wndMdiTabs.GetTabWndStyle() & __ETWS_SHOW_BTN_CLOSE )
		m_wndMdiTabs.ModifyTabWndStyle( __ETWS_SHOW_BTN_CLOSE, 0, true );
	else
		m_wndMdiTabs.ModifyTabWndStyle( 0, __ETWS_SHOW_BTN_CLOSE, true );
#endif // (!defined __EXT_MFC_NO_TABMDI_CTRL)
}
void CMainFrame::OnUpdateMditabsShowClose(CCmdUI* pCmdUI) 
{
#if (defined __EXT_MFC_NO_TABMDI_CTRL)
	pCmdUI->Enable( FALSE );
#else
	pCmdUI->SetCheck(
		(m_wndMdiTabs.GetTabWndStyle() & __ETWS_SHOW_BTN_CLOSE) ? TRUE : FALSE
		);
	pCmdUI->Enable( m_wndMdiTabs.IsWindowVisible() );
#endif // else from (defined __EXT_MFC_NO_TABMDI_CTRL)
}

void CMainFrame::OnMditabsShowCtxHelp() 
{
#if (!defined __EXT_MFC_NO_TABMDI_CTRL)
	if( m_wndMdiTabs.GetTabWndStyle() & __ETWS_SHOW_BTN_HELP )
		m_wndMdiTabs.ModifyTabWndStyle( __ETWS_SHOW_BTN_HELP, 0, true );
	else
		m_wndMdiTabs.ModifyTabWndStyle( 0, __ETWS_SHOW_BTN_HELP, true );
#endif // (!defined __EXT_MFC_NO_TABMDI_CTRL)
}
void CMainFrame::OnUpdateMditabsShowCtxHelp(CCmdUI* pCmdUI) 
{
#if (defined __EXT_MFC_NO_TABMDI_CTRL)
	pCmdUI->Enable( FALSE );
#else
	pCmdUI->SetCheck(
		(m_wndMdiTabs.GetTabWndStyle() & __ETWS_SHOW_BTN_HELP) ? TRUE : FALSE
		);
	pCmdUI->Enable( m_wndMdiTabs.IsWindowVisible() );
#endif // else from (defined __EXT_MFC_NO_TABMDI_CTRL)
}

void CMainFrame::OnUistyle2000() 
{
	g_PaintManager.InstallPaintManager(
		new CExtPaintManager
		);
	RedrawWindow(
		NULL, NULL,
		RDW_INVALIDATE|RDW_ERASE|RDW_ALLCHILDREN|RDW_FRAME
		);
}
void CMainFrame::OnUpdateUistyle2000(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(
		! g_PaintManager->IsKindOf( RUNTIME_CLASS(CExtPaintManagerXP) )
		);
}

void CMainFrame::OnUistyleXp() 
{
	g_PaintManager.InstallPaintManager(
		new CExtPaintManagerXP
		);
	RedrawWindow(
		NULL, NULL,
		RDW_INVALIDATE|RDW_ERASE|RDW_ALLCHILDREN|RDW_FRAME
		);
}
void CMainFrame::OnUpdateUistyleXp(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(
		g_PaintManager->IsKindOf( RUNTIME_CLASS(CExtPaintManagerXP) )
		);
}
