/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Chart;
import com.java4less.rchart.LineDataSerie;
import com.java4less.rchart.LinePlotter;
import com.java4less.rchart.RMatrix;
import java.awt.Graphics;
import java.awt.Polygon;

public class CurvePlotter
extends LinePlotter {
    private static int d = 0;
    private static final int X = 0;
    private static final int Y = 1;
    public int segments = 24;

    private float b(int n, float f) {
        switch (n) {
            case -2: {
                return (((-f + (float)3) * f - (float)3) * f + 1.0f) / (float)6;
            }
            case -1: {
                return (((float)3 * f - (float)6) * f * f + (float)4) / (float)6;
            }
            case 0: {
                return ((((float)-3 * f + (float)3) * f + (float)3) * f + 1.0f) / (float)6;
            }
            case 1: {
                return f * f * f / (float)6;
            }
        }
        return 0.0f;
    }

    private int[] p(int n, float f, int[][] nArray) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = -2; i <= 1; ++i) {
            f2 += this.b(i, f) * (float)nArray[0][n + i];
            f3 += this.b(i, f) * (float)nArray[1][n + i];
        }
        int[] nArray2 = new int[]{Math.round(f2), Math.round(f3)};
        return nArray2;
    }

    private void plotLeastSquares(Graphics graphics, int[][] nArray, LineDataSerie lineDataSerie) {
        int n = nArray[0].length;
        int n2 = 1;
        RMatrix rMatrix = new RMatrix(n, n2 + 1);
        RMatrix rMatrix2 = new RMatrix(n, 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= n2; ++j) {
                rMatrix.setValue(i, j, Math.pow(nArray[0][i], j));
            }
            rMatrix2.setValue(i, 0, nArray[1][i]);
        }
        RMatrix rMatrix3 = rMatrix.transpose();
        RMatrix rMatrix4 = rMatrix3.mult(rMatrix);
        RMatrix rMatrix5 = rMatrix4.invert().mult(rMatrix3).mult(rMatrix2);
        double d = rMatrix5.getValue(0, 0);
        double d2 = rMatrix5.getValue(1, 0);
        int n3 = nArray[0][0];
        int n4 = (int)Math.round(d + (double)n3 * d2);
        int n5 = nArray[0][n - 1];
        int n6 = (int)Math.round(d + (double)n5 * d2);
        lineDataSerie.style.draw(graphics, n3, n4, n5, n6);
    }

    private void plotBSPLines(Graphics graphics, int[][] nArray, LineDataSerie lineDataSerie) {
        int n;
        int[][] nArray2 = new int[2][nArray[0].length + 2];
        for (n = 0; n < nArray[0].length; ++n) {
            nArray2[0][n + 1] = nArray[0][n];
            nArray2[1][n + 1] = nArray[1][n];
        }
        nArray2[0][0] = nArray2[0][1];
        nArray2[1][0] = nArray2[1][1];
        nArray2[0][nArray2[0].length - 1] = nArray[0][nArray[0].length - 1];
        nArray2[1][nArray2[0].length - 1] = nArray[1][nArray[0].length - 1];
        n = this.segments;
        int[] nArray3 = new int[n * (nArray2[0].length - 3) + 1 + 2];
        int[] nArray4 = new int[n * (nArray2[0].length - 3) + 1 + 2];
        Polygon polygon = new Polygon();
        int[] nArray5 = this.p(2, 0.0f, nArray2);
        nArray3[0] = nArray5[0];
        nArray4[0] = nArray5[1];
        int n2 = 1;
        for (int i = 2; i < nArray2[0].length - 1; ++i) {
            for (int j = 1; j <= n; ++j) {
                nArray5 = this.p(i, (float)j / (float)n, nArray2);
                nArray3[n2] = nArray5[0];
                nArray4[n2] = nArray5[1];
                ++n2;
            }
        }
        if (lineDataSerie.fillStyle != null) {
            nArray3[n2 + 1] = nArray3[0];
            nArray4[n2 + 1] = this.bottomCorners[1][0];
            nArray3[n2] = nArray3[n2 - 1];
            nArray4[n2] = this.bottomCorners[1][1];
            lineDataSerie.fillStyle.drawPolygon(graphics, nArray3, nArray4, n2 + 2);
        }
        lineDataSerie.style.drawOpenPolygon(graphics, nArray3, nArray4, n2);
    }

    private void plotCubicNatural(Graphics graphics, int[][] nArray, LineDataSerie lineDataSerie) {
        float[][] fArray = this.naturalCubic(nArray[0].length - 1, nArray[0]);
        float[][] fArray2 = this.naturalCubic(nArray[1].length - 1, nArray[1]);
        int n = this.segments;
        int[] nArray2 = new int[n * fArray[0].length + 1 + 2];
        int[] nArray3 = new int[n * fArray[0].length + 1 + 2];
        nArray2[0] = Math.round(this.evalPolynomial(fArray[0][0], fArray[1][0], fArray[2][0], fArray[3][0], 0.0f));
        nArray3[0] = Math.round(this.evalPolynomial(fArray2[0][0], fArray2[1][0], fArray2[2][0], fArray2[3][0], 0.0f));
        int n2 = 0;
        for (int i = 0; i < fArray[0].length; ++i) {
            for (int j = 1; j <= n; ++j) {
                float f = (float)j / (float)n;
                nArray2[n2] = Math.round(this.evalPolynomial(fArray[0][i], fArray[1][i], fArray[2][i], fArray[3][i], f));
                nArray3[n2] = Math.round(this.evalPolynomial(fArray2[0][i], fArray2[1][i], fArray2[2][i], fArray2[3][i], f));
                ++n2;
            }
        }
        if (lineDataSerie.fillStyle != null) {
            nArray2[n2 + 1] = this.bottomCorners[0][0];
            nArray3[n2 + 1] = this.bottomCorners[1][0];
            nArray2[n2] = this.bottomCorners[0][1];
            nArray3[n2] = this.bottomCorners[1][1];
            lineDataSerie.fillStyle.drawPolygon(graphics, nArray2, nArray3, n2 + 2);
        }
        lineDataSerie.style.drawOpenPolygon(graphics, nArray2, nArray3, n2);
    }

    protected void plotCurve(Graphics graphics, int[][] nArray, LineDataSerie lineDataSerie) {
        if (d != Chart.d()) {
            return;
        }
        if (nArray.length > 1) {
            if (lineDataSerie.lineType == 1) {
                this.plotCubicNatural(graphics, nArray, lineDataSerie);
            }
            if (lineDataSerie.lineType == 2) {
                this.plotBSPLines(graphics, nArray, lineDataSerie);
            }
            if (lineDataSerie.lineType == 3) {
                this.plotLeastSquares(graphics, nArray, lineDataSerie);
            }
        }
    }

    private float[][] naturalCubic(int n, int[] nArray) {
        int n2;
        float[] fArray = new float[n + 1];
        float[] fArray2 = new float[n + 1];
        float[] fArray3 = new float[n + 1];
        fArray[0] = 0.5f;
        for (n2 = 1; n2 < n; ++n2) {
            fArray[n2] = 1.0f / ((float)4 - fArray[n2 - 1]);
        }
        fArray[n] = 1.0f / ((float)2 - fArray[n - 1]);
        fArray2[0] = (float)(3 * (nArray[1] - nArray[0])) * fArray[0];
        for (n2 = 1; n2 < n; ++n2) {
            fArray2[n2] = ((float)(3 * (nArray[n2 + 1] - nArray[n2 - 1])) - fArray2[n2 - 1]) * fArray[n2];
        }
        fArray2[n] = ((float)(3 * (nArray[n] - nArray[n - 1])) - fArray2[n - 1]) * fArray[n];
        fArray3[n] = fArray2[n];
        for (n2 = n - 1; n2 >= 0; --n2) {
            fArray3[n2] = fArray2[n2] - fArray[n2] * fArray3[n2 + 1];
        }
        float[][] fArray4 = new float[4][n];
        for (n2 = 0; n2 < n; ++n2) {
            fArray4[0][n2] = nArray[n2];
            fArray4[1][n2] = fArray3[n2];
            fArray4[2][n2] = (float)(3 * (nArray[n2 + 1] - nArray[n2])) - (float)2 * fArray3[n2] - fArray3[n2 + 1];
            fArray4[3][n2] = (float)(2 * (nArray[n2] - nArray[n2 + 1])) + fArray3[n2] + fArray3[n2 + 1];
        }
        return fArray4;
    }

    private float evalPolynomial(float f, float f2, float f3, float f4, float f5) {
        return ((f4 * f5 + f3) * f5 + f2) * f5 + f;
    }
}

