/*
 * Decompiled with CFR 0.152.
 */
package stec.pos;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import stec.pos.ByteArray;
import stec.pos.Common;
import stec.pos.ObjectStoreEnumeration;
import stec.pos.ObjectStoreInstance;
import stec.pos.ObjectStoreMapper;
import stec.pos.ObjectStoreReference;
import stec.pos.POSException;
import stec.pos.VirtualFileHandle;
import stec.util.HashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ObjectStore {
    private static final String int = "Copyright (C) 2001-2005 Servertec. All rights reserved.";
    private static final String else = "Servertec";
    private static final String long = "Persistent Object Store";
    private static final String null;
    private static final String case = "1.4.1";
    private static final String do;
    private static final String if = "09/04/2005";
    private static final String for = "Open Source Release";
    public static boolean displayLogo;
    protected static final byte goto = 1;
    protected static final short void = 256;
    protected static final String byte = ".htstore";
    protected static final int try = 1;
    protected static final int char = 1;
    protected static HashMap new;
    protected static HashMap a;

    private static final void a() {
        if (displayLogo) {
            displayLogo = false;
            System.err.print(else);
            System.err.print(" (R) ");
            if (null == null) {
                System.err.print(long);
            } else {
                System.err.print(null);
            }
            System.err.print(" Version ");
            System.err.print(case);
            if (do != null) {
                System.err.print(do);
            }
            System.err.print(' ');
            System.err.print(if);
            System.err.print(' ');
            System.err.println(for);
            System.err.println(int);
            System.err.println();
        }
    }

    private static final void if() {
        ObjectStore.a();
    }

    public static final void create(String string, int n, int n2, int n3, int n4, boolean bl) throws IOException, IllegalArgumentException {
        ObjectStore.if();
        if (n < 1) {
            throw new IllegalArgumentException("Page length is too small: ".concat(String.valueOf(String.valueOf(n))));
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Lookup table page count is too small: ".concat(String.valueOf(String.valueOf(n2))));
        }
        if (n3 < n2 && n3 != -1) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Mapper maximum page count must be greater than or equal to lookup table page count: ").append(n3).append(": ").append(n2))));
        }
        if (n4 < n3 && n4 != -1) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Object store maximum page count must be greater than or equal to mapper maximum page count: ").append(n4).append(": ").append(n3))));
        }
        String string2 = Common.getUniqueID(string);
        ObjectStore.if(string2);
        try {
            if (a.containsKey(string2)) {
                throw new IOException("Object store is in use: ".concat(String.valueOf(String.valueOf(string))));
            }
            String string3 = String.valueOf(String.valueOf(string)).concat(byte);
            File file = new File(string3);
            if (file.exists()) {
                if (file.isDirectory()) {
                    throw new IOException("Object store must not be a directory: ".concat(String.valueOf(String.valueOf(string3))));
                }
                if (!bl) {
                    throw new IOException("Object store already exists: ".concat(String.valueOf(String.valueOf(string3))));
                }
                ObjectStore.a(string, file);
                if (ObjectStore.a(string, string3, file)) {
                    throw new IOException("Unable to delete existing object store: ".concat(String.valueOf(String.valueOf(string3))));
                }
            }
            ObjectStoreMapper.a(string, n2, n3, bl);
            VirtualFileHandle virtualFileHandle = new VirtualFileHandle(string3, "rw");
            try {
                byte[] byArray = new byte[23];
                ByteArray.setByte(byArray, 0, 1);
                ByteArray.setShort(byArray, 1, 256);
                ByteArray.setInt(byArray, 3, n);
                ByteArray.setInt(byArray, 7, 0);
                ByteArray.setInt(byArray, 11, n4);
                ByteArray.setInt(byArray, 15, -1);
                ByteArray.setInt(byArray, 19, 0);
                virtualFileHandle.seek(0L);
                virtualFileHandle.write(byArray, 0, byArray.length);
                if (n4 != -1) {
                    virtualFileHandle.seek((long)23 + ((long)n + 5L) * (long)n4 - 1L);
                    virtualFileHandle.writeByte(0);
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                virtualFileHandle.close();
                throw throwable;
            }
            virtualFileHandle.close();
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            ObjectStore.a(string2);
            throw throwable;
        }
        ObjectStore.a(string2);
    }

    private static final boolean a(String string, String string2, File file) throws IOException {
        if (!file.exists()) {
            return false;
        }
        VirtualFileHandle virtualFileHandle = new VirtualFileHandle(string2, "rw");
        try {
            byte[] byArray = new byte[23];
            virtualFileHandle.seek(0L);
            virtualFileHandle.readFully(byArray, 0, byArray.length);
            byte by = ByteArray.getByte(byArray, 0);
            if (by != 1) {
                throw new IOException("File is not a stec.pos.ObjectStore: ".concat(String.valueOf(String.valueOf(by))));
            }
            short s = ByteArray.getShort(byArray, 1);
            if (s != 256) {
                throw new IOException("Object store is not the correct version: ".concat(String.valueOf(String.valueOf(s))));
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            virtualFileHandle.close();
            throw throwable;
        }
        virtualFileHandle.close();
        if (!ObjectStoreMapper.for(string)) {
            throw new IOException("Mapper was not found: ".concat(String.valueOf(String.valueOf(string))));
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean exists(String string) throws IOException {
        boolean bl;
        String string2;
        block10: {
            boolean bl2;
            block9: {
                string2 = Common.getUniqueID(string);
                ObjectStore.if(string2);
                try {
                    String string3 = String.valueOf(String.valueOf(string)).concat(byte);
                    File file = new File(string3);
                    if (!file.exists()) {
                        bl2 = false;
                        Object var12_6 = null;
                        break block9;
                    }
                    if (file.isDirectory()) {
                        throw new IOException("Object store must not be a directory: ".concat(String.valueOf(String.valueOf(string3))));
                    }
                    VirtualFileHandle virtualFileHandle = new VirtualFileHandle(string3, "rw");
                    try {
                        byte[] byArray = new byte[23];
                        virtualFileHandle.seek(0L);
                        virtualFileHandle.readFully(byArray, 0, byArray.length);
                        byte by = ByteArray.getByte(byArray, 0);
                        if (by != 1) {
                            throw new IOException("File is not a stec.pos.ObjectStore: ".concat(String.valueOf(String.valueOf(by))));
                        }
                        short s = ByteArray.getShort(byArray, 1);
                        if (s != 256) {
                            throw new IOException("Object store is not the correct version: ".concat(String.valueOf(String.valueOf(s))));
                        }
                        Object var9_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        virtualFileHandle.close();
                        throw throwable;
                    }
                    virtualFileHandle.close();
                    if (!ObjectStoreMapper.for(string)) {
                        throw new IOException("Mapper was not found: ".concat(String.valueOf(String.valueOf(string))));
                    }
                    bl = true;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var12_8 = null;
                    ObjectStore.a(string2);
                    throw throwable;
                }
            }
            ObjectStore.a(string2);
            return bl2;
        }
        Object var12_7 = null;
        ObjectStore.a(string2);
        return bl;
    }

    private static final void a(String string, File file) throws IOException {
        try {
            if (!file.delete()) {
                throw new IOException("Object store could not be deleted: ".concat(String.valueOf(String.valueOf(string))));
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ObjectStoreMapper.a(string);
            throw throwable;
        }
        ObjectStoreMapper.a(string);
    }

    public static final void delete(String string) throws IOException, FileNotFoundException {
        String string2 = Common.getUniqueID(string);
        ObjectStore.if(string2);
        try {
            if (a.containsKey(string2)) {
                throw new IOException("Object store is in use: ".concat(String.valueOf(String.valueOf(string))));
            }
            String string3 = String.valueOf(String.valueOf(string)).concat(byte);
            File file = new File(string3);
            if (!file.exists()) {
                throw new FileNotFoundException("Object store does not exist: ".concat(String.valueOf(String.valueOf(string3))));
            }
            if (file.isDirectory()) {
                throw new IOException("Object store must not be a directory: ".concat(String.valueOf(String.valueOf(string3))));
            }
            try {
                if (!file.delete()) {
                    throw new IOException("Object store could not be deleted: ".concat(String.valueOf(String.valueOf(string3))));
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ObjectStoreMapper.a(string);
                throw throwable;
            }
            ObjectStoreMapper.a(string);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ObjectStore.a(string2);
            throw throwable;
        }
        ObjectStore.a(string2);
    }

    public static final ObjectStoreReference open(String string, boolean bl) throws IOException, FileNotFoundException {
        Object object;
        ObjectStore.if();
        String string2 = Common.getUniqueID(string);
        ObjectStore.if(string2);
        try {
            String string3 = String.valueOf(String.valueOf(string)).concat(byte);
            ObjectStoreInstance objectStoreInstance = (ObjectStoreInstance)a.get(string2);
            if (objectStoreInstance == null) {
                object = new File(string3);
                if (!((File)object).exists()) {
                    throw new FileNotFoundException("Object store does not exist: ".concat(String.valueOf(String.valueOf(string3))));
                }
                if (((File)object).isDirectory()) {
                    throw new IOException("Object store must not be a directory: ".concat(String.valueOf(String.valueOf(string3))));
                }
                objectStoreInstance = new ObjectStoreInstance();
                objectStoreInstance.a(string, bl);
                a.put(string2, objectStoreInstance);
            } else {
                if (bl || objectStoreInstance.n) {
                    throw new IOException("Object store is locked.");
                }
                objectStoreInstance.a(bl);
            }
            object = new ObjectStoreReference(string2, string, objectStoreInstance);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ObjectStore.a(string2);
            throw throwable;
        }
        ObjectStore.a(string2);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static final ObjectStoreReference do(String string) throws IOException {
        ObjectStoreReference objectStoreReference;
        String string2;
        block8: {
            ObjectStoreReference objectStoreReference2;
            block7: {
                ObjectStoreReference objectStoreReference3;
                block6: {
                    ObjectStore.if();
                    string2 = Common.getUniqueID(string);
                    ObjectStore.if(string2);
                    try {
                        String string3 = String.valueOf(String.valueOf(string)).concat(byte);
                        File file = new File(string3);
                        if (!file.exists()) {
                            throw new FileNotFoundException("Object store does not exist: ".concat(String.valueOf(String.valueOf(string3))));
                        }
                        if (file.isDirectory()) {
                            throw new IOException("Object store must not be a directory: ".concat(String.valueOf(String.valueOf(string3))));
                        }
                        if (a.containsKey(string2)) {
                            objectStoreReference3 = null;
                            Object var7_6 = null;
                            break block6;
                        }
                        ObjectStoreInstance objectStoreInstance = new ObjectStoreInstance();
                        if (!objectStoreInstance.a(string)) {
                            objectStoreReference2 = null;
                            break block7;
                        }
                        a.put(string2, objectStoreInstance);
                        objectStoreReference = new ObjectStoreReference(string2, string, objectStoreInstance);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        ObjectStore.a(string2);
                        throw throwable;
                    }
                }
                ObjectStore.a(string2);
                return objectStoreReference3;
            }
            Object var7_7 = null;
            ObjectStore.a(string2);
            return objectStoreReference2;
        }
        Object var7_8 = null;
        ObjectStore.a(string2);
        return objectStoreReference;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void rehash(String string, int n, int n2) throws IOException, FileNotFoundException, IllegalArgumentException {
        String string2;
        block20: {
            block19: {
                if (n < 1) {
                    throw new IllegalArgumentException("New lookup table page count is too small: ".concat(String.valueOf(String.valueOf(n))));
                }
                string2 = Common.getUniqueID(string);
                ObjectStore.if(string2);
                try {
                    ObjectStoreInstance objectStoreInstance;
                    File file;
                    String string3;
                    File file2;
                    block18: {
                        block17: {
                            if (a.containsKey(string2)) {
                                throw new IOException("Object store is in use: ".concat(String.valueOf(String.valueOf(string))));
                            }
                            String string4 = String.valueOf(String.valueOf(string)).concat(byte);
                            file2 = new File(string4);
                            if (!file2.exists()) {
                                throw new FileNotFoundException("Object store does not exist: ".concat(String.valueOf(String.valueOf(string4))));
                            }
                            if (file2.isDirectory()) {
                                throw new IOException("Object store must not be a directory: ".concat(String.valueOf(String.valueOf(string4))));
                            }
                            string3 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".org").append(".htmapper")));
                            file = new File(string3);
                            if (file.exists()) {
                                if (file.isDirectory()) {
                                    throw new IOException("Object store must not be a directory: ".concat(String.valueOf(String.valueOf(string3))));
                                }
                                if (!file.delete()) {
                                    throw new IOException("Unable to delete object store: ".concat(String.valueOf(String.valueOf(string3))));
                                }
                            }
                            objectStoreInstance = new ObjectStoreInstance();
                            objectStoreInstance.a(string, true);
                            try {
                                int n3 = objectStoreInstance.f();
                                if (n3 == n) {
                                    Object var12_10 = null;
                                    break block17;
                                }
                                String string5 = String.valueOf(String.valueOf(string)).concat(".rehash");
                                ObjectStoreMapper.a(string5, n, n2, true);
                                objectStoreInstance.a(string5, n);
                                break block18;
                            }
                            catch (Throwable throwable) {
                                Object var12_12 = null;
                                objectStoreInstance.null();
                                throw throwable;
                            }
                        }
                        objectStoreInstance.null();
                        Object var19_13 = null;
                        break block19;
                    }
                    Object var12_11 = null;
                    objectStoreInstance.null();
                    String string6 = String.valueOf(String.valueOf(string)).concat(".htmapper");
                    file2 = new File(string6);
                    if (!file2.renameTo(file)) {
                        throw new IOException("Unable to rename: ".concat(String.valueOf(String.valueOf(string6))));
                    }
                    String string7 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".rehash").append(".htmapper")));
                    File file3 = new File(string7);
                    if (!file3.renameTo(file2)) {
                        try {
                            file.renameTo(file2);
                            Object var17_21 = null;
                            throw new IOException("Unable to rename: ".concat(String.valueOf(String.valueOf(string7))));
                        }
                        catch (Throwable throwable) {
                            Object var17_22 = null;
                            throw new IOException("Unable to rename: ".concat(String.valueOf(String.valueOf(string7))));
                        }
                    }
                    if (!file.delete()) {
                        throw new IOException("Unable to delete: ".concat(String.valueOf(String.valueOf(string3))));
                    }
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var19_15 = null;
                    ObjectStore.a(string2);
                    throw throwable;
                }
            }
            ObjectStore.a(string2);
            return;
        }
        Object var19_14 = null;
        ObjectStore.a(string2);
    }

    public static final void pack(String string) throws IOException, FileNotFoundException {
        String string2 = Common.getUniqueID(string);
        ObjectStore.if(string2);
        try {
            if (a.containsKey(string2)) {
                throw new IOException("Object store is in use: ".concat(String.valueOf(String.valueOf(string))));
            }
            String string3 = String.valueOf(String.valueOf(string)).concat(byte);
            File file = new File(string3);
            if (!file.exists()) {
                throw new FileNotFoundException("Object store does not exist: ".concat(String.valueOf(String.valueOf(string3))));
            }
            if (file.isDirectory()) {
                throw new IOException("Object store must not be a directory: ".concat(String.valueOf(String.valueOf(string3))));
            }
            ObjectStoreInstance objectStoreInstance = new ObjectStoreInstance();
            objectStoreInstance.a(string, true);
            try {
                objectStoreInstance.c();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                objectStoreInstance.null();
                throw throwable;
            }
            objectStoreInstance.null();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ObjectStore.a(string2);
            throw throwable;
        }
        ObjectStore.a(string2);
    }

    public static final void expand(String string, int n, int n2) throws IOException, FileNotFoundException, IllegalArgumentException {
        if (n < 1 && n != -1) {
            throw new IllegalArgumentException("Mapper maximum page count must be at least 1 or -1: ".concat(String.valueOf(String.valueOf(n))));
        }
        if (n2 < 1 && n2 != -1) {
            throw new IllegalArgumentException("Keys store maximum page count must be at least 1 or -1: ".concat(String.valueOf(String.valueOf(n2))));
        }
        String string2 = Common.getUniqueID(string);
        ObjectStore.if(string2);
        try {
            if (a.containsKey(string2)) {
                throw new IOException("Object store is in use: ".concat(String.valueOf(String.valueOf(string))));
            }
            String string3 = String.valueOf(String.valueOf(string)).concat(byte);
            File file = new File(string3);
            if (!file.exists()) {
                throw new FileNotFoundException("Object store does not exist: ".concat(String.valueOf(String.valueOf(string3))));
            }
            if (file.isDirectory()) {
                throw new IOException("Object store must not be a directory: ".concat(String.valueOf(String.valueOf(string3))));
            }
            ObjectStoreInstance objectStoreInstance = new ObjectStoreInstance();
            objectStoreInstance.a(string, true);
            try {
                objectStoreInstance.a(n, n2);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                objectStoreInstance.null();
                throw throwable;
            }
            objectStoreInstance.null();
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            ObjectStore.a(string2);
            throw throwable;
        }
        ObjectStore.a(string2);
    }

    public static final boolean inUse(String string) throws IOException {
        boolean bl;
        String string2 = Common.getUniqueID(string);
        ObjectStore.if(string2);
        try {
            bl = a.containsKey(string2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ObjectStore.a(string2);
            throw throwable;
        }
        ObjectStore.a(string2);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void copy(String string, String string2, boolean bl) throws IOException, FileNotFoundException, IllegalArgumentException {
        Exception exception;
        boolean bl2;
        block19: {
            bl2 = false;
            exception = null;
            ObjectStoreReference objectStoreReference = ObjectStore.open(string, true);
            try {
                try {
                    block17: {
                        ObjectStore.create(string2, objectStoreReference.a.a, objectStoreReference.a.d.else, objectStoreReference.a.d.case, objectStoreReference.a.o, bl);
                        bl2 = true;
                        ObjectStoreReference objectStoreReference2 = ObjectStore.open(string2, true);
                        try {
                            try {
                                ObjectStoreEnumeration objectStoreEnumeration = objectStoreReference.keys();
                                while (objectStoreEnumeration.hasMoreElements()) {
                                    Object object = objectStoreEnumeration.nextElement();
                                    objectStoreReference2.put(object, objectStoreReference.get(object));
                                }
                                bl2 = false;
                            }
                            catch (Exception exception2) {
                                if (exception == null) {
                                    exception = exception2;
                                }
                                Object var10_12 = null;
                                objectStoreReference2.close();
                                break block17;
                            }
                            Object var10_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            objectStoreReference2.close();
                            throw throwable;
                        }
                        objectStoreReference2.close();
                    }
                    Object var12_15 = null;
                }
                catch (Exception exception3) {
                    if (exception == null) {
                        exception = exception3;
                    }
                    Object var12_16 = null;
                    objectStoreReference.close();
                    break block19;
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                objectStoreReference.close();
                throw throwable;
            }
            objectStoreReference.close();
        }
        if (exception == null) {
            return;
        }
        try {
            if (bl2) {
                ObjectStore.delete(string2);
            }
            Object var14_19 = null;
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new POSException(exception);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw new POSException(exception);
    }

    public static final void move(String string, String string2, boolean bl) throws IOException, FileNotFoundException, IllegalArgumentException {
        ObjectStore.copy(string, string2, bl);
        ObjectStore.delete(string);
    }

    protected static final boolean for(String string) {
        HashMap hashMap = new;
        synchronized (hashMap) {
            if (new.containsKey(string)) {
                boolean bl = false;
                return bl;
            }
            new.put(string, "");
            boolean bl = true;
            return bl;
        }
    }

    protected static final synchronized void if(String string) throws IOException {
        while (!ObjectStore.for(string)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                throw new POSException(interruptedException);
            }
        }
    }

    protected static final void a(String string) {
        HashMap hashMap = new;
        synchronized (hashMap) {
            new.remove(string);
        }
    }

    static {
        int = int;
        else = else;
        long = long;
        null = null;
        case = case;
        do = null;
        if = if;
        for = for;
        displayLogo = true;
        goto = 1;
        void = (short)256;
        byte = byte;
        try = 1;
        char = 1;
        new = new HashMap();
        a = new HashMap();
    }
}

