/*
 * Copyright (c) 2001-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public class RegistryExplorer_AboutDialog extends JDialog implements ActionListener
{
	JPanel panel1 = new JPanel();
	JPanel panel2 = new JPanel();
	JPanel insetsPanel1 = new JPanel();
	JPanel insetsPanel3 = new JPanel();
	JButton buttonOk = new JButton();
	JLabel label1 = new JLabel();
	JLabel label3 = new JLabel();
	BorderLayout borderLayout1 = new BorderLayout();
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	GridLayout gridLayout1 = new GridLayout();
	public RegistryExplorer_AboutDialog(Frame parent)
	{
		super(parent);
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		try
		{
			jbInit();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		pack();
	}
	/**Component initialization*/
	private void jbInit() throws Exception
	{
		//imageLabel.setIcon(new ImageIcon(RegistryExplorer_AboutDialog.class.getResource("[Your Image]")));
		this.setTitle("About Registry Explorer");
		this.addComponentListener(new java.awt.event.ComponentAdapter()
		{
			public void componentShown(ComponentEvent e)
			{
				this_componentShown(e);
			}
		});
		setResizable(false);
		this.setModal(true);
		panel1.setLayout(borderLayout1);
		panel2.setLayout(gridLayout1);
		label1.setText(RegistryExplorer.RELEASE_INFO);
		label3.setText(RegistryExplorer.COPYRIGHT_INFO);
		insetsPanel3.setBorder(BorderFactory.createEmptyBorder(10, 60, 10, 10));
		insetsPanel3.setLayout(gridBagLayout1);
		buttonOk.setText("Ok");
		buttonOk.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				buttonOk_keyTyped(e);
			}
		});
		buttonOk.addActionListener(this);
		panel2.add(insetsPanel3, null);
		insetsPanel3.add(label1,  new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 59, 0));
		insetsPanel3.add(label3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 59, 0));
		this.getContentPane().add(panel1, null);
		insetsPanel1.add(buttonOk, null);
		panel1.add(insetsPanel1, BorderLayout.SOUTH);
		panel1.add(panel2, BorderLayout.NORTH);
	}
	/**Overridden so we can exit when window is closed*/
	protected void processWindowEvent(WindowEvent e)
	{
		if (e.getID() == WindowEvent.WINDOW_CLOSING)
		{
			cancel();
		}
		super.processWindowEvent(e);
	}
	/**Close the dialog*/
	void cancel()
	{
		hide();
	}
	/**Close the dialog on a button event*/
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == buttonOk)
		{
			cancel();
		}
	}

	void buttonOk_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n')
		{
			cancel();
		}
		else if(chr == 27)
		{
			cancel();
		}
	}

	void this_componentShown(ComponentEvent e)
	{
		buttonOk.grabFocus();
	}
}