/*
 * Copyright (c) 2001-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Hashtable;

import java.io.PrintWriter;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

import stec.lang.DString;

import stec.iws.iws;
import stec.iws.Utils;

import stec.pos.Index;
import stec.pos.ObjectStore;
import stec.pos.IndexReference;
import stec.pos.ObjectStoreReference;
import stec.pos.ObjectStoreEnumeration;

public class SearchServlet extends HttpServlet
{
	String[] exclude_list;
	String template;
	Indexer indexer;
	long search_counter = 0;
	boolean shutdown;

	public void init(ServletConfig config) throws ServletException
	{
		super.init(config);

		shutdown = false;

		try
		{
			template = Utils.getItem(new BufferedReader(new FileReader(new File(iws.getBaseDirectory(), "./search/search.tf"))));
		}
		catch(Exception ex)
		{
			throw new ServletException("search.tf count not be found.", ex);
		}

		String basedir = iws.getBaseDirectory();

		String filename = Utils.concatPaths(basedir, "/search/results");
		File file = new File(filename);
		file.mkdir();

		filename = Utils.concatPaths(basedir, "/search/data");
		file = new File(filename);
		file.mkdir();

		String value = config.getInitParameter("interval");
		if(value != null)
		{
			int interval;

			try
			{
				interval = Integer.parseInt(value);
			}
			catch(NumberFormatException ex)
			{
				throw new ServletException("interval must be numeric: " + value);
			}

			String[] paths = ((stec.iws.ServletConfigImpl)config).getInitParameterValues("path");
			if(paths == null)
			{
				throw new ServletException("path must be specified.");
			}

			Hashtable htpaths = new Hashtable();

			String relative_path;
			String absolute_path;

			ServletContext servlet_context = getServletContext();

			int count = paths.length;

			for(int i = 0; i < count; i++)
			{
				relative_path = paths[i];
				absolute_path = servlet_context.getRealPath(relative_path);

				file = new File(absolute_path);
				if(!file.isDirectory())
				{
					throw new ServletException("path is not a directory: " + value);
				}

				htpaths.put(relative_path, absolute_path);
			}

			String[] exclude_list = ((stec.iws.ServletConfigImpl)config).getInitParameterValues("exclude");
			if(exclude_list != null)
			{
				count = exclude_list.length;

				for(int i = 0; i < count; i++)
				{
					exclude_list[i] = exclude_list[i].toLowerCase();
				}
			}

			this.exclude_list = exclude_list;

			String[] parsers = ((stec.iws.ServletConfigImpl)config).getInitParameterValues("parser");
			if(parsers == null)
			{
				throw new ServletException("parser must be specified.");
			}

			int document_count;

			value = config.getInitParameter("document_count");
			if(value == null)
			{
				value = "1000";
			}

			try
			{
				document_count = Integer.parseInt(value);
			}
			catch(NumberFormatException ex)
			{
				throw new ServletException("document_count is not numeric: " + value);
			}

			if(document_count < 1)
			{
				throw new ServletException("document_count must be at least one: " + value);
			}

			int word_count;

			value = config.getInitParameter("word_count");
			if(value == null)
			{
				value = "1000";
			}

			try
			{
				word_count = Integer.parseInt(value);
			}
			catch(NumberFormatException ex)
			{
				throw new ServletException("word_count is not numeric: " + value);
			}

			if(word_count < 1)
			{
				throw new ServletException("word_count must be at least one: " + value);
			}

			try
			{
				indexer = new Indexer(interval, htpaths, parsers, exclude_list, document_count, word_count);
			}
			catch(Exception ex)
			{
				throw new ServletException(ex);
			}
		}
	}

	public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		response.setContentType("text/html");

		PrintWriter writer = response.getWriter();

		String document = new String(template);

		String search_criteria = request.getParameter("search_criteria");
		if(search_criteria == null)
		{
			search_criteria = "";
		}

		document = DString.replace(document, "%search_criteria%", search_criteria);

		String search_method = request.getParameter("search_method");
		if(search_method == null)
		{
			search_method = "any";
		}

		if(search_method.equalsIgnoreCase("all"))
		{
			document = DString.replace(document, "%search_method_any%", "");
			document = DString.replace(document, "%search_method_all%", "CHECKED");
		}
		else
		{
			document = DString.replace(document, "%search_method_any%", "CHECKED");
			document = DString.replace(document, "%search_method_all%", "");
		}

		String value = request.getParameter("maximum_results");
		if(value == null)
		{
			value = "10";
		}

		int maximum_results;

		try
		{
			maximum_results = Integer.parseInt(value);
		}
		catch(NumberFormatException ex)
		{
			maximum_results = 10;
		}

		switch(maximum_results)
		{
			case -1:
				document = DString.replace(document, "%maximum_results_10%", "");
				document = DString.replace(document, "%maximum_results_25%", "");
				document = DString.replace(document, "%maximum_results_50%", "");
				document = DString.replace(document, "%maximum_results_100%", "");
				document = DString.replace(document, "%maximum_results_all%", "SELECTED");
				break;

			case 100:
				document = DString.replace(document, "%maximum_results_10%", "");
				document = DString.replace(document, "%maximum_results_25%", "");
				document = DString.replace(document, "%maximum_results_50%", "");
				document = DString.replace(document, "%maximum_results_100%", "SELECTED");
				document = DString.replace(document, "%maximum_results_all%", "");
				break;

			case 50:
				document = DString.replace(document, "%maximum_results_10%", "");
				document = DString.replace(document, "%maximum_results_25%", "");
				document = DString.replace(document, "%maximum_results_50%", "SELECTED");
				document = DString.replace(document, "%maximum_results_100%", "");
				document = DString.replace(document, "%maximum_results_all%", "");
				break;

			case 25:
				document = DString.replace(document, "%maximum_results_10%", "");
				document = DString.replace(document, "%maximum_results_25%", "SELECTED");
				document = DString.replace(document, "%maximum_results_50%", "");
				document = DString.replace(document, "%maximum_results_100%", "");
				document = DString.replace(document, "%maximum_results_all%", "");
				break;

			default:
				document = DString.replace(document, "%maximum_results_10%", "SELECTED");
				document = DString.replace(document, "%maximum_results_25%", "");
				document = DString.replace(document, "%maximum_results_50%", "");
				document = DString.replace(document, "%maximum_results_100%", "");
				document = DString.replace(document, "%maximum_results_all%", "");
		}

		int offset = document.indexOf("%results%");

		writer.print(document.substring(0, offset));

		search_criteria = search_criteria.trim();
		if(search_criteria.length() > 0)
		{
			int count = DString.dcount(search_criteria, ' ');

			String[] twords = new String[count];

			int o = 0;

			String word;

			for(int i = 0; i < count; i++)
			{
				word = DString.extract(search_criteria, ' ', i).toLowerCase();
				if(!exclude(word))
				{
					twords[o++] = word;
				}
			}

			String[] words = new String[o];

			System.arraycopy(twords, 0, words, 0, o);

			try
			{
				search(writer, (search_method.equalsIgnoreCase("all")) ? true : false, words, maximum_results);
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
				ex.printStackTrace(writer);
			}
		}

		writer.print(document.substring(offset + "%results%".length()));
	}

	private void search(PrintWriter writer, boolean all, String[] words, int maximum_results) throws Exception
	{
		if(shutdown)
		{
			return;
		}

		int counter;
		Integer icounter;
		Integer word_id;
		Integer doc_id;
		Object obj;
		long uid = System.currentTimeMillis() + search_counter++;

		String basedir = iws.getBaseDirectory();

		ObjectStoreReference words_store_reference = null;
		IndexReference words_index_reference = null;

		try
		{
			String filename = Utils.concatPaths(basedir, "/search/data/words");
			words_store_reference = ObjectStore.open(filename, false);

			filename = Utils.concatPaths(basedir, "/search/data/words");
			words_index_reference = Index.open(filename, false);

			String results_filename = Utils.concatPaths(basedir, "/search/results/" + uid);
			ObjectStore.create(results_filename, 32, 1000, -1, -1, true);

			try
			{
				ObjectStoreReference results_reference = ObjectStore.open(results_filename, false);

				try
				{
					String word;

					int word_count = words.length;

					for(int i = 0; i < word_count; i++)
					{
						if(shutdown)
						{
							return;
						}

						word = words[i];

						obj = words_store_reference.get(word);
						if(obj != null)
						{
							word_id = (Integer)obj;

							if(words_index_reference.setCurrentKey(word_id))
							{
								obj = words_index_reference.getCurrentValue();

								do
								{
									if(shutdown)
									{
										return;
									}

									doc_id = (Integer)obj;

									obj = results_reference.get(doc_id);
									if(obj == null)
									{
										counter = 0;
									}
									else
									{
										counter = ((Integer)obj).intValue();
									}

									icounter = new Integer(counter + 1);

									results_reference.put(doc_id, icounter);
								}
								while((obj = words_index_reference.nextValue(false)) != null);
							}
						}
					}

					if(results_reference.size() > 0)
					{
						Index.create(results_filename, -1, -1, "java.lang.Integer", -1, -1, "java.lang.Integer", -1, -1, null, false, false, true, 2, -1, null, false);

						try
						{
							IndexReference results_index_reference = Index.open(results_filename, false);

							try
							{
								int result_count = 0;


								ObjectStoreEnumeration e = results_reference.keys();
								while(e.hasMoreElements())
								{
									if(shutdown)
									{
										return;
									}

									result_count++;

									if(maximum_results != -1 && result_count > maximum_results)
									{
										break;
									}

									doc_id = (Integer)e.nextElement();
									icounter = (Integer)results_reference.get(doc_id);

									if(all)
									{
										if(icounter.intValue() == word_count)
										{
											results_index_reference.add(icounter, doc_id);
										}
									}
									else
									{
										results_index_reference.add(icounter, doc_id);
									}
								}

								results_index_reference.first();

								filename = Utils.concatPaths(basedir, "/search/data/docids");
								ObjectStoreReference docids_store_reference = ObjectStore.open(filename, false);

								try
								{
									result_count = results_index_reference.size();

									if(result_count == 1)
									{
										writer.println(result_count + " result was found.");
									}
									else
									{
										writer.println(result_count + " results were found.");
									}

									writer.println("<p>");

									while(results_index_reference.next())
									{
										if(shutdown)
										{
											return;
										}

										icounter = (Integer)results_index_reference.getCurrentKey();

										doc_id = (Integer)results_index_reference.getCurrentValue();

										filename = (String)docids_store_reference.get(doc_id);

										writer.println("<a href=\"." + filename + "\">" + filename + "</a><br>");
									}
								}
								finally
								{
									docids_store_reference.close();
								}
							}
							finally
							{
								results_index_reference.close();
							}
						}
						finally
						{
							Index.delete(results_filename);
						}
					}
					else
					{
						writer.println("Criteria could not be found.");
					}
				}
				finally
				{
					results_reference.close();
				}
			}
			finally
			{
				ObjectStore.delete(results_filename);
			}
		}
		finally
		{
			if(words_index_reference != null)
			{
				try
				{
					words_index_reference.close();
				}
				catch(Exception ex) {}
			}

			if(words_store_reference != null)
			{
				try
				{
					words_store_reference.close();
				}
				catch(Exception ex) {}
			}
		}
	}

	public void destroy()
	{
		shutdown = true;

		if(indexer != null)
		{
			try
			{
				indexer.shutdown();
			}
			finally
			{
				indexer = null;
			}
		}
	}

	private boolean exclude(String word)
	{
		int count = exclude_list.length;

		for(int i = 0; i < count; i++)
		{
			if(exclude_list[i].equals(word))
			{
				return true;
			}
		}

		return false;
	}
}