
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{              Tool controls               }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_ctrls;

interface

{$I fr.inc}

uses
  SysUtils, Classes, Types, QControls, QGraphics, QButtons, QStdCtrls, QExtCtrls;

type
  TfrSpeedButton = class(TSpeedButton)
  private
    FGrayed: Boolean;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property GrayedInactive: Boolean read FGrayed write FGrayed;
  end;

  TfrComboBox = class(TComboBox)
  end;

  TfrFontComboBox = class(TComboBox)
  private
    FTrueTypeBMP: TBitmap;
  protected
    function DrawItem(Index: Integer; ARect: TRect;
      State: TOwnerDrawState): Boolean; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Loaded; override;
  end;

  TfrComboEdit = class(TEdit)
  private
    FPanel: TWinControl;
    FButton: TfrSpeedButton;
    FButtonEnabled: Boolean;
    FOnButtonClick: TNotifyEvent;
    function GetGlyph: TBitmap;
    procedure SetGlyph(Value: TBitmap);
    function GetButtonHint: String;
    procedure SetButtonHint(Value: String);
    procedure SetButtonEnabled(Value: Boolean);
    procedure ButtonClick(Sender: TObject);
  public
    constructor Create(AOwner: TComponent); override;
    procedure Resize; override;
    procedure EnabledChanged; override;
  published
    property Glyph: TBitmap read GetGlyph write SetGlyph;
    property ButtonEnabled: Boolean read FButtonEnabled write SetButtonEnabled default True;
    property ButtonHint: String read GetButtonHint write SetButtonHint;
    property OnButtonClick: TNotifyEvent read FOnButtonClick write FOnButtonClick;
  end;

procedure frDrawTransparent(Canvas: TCanvas; x, y: Integer; bmp: TBitmap);


implementation

uses QForms, QImgList, QDialogs;

{$R *.res}


procedure frDrawTransparent(Canvas: TCanvas; x, y: Integer; bmp: TBitmap);
var
  img: TImageList;
begin
  img := TImageList.Create(nil);
  img.Width := bmp.Width;
  img.Height := bmp.Height;
  img.AddMasked(bmp, bmp.TransparentColor);
  img.Draw(Canvas, x, y, 0);
  img.Clear;
  img.Free;
end;


{ TfrSpeedButton }

constructor TfrSpeedButton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Transparent := False;
end;


{ TfrComboEdit }

constructor TfrComboEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Height := 21;
  Cursor := crIBeam;
  FPanel := TPanel.Create(Self);
  FPanel.Parent := Self;
  FPanel.SetBounds(Width - Height + 2, 2, Height - 4, Height - 4);
  FButton := TfrSpeedButton.Create(Self);
  FButton.Parent := FPanel;
  FButton.SetBounds(0, 0, FPanel.Width, FPanel.Height);
  FButton.OnClick := ButtonClick;
  FButtonEnabled := True;
end;

procedure TfrComboEdit.Resize;
begin
  inherited;
  if FPanel = nil then Exit;
  FPanel.SetBounds(Width - Height + 2, 2, Height - 4, Height - 4);
end;

procedure TfrComboEdit.EnabledChanged;
begin
  inherited;
  if FButton = nil then Exit;
  FButton.Enabled := Enabled;
end;

function TfrComboEdit.GetGlyph: TBitmap;
begin
  Result := FButton.Glyph;
end;

procedure TfrComboEdit.SetGlyph(Value: TBitmap);
begin
  FButton.Glyph := Value;
end;

function TfrComboEdit.GetButtonHint: String;
begin
  Result := FButton.Hint;
end;

procedure TfrComboEdit.SetButtonHint(Value: String);
begin
  FButton.Hint := Value;
end;

procedure TfrComboEdit.SetButtonEnabled(Value: Boolean);
begin
  FButtonEnabled := Value;
  FButton.Enabled := Value;
end;

procedure TfrComboEdit.ButtonClick(Sender: TObject);
begin
  SetFocus;
  if Assigned(FOnButtonClick) then
    FOnButtonClick(Self);
end;


{ TfrFontComboBox }

constructor TfrFontComboBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FTrueTypeBMP := TBitmap.Create;
  FTrueTypeBMP.LoadFromResourceName(HInstance, 'FTRUETYPE_FNT');
  Style := csOwnerDrawFixed;
  DropDownCount := 12;
  Width := 150;
  Sorted := True;
end;

destructor TfrFontComboBox.Destroy;
begin
  FTrueTypeBMP.Free;
  inherited Destroy;
end;

procedure TfrFontComboBox.Loaded;
begin
  inherited;
  Items.Assign(Screen.Fonts);
end;

function TfrFontComboBox.DrawItem(Index: Integer; ARect: TRect;
  State: TOwnerDrawState): Boolean;
var
  Bitmap: TBitmap;
  BmpWidth: Integer;
begin
  with Canvas do
  begin
    BmpWidth := 15;
    if odFocused in State then
      FillRect(ARect);
    Bitmap := FTrueTypeBMP;
    if Bitmap <> nil then
    begin
      BmpWidth := Bitmap.Width;
      frDrawTransparent(Canvas, ARect.Left + 1, ARect.Top + 1, Bitmap);
    end;
    ARect.Left := ARect.Left + BmpWidth + 2;
    if not Focused then
      Font.Color := clBlack;
    TextOut(ARect.Left, ARect.Top, Items[Index]);
  end;
  Result := True;
end;


end.

