
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{             Report options               }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_dopt;

interface

{$I fr.inc}

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, fr_const, QExtCtrls, fr_ctrls, QComCtrls;

type
  TfrDocOptForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Image1: TImage;
    General: TTabSheet;
    Documents: TTabSheet;
    GroupBox1: TGroupBox;
    CB1: TCheckBox;
    LB1: TListBox;
    GroupBox2: TGroupBox;
    CB2: TCheckBox;
    Prop: TPageControl;
    GroupBox3: TGroupBox;
    L1: TLabel;
    E1: TEdit;
    L2: TLabel;
    E2: TEdit;
    GroupBox4: TGroupBox;
    E3: TEdit;
    L3: TLabel;
    E4: TEdit;
    L7: TLabel;
    E5: TEdit;
    L8: TLabel;
    E6: TEdit;
    L9: TLabel;
    GroupBox5: TGroupBox;
    L4: TLabel;
    M1: TMemo;
    LM2: TLabel;
    L6: TLabel;
    LM1: TLabel;
    L5: TLabel;
    CB3: TCheckBox;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LB1DrawItem(Sender: TObject; Index: Integer; ARect: TRect;
      State: TOwnerDrawState; var Handled: Boolean);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
  end;


implementation

{$R *.xfm}

uses fr_class, fr_prntr, fr_utils;


procedure TfrDocOptForm.FormActivate(Sender: TObject);
begin
  LB1.Items.Assign(Prn.Printers);
  LB1.ItemIndex := Prn.PrinterIndex;
end;

procedure TfrDocOptForm.Localize;
begin
  Font.Name := frDefaultFont;

  Caption := S53370;
  GroupBox1.Caption := S53371;
  CB1.Caption := S53372;
  GroupBox2.Caption := S53373;
  CB2.Caption := S53374;
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);

  General.Caption := (S55656);
  CB3.Caption := (S55657);
  Documents.Caption := (S55658);
  GroupBox3.Caption := (S55659);
  L1.Caption := (S55660);
  L2.Caption := (S55661);
  GroupBox4.Caption := (S55662);
  L3.Caption := (S55663);
  L7.Caption := (S55664);
  L8.Caption := (S55665);
  L9.Caption := (S55666);
  GroupBox5.Caption := (S55667);
  L4.Caption := (S55668);
  L6.Caption := (S55669);
  L5.Caption := (S55670);


end;

procedure TfrDocOptForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

procedure TfrDocOptForm.LB1DrawItem(Sender: TObject; Index: Integer;
  ARect: TRect; State: TOwnerDrawState; var Handled: Boolean);
var
  r: TRect;
begin
  r := ARect;
  r.Right := r.Left + 18;
  r.Bottom := r.Top + 16;
  OffsetRect(r, 2, 0);
  with LB1.Canvas do
  begin
    FillRect(ARect);
    frDrawTransparent(LB1.Canvas, r.Left, r.Top, Image1.Picture.Bitmap);
    TextOut(ARect.Left + 24, ARect.Top + 1, LB1.Items[Index]);
  end;
end;


end.

