
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{             Designer options             }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_dsopt;

interface

{$I fr.inc}

uses
  SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QComCtrls, QExtCtrls, fr_ctrls;

type
  TfrDesOptionsForm = class(TForm)
    PageControl1: TPageControl;
    Tab1: TTabSheet;
    GroupBox1: TGroupBox;
    CB1: TCheckBox;
    CB2: TCheckBox;
    GroupBox3: TGroupBox;
    RB6: TRadioButton;
    RB7: TRadioButton;
    RB8: TRadioButton;
    GroupBox4: TGroupBox;
    RB1: TRadioButton;
    RB2: TRadioButton;
    RB3: TRadioButton;
    Button1: TButton;
    Button2: TButton;
    GroupBox5: TGroupBox;
    CB4: TCheckBox;
    CB5: TCheckBox;
    GroupBox6: TGroupBox;
    RB9: TRadioButton;
    RB10: TRadioButton;
    RB11: TRadioButton;
    Tab2: TTabSheet;
    GroupBox7: TGroupBox;
    ERB1: TRadioButton;
    ERB2: TRadioButton;
    Label2: TLabel;
    TextFontNameCB: TfrFontComboBox;
    Label3: TLabel;
    TextFontSizeCB: TfrComboBox;
    SampleTextPanel: TPanel;
    GroupBox8: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    ScriptFontNameCB: TfrFontComboBox;
    ScriptFontSizeCB: TfrComboBox;
    SampleScriptPanel: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure ERB1Click(Sender: TObject);
    procedure TextFontNameCBChange(Sender: TObject);
    procedure ScriptFontNameCBChange(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
  end;


implementation

{$R *.xfm}

uses fr_class, fr_utils, fr_const, fr_dock;


procedure TfrDesOptionsForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53280;
  Tab1.Caption := S53281;
  GroupBox1.Caption := S53282;
  GroupBox3.Caption := S53284;
  GroupBox4.Caption := S53285;
  GroupBox5.Caption := S53297;
  GroupBox6.Caption := S53300;
  CB1.Caption := S53286;
  CB2.Caption := S53287;
  CB4.Caption := S53298;
  CB5.Caption := S53299;
  RB1.Caption := S53289;
  RB2.Caption := S53290;
  RB3.Caption := S53291;
  RB6.Caption := S53294;
  RB7.Caption := S53295;
  RB8.Caption := S53296;
  RB9.Caption := S53301;
  RB10.Caption := S53302;
  RB11.Caption := S53303;

  Tab2.Caption := S53304;
  GroupBox7.Caption := S53305;
  GroupBox8.Caption := S53310;
  ERB1.Caption := S53306;
  ERB2.Caption := S53307;
  Label2.Caption := S53308;
  Label3.Caption := S53309;
  Label4.Caption := S53308;
  Label5.Caption := S53309;

  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrDesOptionsForm.FormCreate(Sender: TObject);
var
  Nm: String;
begin
  Localize;
  Nm := rsForm + frDesigner.ClassName;
  TextFontNameCB.ItemIndex := TextFontNameCB.Items.IndexOf(frIni.ReadString(Nm, 'TextFontName', 'Arial'));
  TextFontSizeCB.Text := frIni.ReadString(Nm, 'TextFontSize', '10');
  ScriptFontNameCB.Text := frIni.ReadString(Nm, 'ScriptFontName', 'Courier New');
  ScriptFontSizeCB.Text := frIni.ReadString(Nm, 'ScriptFontSize', '10');
  ERB1.Checked := frIni.ReadBool(Nm, 'UseDefaultFont', True);
  ERB2.Checked := not ERB1.Checked;

  ERB1Click(nil);
  TextFontNameCBChange(nil);
  ScriptFontNameCBChange(nil);
end;

procedure TfrDesOptionsForm.FormHide(Sender: TObject);
var
  Nm: String;
begin
  if ModalResult = mrOk then
  begin
    Nm := rsForm + frDesigner.ClassName;
    frIni.WriteString(Nm, 'TextFontName', TextFontNameCB.Text);
    frIni.WriteString(Nm, 'TextFontSize', TextFontSizeCB.Text);
    frIni.WriteString(Nm, 'ScriptFontName', ScriptFontNameCB.Text);
    frIni.WriteString(Nm, 'ScriptFontSize', ScriptFontSizeCB.Text);
    frIni.WriteBool(Nm, 'UseDefaultFont', ERB1.Checked);
  end;
end;

procedure TfrDesOptionsForm.ERB1Click(Sender: TObject);
begin
  frEnableControls([Label2, TextFontNameCB, Label3, TextFontSizeCB], ERB2.Checked);
end;

procedure TfrDesOptionsForm.TextFontNameCBChange(Sender: TObject);
begin
  SampleTextPanel.Font.Charset := TFontCharset(frCharset);
  SampleTextPanel.Font.Name := TextFontNameCB.Text;
  SampleTextPanel.Font.Size := StrToInt(TextFontSizeCB.Text);
end;

procedure TfrDesOptionsForm.ScriptFontNameCBChange(Sender: TObject);
begin
  SampleScriptPanel.Font.Charset := TFontCharset(frCharset);
  SampleScriptPanel.Font.Name := ScriptFontNameCB.Text;
  SampleScriptPanel.Font.Size := StrToInt(ScriptFontSizeCB.Text);
end;

end.

