
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{              Format editor               }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_fmted;

interface

{$I fr.inc}

uses
  SysUtils, Classes, QGraphics, QControls, QForms, QDialogs, QStdCtrls, QExtCtrls;

type
  TfrFmtForm = class(TForm)
    GroupBox2: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    CatLB: TListBox;
    TypeLB: TListBox;
    Label3: TLabel;
    FormatEdit: TEdit;
    Label1: TLabel;
    DecEdit: TEdit;
    Label2: TLabel;
    SplEdit: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure SplEditEnter(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CatLBClick(Sender: TObject);
    procedure TypeLBClick(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
  private
    { Private declarations }
    procedure ShowPanels;
    procedure Localize;
  public
    { Public declarations }
    Format: Integer;
    FormatStr: String;
  end;


implementation

{$R *.xfm}

uses fr_class, fr_const, fr_utils;

const
  CategCount = 5;
  CategNames: array[0..CategCount - 1, 0..5] of string =
    ((SCateg1, SFormat11, SFormat12, SFormat13, SFormat14, SFormat15),
     (SCateg2, SFormat21, SFormat22, SFormat23, SFormat24, SFormat25),
     (SCateg3, SFormat31, SFormat32, SFormat33, SFormat34, SFormat35),
     (SCateg4, SFormat41, SFormat42, SFormat43, SFormat44, SFormat45),
     (SCateg5, SFormat51, SFormat52, SFormat53, SFormat54, SFormat55));


{$WARNINGS OFF}
procedure TfrFmtForm.FormActivate(Sender: TObject);
var
  i: Integer;
begin
  CatLB.Items.Clear;
  for i := 0 to CategCount - 1 do
    CatLB.Items.Add(CategNames[i, 0]);
  CatLB.ItemIndex := (Format and $0F000000) div $01000000;
  CatLBClick(nil);
  TypeLB.ItemIndex := (Format and $00FF0000) div $00010000;
  ShowPanels;
end;

procedure TfrFmtForm.FormDeactivate(Sender: TObject);
var
  c: WideChar;
begin
  if ModalResult = mrOk then
  begin
    Format := CatLB.ItemIndex * $01000000 + TypeLB.ItemIndex * $00010000 +
      StrToIntDef(DecEdit.Text, 0) * $00000100;
    c := ',';
    if SplEdit.Text <> '' then
      c := SplEdit.Text[1];
    Format := Format + Ord(c);
    if FormatEdit.Enabled then
      FormatStr := FormatEdit.Text;
  end;
end;

procedure TfrFmtForm.ShowPanels;
begin
  frEnableControls([Label1, Label2, DecEdit, SplEdit], CatLB.ItemIndex = 1);
  if DecEdit.Enabled then
  begin
    DecEdit.Text := IntToStr((Format and $0000FF00) div $00000100);
    SplEdit.Text := Chr(Format and $000000FF);
  end
  else
  begin
    DecEdit.Text := '';
    SplEdit.Text := '';
  end;

  frEnableControls([Label3, FormatEdit], TypeLB.ItemIndex = 4);
  if FormatEdit.Enabled then
    FormatEdit.Text := FormatStr else
    FormatEdit.Text := '';
end;

procedure TfrFmtForm.CatLBClick(Sender: TObject);
var
  i: Integer;
  s: String;
begin
  TypeLB.Items.Clear;
  for i := 1 to 5 do
  begin
    s := CategNames[CatLB.ItemIndex, i];
    if s <> '' then
      TypeLB.Items.Add(s);
  end;
  TypeLB.ItemIndex := 0;
  TypeLBClick(nil);
end;

procedure TfrFmtForm.TypeLBClick(Sender: TObject);
begin
  ShowPanels;
end;

procedure TfrFmtForm.SplEditEnter(Sender: TObject);
begin
  SplEdit.SelectAll;
end;
{$WARNINGS ON}

procedure TfrFmtForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53420;
  Label1.Caption := S53422;
  Label2.Caption := S53423;
  Label3.Caption := S53424;
  Button1.Caption := SOk;
  Button2.Caption := SCancel;
end;

procedure TfrFmtForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

end.
