/*
 * Decompiled with CFR 0.152.
 */
package com.makeLogic.utils;

import com.makeLogic.utils.FileMenu;
import com.makeLogic.utils.InternalFrameClosingHandler;
import com.makeLogic.utils.MLInternalFrame;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class RecentFilesMenuItem
extends JMenu
implements ActionListener {
    Container container;
    Hashtable tempOpenHash;
    Vector tempVector;
    Hashtable internalFramesOpenFileNames;
    Vector recentFileEntries;

    RecentFilesMenuItem(Container container) {
        super("Recent Files");
        this.setMnemonic('F');
        this.addActionListener(this);
        this.container = container;
    }

    public void setKeyStrokeForRecentFilesMenuItem(char recentFilesMenuItemKeyStroke) {
        this.setMnemonic(recentFilesMenuItemKeyStroke);
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            String filePathString = evt.getActionCommand();
            File selectedFile = new File(filePathString);
            DataInputStream inputStream = new DataInputStream(new FileInputStream(filePathString));
            StringBuffer stringBuffer = new StringBuffer((int)selectedFile.length());
            String tempText = "";
            while ((tempText = inputStream.readLine()) != null) {
                stringBuffer.append(tempText + "\n");
            }
            MLInternalFrame internalFrame = new MLInternalFrame(this.container, selectedFile, stringBuffer);
            JViewport jvp = (JViewport)((JScrollPane)internalFrame.getContentPane().getComponent(0)).getComponent(0);
            JEditorPane jep = (JEditorPane)jvp.getComponent(0);
            jep.setCaretPosition(0);
            this.internalFramesOpenFileNames = FileMenu.getInternalFramesOpenFileNamesHashTable();
            this.recentFileEntries = FileMenu.getRecentFileEntriesVector();
            this.internalFramesOpenFileNames.put(internalFrame, selectedFile.getAbsolutePath());
            this.recentFileEntries.add(selectedFile.getAbsolutePath());
            internalFrame.addInternalFrameListener(new InternalFrameClosingHandler(this.container, this.internalFramesOpenFileNames, internalFrame));
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(null, fnfe.getMessage(), "MakeLogic:FileMenu", 0);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, ioe.getMessage(), "MakeLogic:FileMenu", 0);
        }
    }
}

