/*
 * Decompiled with CFR 0.152.
 */
package com.makeLogic.utils;

import com.makeLogic.utils.FileMenu;
import com.makeLogic.utils.MLInternalFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;

public class SaveAsMenuItem
extends JMenuItem
implements ActionListener {
    Container container;
    MLInternalFrame internalFrame;

    SaveAsMenuItem(Container container) {
        super("SaveAs");
        this.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        this.addActionListener(this);
        this.container = container;
    }

    public void setKeyStrokeForSaveAsMenuItem(KeyStroke saveAsMenuItemKeyStroke) {
        this.setAccelerator(saveAsMenuItemKeyStroke);
    }

    public void actionPerformed(ActionEvent evt) {
        Hashtable tempOpenMenuHash = FileMenu.getInternalFramesOpenFileNamesHashTable();
        Hashtable tempNewMenuHash = FileMenu.getInternalFramesNewFileNamesHashTable();
        Vector recentFileEntries = FileMenu.getRecentFileEntriesVector();
        Component[] componentInternalFrames = this.container.getComponents();
        MLInternalFrame[] internalFrames = new MLInternalFrame[componentInternalFrames.length];
        int i = 0;
        while (i < internalFrames.length) {
            try {
                internalFrames[i] = (MLInternalFrame)componentInternalFrames[i];
            }
            catch (ClassCastException cce) {
                JOptionPane.showMessageDialog(null, cce.getMessage(), "MakeLogic:FileMenu", 0);
            }
            if (internalFrames[i].isSelected()) {
                int response;
                JFileChooser fileChooser;
                this.internalFrame = internalFrames[i];
                Component[] jsp = this.internalFrame.getContentPane().getComponents();
                JScrollPane jspn = (JScrollPane)this.internalFrame.getContentPane().getComponent(0);
                JViewport jvp = jspn.getViewport();
                JEditorPane jep = (JEditorPane)jvp.getView();
                if (tempOpenMenuHash.containsKey(this.internalFrame)) {
                    String FileName = (String)tempOpenMenuHash.get(this.internalFrame);
                    File file = new File(FileName);
                    fileChooser = new JFileChooser();
                    this.firePropertyChange("FileChooserOpened", fileChooser, null);
                    fileChooser.setSelectedFile(file);
                    response = fileChooser.showSaveDialog(this.container);
                    if (response == 0) {
                        file = fileChooser.getSelectedFile();
                        if (file.exists()) {
                            int result = JOptionPane.showConfirmDialog(this.internalFrame, "This File Already Exists, Do You want to Replace the Existing File ?", "Confirm Dialog", 0);
                            if (result == 0) {
                                try {
                                    DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(file.getAbsolutePath()));
                                    outputStream.writeBytes(jep.getText());
                                    this.internalFrame.setChanged(false);
                                    if (this.internalFrame.getTitle().endsWith("*")) {
                                        this.internalFrame.setTitle(this.internalFrame.getTitle().substring(0, this.internalFrame.getTitle().length() - 1));
                                    }
                                }
                                catch (FileNotFoundException fnfe) {
                                    JOptionPane.showMessageDialog(null, fnfe.getMessage(), "MakeLogic:FileMenu", 0);
                                }
                                catch (IOException ioexcep) {
                                    JOptionPane.showMessageDialog(null, ioexcep.getMessage(), "MakeLogic:FileMenu", 0);
                                }
                            } else if (result == 1) {
                                return;
                            }
                        } else {
                            try {
                                DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(file.getAbsolutePath()));
                                outputStream.writeBytes(jep.getText());
                                this.internalFrame.setChanged(false);
                                if (this.internalFrame.getTitle().endsWith("*")) {
                                    this.internalFrame.setTitle(this.internalFrame.getTitle().substring(0, this.internalFrame.getTitle().length() - 1));
                                }
                                this.internalFrame.setTitle(file.getAbsolutePath());
                            }
                            catch (FileNotFoundException fnfe) {
                                JOptionPane.showMessageDialog(null, fnfe.getMessage(), "MakeLogic:FileMenu", 0);
                            }
                            catch (IOException ioexcep) {
                                JOptionPane.showMessageDialog(null, ioexcep.getMessage(), "MakeLogic:FileMenu", 0);
                            }
                            tempOpenMenuHash.put(this.internalFrame, file.getAbsolutePath());
                            recentFileEntries.add(file.getAbsolutePath());
                        }
                    }
                } else if (tempNewMenuHash.containsKey(this.internalFrame)) {
                    String newFileName = (String)tempNewMenuHash.get(this.internalFrame);
                    File currentFile = new File(newFileName + ".txt");
                    fileChooser = new JFileChooser();
                    this.firePropertyChange("FileChooserOpened", fileChooser, null);
                    fileChooser.setSelectedFile(currentFile);
                    response = fileChooser.showSaveDialog(this.container);
                    if (response == 0) {
                        try {
                            DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(fileChooser.getSelectedFile()));
                            outputStream.writeBytes(jep.getText());
                            this.internalFrame.setChanged(false);
                            if (this.internalFrame.getTitle().endsWith("*")) {
                                this.internalFrame.setTitle(this.internalFrame.getTitle().substring(0, this.internalFrame.getTitle().length() - 1));
                            }
                            this.internalFrame.setTitle(fileChooser.getSelectedFile().getAbsolutePath());
                            tempNewMenuHash.remove(this.internalFrame);
                            tempOpenMenuHash.put(this.internalFrame, fileChooser.getSelectedFile().getAbsolutePath());
                            recentFileEntries.add(fileChooser.getSelectedFile().getAbsolutePath());
                        }
                        catch (FileNotFoundException fnfe) {
                            JOptionPane.showMessageDialog(null, fnfe.getMessage(), "MakeLogic:FileMenu", 0);
                        }
                        catch (IOException ioexcep) {
                            JOptionPane.showMessageDialog(null, ioexcep.getMessage(), "MakeLogic:FileMenu", 0);
                        }
                    }
                }
            }
            ++i;
        }
    }
}

