/*
 * Decompiled with CFR 0.152.
 */
package com.makeLogic.utils;

import com.makeLogic.versionManager.stubs.ProductInfo;
import com.makeLogic.versionManager.stubs.UserStatusInfo;
import com.makeLogic.versionManager.stubs.VersionManagerSoap_Stub;
import com.makeLogic.versionManager.stubs.VersionManager_Impl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.xml.rpc.Stub;

public class VersionManager
extends Thread {
    String operatingSystemName = null;
    String productId = null;
    Calendar startDateTime = null;
    String ipAddress = null;
    String hostName = null;
    String versionManagerUserId = null;
    String outDirName;
    PrintStream standardErrorToFileStream = null;
    boolean divertErrorStream;
    Date today = null;
    InetAddress inetAddress = null;
    Properties systemProperties = null;
    VersionManagerSoap_Stub versionManagerSoap_Stub = null;
    ProductInfo productInfo = null;
    UserStatusInfo userStatusInfo = null;

    public VersionManager(String productId) {
        this.productId = productId;
        this.divertErrorStream = true;
        this.setName("VersionManager");
        if (productId == null || productId.equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Invalid ProductId", "VersionManager", 2);
            System.exit(0);
        }
        this.setDaemon(true);
        this.start();
    }

    public VersionManager(String productId, boolean divertErrorStream) {
        this.productId = productId;
        this.divertErrorStream = divertErrorStream;
        this.setName("VersionManager");
        if (productId == null || productId.equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Invalid ProductId", "VersionManager", 2);
            System.exit(0);
        }
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        File prodIDDirName;
        this.outDirName = "MakeLogicVersionManager";
        File outDir = new File(this.outDirName);
        if (!outDir.exists()) {
            outDir.mkdir();
        }
        if (!(prodIDDirName = new File(this.outDirName + "/" + this.productId)).exists()) {
            prodIDDirName.mkdir();
        }
        System.runFinalizersOnExit((boolean)true);
        this.versionManagerSoap_Stub = this.getRemoteReference();
        this.versionManagerUserId = this.getVersionManagerUserId();
        this.systemProperties = System.getProperties();
        this.operatingSystemName = this.systemProperties.getProperty("os.name") + " " + this.systemProperties.getProperty("os.version");
        this.startDateTime = Calendar.getInstance();
        try {
            this.inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        this.ipAddress = this.inetAddress.getHostAddress();
        this.hostName = this.inetAddress.getHostName();
        this.productInfo = new ProductInfo();
        this.productInfo.setProductID(this.productId);
        this.productInfo.setOperatingSystem(this.operatingSystemName);
        this.productInfo.setIpAddress(this.ipAddress);
        this.productInfo.setHostName(this.hostName);
        this.productInfo.setVersionManagerUserID(this.versionManagerUserId);
        this.userStatusInfo = new UserStatusInfo();
        this.userStatusInfo.setStatus(true);
        this.userStatusInfo.setProductID(this.productId);
        this.userStatusInfo.setVersionManagerUserID(this.versionManagerUserId);
        this.userStatusInfo.setCurrDateTime(this.startDateTime);
        this.backupErrorLog();
        this.standardErrorToFileStream = this.createErrorLogFile();
        if (this.divertErrorStream) {
            System.setErr(this.standardErrorToFileStream);
        }
        try {
            String status = this.versionManagerSoap_Stub.currentStatus(this.userStatusInfo);
            String str = this.versionManagerSoap_Stub.acceptVersionManagerUserInfo(this.productInfo);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.sendFile(this.outDirName + "/" + this.productId + "/vrm_ErrorLog/error_" + this.productId + "_" + this.versionManagerUserId + "_old.log", "");
    }

    public String getVersionManagerUserId() {
        String userID = null;
        String VERSION_MANAGER_CONF_FILE = "MakeLogicVersionManager/" + this.productId + "/VersionManager.conf";
        try {
            FileInputStream propInputStream = new FileInputStream(new File(VERSION_MANAGER_CONF_FILE));
            Properties prop = new Properties();
            prop.load(propInputStream);
            userID = prop.getProperty("MakeLogicVersionManagerUserID");
            if (userID == null || userID.equalsIgnoreCase("null")) {
                userID = this.versionManagerSoap_Stub.getNewUserID(this.productId);
                prop.setProperty("MakeLogicVersionManagerUserID", userID);
                try {
                    ((InputStream)propInputStream).close();
                    FileOutputStream fos = new FileOutputStream(VERSION_MANAGER_CONF_FILE);
                    prop.store(fos, "MakeLogic VersionManager UserID");
                    fos.flush();
                    fos.close();
                    return userID;
                }
                catch (IOException ioe) {
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ((InputStream)propInputStream).close();
            return userID;
        }
        catch (FileNotFoundException fnfe) {
            Properties properties = new Properties();
            try {
                userID = this.versionManagerSoap_Stub.getNewUserID(this.productId);
            }
            catch (RemoteException re) {
                userID = null;
            }
            try {
                properties.setProperty("MakeLogicVersionManagerUserID", userID);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                FileOutputStream fos = new FileOutputStream(VERSION_MANAGER_CONF_FILE);
                properties.store(fos, "MakeLogic VersionManager UserID");
                fos.flush();
                fos.close();
                return userID;
            }
            catch (IOException ioe) {
            }
            catch (Exception e) {
            }
        }
        catch (IllegalArgumentException iae) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return userID;
    }

    protected void finalize() throws Throwable {
        String errorLogName = "error_" + this.productId + "_" + this.versionManagerUserId + ".log";
        this.userStatusInfo.setStatus(false);
        this.userStatusInfo.setProductID(this.productId);
        this.userStatusInfo.setVersionManagerUserID(this.versionManagerUserId);
        this.userStatusInfo.setCurrDateTime(this.startDateTime);
        try {
            String status = this.versionManagerSoap_Stub.currentStatus(this.userStatusInfo);
        }
        catch (RemoteException re) {
            // empty catch block
        }
        try {
            this.standardErrorToFileStream = new PrintStream(new FileOutputStream(this.outDirName + "/" + this.productId + "/vrm_ErrorLog/" + errorLogName, true));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.standardErrorToFileStream.println("----- End   : " + this.today + " --------");
        this.standardErrorToFileStream.flush();
        this.standardErrorToFileStream.close();
    }

    VersionManagerSoap_Stub getRemoteReference() {
        VersionManagerSoap_Stub versionManagerStub = null;
        VersionManager_Impl impl = new VersionManager_Impl();
        Stub stub = (Stub)((Object)impl.getVersionManagerSoap());
        versionManagerStub = (VersionManagerSoap_Stub)stub;
        return versionManagerStub;
    }

    PrintStream createErrorLogFile() {
        String errorFileName = "error_" + this.productId + "_" + this.versionManagerUserId + ".log";
        this.today = null;
        try {
            this.today = new Date();
            File errorFile = new File(this.outDirName + "/" + this.productId + "/vrm_ErrorLog/" + errorFileName);
            File dirName = new File(this.outDirName + "/" + this.productId + "/vrm_ErrorLog");
            if (errorFile.exists()) {
                this.standardErrorToFileStream = new PrintStream(new FileOutputStream(this.outDirName + "/" + this.productId + "/vrm_ErrorLog/" + errorFileName, true));
                this.standardErrorToFileStream.println("\n\n----- Start : " + this.today + " --------");
                this.standardErrorToFileStream.flush();
                return this.standardErrorToFileStream;
            }
            dirName.mkdir();
            this.standardErrorToFileStream = new PrintStream(new FileOutputStream(this.outDirName + "/" + this.productId + "/vrm_ErrorLog/" + errorFileName, true));
            this.standardErrorToFileStream.println("//Do not modify this file. This is a computer generated MakeLogic VersionManager File.");
            this.standardErrorToFileStream.println("//");
            this.standardErrorToFileStream.println("//");
            this.standardErrorToFileStream.println("//");
            this.standardErrorToFileStream.println("\n\n");
            this.standardErrorToFileStream.println("\n\n----- Start : " + this.today + " --------");
            this.standardErrorToFileStream.flush();
            return this.standardErrorToFileStream;
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
        }
        catch (SecurityException se) {
            // empty catch block
        }
        return this.standardErrorToFileStream;
    }

    void backupErrorLog() {
        BufferedReader inputReader = null;
        PrintWriter printWriter = null;
        String inputString = null;
        String errorFileName = "error_" + this.productId + "_" + this.versionManagerUserId + ".log";
        try {
            File errorFile = new File(this.outDirName + "/" + this.productId + "/vrm_ErrorLog/" + errorFileName);
            if (!errorFile.exists()) {
                return;
            }
            inputReader = new BufferedReader(new FileReader(this.outDirName + "/" + this.productId + "/vrm_ErrorLog/" + errorFileName));
            printWriter = new PrintWriter(new FileWriter(this.outDirName + "/" + this.productId + "/vrm_ErrorLog/" + errorFileName.substring(0, errorFileName.length() - 4) + "_old.log", true));
            while ((inputString = inputReader.readLine()) != null) {
                printWriter.println(inputString);
            }
            printWriter.flush();
            inputReader.close();
            printWriter.close();
            errorFile.delete();
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public void sendFile(String fileName, String token) {
        BufferedReader inputReader = null;
        String fileContents = null;
        StringBuffer strBuffer = null;
        StringBuffer tempStrBuffer = null;
        Object reply = null;
        boolean canDelete = true;
        File file = new File(fileName);
        if (file.length() >= 819200L) {
            file.delete();
        }
        if (!file.exists()) {
            return;
        }
        try {
            String response;
            inputReader = new BufferedReader(new FileReader(fileName));
            strBuffer = new StringBuffer();
            tempStrBuffer = new StringBuffer();
            long bufferLength = 0L;
            long bytesToSendAtATime = 51200L;
            while ((fileContents = inputReader.readLine()) != null) {
                try {
                    strBuffer.append(fileContents);
                    if ((long)strBuffer.length() <= bytesToSendAtATime) {
                        tempStrBuffer = new StringBuffer(strBuffer.toString());
                        continue;
                    }
                    response = null;
                    try {
                        response = this.versionManagerSoap_Stub.submitErrors(tempStrBuffer.toString(), this.versionManagerUserId, this.productId);
                    }
                    catch (RemoteException re) {
                        // empty catch block
                    }
                    if (response.equals("OK")) {
                        bufferLength += (long)strBuffer.length();
                        strBuffer = new StringBuffer(fileContents);
                        if ((long)strBuffer.length() < bytesToSendAtATime) continue;
                        tempStrBuffer = new StringBuffer();
                        String response2 = null;
                        try {
                            response2 = this.versionManagerSoap_Stub.submitErrors(strBuffer.toString(), this.versionManagerUserId, this.productId);
                        }
                        catch (RemoteException re) {
                            // empty catch block
                        }
                        if (!response2.equals("OK")) continue;
                        bufferLength += (long)strBuffer.length();
                        continue;
                    }
                    canDelete = false;
                    break;
                }
                catch (Exception ioe) {
                    // empty catch block
                }
            }
            response = null;
            try {
                response = this.versionManagerSoap_Stub.submitErrors(tempStrBuffer.toString(), this.versionManagerUserId, this.productId);
            }
            catch (RemoteException re) {
                // empty catch block
            }
            if (response.equals("OK")) {
                bufferLength += (long)tempStrBuffer.length();
            } else {
                canDelete = false;
            }
            inputReader.close();
            if (canDelete) {
                file.delete();
            }
            return;
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

