/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.messaging.saaj.soap.SOAPPartImpl;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParameterList;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.stream.StreamSource;

public class MessageImpl
extends SOAPMessage {
    private MimeHeaders headers;
    private SOAPPartImpl soapPart;
    private Vector attachments;
    private boolean saved = false;
    private byte[] messageBytes;
    private int messageByteCount;
    private static final Iterator nullIter = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
            throw new IllegalStateException();
        }
    };

    public MessageImpl() {
        this.headers = new MimeHeaders();
    }

    public MessageImpl(SOAPMessage msg) {
        if (!(msg instanceof MessageImpl)) {
            // empty if block
        }
        MessageImpl src = (MessageImpl)msg;
        this.headers = src.headers;
        this.soapPart = src.soapPart;
        this.attachments = src.attachments;
        this.saved = src.saved;
        this.messageBytes = src.messageBytes;
        this.messageByteCount = src.messageByteCount;
    }

    public MessageImpl(MimeHeaders headers, final InputStream in) throws IOException, SOAPException {
        this.headers = headers;
        final String ct = this.getContentType();
        if (ct == null) {
            throw new SOAPException("Absent Content-Type");
        }
        try {
            ContentType contentType = new ContentType(ct);
            int v = this.verify(contentType);
            if (v == 1) {
                this.getSOAPPart().setContent(new StreamSource(in));
            } else {
                DataSource ds = new DataSource(){

                    public InputStream getInputStream() {
                        return in;
                    }

                    public OutputStream getOutputStream() {
                        return null;
                    }

                    public String getContentType() {
                        return ct;
                    }

                    public String getName() {
                        return "";
                    }
                };
                MimeMultipart mp = new MimeMultipart(ds);
                MimeBodyPart mbp = (MimeBodyPart)mp.getBodyPart(0);
                this.getSOAPPart().setContent(new StreamSource(mbp.getInputStream()));
                int i = 1;
                while (i < mp.getCount()) {
                    MimeBodyPart bp = (MimeBodyPart)mp.getBodyPart(i);
                    AttachmentPartImpl ap = new AttachmentPartImpl();
                    DataHandler dh = bp.getDataHandler();
                    ap.setDataHandler(dh);
                    AttachmentPartImpl.copyMimeHeaders(bp, ap);
                    this.addAttachmentPart(ap);
                    ++i;
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new SOAPException("Unable to internalize message", ex);
        }
        this.needsSave();
    }

    private int verify(ContentType contentType) throws SOAPException {
        String primary = contentType.getPrimaryType();
        String sub = contentType.getSubType();
        if (!primary.equalsIgnoreCase("multipart")) {
            if (primary.equalsIgnoreCase("text") && sub.equalsIgnoreCase("xml")) {
                return 1;
            }
            throw new SOAPException("Invalid Content-Type:" + primary + "/" + sub);
        }
        if (sub.equalsIgnoreCase("related")) {
            String type = contentType.getParameter("type").toLowerCase();
            if (type.startsWith("text/xml")) {
                return 2;
            }
            throw new SOAPException("Content-Type needs to be Multipart/Related and with \"type=text/xml\"");
        }
        throw new SOAPException("Invalid Content-Type: " + primary + "/" + sub);
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    final String getContentType() {
        String[] values = this.headers.getHeader("Content-Type");
        if (values == null) {
            return null;
        }
        return values[0];
    }

    private final void needsSave() {
        this.saved = false;
    }

    public synchronized boolean saveRequired() {
        return !this.saved;
    }

    public String getContentDescription() {
        String[] values = this.headers.getHeader("Content-Description");
        if (values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setContentDescription(String description) {
        this.headers.setHeader("Content-Description", description);
        this.needsSave();
    }

    public SOAPPart getSOAPPart() {
        if (this.soapPart == null) {
            this.soapPart = new SOAPPartImpl();
        }
        return this.soapPart;
    }

    public void removeAllAttachments() {
        if (this.attachments != null) {
            this.attachments.removeAllElements();
            this.needsSave();
        }
    }

    public int countAttachments() {
        if (this.attachments != null) {
            return this.attachments.size();
        }
        return 0;
    }

    public void addAttachmentPart(AttachmentPart attachment) {
        if (this.attachments == null) {
            this.attachments = new Vector();
        }
        this.attachments.addElement(attachment);
        this.needsSave();
    }

    public Iterator getAttachments() {
        if (this.attachments == null) {
            return nullIter;
        }
        return ((AbstractList)this.attachments).iterator();
    }

    public Iterator getAttachments(MimeHeaders headers) {
        if (this.attachments == null) {
            return nullIter;
        }
        return new MimeMatchingIterator(headers);
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    private final ByteInputStream getHeaderBytes() throws SOAPException, IOException {
        SOAPPartImpl sp = (SOAPPartImpl)this.getSOAPPart();
        return sp.getContentAsStream();
    }

    /*
     * WARNING - void declaration
     */
    private MimeMultipart getMimeMessage() throws SOAPException {
        try {
            void ex;
            MimeMultipart headerAndBody = new MimeMultipart();
            SOAPPartImpl sp = (SOAPPartImpl)this.getSOAPPart();
            headerAndBody.addBodyPart(sp.getMimePart());
            Iterator i = this.getAttachments();
            while (i.hasNext()) {
                headerAndBody.addBodyPart(((AttachmentPartImpl)i.next()).getMimePart());
            }
            ContentType contentType = new ContentType(headerAndBody.getContentType());
            ParameterList l = new ParameterList();
            l.set("type", "text/xml");
            l.set("boundary", contentType.getParameter("boundary"));
            ContentType nct = new ContentType("multipart", "related", l);
            this.headers.setHeader("Content-Type", nct.toString());
            return ex;
        }
        catch (SOAPException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new SOAPException("Unable to convert SOAP message into a MimeMultipart object", ex);
        }
    }

    public synchronized void saveChanges() throws SOAPException {
        if (this.countAttachments() == 0) {
            ByteInputStream in = null;
            try {
                in = this.getHeaderBytes();
            }
            catch (IOException ex) {
                throw new SOAPException("Unable to get header stream in saveChanges: " + ex.getMessage());
            }
            this.messageBytes = in.getBytes();
            this.messageByteCount = in.getCount();
            this.headers.setHeader("Content-Type", "text/xml; charset=\"utf-8\"");
            this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
        } else {
            ByteOutputStream out = new ByteOutputStream();
            try {
                this.getMimeMessage().writeTo(out);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                throw new SOAPException("Error during saving a multipart message", ex);
            }
            this.messageBytes = out.getBytes();
            this.messageByteCount = out.getCount();
            this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
        }
        String[] soapAction = this.headers.getHeader("SOAPAction");
        if (soapAction == null || soapAction.length == 0) {
            this.headers.setHeader("SOAPAction", "\"\"");
        }
        this.saved = true;
    }

    public void writeTo(OutputStream out) throws SOAPException, IOException {
        if (this.saveRequired()) {
            this.saveChanges();
        }
        out.write(this.messageBytes, 0, this.messageByteCount);
        this.messageBytes = null;
        this.needsSave();
    }

    private class MimeMatchingIterator
    implements Iterator {
        private Iterator iter;
        private MimeHeaders headers;
        private Object nextAttachment;

        public MimeMatchingIterator(MimeHeaders headers) {
            this.headers = headers;
            this.iter = ((AbstractList)MessageImpl.this.attachments).iterator();
        }

        public boolean hasNext() {
            if (this.nextAttachment == null) {
                this.nextAttachment = this.nextMatch();
            }
            return this.nextAttachment != null;
        }

        public Object next() {
            if (this.nextAttachment != null) {
                Object ret = this.nextAttachment;
                this.nextAttachment = null;
                return ret;
            }
            if (this.hasNext()) {
                return this.nextAttachment;
            }
            return null;
        }

        Object nextMatch() {
            while (this.iter.hasNext()) {
                AttachmentPartImpl ap = (AttachmentPartImpl)this.iter.next();
                if (!ap.hasAllHeaders(this.headers)) continue;
                return ap;
            }
            return null;
        }

        public void remove() {
            this.iter.remove();
        }
    }
}

