/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.tags;

import com.sun.xml.messaging.saaj.tags.JaxmContext;
import com.sun.xml.messaging.saaj.tags.SAttachment;
import com.sun.xml.messaging.saaj.tags.SBody;
import com.sun.xml.messaging.saaj.tags.SHeader;
import com.sun.xml.messaging.saaj.tags.StringDataSource;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.xml.messaging.URLEndpoint;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class JaxmSend {
    String endpointS;
    URL endpointURL;
    boolean reuseConnection = true;
    int dL = 0;
    String msgId;
    String jaxmCtx;
    SBody sbody;
    SHeader sheader;
    Vector attachments = new Vector();
    public static final String SOAP_ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    SOAPConnection con;
    SOAPMessage msg;
    URLEndpoint endPoint;
    JaxmContext gctx;

    public void setEndpoint(String s) {
        this.endpointS = s;
    }

    public void setReuseConnection(boolean b) {
        this.reuseConnection = b;
    }

    public void setDebug(int d) {
        this.dL = d;
    }

    public void setMsgId(String s) {
        this.msgId = s;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setJaxmContext(String s) {
        this.jaxmCtx = s;
    }

    public SHeader createSHeader() {
        this.sheader = new SHeader();
        return this.sheader;
    }

    public SBody createSBody() {
        this.sbody = new SBody();
        return this.sbody;
    }

    public void addAttachment(SAttachment at) {
        this.attachments.addElement(at);
    }

    public void setRemoteURL(String urlS) {
        try {
            this.endpointURL = new URL(urlS);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    public void prepareAttachments(SOAPMessage msg) throws SOAPException {
        int i = 0;
        while (i < this.attachments.size()) {
            AttachmentPart ap = msg.createAttachmentPart();
            SAttachment satt = (SAttachment)this.attachments.elementAt(i);
            ap.setContentType("text/xml");
            String ct = "text/plain";
            StringDataSource ds = new StringDataSource(satt.getBody(), satt.getContentType(), satt.getName());
            ap.setContent(satt.getBody(), satt.getContentType());
            msg.addAttachmentPart(ap);
            if (this.dL > 0) {
                this.debug("Added attachment " + i);
            }
            ++i;
        }
    }

    public SOAPMessage prepareMessage(MessageFactory mf) throws SOAPException, IOException {
        StringBuffer body = new StringBuffer();
        this.msg2SB(body);
        MimeHeaders headers = new MimeHeaders();
        headers.setHeader("Content-Type", "text/xml");
        SOAPMessage msg = mf.createMessage(headers, new StringBufferInputStream(body.toString()));
        return msg;
    }

    public void msg2SB(StringBuffer body) {
        body.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"");
        body.append(SOAP_ENV_NS);
        body.append("\" >");
        if (this.sheader != null) {
            body.append("<SOAP-ENV:Header>");
            body.append(this.sheader.getBody());
            body.append("</SOAP-ENV:Header>");
        }
        if (this.sbody != null) {
            body.append("<SOAP-ENV:Body>");
            body.append(this.sbody.getBody());
            body.append("</SOAP-ENV:Body>");
        }
        body.append("</SOAP-ENV:Envelope>\n");
    }

    public void setMessage(SOAPMessage msg) {
        this.msg = msg;
    }

    public SOAPMessage getMessage() {
        return this.msg;
    }

    public void initMessage() throws Exception {
        this.gctx = JaxmContext.getJaxmContext(this.jaxmCtx);
        try {
            if (this.msgId != null) {
                this.msg = (SOAPMessage)this.gctx.getAttribute(this.msgId);
            }
            if (this.msg != null) {
                return;
            }
            SOAPConnectionFactory factory = SOAPConnectionFactory.newInstance();
            this.con = factory.createConnection();
            MessageFactory mf = MessageFactory.newInstance();
            this.msg = this.prepareMessage(mf);
            this.prepareAttachments(this.msg);
            if (this.dL > 0) {
                this.debug("Created SOAPPart");
            }
            if (this.msgId != null) {
                if (this.dL > 0) {
                    this.debug("Set " + this.msgId);
                }
                this.gctx.setAttribute(this.msgId, this.msg);
            }
        }
        catch (Exception ex) {
            this.gctx.setAttribute("lastException", ex);
            this.dumpException(ex);
        }
    }

    public void initEndpoint() throws Exception {
        this.gctx = JaxmContext.getJaxmContext(this.jaxmCtx);
        try {
            if (this.endpointS == null) {
                this.endpointS = "endpoint";
            }
            if (this.endpointURL != null) {
                this.gctx.addURIMapping(this.endpointS, this.endpointURL);
            }
            this.endPoint = new URLEndpoint(this.endpointS);
        }
        catch (Exception ex) {
            this.gctx.setAttribute("lastException", ex);
            this.dumpException(ex);
        }
    }

    public void execute() throws Exception {
        try {
            this.initMessage();
            this.initEndpoint();
            if (this.dL > 0) {
                this.debug("Sent message");
            }
        }
        catch (Exception ex) {
            this.dumpException(ex);
            this.gctx.setAttribute("lastException", ex);
        }
    }

    public void dumpException(Throwable e) {
        e.printStackTrace();
        while (e instanceof SOAPException) {
            if ((e = ((SOAPException)e).getCause()) == null) continue;
            e.printStackTrace();
        }
    }

    public void debug(String s) {
        System.out.println("JaxmSend: " + s);
    }
}

