/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.ClientTransport;
import com.sun.xml.rpc.client.ClientTransportFactory;
import com.sun.xml.rpc.client.StreamingSender;
import com.sun.xml.rpc.client.StreamingSenderState;
import com.sun.xml.rpc.client.dii.BasicCall;
import com.sun.xml.rpc.client.dii.CallInvoker;
import com.sun.xml.rpc.client.dii.CallPropertyConstants;
import com.sun.xml.rpc.client.dii.CallRequest;
import com.sun.xml.rpc.client.http.HttpClientTransportFactory;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.soap.SOAPResponseStructure;
import com.sun.xml.rpc.soap.message.InternalSOAPMessage;
import com.sun.xml.rpc.soap.message.SOAPBlockInfo;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.streaming.XMLReader;

public class CallInvokerImpl
extends StreamingSender
implements CallInvoker,
CallPropertyConstants {
    private static ClientTransportFactory defaultTransportFactory = null;
    protected JAXRPCDeserializer faultDeserializer;
    protected JAXRPCDeserializer responseDeserializer;
    protected ClientTransportFactory transportFactory = defaultTransportFactory;
    protected ClientTransport clientTransport;

    public static void setDefaultTransportFactory(ClientTransportFactory factory) {
        defaultTransportFactory = factory;
    }

    public SOAPResponseStructure doInvoke(CallRequest callInfo, JAXRPCSerializer requestSerializer, JAXRPCDeserializer responseDeserializer, JAXRPCDeserializer faultDeserializer) throws Exception {
        this.responseDeserializer = responseDeserializer;
        this.faultDeserializer = faultDeserializer;
        BasicCall call = callInfo.call;
        StreamingSenderState state = this.setupRequest(callInfo, requestSerializer);
        this._send(call.getTargetEndpointAddress(), state);
        SOAPResponseStructure responseStruct = null;
        Object responseObject = state.getResponse().getBody().getValue();
        responseStruct = responseObject instanceof SOAPDeserializationState ? (SOAPResponseStructure)((SOAPDeserializationState)responseObject).getInstance() : (SOAPResponseStructure)responseObject;
        return responseStruct;
    }

    public void doInvokeOneWay(CallRequest callInfo, JAXRPCSerializer requestSerializer) throws Exception {
        BasicCall call = callInfo.call;
        StreamingSenderState state = this.setupRequest(callInfo, requestSerializer);
        this._sendOneWay(call.getTargetEndpointAddress(), state);
    }

    private StreamingSenderState setupRequest(CallRequest callInfo, JAXRPCSerializer requestSerializer) throws Exception {
        Object encoding;
        Object session;
        Boolean isSOAPActionUsed;
        Object operation;
        Object endpoint;
        Object password;
        BasicCall call = callInfo.call;
        StreamingSenderState state = this._start(call.getHandlerChain());
        InternalSOAPMessage request = state.getRequest();
        SOAPBlockInfo bodyBlock = new SOAPBlockInfo(call.getOperationName());
        bodyBlock.setValue(callInfo.request);
        bodyBlock.setSerializer(requestSerializer);
        request.setBody(bodyBlock);
        SOAPMessageContext messageContext = state.getMessageContext();
        Object username = call.getProperty("javax.xml.rpc.security.auth.username");
        if (username != null) {
            messageContext.setProperty("javax.xml.rpc.security.auth.username", username);
        }
        if ((password = call.getProperty("javax.xml.rpc.security.auth.password")) != null) {
            messageContext.setProperty("javax.xml.rpc.security.auth.password", password);
        }
        if ((endpoint = call.getProperty("javax.xml.rpc.endpoint")) != null) {
            messageContext.setProperty("javax.xml.rpc.endpoint", endpoint);
        }
        if ((operation = call.getProperty("javax.xml.rpc.soap.operation.style")) != null) {
            messageContext.setProperty("javax.xml.rpc.soap.operation.style", operation);
        }
        if ((isSOAPActionUsed = (Boolean)call.getRequiredProperty("javax.xml.rpc.soap.http.soapaction.use")).booleanValue()) {
            messageContext.setProperty("http.soap.action", call.getRequiredProperty("javax.xml.rpc.soap.http.soapaction.uri"));
        }
        if ((session = call.getProperty("javax.xml.rpc.session.maintain")) != null) {
            messageContext.setProperty("javax.xml.rpc.session.maintain", session);
        }
        if ((encoding = call.getProperty("javax.xml.rpc.encodingstyle.namespace.uri")) != null) {
            messageContext.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", encoding);
        }
        return state;
    }

    public ClientTransportFactory _getTransportFactory() {
        if (this.transportFactory == null) {
            this.transportFactory = new HttpClientTransportFactory();
        }
        return this.transportFactory;
    }

    public void _setTransportFactory(ClientTransportFactory factory) {
        this.transportFactory = factory;
        this.clientTransport = null;
    }

    public ClientTransport _getTransport() {
        if (this.clientTransport == null) {
            this.clientTransport = this._getTransportFactory().create();
        }
        return this.clientTransport;
    }

    protected void _readFirstBodyElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {
        Object responseStructObj = this.getResponseDeserializer().deserialize(null, bodyReader, deserializationContext);
        SOAPBlockInfo bodyBlock = new SOAPBlockInfo(null);
        bodyBlock.setValue(responseStructObj);
        state.getResponse().setBody(bodyBlock);
    }

    protected JAXRPCDeserializer getFaultDeserializer() {
        return this.faultDeserializer;
    }

    protected JAXRPCDeserializer getResponseDeserializer() {
        return this.responseDeserializer;
    }
}

