/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.soap;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectSerializerBase;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.StructMap;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class StructMapSerializer
extends ObjectSerializerBase
implements Initializable {
    protected InternalTypeMappingRegistry registry;

    public StructMapSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        super(type, encodeType, isNullable, encodingStyle);
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.registry = registry;
    }

    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        StructMap struct = (StructMap)instance;
        Iterator eachKey = struct.keys().iterator();
        Iterator eachValue = struct.values().iterator();
        while (eachKey.hasNext()) {
            Object value = eachValue.next();
            QName key = (QName)eachKey.next();
            if (value != null) {
                JAXRPCSerializer serializer = (JAXRPCSerializer)this.registry.getSerializer(this.encodingStyle, value.getClass());
                serializer.serialize(value, key, null, writer, context);
                continue;
            }
            this.serializeNull(key, writer, context);
        }
    }

    protected Object doDeserialize(SOAPDeserializationState state, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        StructMap instance = new StructMap();
        StructMapBuilder builder = null;
        boolean isComplete = true;
        int memberIndex = 0;
        while (reader.getState() != 2) {
            reader.nextElementContent();
            QName key = reader.getName();
            if (!SerializerBase.getNullStatus(reader)) {
                JAXRPCDeserializer deserializer = (JAXRPCDeserializer)this.registry.getDeserializer(this.encodingStyle, SerializerBase.getType(reader));
                Object member = deserializer.deserialize(key, reader, context);
                if (member instanceof SOAPDeserializationState) {
                    if (builder == null) {
                        builder = new StructMapBuilder(instance);
                    }
                    state = ObjectSerializerBase.registerWithMemberState(instance, state, member, memberIndex, builder);
                    isComplete = false;
                }
                instance.put(key, member);
                continue;
            }
            instance.put(key, (Object)null);
        }
        return isComplete ? instance : state;
    }

    protected class StructMapBuilder
    implements SOAPInstanceBuilder {
        StructMap instance;

        StructMapBuilder(StructMap instance) {
            this.instance = instance;
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        public void construct() {
        }

        public void setMember(int index, Object memberValue) {
            try {
                this.instance.set(index, memberValue);
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        public void initialize() {
        }

        public void setInstance(Object instance) {
            instance = (StructMap)instance;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

