/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.config.parser;

import com.sun.xml.rpc.processor.config.ConfigurationException;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;

public class ParserUtil {
    public static String getAttribute(XMLReader reader, String name) {
        Attributes attributes = reader.getAttributes();
        return attributes.getValue(name);
    }

    public static String getMandatoryAttribute(XMLReader reader, String name) {
        String value = ParserUtil.getAttribute(reader, name);
        if (value == null) {
            ParserUtil.failWithLocalName("configuration.missing.attribute", reader, name);
        }
        return value;
    }

    public static String getMandatoryNonEmptyAttribute(XMLReader reader, String name) {
        String value = ParserUtil.getAttribute(reader, name);
        if (value == null) {
            ParserUtil.failWithLocalName("configuration.missing.attribute", reader, name);
        } else if (value.equals("")) {
            ParserUtil.failWithLocalName("configuration.invalidAttributeValue", reader, name);
        }
        return value;
    }

    public static void ensureNoContent(XMLReader reader) {
        if (reader.nextElementContent() != 2) {
            ParserUtil.fail("configuration.unexpectedContent", reader);
        }
    }

    public static void fail(String key, XMLReader reader) {
        throw new ConfigurationException(key, Integer.toString(reader.getLineNumber()));
    }

    public static void failWithFullName(String key, XMLReader reader) {
        throw new ConfigurationException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getName().toString()});
    }

    public static void failWithLocalName(String key, XMLReader reader) {
        throw new ConfigurationException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getLocalName()});
    }

    public static void failWithLocalName(String key, XMLReader reader, String arg) {
        throw new ConfigurationException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getLocalName(), arg});
    }
}

