/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class HolderGenerator
extends GeneratorBase {
    private Set types;
    private Port port;

    public HolderGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new HolderGenerator(model, config, properties);
    }

    private HolderGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    protected void preVisitPort(Port port) throws Exception {
        this.port = port;
    }

    protected void postVisitPort(Port port) throws Exception {
        port = null;
    }

    public void visit(SOAPCustomType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    public void visit(SOAPSimpleType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    public void visit(SOAPAnyType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    public void visit(SOAPEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    protected void visitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
        super.visitSOAPArrayType(type);
    }

    protected void visitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
        super.visitSOAPStructureType(type);
    }

    protected void visitLiteralSimpleType(LiteralSimpleType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    protected void visitLiteralSequenceType(LiteralSequenceType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
        super.visitLiteralSequenceType(type);
    }

    protected void preVisitLiteralAllType(LiteralAllType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
        super.preVisitLiteralAllType(type);
    }

    protected void preVisitLiteralFragmentType(LiteralFragmentType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    private boolean isRegistered(AbstractType type) {
        return this.types.contains(type);
    }

    private void registerType(AbstractType type) {
        this.types.add(type);
    }

    private void generateHolder(AbstractType type) {
        if (type.getJavaType().isHolderPresent()) {
            return;
        }
        try {
            String className = this.env.getNames().holderClassName(this.port, type);
            if (className.startsWith("javax.xml.rpc.holders.")) {
                return;
            }
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className);
            out.pln();
            this.writeImports(out);
            out.pln();
            this.writeClassDecl(out, className);
            this.writeMembers(out, type);
            out.pln();
            this.writeClassConstructor(out, className, type);
            out.pOln("}");
            out.close();
            this.log("wrote file: " + classFile.getPath());
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import javax.xml.rpc.holders.Holder;");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(className)).append(" implements Holder {").toString());
    }

    private void writeMembers(IndentingWriter p, AbstractType type) throws IOException {
        p.pln("public " + type.getJavaType().getRealName() + " value;");
    }

    private void writeClassConstructor(IndentingWriter p, String className, AbstractType type) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.pln(stringBuffer.append(Names.stripQualifier(className)).append("() {").toString());
        p.pln("}");
        p.pln();
        StringBuffer stringBuffer2 = new StringBuffer().append("public ");
        this.env.getNames();
        p.plnI(stringBuffer2.append(Names.stripQualifier(className)).append("(").append(type.getJavaType().getRealName()).append(" ").append(this.env.getNames().getTypeMemberName(type)).append(") {").toString());
        p.pln("this.value = " + this.env.getNames().getTypeMemberName(type) + ";");
        p.pOln("}");
    }
}

